/*ScianTextFiles.h
  Eric Pepke
  24 February 1993

  External stuff for ScianTextFiles.c
*/

#define TEXTLINEALLOCCHUNK	200

typedef int TextFlagsTyp;
#define TF_READ		1	/*Read from file*/
#define TF_HASHCOMMENTS	8	/*Comments beginning with a hash in first line*/
#define TF_CONTINUATION	16	/*Honor continuation by \ at end of line*/
#define TF_INCLUDENL	32	/*Include new lines, else remove them*/

typedef struct textfile
    {
	struct textfile *next;	/*Pointer to next file*/
	char *name;		/*Name of the file*/
	FILE *filePtr;		/*File pointer*/
	int lineNum;		/*Number of last line read*/
	char *curLine;		/*Pointer to the current line read*/
	long nAlloc;		/*Number of characters allocated*/
	TextFlagsTyp flags;	/*Flags for the file*/
	Bool eof;		/*True iff at eof*/
    } TextFile, *TextFilePtr;

#ifdef PROTO
void InitTextFiles(void);
TextFilePtr OpenTextFile(char *name, TextFlagsTyp flags);
char *GetCurLine(TextFilePtr textFile);
char *GetNextLine(TextFilePtr textFile);
void CurLineError(TextFilePtr textFile, char *message, char *begin, char *end);
void CloseTextFile(TextFilePtr textFile);
void KillTextFiles(void);
#else
void InitTextFiles();
TextFilePtr OpenTextFile();
char *GetCurLine();
char *GetNextLine();
void CurLineError();
void CloseTextFile();
void KillTextFiles();
#endif
