/*ScianSymbols.c
  Eric Pepke
  19 January 1993

  Symbols system in Scian
*/

#include "Scian.h"
#include "ScianTypes.h"
#include "ScianErrors.h"
#include "ScianSymbols.h"

typedef struct
    {
	Thing	thing;		/* flags and stuff */
	NameTyp	symbol;		/* the actual symbol*/
    } Symbol;

#ifdef PROTO
ObjPtr NewSymbol(NameTyp id)
#else
ObjPtr NewSymbol(id)
NameTyp id;
#endif
/*Creates a new symbol given integer type id*/
{
    Symbol *sym;

    sym = (Symbol *) NewObject(NULLOBJ, sizeof(Symbol) - sizeof(Obj));
    if (!sym)
    {
        OMErr();
        return NULLOBJ;
    }
    sym -> thing . flags = SYMBOL;
    sym -> symbol = id;
    return (ObjPtr) sym;
}

#ifdef PROTO
NameTyp GetSymbolID(ObjPtr sym)
#else
NameTyp GetSymbolID(sym)
ObjPtr sym;
#endif
{
    if (!sym || !IsSymbol(sym))
    {
	ReportError("GetSymbolID", "Not a symbol");
        return 0;
    }
    return ((Symbol *) sym) -> symbol;
}
