/*ScianEvents.h
  Eric Pepke
  Stuff for events
*/

/*Must include ScianWindows.h*/
#ifndef _H_WINDOWS
#include "ScianWindows.h"
#endif

#define CLICK2TIME (HEARTBEAT * 3 / 4)  /*Ticks between a double click */
#define CLICK2DIST 5                    /*Pixels between a double click*/
#define MAXMOVETIME (HEARTBEAT / 4)	/*Maximum moving time allowed*/
#define MINROTTIME 0.20			/*Minimum rotation time*/

extern ObjPtr dropObject;		/*Object to drop in window*/
extern ObjPtr dropSource;		/*Source for the dropping*/
extern int dropX, dropY;		/*Global coordinates of dropX and y*/
extern Bool interactiveMoving;		/*true iff moving interactively*/
extern Bool contextHelp;		/*True iff context sensitive help*/
extern int NTSCOn;			/*True iff NTSC is on*/
extern long defaultMonitor;		/*Default monitor*/
extern int settleEvents;		/*Some events to settle*/

typedef void (*TaskType)();
extern int globalEventFlags;

#define MINCONSTRAINT	2		/*Number of pixels minimum for constraint*/

/*Function keys, integer values*/
#define FK_UP_ARROW	256		/*Up arrow*/
#define FK_DOWN_ARROW	257		/*Down arrow*/
#define FK_LEFT_ARROW	258		/*Left arrow*/
#define FK_RIGHT_ARROW	259		/*Right arrow*/
#define FK_BASE		512		/*The minimum value for function keys*/
#define FK_1		513		/*Numbered function keys*/
#define FK_2		514
#define FK_3		515
#define FK_4		516
#define FK_5		517
#define FK_6		518
#define FK_7		519
#define FK_8		520
#define FK_9		521
#define FK_10		522
#define FK_11		523
#define FK_12		524
#define FK_PRINT_SCREEN	525		/*Print screen*/

/*Mouse buttons*/
#define MB_LEFT		1		/*Left mouse button*/
#define MB_MIDDLE	2		/*Middle mouse button*/
#define MB_RIGHT	3		/*Right mouse button*/

/*Event types*/
#define ET_SET_WINDOW		1	/*Set a new input window*/
#define ET_UNSET_WINDOW		2	/*Unset an old window*/
#define ET_KEY_DOWN		3	/*A key is down*/
#define ET_MOUSE_DOWN		4	/*The mouse goes down*/
#define ET_RESHAPE_WINDOW	5	/*A window is reshaped*/
#define ET_DRAW_WINDOW		6	/*A window needs to be drawn*/
#define ET_UNKNOWN		7	/*Unknown event*/
#define ET_CLOSE_WINDOW		8	/*Close a window*/
#define ET_MOUSE_UP		9	/*The mouse comes up*/
#define ET_QUIT			10	/*Quit SciAn*/
#define ET_DEPTHCHANGE_WINDOW	11	/*A window's depth has changed*/
#define ET_ICONIFY_WINDOW	12	/*A window has been iconified*/
#define ET_DEICONIFY_WINDOW	13	/*A window has been de-iconified*/

#define ISUSEREVENT(t) 	((t) == ET_MOUSE_DOWN || (t) == ET_KEY_DOWN)


/*Event structure*/
typedef struct
    {
	int type;			/*The type of the event*/
	long flags;			/*The event flags*/
	long time;			/*The time of the event*/
	union
	{
	    WinInfoPtr window;		/*Window set (or whatever)*/
	    int key;			/*Key pressed*/
	    struct {
		int mouseButton;	/*Mouse button pressed*/
		int x;			/*Initial x*/
		int y;			/*Initial y*/
	    } mouse;
	} data;
    } Event;

/*Maximum number of events*/
#define MAXNEVENTS	300		/*Why not make it big?*/

/*Event flags*/
#define F_DOUBLECLICK	1		/*Click is potentially a double click*/
#define F_SHIFTDOWN	2		/*Shift key is held down*/
#define F_OPTIONDOWN	4		/*Option key is down*/
#define F_COMMANDDOWN	8		/*Command key is down*/
#define T_PRESS		0x1000		/*Press tool*/
#define T_ROTATE	0x2000		/*Rotate tool*/
#define T_HELP		0x3000		/*Context sensitive help*/
#define TOOLBITS	0xF000		/*Bits for the tool*/
#define TOOL(f)		((f) & TOOLBITS)/*Macro to get tool*/

#define F_EXTEND	F_SHIFTDOWN	/*Extended click*/
#define F_CONSTRAIN	F_SHIFTDOWN	/*Constrained click*/

#ifdef PROTO
void QueueDevices(void);
void UnqueueDevices(void);
void MainLoop(void);
void DoQuit(void);
void MaybeQuit(void);
Bool OneEvent(Bool);
void SetNTSC(void);
void Set60(void);
void LongOperation(void);
void DoTask(TaskType);
void DoUniqueTask(TaskType);
void SetContextSensitiveHelp(void);
void InitEvents(void);
void KillEvents(void);
void DeferMessage(ObjPtr, int);
void DeferUniqueMessage(ObjPtr, int);
void FlushKeystrokes(void);
Bool AltDown(void);
Bool ShiftDown(void);
Bool OptionDown(void);
Bool Mouse(int *, int *);
void NewEvents(void);
Bool UserEvent(void);
void PostEvent(Event *);
#else
void QueueDevices();
void UnqueueDevices();
void MainLoop();
void DoQuit();
void MaybeQuit();
Bool OneEvent();
void SetNTSC();
void Set60();
void LongOperation();
void DoTask();
void DoUniqueTask();
void SetContextSensitiveHelp();
void InitEvents();
void KillEvents();
void DeferMessage();
void DeferUniqueMessage();
void FlushKeystrokes();
Bool AltDown();
Bool ShiftDown();
Bool OptionDown();
Bool Mouse();
void NewEvents();
Bool UserEvent();
void PostEvent();
#endif
