/*Object IDs and variable IDs
  Eric Pepke
  March 28, 1990
*/

/*Variables and methods*/
#define DATA		1	/*Data variable*/
#define DATAFORM	2	/*Data form*/
#define COLORS		3	/*Colors for field dots*/
#define DIMENSIONS	4	/*Dimensions of something*/
#define BOUNDS		5	/*Bounds of an object*/
#define ICONLOC		6	/*Icon location*/
#define REPOBJ		7	/*Object this object represents*/
#define NAME		8	/*Name of this object*/
#define DRAW		9	/*Draw yerself.*/
#define CONTENTS	10	/*Contents of this panel, corral, or whatever*/
#define WHICHICON	11	/*The number of the icon*/
#define PRESS		12	/*Press method*/
#define SELECTED	13	/*Selected variable*/
#define HIGHLIGHTED	14	/*Highghlighghglighghted variable.*/
#define BASECOLOR	15	/*Base color of an object*/
#define XFORM		16	/*Rotation and translation matrix for an observer*/
#define ROTATE		17	/*Rotate message*/
#define BUTTONTYPE	18	/*Type of button*/
#define MARKERTYPE	19	/*Type of marker*/
#define XSTRETCH	20	/*Stretch in X*/
#define YSTRETCH	21	/*Stretch in Y*/
#define CHANGEDVALUE	22	/*Changedvalue method for buttons & controls*/
#define LEVEL		23	/*Level in a slice*/
#define ADDCONTROLS	24	/*Gives visualization a chance to add controls*/
#define DRAWCONTENTS	25	/*Method to draw the contents of something*/
#define PRESSCONTENTS	26	/*Method to press in the contents of something*/
#define BACKGROUND	27	/*Background color of something*/
#define STYLE		28      /*Style of anything*/
#define LOVALUE         29      /*Lower limit of slider value*/
#define HIVALUE         30      /*Upper limit of slider value*/
#define STEPVALUE       31      /*Step value of slider*/
#define VALUE           32      /*Current value of slider*/
#define VALUE2          33      /*Second value of dual-value slider*/
#define GETVAL		34	/*Get value method*/
#define NORMALS		35	/*Normals for a mesh*/
#define DEFAULTICON	36	/*Default icon for a visualization object*/
#define NEWCTLWINDOW	37	/*New control window method*/
#define SPECVAL		38	/*Specular value*/
#define SHINVAL		39	/*Shininess value*/
#define CLEANUP		40	/*Clean up object message*/
#define CLOSE		41	/*Close (a window) message*/
#define STICKINESS	42	/*Stickiness of an object, flag bits*/
#define RESHAPE		43	/*Reshape a window*/
#define INITIALIZE	44	/*Initialize an object*/
#define HILITESEGMENT	45	/*Variable containing hilite segment*/
#define SURFACE		46	/*Variable containing a surface*/
#define DELTAS		47	/*Variable containing deltas in a field*/
#define ISTRANSPARENT	48	/*True iff surface is transparent*/
#define BRIGHTNESS	49	/*Brightness of a surface*/
#define ISOVAL		50	/*Isosurface value*/
#define YAW		51	/*Yaw of the eye*/
#define ROLL		52	/*Roll of the eye*/
#define PITCH		53	/*Pitch of the eye*/
#define KEYDOWN		54	/*KeyDown method*/
#define AIRSPEED	55	/*Airspeed of eye*/
#define LASTTIME	56	/*Last time eye was moved*/
#define CONNECT		57	/*Connect something, maybe a recorder*/
#define DISCONNECT	58	/*Disconnect something*/
#define PORTNUMBER	59	/*Port number for a recorder*/
#define RECORD		60	/*Record some frames*/
#define PREPARETORECORD	61	/*Prepare to record some frames*/
#define STOPRECORDING	62	/*Stop recording*/
#define SNAPONEFRAME	63	/*Snap a single frame shot*/
#define SELECT		64	/*Select an icon or something*/
#define ICONY		65	/*Y of next icon*/
#define MATERIALHUE	66	/*Hue of material*/
#define CONTROLICON	67	/*Icon for controlling stuff*/
#define PANEL		68	/*Var holding control panel for an icon or space*/
#define PANELCONTENTS	69	/*Contents for a control panel for an icon*/
#define REPICON		70	/*Icon that represents this field*/
#define MULTIDRAW	71	/*True iff all classes of objects are to be drawn*/
#define BBFLAGS		72	/*Flags for bounding box*/
#define WHICHFLAG	73	/*Which flag a check box controls*/
#define SETVAL		74	/*Method to set a value*/
#define LILSTEP		75	/*Little step in a scale*/
#define BIGSTEP		76	/*Big step in a scale*/
#define FORMAT		77	/*Format of numbers*/
#define TRACKNOT	78	/*Variable to inhibit tracking*/
#define MAXSIZE		79	/*Maximum size of objects within space*/
#define SPACE		80	/*Space to which this object belongs*/
#define PARENT		81	/*Parent of object in window*/
#define PORTIONSHOWN	82	/*Portion of a scrolled window that's shown*/
#define TIMESTEPS	83	/*Array of time steps*/
#define TIMEDATA	84	/*Data corresponding to the time steps*/
#define OWNERWINDOW	85	/*Window that owns this space*/
#define WAKEUP		86	/*Wakeup call*/
#define CLOCK		87	/*The clock in this space*/
#define TIME		88	/*Time of this space*/
#define TIMEBOUNDS	89	/*Bounds of the time, array[2] of real*/
#define FOCUSDIST	90	/*Distance of focus, relates FOCUSPOINT to EYEPOSN*/
#define SMOOTH		91	/*Boolean value of smoothness of curve*/
#define SHEAR		92	/*Shear matrix*/
#define ALIGNMENT	93	/*Alignment*/
#define WHICHDIALOG	94	/*Identifier for dialog*/
#define DTIME		95	/*Delta time per second*/
#define MARKTIME	96	/*Mark time in a time-dependant field*/
#define ANCHOR		97	/*Anchor for a slider*/
#define COLOR		98	/*Color of a something*/
#define DISPLAY		99	/*Display yourself*/
#define BUTTONPRESSED	100	/*Method when a button has been pressed*/
#define CURRENT		101	/*Current object in window clicked*/
#define KEYSTRING	102	/*String so far in a slider from keypress*/
#define READOUT		103	/*Slider readout*/
#define SETREADOUT	104	/*Method to set slider readout*/
#define MAKEDRAWN	105	/*Method to make something drawn if not already*/
#define MARK		106	/*Mark method*/
#define INHIBITDRAWING	107	/*Flag to inhibit drawing.  DrawObject looks at it*/
#define XSCALE		108	/*Scale along X dimension*/
#define YSCALE		109	/*Scale along Y dimension*/
#define ZSCALE		110	/*Scale along Z dimension*/
#define DOUBLECLICK	111	/*Double click method*/
#define NCELLS		112	/*Number of cells in a switch*/
#define OUTCELL		113	/*Which cell is the output*/
#define ISTRANSLUCENT	114	/*True iff translucent*/
#define OTHERSWITCH	115	/*Another switch*/
#define DONTCHANGE	116	/*Temporary flag meaning don't do changedvalue*/
#define MINMAX		117	/*Minimum and maximum*/
#define CPALETTE	118	/*Variable to store palette*/
#define COLOROBJ	119	/*Object waiting to be color*/
#define DROPOBJECTS	120	/*Method to drop some objects*/
#define DROPINCONTENTS	121	/*Drop in contents of something like a corral*/
#define HSCROLL		122	/*Horizontal scroll bar*/
#define VSCROLL		123	/*Vertical scroll bar*/
#define RECALCSCROLL	124	/*Recalculate scroll bars*/
#define LABEL		125	/*Label of button*/
#define ISOSLIDER	126	/*Slider for an iso value*/
#define HANDLEMISSING	127	/*Integer specifying how to handle missing data*/
#define EDGES		128	/*Edges for an unstructured grid*/
#define CELLS		129	/*Cells for an unstructured grid*/
#define TEXTFONT	130	/*Text font*/
#define TEXTSIZE	131	/*Text size, as if you couldn't guess.*/
#define LINESPACE	132	/*Line spacing for text boxes*/
#define SPACES		133	/*List of spaces*/
#define DISPLAYCLOCK	134	/*Displayed clock in a space*/
#define MAGICDRAG	135	/*Predicate giving magic drag of a panel*/
#define FRONTPANEL	136	/*Front space panel*/
#define BACKPANEL	137	/*Back space panel*/
#define BINDTOSPACE	138	/*Method to bind a controller to a space*/
#define TOUCHSPACE	139	/*Method for a changed controller to touch a space*/
#define OBSERVER	140	/*Observer of this space.  That's YOU!*/
#define WHICHUPDATE	141	/*Place for current update*/
#define ERRORLIST	142	/*List of errors waiting*/
#define ERRORNUMBER	143	/*Currently displayed error*/
#define ERRORTEXT	144	/*TextBox of the error message*/
#define ERRORCOUNT	145	/*Number of errors*/
#define DPITCH		146	/*Change in pitch*/
#define ALWAYSCHANGE	147	/*Always do a changed value*/
#define RANGE		148	/*Range of a whatever*/
#define FILETYPE	149	/*File type*/
#define MARQUEE		150	/*Marquee around icons*/
#define LOCATION	151	/*Location of an object, usually in 3-space*/
#define LIGHTS		152	/*Individual lights in a lights class*/
#define WHATVALUE	153	/*A value for a button that changes a slider*/
#define CYCLECLOCK	154	/*Clock cycle predicate*/
#define GETVISDATASETS	155	/*Returns a dataset or list of datasets from vis obj*/
#define PANELHIDDEN	156	/*True iff the panel is hidden*/
#define ENCLOSELOW	157	/*True iff enclosing low values in isosurface*/
#define ENABLED		158	/*True iff something is enabled, like a light*/
#define FINDOBJECT	159	/*Finds an object*/
#define INTERPOLATEP	160	/*True iff we're to interpolate*/
#define RESOLVEDONE	161	/*Method to resolve a controller after spaces touched*/
#define TIMEREGISTERED	162	/*Dummy variable for registering time*/
#define LASTTIMESTEP	163	/*Size of last time step*/
#define PREFVIS		164	/*Preferred visualization*/
#define TRANSLUCENTCNT	165	/*Translucent control, if already made*/
#define TRANSPARENTCNT	166	/*Transparent control, if already made*/
#define COLORSHADING	167	/*Color shading value*/
#define LIGHTSHADING	168	/*Light shading value*/
#define PICCOLORED	171	/*Dummy dependency variable for picture colored*/
#define MAINDATASET	172	/*The main data set which sets up the time*/
#define ISOFIELD	173	/*The field that the isosurface is made from*/
#define SETMAINDATASET	174	/*Method for a vis object to accept a main field*/
#define CONTOURFIELD	175	/*Field for contours*/
#define UNSTRUCTURED	176	/*Boolean that tells if a data form is unstructured*/
#define VIEWBYWHAT	177	/*View by icon or name*/
#define VIRTUALBOUNDS	178	/*Virtual bounds of a scrolled field*/
#define BGNSEL		179	/* index of first char of text selection */
#define ENDSEL		180	/* index of last char of text selection */
#define SELECTALL	181	/* method to select all text in a textbox */
#define CALLBACK	182	/* callback method for a dialog */
#define	FILELIST	183	/* list of file lists by type */
#define SELECTOR	184	/* selector bits for file types */
#define PATH		185	/* path name to file window's directory */
#define OKMETHOD	186	/* method to call when OK button pressed */
#define SHOWFILES	187	/* method to show files in a corral */
#define REGISTERFIELD	188	/*Method to register a field*/
#define HIDDEN		189	/*True iff a visualization object is hidden*/
#define ICONGREYED	190	/*Greyed (an icon*)*/
#define WHICHPREF	191	/*Which preference a control deals with*/
#define HIGHLIGHTCOLOR	192	/*Color of a highlight*/
#define HIDE		193	/*Hide method*/
#define CLONE		194	/*Clone yourself method*/
#define ACTIVATED	195	/*Object is activated*/
#define ICONEXTRADRAW	196	/*Method to draw extra stuff for an icon*/
#define CURDATA		197	/*Current data*/
#define CMODERADIO	198	/*Color map radio button for a window*/
#define RENDERER	199	/*Renderer for a space*/
#define RENDERTYPE	200	/*Type of renderer*/
#define FILTERTYPE	201	/*Type of image filter*/
#define ENTERMETHOD	202	/*Method to call when enter key pressed in object*/
#define KEDGES		203	/*K-edges*/
#define DELETEICON	204	/*Message to send an icon to delete its repobj before deleting*/
#define CORRAL		205	/*Corral assoc with a space or window*/
#define VISBUTTON	206	/*The vis button for a corral*/
#define SHOWCNTBUTTON	207	/*Show controls button*/
#define TIMEPERPIXEL	208	/*Time per pixel on screen in time control*/
#define PREFIXDATASETS	209	/*Method to have a vis object prefix datasets it uses*/
#define DATASETS	210	/*Datasets of a clock*/
#define DISPLAYSTEP	211	/*Step for displaying time*/
#define DISPLAYTICS	212	/*Number of tics per time step*/
#define TIMECONTROL	213	/*A time control in a dialog*/
#define AUTOSCROLL	214	/*Autoscroll message*/
#define REINIT		215	/*Reinitialize controller*/
#define TIMEFORMAT	216	/*Format of time associated with dataset*/
#define CUT		217	/*Method to cut from something*/
#define COPY		218	/*Method to copy from something*/
#define PASTE		219	/*Method to paste on something*/
#define CLEAR		220	/*Method to clear something*/
#define TOPVARS		221	/*Topological variables*/
#define LASTINTERP	222	/*Last value of interpolate*/
#define VALUESET	223	/*Predicate, means new set value has been registered once*/
#define ROTATING	224	/*Of a space, predicate saying we are rotating*/
#define MOVING		225	/*Of a space, true iff moving*/
#define HELPSTRING	226	/*The help string of an object for the default help system*/ 
#define BORDERTYPE	227	/*Type of border, on a panel*/
#define HELPCONTENTS	228	/*Array of contents for help*/
#define HELPRADIO	229	/*Radio button in a help dialog*/
#define TYPESTRING	230	/*type string*/
#define	MAKE1HELPSTRING	231	/*Makes the help string*/
#define SINGLECORRAL	232	/*True iff corral can only hold one icon*/
#define REGISTERCOMP	233	/*Method to register a component*/
#define XFIELD		234	/*Field for X of trace*/
#define YFIELD		235	/*Field for Y of trace*/
#define ZFIELD		236	/*Field for Z of trace*/
#define XTOPDIM		237	/*Topological dimension for X*/
#define YTOPDIM		238	/*Topological dimension for Y*/
#define ZTOPDIM		239	/*Topological dimension for Z*/
#define ORTHO		240	/*Predicate to see if a perspec control is ortho*/
#define NCOMPONENTS	241	/*Number of components for a vector dataset or null for scalar*/
#define INDICES		242	/*Indices for array*/
#define COLORCELLS	243	/*What kind of color cells*/
#define ZDISPLACED	244	/*True iff z is displaced*/
#define VISASBUTTON	245	/*Visualize As button*/
#define PARENTS		246	/*List of parents*/
#define SLIDER		247	/*A slider a text box represents*/
#define CHANGED		248	/*Dummy variable used sometimes to indicate data changed*/
#define PALETTESET	249	/*Set if a color palette is set in a dataset*/
#define COLORWHEEL	250	/*Color control*/
#define KEPTPALETTE	251	/*The kept palette*/
#define COLORBAR	252	/*A color bar with which a slider or colorwheel works*/
#define OLDCOLORS	253	/*Old colors to revert to*/
#define BUTTON		254	/*A random button*/
#define TEMPPALETTE	255	/*Temporary palette*/
#define INITVALUE	256	/*Initial value of something*/
#define KEEPBUTTON	257	/*Keep button*/
#define REVERTBUTTON	258	/*Revert button*/
#define PALETTEFUNC	259	/*Palette function*/
#define FULLCOMPBUTTONS	260	/*List of buttons to activate or deactivate on full and components*/
#define COMPBUTTONS	261	/*List of buttons to activate or deactivate on components*/
#define EDITMODE	262	/*The edit mode, esp. of a color bar*/
#define TOOLGROUP	263	/*Group of tools*/
#define FUNCTIONBOX	264	/*Box that controls a function*/
#define FREEFORMBUTTON	265	/*Button for free form tool*/
#define HALTHELP	266	/*Halt help search predicate*/
#define NCOLORBOX	267	/*Box for ncolors*/
#define MINBOX		268	/*Box for min*/
#define MAXBOX		269	/*Box for max*/
#define REGISTERFORM	270	/*Register data form*/
#define JUSTCOLORCHANGE	271	/*Just the colors changed*/
#define GETTOPDIM	272	/*Get topological dimension*/
#define INITFILTER	273	/*Initialize filter*/
#define GETSPATIALDIM	274	/*Get spatial dimension*/
#define GETDATASETINFO	275	/*Get dataset info*/
#define SETRGBMESSAGE	276	/*Message to set to RGB*/
#define DIMVALUES	277	/*Array of dimension values*/
#define GETFORMDIMS	278	/*Method to get form dimensions*/
#define OPENBTN		279	/*Open button in file window*/
#define SETFORMATBTN	280	/*Set Format button in file window*/
#define SHOWINFOBTN	281	/*Show Info button in file window*/
#define FILEINFO	282	/*Text box in file information window*/
#define WHICHDIMENSION	283	/*Which dimension a slider controls*/
#define TOPDOWN		284	/*Predicate of field, true iff top down*/
#define VIEWTYPE	285	/*Type of view*/
#define EYEOFFSET	286	/*Offset of individual eyes*/
#define PERSPECCONTROL	287	/*Perspective control of this radio group*/
#define OLDVALUE	288	/*Old value for something*/
#define INTERPCOLORS	289	/*True iff interp colors*/
#define DRAWSURFACE	290	/*Draw the surface*/
#define DRAWWIREFRAME	291	/*Draw the wire frame*/
#define VECTORFACTOR	292	/*Factor for vector displays*/
#define SHAFTWIDTH	293	/*Width of an arrow's shaft*/
#define	HEADWIDTH	294	/*Width of an arrow's head*/
#define HEADLENGTH	295	/*Length of an arrow's head*/
#define GETLONGNAME	296	/*Returns long name of an object*/
#define WHICHVAR	297	/*Which var for numeric text*/
#define TEMPLATEP	298	/*True iff the object is a template*/
#define ALLFILTERS	299	/*Method to get all filters*/
#define DISPOSE		300	/*Dispose method for a window*/
#define READALL		301	/*Read all of a file method*/
#define OLDREAD		302	/*Old style file read routine, NOT method style*/
#define EXTENSION	303	/*Extension for file reader*/
#define TIMEDDATASETS	304	/*Timed datasets flags*/
#define OUTOFBOUNDS	305	/*Integer specifying how to handle out of bounds*/
#define TICDENSITY	306	/*Tic mark density*/
#define TICLENGTH	307	/*Length of tic marks*/
#define SPHERESUBDIV	308	/*Sphere subdivisions*/
#define FRUSTUMSUBDIV	309	/*Subdivision of a frustum*/
#define CAPENDSP	310	/*Cap ends predicate*/
#define ETERNALPART	311	/*Eternal portion of a picture*/
#define YOURENOTCURRENT	312	/*You're not current anymore message*/
#define HIDEPANEL	313	/*True iff window has panel to hide*/
#define MINMAJORSTEP	314	/*Number of pixels minimum in major step*/
#define COLORBYFIELD	315	/*Color text by field*/
#define CHECKBOX	316	/*A check box*/
#define SHOWOVERUNDER	317	/*Show over and under*/
#define SHOWMISSING	318	/*Show missing data*/
#define NUMBERSONLY	319	/*Numbers only*/
#define SHOWMINORTICS	320	/*Show minor tics*/
#define ROTAXIS		321	/*Axis of rotation*/
#define ROTSPEED	322	/*Rotation speed*/
#define FLYING		323	/*F L Y I N ---- G predicate*/
#define DEFORMOBJ	324	/*Deformation object*/
#define DEFCONSTANT	325	/*Constant deformation*/
#define DEFOFFSET	326	/*Offset of deformation*/
#define DEFFACTOR	327	/*Factor of deformation*/
#define DEFORMSWITCH	328	/*Value of deform switch*/
#define REVERSESENSE	329	/*Reverse order of contour*/
#define COLORMODEL	330	/*Color model for palette*/
#define CMODELRADIO	331	/*Color model radio button*/
#define FILENAME	332	/*Name of file where a dataset was found*/
#define DIRECTORY	333	/*Name of directory where a dataset was found*/
#define SAVECPANEL	334	/*Method to save the controls of an object*/
#define SAVEALLCONTROLS	335	/*Method to save all the indiv. controls of an object*/
#define CONTOURLINES	336	/*List of contour lines in an object*/
#define STARTVALUE	337	/*Starting value of a contour line*/
#define PICDEFORMED	338	/*Dummy variable for deformed picture*/
#define CONNECTIONSTATE 339	/*State of a connection*/
#define INHIBITLOGGING	340	/*Control predicate, inhibits logging*/
#define TIMEOUT		341	/*Timeout message*/
#define CURCMD		342	/*Current command being assembled*/
#define CMDPROCNAME	343	/*Command process name*/
#define ALLPROCESSES	344	/*All processes in a connection*/
#define OBJPANEL	345	/*A space's object panel*/
#define TOOLPANEL	346	/*A space's tool panel*/
#define ESCAPED		347	/*Connection is escaped*/
#define EDITTOOL	348	/*Edit tool*/
#define LINEWIDTH	349	/*Line width*/
#define COLORWIDTH	350	/*Width of a color bar in a palette display*/
#define TEXTWIDTH	351	/*Width of text on a palette display*/
#define STARTPOINT	352	/*Starting location (for a line)*/
#define ENDPOINT	353	/*Ending location (for a line)*/
#define ARROWHEAD	354	/*Of a line, are there arrowheads at each side*/
#define READER		355	/* reader for a file */
#define FIELD		356	/* control field */
#define OPEN		357	/* open message */
#define CLASSID		358	/*ID of a class*/
#define ONEONLY		359	/*One only predicate, of a controller in a space*/
#define TWOSIDEDSURFACE	360	/*Two-sided surface predicate*/
#define CONTROLLERP	361	/*True iff it's a controller*/
#define SHOWGRID	362	/*True iff show grid*/
#define FUNCTIONBUTTONS 363	/*List of function buttons in a window*/
#define SHOWCONTROLS	364	/*Show controls method of an object*/
#define DOFUNCTION	365	/*Deferred message for an object function button*/
#define VISUALIZE	366	/*Visualize an object*/
#define VISUALIZEAS	367	/*Visualize an object as...*/
#define MODIFY		368	/*Modify datasets*/
#define DELETE		369	/*Delete yourself from current window*/
#define SHOW		370	/*Show an object, opposite of hide*/
#define DUPLICATE	371	/*Duplicate an object*/
#define LOCALCOPY	372	/*Make local copy*/
#define PICKUP		373	/*Pick up an object*/
#define COLLECT		374	/*Collect object into a list*/
#define FORALLOBJECTS	375	/*For all objects method*/
#define APPEARANCE	376	/*Appearance of an object*/
#define BEVELED		377	/*Beveled style predicate*/
#define SHADOW		378	/*Shadow int variable*/
#define BINOCULARITY	379	/*Binocular distance*/
#define BRINGTOTOP	380	/*Bring object to top*/
#define PUSHTOBOTTOM	381	/*Push object to bottom*/
#define MOVETOBACKPANEL	382	/*Move to back panel*/
#define MOVETOFRONTPANEL 383	/*Move to front panel*/
#define MESHFIELD	384	/*Field for the mesh*/
#define CONTOURCENTER	385	/*Center value of contour*/
#define CONTOURSTEP	386	/*Step of contour*/
#define CONTOURMAX	387	/*Maximum value of contour*/
#define CONTOURDIV	388	/*Divisions of contour*/
#define CONTOURMIN	389	/*Minimum value of contour*/
#define CONTOURMAJWIDTH	390	/*Major width of contours*/
#define CONTOURMINWIDTH	391	/*Minor width of contours*/
#define DEFERLASTKEY	392	/*Defer the last keystroke*/
#define XNAME		393	/*Name of X axis*/
#define YNAME		394	/*Name of Y axis*/
#define ZNAME		395	/*Name of Z axis*/
#define READVECTOR	396	/*Read vector data*/
#define DTIMEPER	397	/*Delta time per second*/
#define RUNSPEED	398	/*Control integer for running*/
#define RUNCONTROL	399	/*Running radio button*/
#define DTIMEUNITS	400	/*Units for delta time*/
#define DTIMEPERUNITS	401	/*Units for delta time per*/
#define TIMESTEP	402	/*Time step in a clock*/
#define SHOWPANEL 	403	/*Show a panel*/
#define CONNECTIONKIND	404	/*Kind of connection*/
#define CONNECTTOPROCESS 406	/*Connect to a process*/
#define OUTPUTQUEUE	407	/*Output queue for a connection*/
#define OWNERCONNECTION	408	/*The connection of a process*/
#define CMDPROCSOCKET	409	/*Socket for a proc*/
#define ALLOBJECTS	410	/*All objects of a proc*/
#define SOCKETID	411	/*Socket a process wants to connect*/
#define OBJECTID	412	/*ID of object*/
#define ADVERTISED	413	/*Of an object, true iff advertised*/
#define ADVERTISE	414	/*Advertise obj function*/
#define UNADVERTISE	415	/*Unadvertise obj function*/
#define OLDCONNSTATE	416	/*Old connection state*/
#define OWNERPROCESS	417	/*Process that owns this connection*/
#define READNUMBERONE	418
#define READNUMBERTWO	419
#define READNUMBERTHREE	420
#define RECEIVEEXTRA	421
#define NETWORKID	422
#define TRANSMITEXTRA	423
#define ALLADVERTISED	424	/*Advertised objects of a process*/
#define TARGETOBJECT	425	/*Target for an incoming object*/
#define TARGETVAR	426
#define NEWREMOTEOBJ	427	/*New remote object method*/
#define BOUNDSINVALID	428	/*Bounds invalid method*/
#define SHOWBOUNDS	429	/*Show bounds predicate*/
#define PREFWIDTH	430	/*Preferred width of an object*/
#define PREFHEIGHT	431	/*Preferred height of an object*/
#define INNERSOFTMARGIN	432	/*Inner soft margin*/
#define OUTERSOFTMARGIN	433	/*Outer soft margin*/
#define SHOWROTGUIDES	434	/*Show rotation guides*/
#define SHOWMOTGUIDES	435	/*Show motion guides*/
#define SHOWFRAME	436	/*Of a window, show the frame*/
#define HIDEFRAME	437	/*Of a window, hide the frame*/
#define SPACEWINDOW	438	/*Space window of this window if any*/
#define SETTORGBMODE	439	/*Message to set a window to RGB mode*/
#define SETTOCMAPMODE	440	/*Message to set a window to CMAP mode*/
#define CHANGEDBOUNDS	441	/*Bounds which have been changed*/
#define BUFFER0		442	/*State of window buffer 0*/
#define BUFFER1		443	/*State of window buffer 1*/
#define WHICHBUFFER	444	/*Which buffer pointed to*/
#define SUBWINDOWS	445	/*Sub windows*/
#define SUPERWINDOW	446	/*Super window of this window*/
#define SUBWINDOWMARGIN	447	/*Margin for a subwindw*/
#define OPAQUE		448	/*Opaque predicate of object within panel*/
#define BACKNOTNEEDED	449	/*Drawing of background not needed*/
#define TEMPOBSCURED	450	/*Temporary obscuring for interaction*/
#define READNUMBERFOUR	451
#define VIEWFIELD	452	/*Field of view for an observer*/
#define VIEWCLIP	453	/*Two clipping planes for an observer*/
#define UPVECTOR	454	/*Up vector of an observer*/
#define FORWARDVECTOR	455	/*Forward vector of an observer*/
#define IMINVALID	456	/*Message for non-standard iminvalid*/
#define SPACECENTER	457	/*Center of space*/
#define SPACESCALE	458	/*Scale of space*/
#define REMOTECHCOUNT	459	/*Remote change count*/
#define SIZEOBJ		460	/*Size object*/
#define SIZECONSTANT	461	/*Constant sizing*/
#define SIZEOFFSET	462	/*Offset of sizing*/
#define SIZEFACTOR	463	/*Factor of sizing*/
#define SIZESWITCH	464	/*Value of size switch*/
#define ALLCONNECTIONS	465	/*All connections an object's been sent to*/
#define POINTSFIELD	466	/*Points field*/
#define NOTES		467	/*List of notes*/
#define POINTSTYLE	468	/*Style flags for points visualization*/
#define CURDATAFORM	469	/*Dummy variable of a dataset means valid dataform*/
#define STICKSFIELD	470	/*Sticks field*/
#define OPENMANUALLY	471	/*Message to ask to open an iconified window manually*/
#define DRAWINGTIME	472	/*Time to draw object or space*/
#define FASTSOCKET	473
#define NETWAITINGOBJECTS 474
#define DEPTHCUELINES	475	/*Use depth cueing on lines*/
#define UNITS		476	/*Units of a dataset or dataform*/
#define UNITSNAME	477	/*Units name*/
#define UNITSPALETTE	478	/*Method to create a units palette*/
#define ANTIALIASLINES	479	/*Anti-alias lines*/
#define SHMSEMAPHORE	480	/*Semaphore for shared memory*/
#define SHMADDRESS	481	/*Address for shared memory*/
#define INHIBITALL	482	/*Inhibit interaction and drawing, predicate*/
#define DRAWDOTS	483	/*Draw the dots of an object*/
#define DEPTHCUEDOTS	484	/*Use depth cueing on dots*/
#define ANTIALIASDOTS	485	/*Anti-alias dots*/
#define BIGGERDOTS	486	/*True iff use bigger dots*/
#define NUMBERSFIELD	487	/*Numbers field*/
#define DROPPEDINSPACE	488	/*Alert an object that it's been dropped in a space*/
#define REPOBJONLY	489	/*Object only serves for its repobj*/
#define ABORTCONTROLS	490	/*Abort controls predicate*/
#define PICKPOINT	491	/*Picks a number of points in the object*/	
#define GETPOINT	492	/*Gets a point for a certain number*/
#define IDLECURSOR	493	/*Idles a cursor within a window*/
#define ENTERCURSOR	495	/*Message when cursor enters a window*/
#define LEAVECURSOR	496	/*Message when cursor leaves a window*/
#define RESIDUES	497	/*Residues*/
#define SHOWATOMSHOW	498	/*Show atoms how?*/
#define STUFFSELPOINT	499	/*Stuff a selection point*/
#define BEGINSTUFFING	500	/*Begin stuffing some selection points*/
#define SELECTSELPOINT	501	/*Method to select a single selection point*/
#define PORTIONSELECTED	502	/*Portion that's selected*/
#define ALLSENTLIST	503	/*List of all sent, whatever that means*/
#define HOROFFSET	504	/*Horizontal offset for text box*/
#define SNAPVARS	505	/*Variables of an object for snapshot*/
#define OLDSNAPSHOTS	506	/*Old snapshots of an undo*/
#define UNDOTYPE	507	/*Type of undo*/
#define LASTKEY		508	/*Last type of key pressed in text box*/
#define SELECTION	509	/*Selection within a complex control*/
#define RANDOMJITTER	510	/*Random jitter for points*/
#define CHANGEDSELECTION 511	/*Changed selection*/
#define SETSELECTION	512	/*Set a selection*/
