/*
 * box.c
 *
 * Copyright (C) 1989, Craig E. Kolb
 *
 * This software may be freely copied, modified, and redistributed,
 * provided that this copyright notice is preserved on all copies.
 *
 * There is no warranty or other guarantee of fitness for this software,
 * it is provided solely .  Bug reports or fixes may be sent
 * to the author, who may or may not act on them as he desires.
 *
 * You may not include this software in a program or other software product
 * without supplying the source, or without informing the end-user that the
 * source is available for no extra charge.
 *
 * If you modify this software, you should include a notice giving the
 * name of the person performing the modification, the date of modification,
 * and the reason for such modification.
 *
 * $Id: box.c,v 1.2 1991/11/22 23:59:35 welling Exp $
 *
 * $Log: box.c,v $
 * Revision 1.2  1991/11/22  23:59:35  welling
 * Added point_diameter, line_diameter, ignore_text, text_stroke_width,
 * and text_thickness handling, and generation of text from Hershey fonts
 * using boxes mitered with cylinders (as per art_ren).  This involved
 * sucking in the Rayshade 'box' primitive.
 *
 * Revision 1.1  1991/02/08  19:23:19  welling
 * Initial revision
 *
 * Revision 3.0.1.1  89/12/06  16:33:48  craig
 * patch2: Added calls to new error/warning routines.
 * 
 * Revision 3.0  89/10/27  02:05:47  craig
 * Baseline for first official release.
 * 
 */
#include <math.h>
#include <stdio.h>
#include "constants.h"
#include "typedefs.h"
#include "funcdefs.h"

ray_Object *
makbox(surf, x, y, z, xs, ys, zs)
char *surf;
double x, y, z, xs, ys, zs;
{
	Box          *box;
	ray_Primitive *prim;
	ray_Object *newobj;

	if (xs < EPSILON || ys < EPSILON || zs < EPSILON) {
		fprintf(stderr,"Degenerate box.\n");
		return (ray_Object *)0;
	}
	prim = mallocprim();
	prim->surf = find_surface(surf);
	newobj = new_object(NULL, BOX, (char *)prim, (ray_Trans *)NULL);
	prim->type = BOX;
	box = (Box *)Malloc(sizeof(Box));
	prim->objpnt.p_box = box;
	box->bounds[LOW][X] = x - xs;
	box->bounds[HIGH][X] = x + xs;
	box->bounds[LOW][Y] = y - ys;
	box->bounds[HIGH][Y] = y + ys;
	box->bounds[LOW][Z] = z - zs;
	box->bounds[HIGH][Z] = z + zs;
	return newobj;
}

double
intbox(pos, ray, obj)
ray_Vector *ray;	/* ray vector */
ray_Vector *pos;	/* origin of ray */
ray_Primitive *obj;	/* box description */
{
	ray_Ray tmpray;
	extern unsigned long BVTests, primtests[];

	/*
	 * IntBounds will increment BVTests, even though we're
	 * not really doing a BV intersection test.
	 */
	primtests[BOX]++;
	BVTests--;
	tmpray.pos = *pos;
	tmpray.dir = *ray;
	return IntBounds(&tmpray, obj->objpnt.p_box->bounds);
}

nrmbox(pos, obj, nrm)
ray_Vector           *pos, *nrm;	/* point of intersection */
ray_Primitive       *obj;	/* box description */
{
	Box          *box;

	box = obj->objpnt.p_box;
	nrm->x = nrm->y = nrm->z = 0.;

	if (equal(pos->x, box->bounds[HIGH][X]))
		nrm->x = 1.;
	else if (equal(pos->x, box->bounds[LOW][X]))
		nrm->x = -1.;
	else if (equal(pos->y, box->bounds[HIGH][Y]))
		nrm->y = 1.;
	else if (equal(pos->y, box->bounds[LOW][Y]))
		nrm->y = -1.;
	else if (equal(pos->z, box->bounds[HIGH][Z]))
		nrm->z = 1.;
	else if (equal(pos->z, box->bounds[LOW][Z]))
		nrm->z = -1.;
	else
		fprintf(stderr,"Nrmbox: confusion!\n");
}

boxextent(o, bounds)
ray_Primitive *o;
double bounds[2][3];
{
  Box *b;
  b = o->objpnt.p_box;

  bounds[LOW][X] = b->bounds[LOW][X];
  bounds[HIGH][X] = b->bounds[HIGH][X];
  bounds[LOW][Y] = b->bounds[LOW][Y];
  bounds[HIGH][Y] = b->bounds[HIGH][Y];
  bounds[LOW][Z] = b->bounds[LOW][Z];
  bounds[HIGH][Z] = b->bounds[HIGH][Z];
}
