/****************************************************************************
 * alisp.h
 * Author Chris Nuuja
 * Copyright 1989, Pittsburgh Supercomputing Center, Carnegie Mellon University
 *
 * Permission use, copy, and modify this software and its documentation
 * without fee for personal use or use within your organization is hereby
 * granted, provided that the above copyright notice is preserved in all
 * copies and that that copyright and this permission notice appear in
 * supporting documentation.  Permission to redistribute this software to
 * other organizations or individuals is not granted;  that must be
 * negotiated with the PSC.  Neither the PSC nor Carnegie Mellon
 * University make any representations about the suitability of this
 * software for any purpose.  It is provided "as is" without express or
 * implied warranty.
 *****************************************************************************/

/*  
    This file contains all the external definitions needed by files using
    alisp functions.  It includes alisp_node.h, which defines all the 
    data-types and macros needed by alisp.  This is the only file that 
    needs to be included in any file for that file to use alisp functions.
*/

#include "alisp_node.h"

extern int PRINT_FLAG;

extern int alisp();
extern void  setup_env();
extern void  setup_parse();
extern void cleanup_env();
extern void cleanup_parse();
extern void shutdown_callOut();
extern void print_out();
extern void dprint_out();
extern NODE *EVAL_ENV;
extern NODE *memory_record;
extern NODE *RESULT;
extern NODE *LAMBDA_KEY;

extern NODE *ilisp();
extern NODE *eval_ilisp();
extern NODE *apply_ilisp();
extern NODE *eval_not();
extern NODE *eval_and();
extern NODE *eval_or();
extern NODE *eval_cond();
extern NODE *eval_if();
extern NODE *eval_let();
extern NODE *eval_do();
extern NODE *apply_lambda();
extern void preform_def();
extern void eval_new_program();
extern NODE *eval_program();

extern void decr_elem();
extern void decr_partlist();
extern void decr_list();
extern NODE *apply_prim();
extern NODE *make_array();

extern NODE *handle_error();
extern NODE *lookup();
extern NODE *lookup_symbol();
extern void add_setf_method();
extern NODE *get_setf_method();
extern NODE *get_plist();
extern NODE *assoc();
extern NODE *eval_list();
extern NODE *append();
extern NODE *cons();
extern NODE *make_funarg();

extern void free();
#ifndef NOMALLOCDEF
extern char *malloc();
#endif

extern void Bind();
extern void unBind();
extern void add_Bindlist();
extern void add_vallist();
extern void remove_Binding();
extern void remove_Bindings();
extern void unlink_Bindlist();

extern NODE *apply_callOut();
extern int free_node();
extern NODE *new_node();

extern NODE *get_floatrep();
extern NODE *get_integerrep();
extern NODE *get_symbolrep();
extern int hash_string();
extern int list_length();
extern void parse();


