/****************************************************************************
 * alisp_node.h
 * Author Joel Welling and Chris Nuuja
 * Copyright 1989, Pittsburgh Supercomputing Center, Carnegie Mellon University
 *
 * Permission use, copy, and modify this software and its documentation
 * without fee for personal use or use within your organization is hereby
 * granted, provided that the above copyright notice is preserved in all
 * copies and that that copyright and this permission notice appear in
 * supporting documentation.  Permission to redistribute this software to
 * other organizations or individuals is not granted;  that must be
 * negotiated with the PSC.  Neither the PSC nor Carnegie Mellon
 * University make any representations about the suitability of this
 * software for any purpose.  It is provided "as is" without express or
 * implied warranty.
 *****************************************************************************/

#include <stdio.h>
#include <ctype.h>

#define NONAME ""
#define TRUE 1
#define FALSE 0


#define	Type_Of(x)	( (x)->expr_type )
#define symbol_type(x) ( (x)->val.symbol.typeof_symbol )
#define symbol_name(x) ( (x)->val.symbol.name )
#define null(x)		( Type_Of(x) == N_NIL )
#define atom(x)		(null(x) || Type_Of(x) != N_LIST)
#define listp(x)	(null(x) || Type_Of(x) == N_LIST)
#define consp(x)	( Type_Of(x) == N_LIST )
#define not_list(x) 	( Type_Of(x) != N_LIST )

#define is_callout(x)	( (Type_Of(x) == N_SYMBOL) &&   \
			  (symbol_type(x) == K_CALLOUT) )

#define is_prim(x)	( ((int)symbol_type(x) > (int) K_NIL) &&  \
			  ((int)symbol_type(x) < (int)K_SYSTEM ) )

#define is_constr(x)	((int)symbol_type(x) >(int)K_SYSTEM)
#define is_systemcall(x) (symbol_type(x) == K_SYSTEM)
			 
#define is_lambda(x)	((Type_Of(x) == N_SYMBOL) &&  \
			 ( symbol_type(x) == K_LAMBDA) )
			 
#define is_cond(x)	((Type_Of(x) == N_SYMBOL) &&  \
			 ( symbol_type(x) == K_COND) )
			 
#define is_do(x)	((Type_Of(x) == N_SYMBOL) &&  \
			 ( symbol_type(x) == K_DO) )
#define is_dostar(x)	((Type_Of(x) == N_SYMBOL) &&  \
			 ( symbol_type(x) == K_DOSTAR) )
			 
#define is_let(x)	((Type_Of(x) == N_SYMBOL) &&  \
			 ( symbol_type(x) == K_LET) )
#define is_letstar(x)	((Type_Of(x) == N_SYMBOL) &&  \
			 ( symbol_type(x) == K_LETSTAR) )
			 
#define is_quote(x)	((Type_Of(x) == N_SYMBOL) &&  \
			 ( symbol_type(x) == K_QUOTE) )
			 
#define is_funarg(x)	((Type_Of(x) == N_SYMBOL) &&  \
			 ( symbol_type(x) == K_FUNARG) )
			 
#define symbolp(x)	(Type_Of(x) == N_SYMBOL)
#define good_functor(x) ( symbolp(x) || is_callout(x) )
			 
#define keywordp(x)	( (Type_Of(x) == N_SYMBOL) && \
			  (symbol_type(x) == K_SYMBOLKEY) )
#define systemp(x)	( (Type_Of(x) == N_SYMBOL) && \
			  (symbol_type(x) == K_SYSTEM) )

#define key_symbolp(x)  ( (Type_Of(x) == N_SYMBOL) &&  \
			  (symbol_type(x) == K_KEY) )
			 
#define is_rest(x)	((Type_Of(x) == N_SYMBOL) &&  \
			 ( symbol_type(x) == K_REST) )
			 
#define fixp(x)		((Type_Of(x) == N_INT))
			 
#define floatp(x)	((Type_Of(x) == N_REAL))
			 
#define stringp(x)	((Type_Of(x) == N_STRING))
			 
#define arrayp(x)	((Type_Of(x) == N_ARRAY))
			 
#define is_setf(x)	( (Type_Of(x) == N_SYMBOL) &&  \
			  (symbol_type(x) == K_SETF) )

#define is_setq(x)	( (Type_Of(x) == N_SYMBOL) &&  \
		          (symbol_type(x) == K_SETQ) )
			 
/*   List acessing macros  */

#define	car(x)   (((x)->val.list).Car)
#define	cdr(x)   (((x)->val.list).Cdr)
#define rplaca(x,y)	(car(x) = (y))
#define rplacd(x,y)	(cdr(x) = (y))
#define preplace(x,y)	((x) = (y))
#define nth1(x)	( car(x) )
#define nth2(x) ( car(cdr(x)) )
#define nth3(x) ( car(cdr(cdr(x))) )
#define nth4(x) ( car(cdr(cdr(cdr(x)))) )

/*  Number accessing macros  */

#define getfixnum(x)	(((x)->val).int_val)
#define getflonum(x)	(((x)->val).float_val)

/*  Symbol accessing macros */

#define getname(x)	( ((x)->val).symbol.name )
#define setname(x,y)	( getname(x) = (y) )

/*  Keyword name accessing  macros */
/*  This is a problem......        */
#define keyword_name(x) ( ((x)->val).symbol.name)

/*  Call-out accessing macros  */
#define callout_name(x) ( ((x)->val).symbol.name )

/*  String accessing macros  */
#define getstring(x)	( ((x)->val).symbol.name )

/*   Primitive accessing macros  */
#define key_name(x)	( ((x)->val).symbol.typeof_symbol )


/*  Array accessing macros   */
#define array_ref(x,n)	( (((x)->val.array).the_array)[n] )
#define array_max(x)	( ((x)->val.array).size )
#define array_st(x)	( ((x)->val.array).the_array )

/*  User data structure macros */
#define userdef_data(x) ( ((x)->val.userdef.data) )
#define userdef_methods(x) ( ((x)->val.userdef.methods) )

/*  Boolean accessing macro  */
#define getbool(x)	( ((x)->val).boolvalue )

/*   Lambda accessing macros   */

#define lambda_vars(x)	( nth2(x) )
#define lambda_body(x)	( cdr(cdr(x) ) )
#define lambda_name(x)	( nth1(x) )

/* Funarg accessing macros	*/
#define funarg_body(x)	( cdr(cdr(cdr(x))) )
#define funarg_env(x)	( nth2(x) )
#define funarg_vars(x)	( nth3(x) ) 

/* do accessing macros 		*/
#define do_vars(x)	( nth2(x) )
#define do_endform(x)	( nth3(x) )
#define do_body(x)	( cdr(cdr(cdr(x))) )


/* let accessing macros 	*/
#define let_vars(x)	( nth2(x) )
#define let_body(x)	( nth3(x) )

#define quote_body(x)	( cdr(x) )

#define cond_list(x)	( cdr(x) )

typedef enum{
             N_FREE, N_INT, N_REAL, N_SYMBOL, N_LIST, N_LIST_L, N_LIST_R, 
	     N_TRUE, N_NIL, N_STRING, N_ARRAY, N_USERDATA
}EXPR_TYPE;

#define tokensize 128
#define maxline 256

/*key type definitions used as return values in check_key() and
 *in switch statement to call appropriate parsing functions*/
typedef enum{ 
     K_NORMAL=0,K_TRUE,K_NIL,
     K_EVAL, K_APPLY, K_CAR, K_CDR, K_CAAR, K_CDDR, K_CADR, K_CDAR, K_GREATER, 
     K_LESS, K_CAAAR, K_CAADR, K_CADAR, K_CDAAR, K_CADDR, K_CDADR, K_CDDAR, 
     K_CDDDR, K_CONS, K_APPEND, K_LIST, K_RPLCA, K_RPLCD, K_NULL, K_ATOMP,
     K_LISTP, K_CONSP, K_SYMBOLP, K_FIXP, K_FLOATP,K_ADD, K_SUB, K_MUL, K_DIV, 
     K_EQ,K_MARRAY,K_AREF,K_ASSOC,K_ARRAYP,K_QUIT, K_MAPCAR,K_PPRINT,K_LOAD,
     K_BOUNDP,K_FBOUNDP,
/* System keyword     */
     K_SYSTEM, K_CALLOUT,
/* Primitive keywords */
  K_AND, K_COND, K_DEFSTRUCT, K_DEFUN,  K_DO, K_DOSTAR, K_IF, K_KEY, K_LAMBDA,
  K_LET,  K_LETSTAR,  K_NOT, K_OR, K_PROGN,  K_QUOTE, K_REST, 
  K_SETQ, K_SETF, K_SYMBOLKEY
	    }KEY_TYPE;

/* All user defined data types must provide one instance of this */
typedef struct userdef_struct {
  char *type;
  void (*destroy)();     /* takes data pointer as argument */
  void (*print)();       /* takes data pointer as argument */
  void (*setf_method)(); /* takes accessor symbol, target node, and new val */
} USERDATA;
  

typedef struct node{
    EXPR_TYPE	expr_type; /*node type*/
    int ptr_cnt;
    union{
	struct{
	    		struct node	*Car;
	    		struct node	*Cdr;
	      }list;
	struct{
			struct node     **the_array;
			int		size;
	      }array;
	long		int_val;
	float		float_val;
	struct{
			char *name;
		        KEY_TYPE typeof_symbol;
	      }symbol;
	struct{
	  char *data;
	  USERDATA *methods;
	} userdef;
    }val;
}NODE;


#define	Is_Nil(c)	(Type_Of(c) == N_NIL)

#define	Alloc(type, num)	    (type *)malloc((num) * sizeof(type))
#define	AllocPtrArray(type, num)    (type **)malloc((num) * sizeof(type *))

#define key_index_of(a)	    ( (int) (((a)->val).symbol.typeof_symbol) )



#define PRIME 2713
extern NODE *INTEGERTABLE;
extern NODE *FLOATTABLE;		/* Not actually used	*/
extern NODE *SYMBOLTABLE[ PRIME ];

/*command-line arguements*/
extern int	gargc;
extern char	**gargv;

#define top_of(x)	( consp(x) ? car(x) : x )
#define rest_of(x)	( consp(x) ? cdr(x) : NIL )

#define incr_ref(x)	(((x)->ptr_cnt)++)
#define decr_ref(x)  ( ( (--((x)->ptr_cnt) < 1) && (!null(x))) ? free_node(x) : 0)

extern NODE	*NIL,*TRUE_NODE;
extern int SESSION_END;



