/****************************************************************************
 * displace.c
 * Author Julie Roskies
 * Copyright 1989, Pittsburgh Supercomputing Center, Carnegie Mellon University
 *
 * Permission use, copy, and modify this software and its documentation
 * without fee for personal use or use within your organization is hereby
 * granted, provided that the above copyright notice is preserved in all
 * copies and that that copyright and this permission notice appear in
 * supporting documentation.  Permission to redistribute this software to
 * other organizations or individuals is not granted;  that must be
 * negotiated with the PSC.  Neither the PSC nor Carnegie Mellon
 * University make any representations about the suitability of this
 * software for any purpose.  It is provided "as is" without express or
 * implied warranty.
 *****************************************************************************/

#include <stdio.h>
#include "struct_defs.h"
#include "err_defs.h"
#include "disp_defs.h"

/* 
Fill in displacement section of model reading from displacement file */

void add_displace (displace_data, thismodel)
FILE *displace_data; 
Model *thismodel;

{
	int i;
	float x, y, z;
        Vertex *thisvertex;

	ger_debug("add_displace:");

	/* Memory allocation for the displacement list */
	if ( !(thismodel->displace_list= 
			(Vertex *)malloc(thismodel->vertex_count * sizeof(Vertex)) ) )
		ger_fatal (
		  "add_displace: unable to allocate %d bytes",
		  thismodel->vertex_count * sizeof(Vertex) );
	
	/* Initializes thisvertex pointer to point to first vertex */
	thisvertex = thismodel->displace_list;

	/* Fills up displacement list, vertex by vertex */
	for (i = 0; i<thismodel->vertex_count; i++) {
		fscanf (displace_data, "%f %f %f", &x, &y, &z);
		thisvertex->x = x/10.0;
		thisvertex->y = y/10.0;
		thisvertex->z = z/10.0;
		thisvertex->color = (Color *)NULL;
		thisvertex->normal = (Vector *)NULL;
		thisvertex++;
		 }
}
