Mp3d is a tool for examining models in a P3D model file.  It provides
the capability to view P3D files interactively, and can also be used
to produce new P3D files containing single views of existing models or
flybys of existing models.

Mp3d uses a point-and-click user interface based on Motif to control a
renderer which can rapidly draw 3D models.  Mp3d is the name given at
the PSC to the version of display-p3d which uses this Motif interface
with the Painter renderer.  Other combinations are also possible; see
for example display-p3d.t.

On the PSC machines, mp3d uses the Painter renderer.  This renderer
uses lines and polygons to draw objects from back to front, so that
near things cover up things which are farther away.  This is called
the Painter's Algorithm, because it is what real painters supposedly
do.  This algorithm is fairly fast and general, but it is not perfect.
Sometimes, from some angles, display-p3d will show an object which
should be hidden by another object, or vice versa.  We're sorry about
this, but using this simple renderer allows display-p3d to be used by
users with the widest possible range of home equipment.  The algorithm
will work best if all the objects (polygons, lines, etc.) in a model
are around the same size.

Mp3d draws on your workstation or X terminal screen using one of the
two X Window System device drivers for our CGM translator, GPlot.  By
default the "xws" device driver is used; users with monochrome
displays may prefer the "xl" device driver.  To change the device
driver, do the following.  If you want to use device "xl", driver, for
example) place a file named p3d_dflts.lsp in the directory from which
you will be running mp3d.  The file should contain the following line:

	(setq p3d-device "xl")

When you start up mp3d, that file will be read and the "xl" device
will be used.  A number of other parameters, for example the default
attributes used by mp3d, can be changed by the same mechanism.  We
hope to add a more convenient mechanism in the future.  Note that only
the two devices "xws" and "xl" will work with mp3d; to use other GPlot
device drivers use display-p3d (a similar executable built with a
keyboard user interface instead of Motif).  Note also that the
settings in your p3d_dflts.lsp file will effect other P3D renderers,
so it is necessary to keep careful track of them if you are switching
between mp3d and some other P3D renderer.

Once the appropriate display device is set, you can proceed to display
your P3D file.  If the file you want to examine is mymodel.p3d, the
appropriate command is:

% mp3d mymodel.p3d

When the command is entered, the lisp code which makes up the model
will be parsed by the lisp interpreter within display-p3d.  (If you
want to use the interpreter directly, give the display-p3d command
without a file name).  

As the program starts up, a new window will open on your display;
when the first model in your file has been loaded it will be displayed
in that window.  Text will continue to be output to the window in
which you started mp3d.  This text is sometimes informative, but if
you wish to avoid it (for example, to run mp3d in the background),
redirect both the standard output and standard error to /dev/null.
On Unix systems, the command to run mp3d in the background would be:

% mp3d mymodel.p3d >& /dev/null &

If you wish to start up mp3d automatically, or otherwise wish to start
it without providing a model file name, use the name mouse_strt.p3d.
This file is stored in a location from which it can be automatically
found and loaded, so it provides a convenient first model for the
renderer.

Once mp3d has started, an interactive Motif window should appear on
your screen.  That window has a 'help' pulldown menu;  refer to that
menu for operating instructions.  The tool is pretty typical of Motif
applications.

Mp3d will accept X resource information from your .Xdefaults file.
For example, to set the geometry of the mp3d window include the
following line (or something like it) in the file:

mp3d*geometry:	512x640+10+10

Mp3d also accepts the standard X Toolkit command line options.  For
example, the -geometry option can be used as follows to achieve the
same effect as the above .Xdefaults entry:

% mp3d -geometry 512x640+10+10 mymodel.p3d

The option -captive, which prevents new model files from being opened
from mp3d's 'File' menu, is also supported.

If you are using the "xws" device driver and the colors of your model
don't look correct, it may be because the software is having
difficulty controlling the color map of your display.  A quick fix is
to try the Unix command "xstdcmap -all".  If this doesn't work, call
PSC user services or send mail to welling@psc.edu for advice.  Color
map handling is unfortunately rather vendor-dependent and it is not
always easy to convince the display to produce the colors desired.

