Rayshade Renderer Driver
-----------------------------

Files: art_ren.t

Renderer: Interface to the scene file format of the ART ray tracer,
	from the University of Melbourne Dept. of Engineering VORT package

Primitives:
	Intrinsic:
		polygon, sphere, cylinder, torus, triangle strip
	Emulated:
		polyline (as cylinders and spheres), polymarker (as spheres), 
		Bezier patch, mesh, text (as boxes and cylinders following
		the Hershey fonts)

Attributes: color, material, backcull, text-font, text-height, 
	text-stroke-width-fraction, text-thickness-fraction,
	line-diameter, point-diameter, shadows

Lights: light, ambient

Camera handling: complete.

Auxiliary functions:  ren_setup, ren_reset, ren_shutdown.
	ren_free, ren_dump, ren_def_material, and ren_free_material are
	dummy routines.

Hooks:  none

Comments:
	This renderer is an interface to the scene file format of
	the ART ray tracer, from the University of Melbourne Dept. of
	Engineering (authors David Hook and others).

	The operation of this renderer is tied to the behavior of the
	trivial user interface, tui.c.  As such, it should be built
	inter render-p3d only;  interactive user interfaces may cause
	it to produce invalid scene files.  This should not be a problem
	until that happy day when interactive ray tracing arrives.

	Objects are output at rendering traversal time.  Output will be
	written to the file named by p3d-outfile (set in p3d_dflts.lsp
	or p3d_global.lsp).  If that file name is set to "-", output 
	will be directed to the standard output.  Objects are described 
	hierarchically;  at this point light sources are described as a 
	flat list.

	If the renderer hint "make-shellscript" is set to true in
	p3d_dflts.lsp or p3d_global.lsp, the output will be a csh
	shell script which runs ART.  (The command used to start
	ART is set at compile time).  This is probably the easiest
	way to run this renderer, with a command like:

		render-p3d myfile.p3d | csh

	In this mode, the first output image will be named frame_0000.pix,
	and subsequent images will be numbered incrementally.  This
	allows this renderer to be used to produce animation.  The
	initial frame number can be changed by setting initial-frame-id;
	see below.

	The renderer looks for the following attribute-value pairs in the
	'p3d-hints' list defined in p3d_dflts.lsp or p3d_global.lsp.
	They are:

	  make-shellscript	boolean;  see above

	  x-resolution		integer;  x resolution at which to render
					  (shell script mode only)

	  y-resolution		integer;  y resolution at which to render
					  (shell script mode only)

	  initial-frame-id	integer;  initial frame number
					  (shell script mode only)

	  ignore-text		boolean;  ignore text primitives (because
					  they take up a lot of file space
					  and render slowly)

	  rays-per-pixel	integer;  rays to trace for each pixel

	  max-reflection-depth	integer;  number of bounces to allow
					  reflected light.  A value
					  of 0 causes ray casting,
					  such that no shadows are cast.

	The current implementation is quite complete.  Text is drawn
	by building Hershey font characters out of boxes mitred with
	cylinders;  the results are quite good but take up a lot of
	file space and are slow to render.  See the 'ignore-text hint.
	Vertex colors and normals are properly handled, except in the 
	case of polylines.  There each line segment is drawn with the
	color of the first of the two vertices defining it, as there
	is no color interpolation for cylinders.  See the documentation
	for ART for other limitations;  ART imposes the restriction 
	that vertex colors and normals cannot be interpolated on 
	polygons with more than four vertices, for example.

	The full source and documents for ART and the rest of the VORT
	software is available by anonymous FTP from gondwana.ecr.mu.oz.au
	(internet id 128.250.1.63).  The authors have made a number of
	enhancements in support of P3D, so if you have an old version
	of the code it might be necessary to update it.

Known bugs:
	none 
