/*
 * Copyright (C) 1992, Board of Trustees of the University of Illinois.
 *
 * Permission is granted to copy and distribute source with out fee.
 * Commercialization of this product requires prior licensing
 * from the National Center for Supercomputing Applications of the
 * University of Illinois.  Commercialization includes the integration of this 
 * code in part or whole into a product for resale.  Free distribution of 
 * unmodified source and use of NCSA software is not considered 
 * commercialization.
 *
 */
/* $Id: portable.h,v 1.2 1993/05/05 17:10:02 gbourhis Exp $ */


/*
*   portable.h
*
*   Header file for portable type declarations and other stuff
*
*  Quincey Koziol                       Dec. 1991
*
*/

#ifndef PORTABLE_H
#define PORTABLE_H

/* Check if we are on a MS-DOS machine */
/* M_I86 is predefined for all the 16-bit MS-DOS compilers we have */
#ifdef M_I86
#if defined(TRUE) | defined(FALSE)
typedef unsigned char boolean;          /* define a boolean type */
#else
typedef enum {FALSE=0,TRUE=1} boolean;  /* define a boolean type */
#endif
typedef signed char int8;               /* define an 8-bit signed integer */
typedef unsigned char uint8;            /* define an 8-bit unsigned integer */
typedef signed int int16;               /* define a 16-bit signed integer */
typedef unsigned int uint16;            /* define a 16-bit unsigned integer */
typedef signed long int32;              /* define a 32-bit signed integer */
typedef unsigned long uint32;           /* define a 32-bit unsigned integer */
typedef float float32;                  /* define a 32-bit IEEE float */
typedef double float64;                 /* define a 64-bit IEEE float */
#else
#ifdef sun
#define signed
#endif
#ifdef __hpux
#define signed
#endif
#if defined(TRUE) | defined(FALSE)
typedef unsigned char boolean;          /* define a boolean type */
#else
typedef enum {FALSE=0,TRUE=1} boolean;  /* define a boolean type */
#endif
typedef signed char int8;               /* define an 8-bit signed integer */
typedef unsigned char uint8;            /* define an 8-bit unsigned integer */
typedef signed short int int16;         /* define a 16-bit signed integer */
typedef unsigned short int uint16;      /* define a 16-bit unsigned integer */
typedef signed int int32;               /* define a 32-bit signed integer */
typedef unsigned int uint32;            /* define a 32-bit unsigned integer */
typedef float float32;                  /* define a 32-bit IEEE float */
typedef double float64;                 /* define a 64-bit IEEE float */
#endif

/* Virtual memory allocation macros */
#define vmalloc             malloc
#define vfree               free
#define vrealloc            realloc

/* Macros for exception handling */
#define EXCHECK(a,b)    if(a) goto b

#endif  /* PORTABLE_H */

