/*
 * Copyright (C) 1992, Board of Trustees of the University of Illinois.
 *
 * Permission is granted to copy and distribute source with out fee.
 * Commercialization of this product requires prior licensing
 * from the National Center for Supercomputing Applications of the
 * University of Illinois.  Commercialization includes the integration of this 
 * code in part or whole into a product for resale.  Free distribution of 
 * unmodified source and use of NCSA software is not considered 
 * commercialization.
 *
 */
#if ! defined(lint) && ! defined(LINT)
static char rcs_id[] = "$Id: load.c,v 1.9 1993/11/05 18:08:58 gbourhis Exp $";
#endif
/* $Log: load.c,v $
 * Revision 1.9  1993/11/05  18:08:58  gbourhis
 * Some changes in ScaleRasterImage().
 * Test if ReadHDFRasterGroupData() worked well before calling
 * ScaleRasterImage() in ReadHDFObject().
 *
 */

#include <stdio.h>

#include <X11/Xlib.h>
#include <X11/Intrinsic.h>
#include <Xm/Xm.h>
#include <Xm/Form.h>
#include <Xm/FileSB.h>

#ifdef HDF32
#include <hdf/hdf.h>
#else
#include <hdf/df.h>
#endif

#include <hb/hbox.h>

#include "collageP.h"
#include "netdata.h"
#include "net.h"
#include "list.h"

#ifndef MALLOC
#define MALLOC	malloc
#define FREE	free
#endif

#define LOAD_MODULE_NAME	"Load"

static Widget	fileBox;
static int	fileBoxOpen;
static int	IsItAnimationLoad;

static char *curFileName = (char *) 0;
static Display *myDpy;
static Widget rootWidget;

extern Data *ReadHDFPalette8Data();
extern Data *ReadHDFRasterGroupData();
extern Data *ReadHDFSDSData();
extern List fileLoadList;

void ScaleRasterImage(d)
Data *d;
{
Data *pal;
unsigned char min,max;

	if ((d->dot != DOT_Array) || (d->dost != DOST_Char) || (d->rank != 2)){
		return; /* only scales raster images */
		}
	pal = d->group;
	if (!pal){
		return; /* no palette */
		}

	RemoveGapsFromImage(d->data,d->data,d->dim[0],d->dim[1],
				pal->data,pal->data);
	SetCharMinMax(d->data,d->dim[0],d->dim[1],&min,&max);
	if ((max - min + 1) > NCOLORS) {
#ifdef DEUBG
		printf("Squeezing Image\n");
#endif
		SqueezeImage(d->data,d->data,d->dim[0],d->dim[1],
                                max,BASE_PIX,res_gotten.last_pixel,
                                pal->data,pal->data);
		}
	else {
#ifdef DEUBG
		printf("Shifting Image\n");
#endif
		ShiftImage(d->data,d->data,d->dim[0],d->dim[1],
				BASE_PIX,pal->data,pal->data);
		}

	return;
}

Data *ReadHDFObject(fileName,tag,ref,isanim)
char *fileName;
uint16 tag,ref;
Boolean isanim;
{
Data *d;
int x;
	
#ifdef DEBUG 
	{
	int group;
	group = (tag / 100)*100;
	printf("Group is %d\n",group);
	printf("ReadHDFObject(): reading in tag %d, ref %d from file \"%s\"\n",
				tag,ref,fileName);
	}
#endif
	d = (Data *) 0;
	switch (tag) {
		case DFTAG_IP8:
		case DFTAG_LUT:
		case DFTAG_LD:
#ifdef DEBUG
			printf("ReadHDFObject(): Reading a palette\n");
#endif
			d = ReadHDFPalette8Data(fileName,tag,ref,isanim);
			break;
		case DFTAG_ID8:
		case DFTAG_RI8:
		case DFTAG_CI8:
		case DFTAG_II8:
		case DFTAG_ID:
		case DFTAG_RI:
		case DFTAG_CI:
		case DFTAG_RIG:
		case DFTAG_MD:
		case DFTAG_MA:
		case DFTAG_CCN:
		case DFTAG_CFM:
		case DFTAG_AR:
#ifdef DEBUG
			printf("ReadHDFObject(): Reading a Raster Group\n");
#endif
			d = ReadHDFRasterGroupData(fileName,tag,ref,isanim);
			if (d && (!isanim) && SHOULD_SCALE_IMAGE) {
				ScaleRasterImage(d);
				}
		break;
                    case DFTAG_SDG:
                    case DFTAG_SD:
#ifdef HDF32
                    case DFTAG_NDG:
#endif
#ifdef DEBUG
			printf("ReadHDFObject(): Reading an SDS\n");
#endif
			d = ReadHDFSDSData(fileName, tag, ref, isanim);
			break;
		default:
			WarningMesg(
			"Don't know what to do with this HDF object\n");
			break;
				
		};

	return(d);

} /* ReadHDFObject() */


HBLoad(numItems, tagAndRefs)
int numItems;
tag_ref_ptr tagAndRefs;
{
Data *d;
        int i;
        int x;
        if (!numItems) {
                WriteMesg("No data object selected\n");
                return;
	        }
#ifdef DEBUG
        printf("number of items is %d\n",numItems);
        for (i=0; i <numItems; i++)     {
                printf("tag = %d, Ref = %d\n",tagAndRefs[i].tag, tagAndRefs[i].ref);
        }
#endif
	if (IsItAnimationLoad) {
		AnimLoadNewAnimation(curFileName,tagAndRefs,numItems);
		}
	else {

		for (x = 0 ; x < numItems; x++) {
			d = ReadHDFObject(curFileName,tagAndRefs[x].tag,
					tagAndRefs[x].ref, False);
			if (d) {
				NetSendDataObject(0,d,TRUE,TRUE, 
						LOAD_MODULE_NAME);
				}
			}
		}
} /* HBLoad() */

static void LoadText(fileName)
char *fileName;
{
static Text t;
char buff[1024];


	if (!(t.title = (char *)MALLOC(strlen(fileName)+1))) {
		ErrMesg("Out of Memory reading text\n");
		return;
		}
	strcpy(t.title,fileName);
	if (!(t.dim = TextReadFile(t.title,&(t.textString)))) {
		sprintf(buff,"Couldn't read text file %s",fileName);
		ErrMesg(buff);
		return;
		}
	t.selLeft = 0;
	t.selRight = 0;
	t.insertPt = 0;
	t.numReplace = t.dim;
	t.replaceAll = TRUE;
	t.id = "me";
	NetSendText(0,&t,TRUE,LOAD_MODULE_NAME);
}


HBCancel(browseShell)
Widget browseShell;
{
#ifdef DEBUG
        printf("HDF Browse cancelled\n");
#endif
/*
        XtDestroyWidget(browseShell);
*/
}

/*
LoadAnimation(fileName)
char *fileName;
{
int num;
unsigned char *raster;
char buff[1024];
Data data;
int xdim,ydim;
int hasPalette;
int x;

	if (!(num = ReadNumberOfRasterImages(fileName))) {
		return(0);
		}
	if (num < 1) {
		sprintf(buff,"File %s doesn't contain any animation images\n",
			fileName);
		ErrMesg(buff);
		return(0);
		}
	if (!ReadDimsOfRasterImage(fileName,&xdim,&ydim,&hasPalette)) {
		sprintf(buff,"Couldn't get dimensions of image in file %s\n",
			fileName);
		ErrMesg(buff);
		return(0);
		}
	data.label = fileName;
	data.entity = ENT_File;
	data.dot = DOT_Array;
	data.dost = DOST_Char;
	data.dim[0] = xdim;
	data.dim[1] = ydim;
	data.rank = 2;
	if (!(data.data = (char *) MALLOC(xdim * ydim))) {
		sprintf(buff,"Out of Memory reading image from file %s\n",
			fileName);
		ErrMesg(buff);
		return(0);
		}
	for (x = 0; x < num; x++) {
		if (ReadRIS8FromAnimation(fileName,data.data,xdim,ydim,x)) {
			NetSendAnimation(0,data,TRUE,TRUE,LOAD_MODULE_NAME);
			}
		}
	FREE(data.data);
	return(1);
}
*/


static void CBLoadFileOk(w,client_data,call_data)
Widget w;
caddr_t client_data;
caddr_t call_data;
{
XmFileSelectionBoxCallbackStruct *f;
char *fileName;
static char buff[2048];

        if (fileBoxOpen == FALSE) {
		return;
		}

        f = (XmFileSelectionBoxCallbackStruct *) call_data;
        XtUnmanageChild(fileBox);
        fileBoxOpen = FALSE;
        XmStringGetLtoR(f->value,XmSTRING_DEFAULT_CHARSET,&fileName);

	curFileName = fileName;
	if (IsItHDF(fileName)) {
		hbMain(rootWidget,fileName, NULL,HBLoad,HBCancel);
		}
	else if (IsItGIF(fileName)) {
		LoadGIF(fileName);
		}
	else if (IsItXWD(fileName)) {
		LoadXWD(fileName);
		}
	else if (IsItText(fileName)) {
		LoadText(fileName);
		}
	else {
		sprintf(buff,"Unknown File Format for %s\nKnown file formats are HDF, GIF, ASCII text files, and XWD\n",fileName);
		ErrMesg(buff);
		}
}

static void CBLoadFileCancel(w,client_data,call_data)
Widget w;
caddr_t client_data;
caddr_t call_data;
{
        XtUnmanageChild(fileBox);
        fileBoxOpen = FALSE;
	IsItAnimationLoad = FALSE;
}

void CBLoadFile(w,client_data,call_data)
Widget w;
caddr_t client_data;
caddr_t call_data;
{
        if (fileBoxOpen) {
                XRaiseWindow(myDpy,XtWindow(fileBox));
                ErrMesg("File Select Window already open\n");
                return;
                }
        XtManageChild(fileBox);
        fileBoxOpen = TRUE;
	IsItAnimationLoad = FALSE;
}

void CBLoadAnimation(w,client_data,call_data)
Widget w;
caddr_t client_data;
caddr_t call_data;
{
        if (fileBoxOpen) {
                XRaiseWindow(myDpy,XtWindow(fileBox));
                ErrMesg("File Select Window already open\n");
                return;
                }
        XtManageChild(fileBox);
        fileBoxOpen = TRUE;
	IsItAnimationLoad = TRUE;
}

int LoadInit(topWidget)
Widget topWidget;
{
Arg argList[10];

	rootWidget = topWidget;
        fileBox =  XmCreateFileSelectionDialog(rootWidget,"fileSelectionBox",
                        argList,0);
        XtAddCallback(fileBox,XmNokCallback,CBLoadFileOk,0);
        XtAddCallback(fileBox,XmNcancelCallback,CBLoadFileCancel,0);
        fileBoxOpen = FALSE;

	myDpy = XtDisplay(rootWidget);

	return(1);
}



LoadFromStart(fileName)
char *fileName;
/* this routine called as a result of start up params */
{
char errBuff[1024];
int num;
int xdim,ydim;
int hasPalette;
Data *image;
Data *pal;
char *textString;
int length;
Text text;
int x;

	image = DataNew();
	pal = DataNew();
#ifdef DEBUG
		printf("LoadFromStart(): checking if it's an HDF\n");
#endif
	if (IsItHDF(fileName)) {
#ifdef DEBUG
		printf("LoadFromStart(): It's an HDF file \n");
#endif
		if (num = ReadNumberOfRasterImages(fileName)) {
		    if (num > 1) {
			for (x = 0; x < num ; x++ ) {
			    image = DataNew();
			    pal = DataNew();
                            if(ReadRasterImage(fileName,image,pal,&hasPalette)){
				NetSendArray(0,image,True,True,
					LOAD_MODULE_NAME,True);
				if (hasPalette)   {
					NetSendPalette8(0,pal->label,
						pal->data,(char *)NULL,True,
							LOAD_MODULE_NAME);
					}
				}
			    else {
				sprintf(errBuff,
					"Can't read raster image from file\n%s",
					fileName);
				ErrMesg(errBuff);
				return(0);
				}
			  }
			}
		    else {
			if (ReadRasterImage(fileName,image,pal,&hasPalette)) {
				/*DataAddEntry(image);*/
				NetSendRaster8(0,image,True,True,
						LOAD_MODULE_NAME);
				if (hasPalette)   {
					NetSendPalette8(0,pal->label,
						pal->data,(char *)NULL,True,
							LOAD_MODULE_NAME);
					/*DataAddEntry(pal);*/
					}
				}
			else {
				sprintf(errBuff,
					"Can't read raster image from file\n%s",
					fileName);
				ErrMesg(errBuff);
				return(0);
				}
			}
		    }
		else {
			int rank, ref, ispre32 = True;
			int32 dim[3];
			Data *d;

			if (! DFSDgetdims(fileName, &rank, dim, 3)) {
				/* we found an SDS */
				ref = DFSDlastref();
#ifdef HDF32
				if (DFSDpre32sdg(fileName, (uint16)ref,
						 &ispre32))
					ispre32 = False; 
				/* guess it's a NDG that's */
				/* incompatible with the SDG structure */
#endif

				d = ReadHDFSDSData
					(fileName,
#ifdef HDF32
					 ispre32 ? DFTAG_SDG : DFTAG_NDG,
#else
					 DFTAG_SDG,
#endif /* defined HDF32 */
					 ref, False);
				if (d)
					NetSendDataObject(0,d,TRUE,TRUE, 
							  LOAD_MODULE_NAME);
				}
			else
				return 0;
			}
		}
	else if (IsItGIF(fileName)) {
		LoadGIF(fileName);
		}
	else if (IsItXWD(fileName)) {
		LoadXWD(fileName);
		}
	else if (IsItText(fileName)) {
		if (length = TextReadFile(fileName,&(text.textString))) {
			if (!(text.title =(char *)MALLOC(strlen(fileName)+1))){
				ErrMesg("Out of Memory loading text");
				return(0);
				}
			strcpy(text.title,fileName);
			text.selLeft = 0;
			text.selRight = 0;
			text.insertPt = 0;
			text.replaceAll = 1;
			text.dim = length;
			NetSendText(0,&text,True,LOAD_MODULE_NAME);
			}
		}
	else {
		sprintf(errBuff,
			"file %s\n is of unknown file format (not HDF, GIF, XWD or Text)",
			fileName);
		ErrMesg(errBuff);
		return(0);
		}
	return(1);
}

LoadArgFiles(fileLoadList)
List fileLoadList;
{
char *fileName;

	fileName = (char *) ListHead(fileLoadList);
	while (fileName) {
		LoadFromStart(fileName);
		fileName = (char *) ListNext(fileLoadList);
		}
	
}

void
CBTimeToLoadFiles(w, client_data, event)
Widget w;
caddr_t client_data;
XEvent *event;
{
	LoadArgFiles(fileLoadList);
}

