/*
 * Copyright (C) 1992, Board of Trustees of the University of Illinois.
 *
 * Permission is granted to copy and distribute source with out fee.
 * Commercialization of this product requires prior licensing
 * from the National Center for Supercomputing Applications of the
 * University of Illinois.  Commercialization includes the integration of this 
 * code in part or whole into a product for resale.  Free distribution of 
 * unmodified source and use of NCSA software is not considered 
 * commercialization.
 *
 */
#if ! defined(lint) && ! defined(LINT)
static char rcs_id[] = "$Id: dtm.c,v 1.11 1993/11/05 17:51:27 gbourhis Exp $";
#endif

/* $Log: dtm.c,v $
 * Revision 1.11  1993/11/05  17:51:27  gbourhis
 * fix a bug in GotDol(), when the function is "BERASE".
 *
 * Revision 1.10  1993/07/13  21:14:07  gbourhis
 * mods. in GotDtmOrSrv() : add calls to handleLock(), AddUser() & RemoveUser().
 *
 * Revision 1.9  1993/07/07  15:29:45  gbourhis
 * Add GotDol routine.
 *
 */

#include <stdio.h>
#include <signal.h>

#include <X11/Xlib.h>
#include <X11/StringDefs.h>
#include <X11/Intrinsic.h>
#include <dtm/dtm.h>
#include <dtm/sds.h>
#include <dtm/ris.h>
#include <dtm/col.h>
#include <dtm/dol.h>
/*
#include <dtm/mdd.h>
*/
#include <dtm/srv.h>

#include "pal.h"
#include "view.h"
#include "viewer.h"
#include "doodle.h"
#include "mode.h"
#include "net.h"
#include "netdata.h"
#include "profUI.h"

#ifndef DTM_STRING_SIZE
#define DTM_STRING_SIZE 1024
#endif


extern View *NewRast();		/* from ras.c */
extern View *NewSheet();	/* from sheet.c */
extern void NewCdata();		/* from main.c */
/* extern void ReceiveSelection();
   extern int NewTextData(); */
/* extern void ReturnInOut(); */
/* extern void CBSetMode(); */
extern void DrawCollabSelectArea(); /* from area.c */
extern void DrawCollabDoodle();	/* from doodle.c */
extern void DrawCollabContDoodle(); /* from doodle.c */
extern void AddNewPal();	/* from palControl.c */
extern void ConvertToXColors();	/* from support.c */
extern void Got3Dsds();		/* from threeDim.c */
#ifdef MAC_COMPAT
extern void RegisterPopup();	/* from control.c */
#endif /* MAC_COMPAT */

extern NetPort *outP;



void
GotDelete(data, new)
	Data *data;
	int new;
{
}


void
GotCol(data, new)
	Col *data;
	int new;
{
	int i;
	Cdata *d;
	View *V;
	int length;
	POINT *doodle;

	if (data->selType == COL_DOODLE_DISC)
	{
	    if (!strcmp(data->func, "CLEAR"))
	    {
		    DrawCollabClearDoodle(data->title, data->id);
	    }
	    else if (!strcmp(data->func,"SET"))
	    {
/*EJB
		if (Mode != FREEHAND)
		{
			CBSetMode(0, FREEHAND, 0);
		}
*/
	    }
	    else if (!strcmp(data->func,"ERASE"))
	    {
		length = data->dim;
		if (!(doodle = (POINT *)MALLOC(sizeof(POINT) * length)))
		{
			ErrMesg("Out of Memory.  Can't read collab doodle\n");
			return;
		}
	
		for (i=0; i<length; i++)
		{
			doodle[i].x = (short) data->data[i].x;
			doodle[i].y = (short) data->data[i].y;
		}
		DrawCollabErase(data->title, data->id, doodle, length);
	    }
	    else if (!strcmp(data->func, "BERASE"))
	    {
		length = data->dim;
		if (!(doodle = (POINT *)MALLOC(sizeof(POINT) * length)))
		{
			ErrMesg("Out of Memory.  Can't read collab doodle\n");
			return;
		}
	
		for (i=0; i<length; i++)
		{
			doodle[i].x = (short) data->data[i].x;
			doodle[i].y = (short) data->data[i].y;
		}
	
		DrawCollabEraseBlock(data->title, data->id, doodle, length);
	    }
	    else
	    {
		DColor color;

		length = data->dim;
		if (!(doodle = (POINT *)MALLOC(sizeof(POINT) * (length - 1))))
		{
			ErrMesg("Out of Memory.  Can't read collab doodle\n");
			return;
		}
	
		color.red = (short)(data->data[0].x);
		color.green = (short)(data->data[0].y);
		color.blue = (short)(data->data[0].z);
		for (i=1; i<length; i++)
		{
			doodle[i - 1].x = (short) data->data[i].x;
			doodle[i - 1].y = (short) data->data[i].y;
		}

		if (length > 1)
		{
			DrawCollabDoodle(data->title, data->id,
				data->width, doodle, (length - 1), &color);
		}
	    }
	} /* end if type == COL_DOODLE_DISC */

	if (data->selType == COL_DOODLE_CONT)
	{
	    if (!strcmp(data->func, "CLEAR"))
	    {
		    DrawCollabClearDoodle(data->title, data->id);
	    }
	    else if (!strcmp(data->func,"SET"))
	    {
/*EJB
	There is no longer a set doodle mode function.
*/
	    }
	    else if (!strcmp(data->func,"ERASE"))
	    {
	    }
	    else if (!strcmp(data->func, "BERASE"))
	    {
		length = data->dim;
		if (!(doodle = (POINT *)MALLOC(sizeof(POINT) * length)))
		{
			ErrMesg("Out of Memory.  Can't read collab doodle\n");
			return;
		}
	
		for (i=0; i<length; i++)
		{
			doodle[i].x = (short) data->data[i].x;
			doodle[i].y = (short) data->data[i].y;
		}
	
		DrawCollabEraseBlock(data->title, data->id, doodle, length);
	    }
	    else
	    {
		DColor color;

		length = data->dim;
		if (!(doodle = (POINT *)MALLOC(sizeof(POINT) * (length - 1))))
		{
			ErrMesg("Out of Memory.  Can't read collab doodle\n");
			return;
		}
	
		color.red = (short)(data->data[0].x);
		color.green = (short)(data->data[0].y);
		color.blue = (short)(data->data[0].z);
		for (i=1; i<length; i++)
		{
			doodle[i - 1].x = (short) data->data[i].x;
			doodle[i - 1].y = (short) data->data[i].y;
		}

		if (length > 1)
		{
			DrawCollabContDoodle(data->title, data->id,
				data->width, doodle, (length - 1), &color);
		}
	    }
	}

	if (data->selType == COL_AREA)
	{
		DrawCollabSelectArea(data->title, data->id,
			(int)data->data[0].x, (int)data->data[0].y,
			(int)data->data[1].x, (int)data->data[1].y);
	}

	if (data->selType == COL_LINE)
	{
		DrawCollabSelectLine(data->title, data->id,
			(int)data->data[0].x, (int)data->data[0].y,
			(int)data->data[1].x, (int)data->data[1].y);
	}

	if (data->selType == COL_POINT)
	{
		if (!strcmp(data->func, "VALUE"))
		{
			DrawCollabSelectPoint(data->title, data->id,
				(int)data->data[0].x, (int)data->data[0].y);
		}
		else if (!strcmp(data->func, "POINTER"))
		{
			DrawCollabGlobalPoint(data->title, data->id,
				(int)data->data[0].x, (int)data->data[0].y);
		}
		else
		{
			fprintf(stderr, "Point Selection, func = (%s)\n", data->func);
		}
	}

}

void
GotDol(data, new)
	Dol *data;
	int new;
{
	int i;
	Cdata *d;
	View *V;
	int length;
	POINT *doodle;

	switch (data->selType) {
	    case DOL_DOODLE_DISC:
	    case DOL_DOODLE_CONT:
		if (!strcmp(data->func, "CLEAR"))
		{
			DrawCollabClearDoodle(data->title, data->id);
		}
		else if (!strcmp(data->func,"ERASE"))
		{
			length = data->dim / 2;
			if (!(doodle = (POINT *)MALLOC(sizeof(POINT)*length)))
			{
				ErrMesg("Out of Memory.  Can't read collab doodle\n");
				return;
			}
	
			for (i=0; i < data->dim; i += 2)
			{
				doodle[i/2].x = data->data[i];
				doodle[i/2].y = data->data[i+1];
			}
			DrawCollabErase(data->title, data->id, doodle, length);
			FREE(doodle);
		}
		else if (!strcmp(data->func, "BERASE"))
		{
			length = data->dim / 2;
			if (!(doodle = (POINT *)MALLOC(sizeof(POINT)*length)))
			{
				ErrMesg("Out of Memory.  Can't read collab doodle\n");
				return;
			}
			
			for (i=0; i < data->dim; i += 2)
			{
				doodle[i/2].x = data->data[i];
				doodle[i/2].y = data->data[i+1];
			}
	
			DrawCollabEraseBlock(data->title, data->id, doodle, length);
			FREE(doodle);
		}
		else if (!strcmp(data->func, "DOODLE"))
		{
			DColor color;

			length = (data->dim - 3) / 2;
			if (!(doodle = (POINT *)MALLOC(sizeof(POINT) * length)))
			{
				ErrMesg("Out of Memory.  Can't read collab doodle\n");
				return;
			}
			
			color.red = data->data[0];
			color.green = data->data[1];
			color.blue = data->data[2];
			for (i=0; i<length; i++)
			{
				doodle[i].x = data->data[2*i+3];
				doodle[i].y = data->data[2*i+4];
			}

			if (length > 1)
			{
				if (data->selType == DOL_DOODLE_DISC)
					DrawCollabDoodle(data->title, data->id,
							 data->width, doodle,
							 length, &color);
				else
					DrawCollabContDoodle
						(data->title, data->id,
						 data->width, doodle,
						 length, &color);
			}
			FREE(doodle);
		}
		else
		{
			fprintf(stderr, "Unknown DOL function : %s\n",
				data->func);
		}
		break;
		/* end case type == COL_DOODLE_DISC */
	    case DOL_AREA:
		DrawCollabSelectArea(data->title, data->id,
			(int)data->data[0], (int)data->data[1],
			(int)data->data[2], (int)data->data[3]);
		break;
	    case DOL_LINE:
		DrawCollabSelectLine(data->title, data->id,
			(int)data->data[0], (int)data->data[1],
			(int)data->data[2], (int)data->data[3]);
		break;
	    case DOL_POINT:
		if (!strcmp(data->func, "VALUE"))
		{
			DrawCollabSelectPoint(data->title, data->id,
				(int)data->data[0], (int)data->data[1]);
		}
		else if (!strcmp(data->func, "POINTER"))
		{
			DrawCollabGlobalPoint(data->title, data->id,
				(int)data->data[0], (int)data->data[1]);
		}
		else
		{
			fprintf(stderr, "Point Selection, func = (%s)\n", data->func);
		}
		break;
	    default:
		fprintf(stderr, "Unknow Selection Type : %d\n", data->selType);
	}

}


void
GotDtmOrSrv(data, new)
	Server *data;
	int new;
{
#ifdef DEBUG
	fprintf(stderr, "GotDtmOrSrv called, new = %d\n", new);
	if (data->inPort == NULL)
	  fprintf(stderr, "data->inPort = NULL\n");
	else
	  fprintf(stderr, "data->inPort = (%s)\n", data->inPort);
#endif
	if (new == 2)		/* means Got Srv */
		if (data->func == SRV_FUNC_CONNECT && outP == NULL)
			outP = data->netPort;
		else if (data->func == SRV_FUNC_DISCONNECT && outP != NULL &&
			 ! outP->open) {
			FREE(outP);
			outP = NULL;
		}
		else if (data->func == SRV_FUNC_LOCK)
			handleLock(TRUE);
		else if (data->func == SRV_FUNC_UNLOCK)
			handleLock(FALSE);
		else if (data->func == SRV_FUNC_ADD_USER)
			AddUser(data->id);
		else if (data->func == SRV_FUNC_REMOVE_USER)
			RemoveUser(data->id);
/*
	ReturnInOut(inPortName, data->inPort);
*/
}

#define LookForPalette()				\
  do {							\
	d->hasPalette = TRUE;				\
	if (!(d->pal = PaletteSearchByName(d->name)))	\
	{						\
		if (!(d->pal = PaletteFirst()))		\
		{					\
			d->hasPalette = FALSE;		\
		}					\
	}						\
     } while (0)

void
GotRis(data, new)
	Data *data;
	int new;
{
	char title[DTM_STRING_SIZE];
	Cdata *d, *assocData;
	View *V;
	int isacopy;

	if ((data->dot == DOT_Array)&&(data->dost == DOST_Char))
	{
		title[0] = '\0';
		strcpy(title, data->label);
		if (title[0] == '\0')
		{
			strcpy(title, "Untitled");
		}
#ifdef MAC_COMPAT
		isacopy = FALSE;
#else
		isacopy = strcmp(&(title[strlen(title) - 5]),
				 " COPY") == 0;
#endif /* MAC_COMPAT */

		if (new && CdataSearchByName(title) == NULL)
		{
			if (!(d = CdataNew()))
			{
				return;
			}
			if (!(d->name = (char *)MALLOC(strlen(title) + 1)))
			{
				fprintf(stderr,
				  "Can't allocate memory for DTM SDS name\n");
				return;
			}
			strcpy(d->name, title);

			d->type = D_CHAR;
			d->xdim = data->dim[0];
			d->ydim = data->dim[1];

			LookForPalette();
#ifdef MAC_COMPAT
			if (strcmp(title, "Whiteboard") == 0)
			{
				V = NewRast(d, 1);
				CdataAddEntry(d);
				RegisterPopup(V->shell, "Whiteboard", False,
					      V);
			}
			else
#endif /* MAC_COMPAT */
			V = (data->view_type == V_SHEET) ?
			  NewSheet(d, outP != NULL) : NewRast(d, outP != NULL);
		}
		else
		{
			Data *oldData;

			d = (Cdata *)CdataSearchByName(title);
			if (d == NULL)
			{
				fprintf(stderr, "can't find dataset (%s)\n", title);
				return;
			}
			if (d->image != NULL)
			{
				d->image->data = NULL;
				XDestroyImage(d->image);
				d->image = (XImage *)NULL;
			}
			if (d->doodleImage != NULL)
			{
				XDestroyImage(d->doodleImage);
				d->doodleImage = (XImage *)NULL;
			}
			if (d->fbuff != NULL)
			  if (d->type == D_FLOAT)
			    if (oldData = DataSearchByLabelAndDOTAndDOST
				(title,DOT_Array,DOST_Float))
			      {
				DataDestroy(oldData);
			      }
			    else
				FREE(d->fbuff);
			  else if (d->type == D_INT)
			    if (oldData = DataSearchByLabelAndDOTAndDOST
				(title,DOT_Array,DOST_Int32))
			      {
				DataDestroy(oldData);
			      }
			    else
				FREE(d->fbuff);
			d->fbuff = NULL;

			V = d->V;
			if (data->view_type && V->type != data->view_type)
			  {
			    fprintf(stderr, "Warning: view type mismatch\n");
			  }
			data->view_type = V->type;
			LookForPalette();
		}

		d->type = D_CHAR;
		d->xdim = data->dim[0];
		d->ydim = data->dim[1];
		d->xmag = (int)data->expandX;
		d->ymag = (int)data->expandY;
		d->buff = data->data;

		if (data->associated &&
		    (assocData = CdataSearchByName(data->associated)) != NULL)
		  do {
			int sizeOfElt = 0;

			if (assocData->type == D_FLOAT ||
			    assocData->type == D_INT)
			  {
				if (data->view_type == V_SHEET)
					break;
				if (d->xmag*assocData->xdim != d->xdim)
					d->xmag = d->xdim / assocData->xdim;
				if (d->xmag*assocData->xdim != d->xdim)
				  {
				    fprintf(stderr,
			   "Error, dim of associated data is incompatible\n");
					break;
				  }
				if (d->ymag*assocData->ydim != d->ydim)
					d->ymag = d->ydim / assocData->ydim;
				if (d->ymag*assocData->ydim != d->ydim)
				  {
				    fprintf(stderr,
			   "Error, dim of associated data is incompatible\n");
					break;
				  }
			  }
			d->type = assocData->type;
			if (d->type == D_FLOAT)
			  {
			    if (data->min.f == data->max.f)
			      SetMinMax(assocData->fbuff, assocData->xdim,
					assocData->ydim, &d->min.f, &d->max.f);
			    else
			      d->min.f = data->min.f,
			      d->max.f = data->max.f;
			    sizeOfElt = sizeof(float);
			  }
			else if (d->type == D_INT)
			  {
			    if (data->min.f == data->max.f)
			      SetIntMinMax(assocData->fbuff, assocData->xdim,
					   assocData->ydim, &d->min.i,
					   &d->max.i);
			    else
			      d->min.i = (int)data->min.f,
			      d->max.i = (int)data->max.f;
			    sizeOfElt = sizeof(int);
			  }
			if (d->type == D_FLOAT || d->type == D_INT)
			  {
				d->fbuff = (float *)MALLOC(assocData->xdim*
							   assocData->ydim*
							   sizeOfElt);
				if (d->fbuff == (float *)NULL) {
					fprintf(stderr,
						"Can't allocate memory \n");
					return;
				  }
				memcpy(d->fbuff, assocData->fbuff,
				       assocData->xdim*assocData->ydim*
				       sizeOfElt);
			  }
			assocData->V->next = V;
			V->next = assocData->V;
		  } while (0);
		else if (V->next != NULL) {
			if (V->next->next == V)
				V->next->next = NULL;
			V->next = NULL;
		}

#ifdef MAC_COMPAT
		if (strcmp(title, "Whiteboard"))
#endif /* MAC_COMPAT */
		if (data->view_type == V_SHEET) MakeCurrentSheet(V);
		else NewCdata(V);
		return;
	}
	else
	{
		return;
	}
}


void
GotSds(data, new)
	Data *data;
	int new;
{
	char title[DTM_STRING_SIZE];
	Cdata *d;
	Data *oldData;
	View *V;
	int isacopy;

	if ((data->dot == DOT_Array)&&(data->dost == DOST_Char))
	{
		if (data->rank != 2)
		{
			return;
		}

		title[0] = '\0';
		strcpy(title, data->label);
		if (title[0] == '\0')
		{
			strcpy(title, "Untitled");
		}
#ifdef MAC_COMPAT
		isacopy = FALSE;
#else
		isacopy = strcmp(&(title[strlen(title) - 5]),
				 " COPY") == 0;
#endif /* MAC_COMPAT */
		if (new && CdataSearchByName(title) == NULL)
		{
			if (!(d = CdataNew()))
			{
				return;
			}
			if (!(d->name = (char *)MALLOC(strlen(title) + 1)))
			{
				fprintf(stderr,
				  "Can't allocate memory for DTM SDS name\n");
				return;
			}
			strcpy(d->name, title);

			d->type = D_CHAR;
			d->xdim = data->dim[0];
			d->ydim = data->dim[1];

			LookForPalette();
#ifdef MAC_COMPAT
			if (strcmp(title, "Whiteboard") == 0)
			{
				V = NewRast(d, 1);
				CdataAddEntry(d);
				RegisterPopup(V->shell, "Whiteboard", False,
					      V);
			}
			else
			{
#endif /* MAC_COMPAT */
			V = (data->view_type == V_SHEET) ?
			  NewSheet(d, outP != NULL) : NewRast(d, outP != NULL);
#ifdef MAC_COMPAT
			}
#endif /* MAC_COMPAT */
		}
		else
		{
			d = (Cdata *)CdataSearchByName(title);
			if (d == NULL)
			{
				fprintf(stderr, "can't find dataset (%s)\n", title);
				return;
			}
			if (d->image != NULL)
			{
				d->image->data = NULL;
				XDestroyImage(d->image);
				d->image = (XImage *)NULL;
			}
			if (d->doodleImage != NULL)
			{
				XDestroyImage(d->doodleImage);
				d->doodleImage = (XImage *)NULL;
			}
			if (d->buff != NULL)
			{
/* data was freeed in net.c
				FREE(d->buff);
*/
				d->buff = NULL;
			}
			V = d->V;
			if (data->view_type && V->type != data->view_type)
			  {
			    fprintf(stderr, "Warning: view type mismatch\n");
			  }
			data->view_type = V->type;
			LookForPalette();
		}

		d->xdim = data->dim[0];
		d->ydim = data->dim[1];
		d->xmag = 1;
		d->ymag = 1;
			
		d->buff = data->data;
		d->type = D_CHAR;

#ifdef MAC_COMPAT
		if (strcmp(title, "Whiteboard"))
#endif /* MAC_COMPAT */
		  if (data->view_type == V_SHEET) MakeCurrentSheet(V);
		  else NewCdata(V);

		return;
	}
	else if ((data->dot == DOT_Array)&&(data->dost == DOST_Float))
	{
		if (data->rank != 2)
		{
			if (data->rank == 3)
				Got3Dsds(data, new);
			return;
		}

		title[0] = '\0';
		strcpy(title, data->label);
		if (title[0] == '\0')
		{
			strcpy(title, "Untitled");
		}
		isacopy = strcmp(&(title[strlen(title) - 5]),
				 " COPY") == 0;
		if (new && CdataSearchByName(title) == NULL)
		{
			if (!(d = CdataNew()))
			{
				return;
			}
			if (!(d->name = (char *)MALLOC(strlen(title) + 1)))
			{
				fprintf(stderr,
				  "Can't allocate memory for DTM SDS name\n");
				return;
			}
			strcpy(d->name, title);

			d->type = D_FLOAT;
			d->xdim = data->dim[0];
			d->ydim = data->dim[1];

			LookForPalette();

			V = (data->view_type == V_RASTER) ?
			  NewRast(d, outP != NULL) : NewSheet(d, outP != NULL);
		}
		else
		{
			d = (Cdata *)CdataSearchByName(title);
			if (d == NULL)
			{
				fprintf(stderr, "can't find dataset (%s)\n", title);
				return;
			}
			if (d->image != 0)
			{
				d->image->data = NULL;
				XDestroyImage(d->image);
				d->image = (XImage *)0;
			}
			if (d->doodleImage != 0)
			{
				XDestroyImage(d->doodleImage);
				d->doodleImage = (XImage *)0;
			}
			if (oldData =
			    DataSearchByLabelAndDOTAndDOST(title,DOT_Array,
							   DOST_Char))
			  {
				DataDestroy(oldData);
			  }
			else if (d->buff)
				FREE(d->buff);

			V = d->V;
			d->xmag = d->ymag = 1;
			if (data->view_type && V->type != data->view_type)
			  {
			    fprintf(stderr, "Warning: view type mismatch\n");
			  }
			data->view_type = V->type;
			LookForPalette();
		}

		d->xdim = data->dim[0];
		d->ydim = data->dim[1];

		d->fbuff = (float *)data->data;
		d->type = D_FLOAT;
		if (data->min.f == data->max.f)
		  SetMinMax(d->fbuff, d->xdim, d->ydim,
			    &d->min.f, &d->max.f);
		else
		  d->min.f = data->min.f,
		  d->max.f = data->max.f;

		if (data->view_type == V_RASTER)
		  {
		    if (BuildRasterbuff(d, (int)data->expandX,
					(int)data->expandY, False,
					d->min, d->max))
		      NewCdata(V);
		  }
		else MakeCurrentSheet(V);
		return;
	}
	else if ((data->dot == DOT_Array)&&(data->dost == DOST_Int32))
	{
		if (data->rank != 2)
		{
			if (data->rank == 3)
				Got3Dsds(data, new);
			return;
		}

		title[0] = '\0';
		strcpy(title, data->label);
		if (title[0] == '\0')
		{
			strcpy(title, "Untitled");
		}
		isacopy = strcmp(&(title[strlen(title) - 5]),
				 " COPY") == 0;

		if (new && CdataSearchByName(title) == NULL)
		{
			if (!(d = CdataNew()))
			{
				return;
			}
			if (!(d->name = (char *)MALLOC(strlen(title) + 1)))
			{
				fprintf(stderr,
				  "Can't allocate memory for DTM SDS name\n");
				return;
			}
			strcpy(d->name, title);

			d->type = D_INT;
			d->xdim = data->dim[0];
			d->ydim = data->dim[1];

			LookForPalette();
			V = (data->view_type == V_RASTER) ?
			  NewRast(d, outP != NULL) : NewSheet(d, outP != NULL);
		}
		else
		{
			d = (Cdata *)CdataSearchByName(title);
			if (d == NULL)
			{
				fprintf(stderr, "can't find dataset (%s)\n", title);
				return;
			}
			if (d->image != 0)
			{
				d->image->data = NULL;
				XDestroyImage(d->image);
				d->image = (XImage *)0;
			}
			if (d->doodleImage != 0)
			{
				XDestroyImage(d->doodleImage);
				d->doodleImage = (XImage *)0;
			}
			if (oldData =
			    DataSearchByLabelAndDOTAndDOST(title,DOT_Array,
							   DOST_Char))
			  {
				DataDestroy(oldData);
			  }
			else if (d->buff)
				FREE(d->buff);

			V = d->V;
			if (data->view_type && V->type != data->view_type)
			  {
			    fprintf(stderr, "Warning: view type mismatch\n");
			  }
			data->view_type = V->type;
			LookForPalette();
		}

		d->xdim = data->dim[0];
		d->ydim = data->dim[1];
		d->xmag = 1;
		d->ymag = 1;

		d->fbuff = (float *)data->data;

		d->type = D_INT;
		if (data->min.i == data->max.i)
		  SetIntMinMax(d->fbuff, d->xdim, d->ydim,
			       &d->min.i, &d->max.i);
		else
		  d->min.i = data->min.i,
		  d->max.i = data->max.i;

		if (data->view_type == V_RASTER)
		  {
		    if (BuildRasterbuff(d, (int)data->expandX,
					(int)data->expandY, False,
					d->min, d->max))
		      NewCdata(V);
		  }
		else MakeCurrentSheet(V);
		return;
	}
	else
	{
		return;
	}
}


void
GotPal(data, new)
	Data *data;
	int new;
{
	char title[DTM_STRING_SIZE];
	Cdata *d;
	Palette *p;
/*	View *V;*/

	if (data->dot != DOT_Palette8)
	{
		return;
	}

	title[0] = '\0';
	strcpy(title, data->label);
	if (title[0] == '\0')
	{
		strcpy(title, "Untitled");
	}

	if (new)
	{
		if (!(p = PaletteNew(title)))
		{
			return;
		}
		InitPalette(p);
	}
	else
	{
		if (!(p = PaletteSearchByName(title)))
		{
			return;
		}
	}
	bcopy(data->data, p->rgb, 768);

	ConvertToXColors(p->rgb, p->ccells);
	SetColors(p);

	if (new)
	{
		AddNewPal(p);
	}

	if (data->associated && (d = CdataSearchByName(data->associated))
	    && d->pal != p)
	{
		d->hasPalette = TRUE;
		d->pal = p;
		if (XtIsRealized(d->V->shell))
		  SetPalette(d->V, p);
	}
	else if (d = (Cdata *)RasDataSearchByName(title))
	{
		if (d->pal != p)
		{
			d->hasPalette = TRUE;
			d->pal = p;
			SetPalette(d->V, p);
		}
	}
	return;
}


/*
void
GotTxt(data, new)
	Text *data;
	int new;
{
	Tdata *t;

	UpdateLegend();
	got_count++;

	if (data->selLeft || data->selRight)
	{
		if (!(t = TextSearchByName(data->title)))
		{
			return;
		}
		ReceiveSelection(t->V, data->selLeft, data->selRight);
		return;
	}
	NewTextData(data->title, data->id, data->insertPt, data->replaceAll,
			data->dim, data->textString);
}
*/

