/*
 * Copyright (C) 1992, Board of Trustees of the University of Illinois.
 *
 * Permission is granted to copy and distribute source with out fee.
 * Commercialization of this product requires prior licensing
 * from the National Center for Supercomputing Applications of the
 * University of Illinois.  Commercialization includes the integration of this 
 * code in part or whole into a product for resale.  Free distribution of 
 * unmodified source and use of NCSA software is not considered 
 * commercialization.
 *
 */


#include <stdio.h>
#include <X11/Xlib.h>
#include <X11/StringDefs.h>
#include <X11/Intrinsic.h>
#include <dtm/dtm.h>

#include "viewer.h"
#include "view.h"
#include "net.h"


#define ABS(x)  ((x)>0) ? (x): (-1.0*(x))


extern void MoveSheet();
extern void InitDrawAreaSel();
extern void DrawAreaSel();
extern void HistInternalChange();


extern NetPort *outP;
extern GC	selGC;
extern Display	*myDpy;
extern int	SdrawWidth, SdrawHeight, SdrawAscent;



void
RubberSelect(V, w)
	View *V;
	Widget w;
{
	int x, y;
	unsigned int width, height;

	if (V->area_x1 <= V->area_x2)
	{
		x = V->area_x1;
		width = V->area_x2 - V->area_x1;
	}
	else
	{
		x = V->area_x2;
		width = V->area_x1 - V->area_x2;
	}
	if (V->area_y1 <= V->area_y2)
	{
		y = V->area_y1;
		height = V->area_y2 - V->area_y1;
	}
	else
	{
		y = V->area_y2;
		height = V->area_y1 - V->area_y2;
	}
	XDrawRectangle(myDpy, XtWindow(w), selGC, (x - 2), (y - 2),
		(width + 4), (height + 4));
}



void
InitRasterSel(V, w, win_x, win_y)
	View *V;
	Widget w;
	int win_x, win_y;
{
	if (V->areaSelect)
	{
		RubberSelect(V, w);
	}
	V->areaSelect = True;

	V->area_x1 = win_x;
	V->area_y1 = win_y;
	V->area_x2 = V->area_x1;
	V->area_y2 = V->area_y1;
	RubberSelect(V, w);
}


void
RasterSel(V, w, win_x, win_y)
	View *V;
	Widget w;
	int win_x, win_y;
{
	if (win_x < 0)
		win_x = 0;
	if (win_y < 0)
		win_y = 0;
	if (win_x >= V->cData->xdim)
		win_x = V->cData->xdim - 1;
	if (win_y >= V->cData->ydim)
		win_y = V->cData->ydim - 1;

	if ((win_x != V->area_x2)||(win_y != V->area_y2))
	{
		RubberSelect(V, w);
		V->area_x2 = win_x;
		V->area_y2 = win_y;
		RubberSelect(V, w);
	}
}


void
DoneRasterSel(V, w, win_x, win_y)
	View *V;
	Widget w;
	int win_x, win_y;
{
	int x1, y1, x2, y2;

	if (V->area_x2 < V->area_x1)
	{
		x1 = V->area_x2;
		x2 = V->area_x1;
	}
	else
	{
		x1 = V->area_x1;
		x2 = V->area_x2;
	}
	if (V->area_y2 < V->area_y1)
	{
		y1 = V->area_y2;
		y2 = V->area_y1;
	}
	else
	{
		y1 = V->area_y1;
		y2 = V->area_y2;
	}

	if (V->type == V_SHEET)
	{
		x1 = x1 + V->Scroll_x;
		x2 = x2 + V->Scroll_x;
		y1 = y1 + V->Scroll_y;
		y2 = y2 + V->Scroll_y;
	}

	if ((V->cData)&&(V->ispub))
	{
		NetSendAreaSelect(outP, V->cData->name, "HISTOGRAM", x1, y1,
				  x2, y2);
	}
	HistInternalChange(V->cData->name, x1, y1, x2, y2);
}


void
DrawCollabSelectArea(title, id, x1, y1, x2, y2)
	char *title;
	char *id;
	int x1, y1, x2, y2;
{
	Cdata *d;

	d = CdataSearchByName(title);
	if (d)
	{
		if (!(d->V->isUp))
		{
			XtPopup(d->V->shell, XtGrabNone);
			XFlush(myDpy);
		}

		if (d->V->type == V_SHEET)
		{
			int X1, X2, Y1, Y2;

			if (d->V->isUp)
			{
				X1 = (x1 * SdrawWidth * S_DIGITS) - d->V->Scroll_x;
				X2 = (x2 * SdrawWidth * S_DIGITS) - d->V->Scroll_x;
				Y1 = (y1 * SdrawHeight) - d->V->Scroll_y;
				Y2 = (y2 * SdrawHeight) - d->V->Scroll_y;
				InitDrawAreaSel(d->V, d->V->drawArea, X1, Y1);
				DrawAreaSel(d->V, d->V->drawArea, X2, Y2);
			}
			else
			{
				d->V->area_x1 = x1;
				d->V->area_x2 = x2;
				d->V->area_y1 = y1;
				d->V->area_y2 = y2;
			}

			if ((d->V->next)&&(d->V->next->type == V_RASTER))
			{
				int xm1, xm2, ym1, ym2;
				View *V = d->V->next;

				xm1 = x1 * V->cData->xmag;
				ym1 = y1 * V->cData->ymag;
				xm2 = x2 * V->cData->xmag;
				ym2 = y2 * V->cData->ymag;

				if ((V->areaSelect)&&(V->isUp))
				{
					RubberSelect(V, V->drawArea);
				}
				V->areaSelect = True;

				V->area_x1 = xm1;
				V->area_x2 = xm2;
				V->area_y1 = ym1;
				V->area_y2 = ym2;
				if (V->isUp)
				{
					RubberSelect(V, V->drawArea);
				}
			}
		}
		else
		{
			if ((d->V->areaSelect)&&(d->V->isUp))
			{
				RubberSelect(d->V, d->V->drawArea);
			}
			d->V->areaSelect = True;

			d->V->area_x1 = x1;
			d->V->area_x2 = x2;
			d->V->area_y1 = y1;
			d->V->area_y2 = y2;
			if (d->V->isUp)
			{
				RubberSelect(d->V, d->V->drawArea);
			}

			if ((d->V->next)&&(d->V->next->type == V_SHEET))
			{
				View *V = d->V->next;
				int X1, X2, Y1, Y2;
				int xm1, xm2, ym1, ym2;

				xm1 = x1 / d->xmag;
				ym1 = y1 / d->ymag;
				xm2 = x2 / d->xmag;
				ym2 = y2 / d->ymag;

				if (V->isUp)
				{
					X1 = (xm1 * SdrawWidth * S_DIGITS) -
						V->Scroll_x;
					Y1 = (ym1 * SdrawHeight) - V->Scroll_y;
					MoveSheet(V, V->drawArea, X1, Y1);
					X1 = (xm1 * SdrawWidth * S_DIGITS) -
						V->Scroll_x;
					X2 = (xm2 * SdrawWidth * S_DIGITS) -
						V->Scroll_x;
					Y1 = (ym1 * SdrawHeight) - V->Scroll_y;
					Y2 = (ym2 * SdrawHeight) - V->Scroll_y;
					InitDrawAreaSel(V, V->drawArea, X1, Y1);
					DrawAreaSel(V, V->drawArea, X2, Y2);
				}
				else
				{
					V->area_x1 = xm1;
					V->area_x2 = xm2;
					V->area_y1 = ym1;
					V->area_y2 = ym2;
				}
			}
		}
	}
}

