
/*
*  NCSA Telnet source code
*  National Center for Supercomputing Applications
*  November 1, 1987
*  (C) Copyright 1987 The Board of Trustees of the University of Illinois
*
*  Permission is granted to any individual or institution to use, copy,
*  modify, or redistribute this software and its documentation provided
*  this notice and the copyright notices are retained.  This software
*  may not be distributed for profit, either in original form or in
*  derivative works.  The University of Illinois makes no representations
*  about the suitability of this software for any purpose.  
*  THE UNIVERSITY OF ILLINOIS GIVES NO WARRANTY,
*  EITHER EXPRESS OR IMPLIED, FOR THE PROGRAM AND/OR DOCUMENTATION PROVIDED,
*  INCLUDING, WITHOUT LIMITATION, WARRANTY OF MERCHANTABILITY AND WARRANTY
*  OF FITNESS FOR A PARTICULAR PURPOSE.
*/
#ifndef lint
static char *SCCSid = "@(#)options.c	1.5	(NCSA)	8/12/87";
#endif lint

/*
** Options Menu
*/

#include <sys/types.h>
#include <suntool/sunview.h>
#include <suntool/panel.h>
#include <suntool/canvas.h>
#include <sunwindow/notify.h>
#include "machdep.h"
#include "defs.h"
#include "session.h"

extern Frame base_frame;

char psfname[200];
char hpfname[200];
char tekfname[200];
char bfname[200];

/*
** build the menu
*/

Menu optionsmenu;
init_options_menu()
{

	extern struct Pixfont *zzbold;
	caddr_t char_proc();
	caddr_t char_active();
	caddr_t tek_cdp();
	caddr_t tek_cdhp();
	caddr_t tek_cdb();
	caddr_t tek_cdt();
	Menu_item char_gen();

	optionsmenu = menu_create(MENU_FONT,zzbold,
						   MENU_ITEM,
						   MENU_STRING,"Activate Special Characters",/* 1 */
						   MENU_GEN_PROC, char_gen,
						   MENU_ACTION_PROC, char_active,
						   0,
						   MENU_ITEM,
						   MENU_STRING,"Change Special Characters...",/* 2 */
						   MENU_ACTION_PROC,char_proc,
						   MENU_INACTIVE,FALSE,0,
						   MENU_ITEM,
						   MENU_STRING,
						   "Change Default PostScript Device...",/* 3 */
						   MENU_ACTION_PROC,tek_cdp,
						   MENU_INACTIVE,FALSE,0,
						   MENU_ITEM,
						   MENU_STRING,
						   "Change Default HP-GL Device...", /* 4 */
						   MENU_ACTION_PROC,tek_cdhp,
						   MENU_INACTIVE,FALSE,0,
						   MENU_ITEM,
						   MENU_STRING,
						   "Change Default TEK Output File...", /* 5 */
						   MENU_ACTION_PROC,tek_cdt,
						   MENU_INACTIVE,FALSE,0,
						   MENU_ITEM,
						   MENU_STRING,
						   "Change Default BitMap Device...",/* 6 */
						   MENU_ACTION_PROC,tek_cdb,
						   MENU_INACTIVE,FALSE,0,
						   0);
}

/*
** figure out selection from this menu
*/

Notify_value optionshandler(item, event)
Panel_item item;
Event *event;
{
	extern Panel menubar;

	/*
	** only process menu on right button down
	*/

	switch (event_id(event)) {

		case MS_RIGHT:
			if (event_is_up(event))
				return;
			menu_show(optionsmenu,menubar,event,0);
			break;

		default:
			kbdhandler(Session.s_canvas, event);
			break;
	}

	return NOTIFY_DONE;
}

/*
** generate proc for item #1
*/

Menu_item char_gen(mi, op)
Menu_item mi;
Menu_generate op;
{

	switch (op) {
		case MENU_DISPLAY:
			if (!Session.s_spcflag)
				menu_set(mi, MENU_STRING, "Activate Special Characters", 0);
			else
				menu_set(mi, MENU_STRING, "Deactivate Special Characters", 0);
			break;

		case MENU_DISPLAY_DONE:
		case MENU_NOTIFY:
		case MENU_NOTIFY_DONE:
			break;
	}
	return mi;
}

/*
** action proc for #1, allow special chars
*/

caddr_t char_active(m, mi)
Menu m;
Menu_item mi;
{

	Session.s_spcflag = !Session.s_spcflag;
}

/*
** action proc for #2, change special chars
*/

char 		*charmsg[6] = { "Erase Char        :", 
							"Erase Line        :",
							"Interrupt Process :",
					 		"Abort Output      :", 
							"Break             :",
							"Scroll Lock       :"};

caddr_t char_proc(m, mi)
Menu m;
Menu_item mi;
{

	Panel 		chars_panel;
	Frame 		chars_frame;
	Panel_item	chars[6];
	int			i;

	int			width;
	int			height;
	int			left;
	int			top;
	int			y = 0;
	Rect		rr;

	Rect		*rect;
	struct pixrect *pr;
	char		get_special();
	char		*mkprint();
	void		cancel_ok();
	int			result;

	chars_frame = window_create(0, FRAME, FRAME_LABEL,
					"Special Characters",0);
	
	chars_panel = window_create(chars_frame, PANEL, 
								PANEL_BLINK_CARET,TRUE,
								PANEL_LAYOUT, PANEL_HORIZONTAL, 
								0);

	for (i = 0; i < 6; i++) {
		chars[i] = panel_create_item(chars_panel, PANEL_TEXT,
									 PANEL_LABEL_STRING,charmsg[i],
									 PANEL_VALUE,
									 mkprint(Session.s_special[i]),
									 PANEL_NOTIFY_LEVEL,PANEL_ALL,
									 PANEL_VALUE_STORED_LENGTH,2,
									 PANEL_VALUE_DISPLAY_LENGTH,2,
									 PANEL_ITEM_X,0,
									 PANEL_ITEM_Y,y,
									 0);
		y += 23;
	}

	/*
	** create action buttons
	*/

	pr = panel_button_image(chars_panel, " OK ", 6, 0);

	width = pr->pr_width + 10;

	pr = panel_button_image(chars_panel, "CANCEL", 7, 0);

	width += pr->pr_width;
	width += 10;

	rect = (Rect *) panel_get(chars[MAXDEFCHARS-1], PANEL_ITEM_RECT);

	left = (rect->r_width + 20 - width) / 2;

	top = rect_bottom(rect) + 5;

	panel_create_item(chars_panel, PANEL_BUTTON,
					  PANEL_LABEL_IMAGE, pr,
					  PANEL_ITEM_X, left,
					  PANEL_ITEM_Y, top,
					  PANEL_CLIENT_DATA, FALSE,
					  PANEL_NOTIFY_PROC, cancel_ok, 0);

	panel_create_item(chars_panel, PANEL_BUTTON,
					  PANEL_LABEL_IMAGE,
					  panel_button_image(chars_panel, " OK ", 6, 0),
					  PANEL_CLIENT_DATA, TRUE,
					  PANEL_NOTIFY_PROC, cancel_ok, 0);

	window_fit(chars_panel);
	window_fit(chars_frame);

	win_getsize(window_get(base_frame, WIN_FD), &rr);

	width = (int) window_get(chars_frame, WIN_WIDTH);
	height = (int) window_get(chars_frame, WIN_HEIGHT);

	left = (rr.r_width - width) / 2;
	top = (rr.r_height - height) / 2;

	left += (int) window_get(base_frame, WIN_X);
	top += (int) window_get(base_frame, WIN_Y);

	window_set(chars_frame, WIN_X, left, WIN_Y, top, 0);

	/*
	** wait for some input
	*/

	result = (int)window_loop(chars_frame);

	if (result == TRUE) {

		/*
		** update special characters
		*/

		for (i = 0; i < 6; i++)
			Session.s_special[i] = get_special((char *)
											   panel_get_value(chars[i]));

	}

	window_set(chars_frame, FRAME_NO_CONFIRM, TRUE, 0);
	window_destroy(chars_frame);

}

/*
** set up a special character
*/

char get_special(s)
char *s;
{

	if (strlen(s) == 1)
		return *s;

	if (*s == '^')
		return *(++s) & 0x1f;
}

/*
** make a control char print
*/

char printbuf[3];

char *mkprint(c)
char c;
{

	printbuf[2] = '\0';
	printbuf[0] = '^';

	if (c < 31)
		printbuf[1] = c + '@';
	else
		printbuf[1] = '?';

	return printbuf;
}

/*
** cancel or ok
*/

static void cancel_ok(item, event)
Panel_item	item;
Event		*event;
{
	window_return(panel_get(item, PANEL_CLIENT_DATA));
}

/*
** change the default printer device
*/

caddr_t tek_cdp(m, mi)
Menu m;
Menu_item mi;
{
	int  stat;
	char tmp[200];

	stat = dialog(tmp,"Default PostScript Output Device:",70,199,psfname,FALSE);

	if (stat != 0)
		strcpy(psfname, tmp);

	return mi;
}

/*
** change the default plotter device
*/

caddr_t tek_cdhp(m, mi)
Menu m;
Menu_item mi;
{
	int  stat;
	char tmp[200];

	stat = dialog(tmp,"Default HP-GL Output Device:",70,199,hpfname,FALSE);

	if (stat != 0)
		strcpy(hpfname, tmp);

	return mi;
}

/*
** change the default tek capture file
*/

caddr_t tek_cdt(m, mi)
Menu m;
Menu_item mi;
{
	int  stat;
	char tmp[200];

	stat = dialog(tmp,"Default TEK Capture File:",70,199,tekfname,FALSE);

	if (stat != 0)
		strcpy(tekfname, tmp);

	return mi;
}

/*
** change the default bitmap device
*/

caddr_t tek_cdb(m, mi)
Menu m;
Menu_item mi;
{
	int  stat;
	char tmp[200];

	stat = dialog(tmp,"Default BitMap Output Device:",70,199,bfname,FALSE);

	if (stat != 0)
		strcpy(bfname, tmp);

	return mi;
}
