
/*
*  NCSA Telnet source code
*  National Center for Supercomputing Applications
*  November 1, 1987
*  (C) Copyright 1987 The Board of Trustees of the University of Illinois
*
*  Permission is granted to any individual or institution to use, copy,
*  modify, or redistribute this software and its documentation provided
*  this notice and the copyright notices are retained.  This software
*  may not be distributed for profit, either in original form or in
*  derivative works.  The University of Illinois makes no representations
*  about the suitability of this software for any purpose.  
*  THE UNIVERSITY OF ILLINOIS GIVES NO WARRANTY,
*  EITHER EXPRESS OR IMPLIED, FOR THE PROGRAM AND/OR DOCUMENTATION PROVIDED,
*  INCLUDING, WITHOUT LIMITATION, WARRANTY OF MERCHANTABILITY AND WARRANTY
*  OF FITNESS FOR A PARTICULAR PURPOSE.
*/
#ifndef lint
static char *SCCSid = "@(#)log.c	1.6	(NCSA)	8/10/87";
#endif lint

#include <suntool/sunview.h>
#include <suntool/canvas.h>
#include <suntool/scrollbar.h>

/*
** logging routines for debugging
*/

static int console;

extern int DebugLevel;

Frame consoleframe;
Canvas consolecanvas;
Icon db_icon;

short icon_image[] = {
#include "Icons/debug.icon"
};
mpr_static(debug_pixrect, 64, 64, 1, icon_image);
openlog()
{
	int consoleredraw();

	if (DebugLevel == 0)
		return;

	console = VSnewscreen(24,0,80,1);

	/*
	** make the frame and the canvas
	*/

	db_icon = icon_create(ICON_IMAGE,&debug_pixrect, 0);

	consoleframe = window_create(0, FRAME, 
								 FRAME_LABEL, "Telnet Tool Debugging Console",
								 FRAME_ICON,db_icon,
								 WIN_WIDTH,650,
								 WIN_HEIGHT,408,
								 WIN_SHOW, TRUE,
								 0);
						
	consolecanvas = window_create(consoleframe,CANVAS,
								  WIN_WIDTH,650,
								  WIN_HEIGHT,408,
								  WIN_SHOW, TRUE,
								  CANVAS_WIDTH,640,
								  CANVAS_HEIGHT,384,
								  CANVAS_REPAINT_PROC,consoleredraw,
								  0);
	RSattach(1,consoleframe,console,consolecanvas,
			-1, (Scrollbar)0, (Scrollbar)0);
	pw_writebackground(canvas_pixwin(consolecanvas), 0, 0, 640, 384, 
					   PIX_SRC);
}

/*
** display a message
*/

debug(l, s)
int l;
char *s;
{

	if (DebugLevel < l)
		return;

	VSwrite(console, s, strlen(s));
}

/*
** close the log
*/

closelog()
{
	if (DebugLevel < 1)
		return;

	window_set(consoleframe,FRAME_NO_CONFIRM,TRUE,0);
	window_destroy(consoleframe);
}

/*
** redraw the console
*/

consoleredraw(canvas, pixwin, repaint_area)
Canvas canvas;
Pixwin *pixwin;
Rectlist *repaint_area;
{
	VSredraw(RSgetwin(canvas), 0, 0, 79, 23);
}
