/******************************************************************** 
** fits2hdf.h --  Header file to be included in fits2hdf.c 
********************************************************************/

#include "df.h"

#define CARDLENGTH         80
#define BLOCKLENGTH      2880
#define MAXKEYWORDCOL       8
#define MAXDATACOL         30
#define NOTaNUMBER 0x7FFFFFFF     
#define IMAGE_SPREAD 254

typedef int bool;

/* tokens and their classes*/

#define ILLEGAL     -1      /* indicates illegal token */
#define SIMPLE       0
#define BITPIX       1
#define NAXIS        2
#define DIMSIZE      3
#define OTHER        4
#define BSCALE       5
#define BZERO        6
#define DATAMAX      7
#define DATAMIN      8
#define COMMENT      9
#define BLANK       10
#define END        100

/* Table of keywords, together with their token values */

struct class {
       char *word;
       int  value;
} classtab[] = {
    "SIMPLE",   SIMPLE,
    "BITPIX",   BITPIX,
    "NAXIS",    NAXIS,
    "NAXISN",   DIMSIZE,
    "BSCALE",   BSCALE,
    "BZERO",    BZERO, 
    "DATAMAX",  DATAMAX,
    "DATAMIN",  DATAMIN,
    "BLANK",    BLANK,
    "HISTORY",  COMMENT,
    "COMMENT",  COMMENT,
    "END",      END
};

#define NCLASSES (sizeof classtab / sizeof(struct class) )

/* define TOKEN struct, to hold info about a single token */

typedef struct {
      int  class;         /* e.g. SIMPLE, BITPIX, NAXIS, DIMSIZE, etc. */
      int  subclass;      /* currently only 'n' from NAXISn            */
      int  int_val;       /* integer value assigned, if any            */
      float float_val;    /* float value assigned, if any              */
      char str_val[CARDLENGTH+1]; /* string value assigned, if any     */
      char comment[CARDLENGTH+1]; /* comment                           */
} TOKEN;

/* define structs to hold info about FITS file */

/* FITSVALS holds values assigned via keywords in the header */
typedef struct {     
    char  simple;    /* SIMPLE ('T' or 'F')    */
    int   bitpix,    /* BITPIX (16, 32 or -32) */
          rank,      /* currently, the # of NAXISn values not equal to 1 */
          *dimsizes, /* currently, array of NAXISn values not equal to 1 */
          blank;     /* BLANK  */
    float bscale,    /* BSCALE */
          bzero,     /* BZERO  */
          max,       /* DATAMAX */
          min,       /* DATAMIN */
          outblank;  /* value for "blank" to be placed in output */
} FITSVALS;

/* FITSOPTS indicates which optional keywords occurred in header AND 
** were interpreted by this program.
*/
typedef struct { 
    bool    issimple,
            isbzero,
            isbscale,
            ismax,
            ismin,
            isblank;
} FITSOPTS;

typedef struct {
    char *name;       /* name of fits input file */
    FILE *fp;         /* input file pointer      */
    char *block;      /* buffer to hold "current" block of input   */
    int  blockptr;    /* "current" position in current input block */
    char card[CARDLENGTH+1]; /* current header card being processed */
    FITSVALS val;     /* optional attribute values, if selected */
    FITSOPTS opt;     /* tells which optional attribute values chosen */
} FITSFILE;

