/*
	Author		: Sreedhar Sivakumaran
	Notes		:
	
		Test function to open an inport and outport, 
		and to write on outport and read from inport.	
*/

#include <stdio.h>
#include <sys/types.h>
#include <netinet/in.h>
#include <dtmint.h>
#include <dtm.h>
#include "test.h"

int	DTMtestWriteRead( outpname, num_msgs, num_sets )
	char	*outpname;
	int		num_msgs;
	int		num_sets;
{
	int		outport[ 200 ] ;
	char	buf[ MAXMSGLEN ] ;
	int		temp ;
	int		nset, nmsg;

	temp = 0 ;

	/*	
		Open the out port. 
	*/
	if( (outport[ temp ] = DTMmakeOutPort( outpname, DTM_SYNC )) ==DTMERROR){
		fprintf( stderr, "%%Test: Outport open error, %s\n", 
			sherr( DTMerrno ) );
		return 0 ;
	} else {
		fprintf( stdout, "%%Test: Outport %s opened\n", outpname );
	}
		
	if ( num_msgs <= 0 ) num_msgs = 1;
	for ( nmsg = 0 ; nmsg < num_msgs ; nmsg++ ) { 

		/*	Write on outport	*/

		sprintf( buf, MSGHEADER, outpname, (nmsg + 1) );
		if( DTMbeginWrite( outport[ temp ], buf, 
				strlen(buf) + 1 ) == DTMERROR ) {
			fprintf( stderr, "%%Test: ERROR - Outport %d beginWrite, %s\n",
				 outport[ temp ], sherr( DTMerrno ) );
			return 0 ;
		} else {
			fprintf( stdout, "%%Test: Header '%s' written\n", buf );
		}

		/*
			The default is 0 so we have to map that into something normal
		*/
		if ( num_sets <= 0 ) num_sets = 1;
		for ( nset = 0 ; nset < num_sets ; nset++ ) {
			sprintf( buf, MSGDATA, (nset == (num_sets - 1)) ? "=" : "+", 
					outpname, nmsg + 1, nset + 1 );
			if( DTMwriteDataset( outport[ temp ], buf, strlen( buf ) + 1, 
					DTM_CHAR ) == DTMERROR ) {
				fprintf(stderr,"%%Test: ERROR - Outport %d writeDataset, %s\n",
					 outport[ temp ], sherr( DTMerrno ) );
				return 0 ;
			} else {
				fprintf( stdout, "%%Test: Data '%s' written\n", buf );
			}
		}

		if( DTMendWrite( outport[ temp ] ) == DTMERROR )
		{
			fprintf( stderr, "%%Test: ERROR - Outport %d endWrite, %s\n",
				 outport[ temp ], sherr( DTMerrno ) );
			return 0 ;
		}	
		else
		{
			fprintf( stdout, "%%Test: Write over\n" );
		}
	}
	fprintf( stdout, "WriteRead done with (%d, %d) %d\n", num_msgs,
		num_sets, nmsg );

	/*	Close the out port.		*/

	if( DTMdestroyPort( outport[ temp ] ) == DTMERROR )
	{
		fprintf( stderr, "%%Test: Outport %d destroy error, %s\n", 
				outport[ temp ], sherr( DTMerrno ) );
		return 0 ;
	}

	return 1 ;
}
