* **********************************************************************
* ** NOAA/USGS GENERAL MAP PROJECTION PACKAGE ..... DR. A. A. ELASSAL **
* **          MATHEMATICAL ANALYSIS BY JOHN SNYDER                    **
* ** GCTP/II                 VERSION 1.0.2           SEPTEMBER 1,1986 **
* **********************************************************************
*                    *  OBLIQUE MERCATOR (HOTINE)  *
* **********************************************************************
*
      SUBROUTINE PJ20Z0
*
      IMPLICIT REAL*8 (A-Z)
      INTEGER*4 SWITCH,I,ZONE,MODE,IPFILE,IFLG
      CHARACTER*16 ANGS1(5),ANGS2(3)
      COMMON /ELLPZ0/ AZ,EZ,ESZ,E0Z,E1Z,E2Z,E3Z,E4Z
* **** PARAMETERS **** A,E,ES,KS0,ALPHA,LONC,LON1,LAT1,LON2,LAT2,LAT0 **
* ********************** X0,Y0,GAMMA,LON0,AL,BL,EL *********************
      DATA PI /3.14159265358979323846D0/
      DATA HALFPI /1.57079632679489661923D0/
      DATA TOL,EPSLN /1.0D-7,1.0D-10/
      DIMENSION DATA(1),GEOG(1),PROJ(1)
      DATA ZERO,HALF,ONE /0.0D0,0.5D0,1.0D0/
      DATA SWITCH /0/
*
* ......................................................................
*      .  INITIALIZATION OF PROJECTION PARAMETERS (ENTRY INPUT)  .
* ......................................................................
*
      ENTRY IS20Z0 (ZONE,DATA,IPFILE,IFLG)
*
      IFLG = 0
      IF (SWITCH.NE.0 .AND. SWITCH.EQ.ZONE) RETURN
      MODE = 0
      IF (DATA(13) .NE. ZERO) MODE = 1
      IF (DATA(1) .LE. ZERO) GO TO 100
      A = DATA(1)
      B = DATA(2)
      IF (B .GT. ZERO) GO TO 040
      E = ZERO
      ES = ZERO
      GO TO 120
  040 IF (B .GT. ONE) GO TO 060
      E = DSQRT (B)
      ES = B
      GO TO 120
  060 ES = ONE - (B / A) ** 2
      E = DSQRT (ES)
      GO TO 120
  100 A = AZ
      E = EZ
      ES = ESZ
  120 KS0 = DATA(3)
      CALL UNITZ0 (DATA(6),5,LAT0,0,IPFILE,IFLG)
      IF (IFLG .NE. 0) RETURN
      X0 = DATA(7)
      Y0 = DATA(8)
      SINPH0 = DSIN (LAT0)
      COSPH0 = DCOS (LAT0)
      CON = ONE - ES * SINPH0 * SINPH0
      COM = DSQRT (ONE - ES)
      BL = DSQRT (ONE + ES * COSPH0 ** 4 / (ONE - ES))
      AL = A * BL * KS0 * COM / CON
      TS0 = TSFNZ0 (E,LAT0,SINPH0)
      CON = DSQRT (CON)
      D = BL * COM / (COSPH0 * CON)
      F = D + DSIGN (DSQRT (DMAX1 ((D * D - ONE), 0.0D0)) , LAT0)
      EL = F * TS0 ** BL
      IF (IPFILE .NE. 0) WRITE (IPFILE,2000) A,ES,KS0
 2000 FORMAT (' INITIALIZATION PARAMETERS (OBLIQUE MERCATOR ''HOTINE''',
     .        ' PROJECTION)'/
     .        ' SEMI-MAJOR AXIS OF ELLIPSOID =',F16.4,' METERS'/
     .        ' ECCENTRICITY SQUARED         =',F16.13/
     .        ' SCALE AT CENTER              =',F16.13)
      IF (MODE .EQ. 0) GO TO 140
      CALL UNITZ0 (DATA(4),5,ALPHA,0,IPFILE,IFLG)
      IF (IFLG .NE. 0) RETURN
      CALL UNITZ0 (DATA(5),5,LONC,0,IPFILE,IFLG)
      IF (IFLG .NE. 0) RETURN
      G = HALF * (F - ONE / F)
      GAMMA = ASINZ0 (DSIN (ALPHA) / D)
      LON0 = LONC - ASINZ0 (G * DTAN (GAMMA)) / BL
*
* LIST INITIALIZATION PARAMETERS (CASE B).
*
      CALL DMSLZ0 (ALPHA,0,ANGS2(1),IPFILE,IFLG)
      CALL DMSLZ0 (LONC,0,ANGS2(2),IPFILE,IFLG)
      CALL DMSLZ0 (LAT0,0,ANGS2(3),IPFILE,IFLG)
      IF (IPFILE .NE. 0) WRITE (IPFILE,2010) ANGS2
 2010 FORMAT (' AZIMUTH OF CENTRAL LINE      =',A16/
     .        ' LONGITUDE OF ORIGIN          =',A16/
     .        ' LATITUDE OF ORIGIN           =',A16)
      CON = DABS (LAT0)
      IF (CON.GT.EPSLN .AND. DABS(CON - HALFPI).GT.EPSLN) GO TO 160
      IF (IPFILE .NE. 0) WRITE (IPFILE,2020)
 2020 FORMAT (' IMPROPER PARAMETER')
      IFLG = 2002
      RETURN
  140 CALL UNITZ0 (DATA(9),5,LON1,0,IPFILE,IFLG)
      IF (IFLG .NE. 0) RETURN
      CALL UNITZ0 (DATA(10),5,LAT1,0,IPFILE,IFLG)
      IF (IFLG .NE. 0) RETURN
      CALL UNITZ0 (DATA(11),5,LON2,0,IPFILE,IFLG)
      IF (IFLG .NE. 0) RETURN
      CALL UNITZ0 (DATA(12),5,LAT2,0,IPFILE,IFLG)
      IF (IFLG .NE. 0) RETURN
      SINPHI = DSIN (LAT1)
      TS1 = TSFNZ0 (E,LAT1,SINPHI)
      SINPHI = DSIN (LAT2)
      TS2 = TSFNZ0 (E,LAT2,SINPHI)
      H = TS1 ** BL
      L = TS2 ** BL
      F = EL / H
      G = HALF * (F - ONE / F)
      J = (EL * EL - L * H) / (EL * EL + L * H)
      P = (L - H) / (L + H)
      CALL DMSLZ0 (LON2,0,ANGS1(3),IPFILE,IFLG)
      DLON = LON1 - LON2
      IF (DLON .LT. -PI) LON2 = LON2 - 2.D0 * PI
      IF (DLON .GT.  PI) LON2 = LON2 + 2.D0 * PI
      DLON = LON1 - LON2
      LON0 = HALF * (LON1 + LON2) - DATAN (J * DTAN (HALF * BL *
     .       DLON) / P) / BL
      DLON = ADJLZ0 (LON1 - LON0)
      GAMMA = DATAN (DSIN (BL * DLON) / G)
      ALPHA = ASINZ0 (D * DSIN (GAMMA))
      CALL DMSLZ0 (LON1,0,ANGS1(1),IPFILE,IFLG)
      CALL DMSLZ0 (LAT1,0,ANGS1(2),IPFILE,IFLG)
*     CALL DMSLZ0 (LON2,0,ANGS1(3),IPFILE,IFLG)
      CALL DMSLZ0 (LAT2,0,ANGS1(4),IPFILE,IFLG)
      CALL DMSLZ0 (LAT0,0,ANGS1(5),IPFILE,IFLG)
      IF (IPFILE .NE. 0) WRITE (IPFILE,2030) ANGS1
 2030 FORMAT (' LONGITUDE OF 1ST POINT       =',A16/
     .        ' LATITUDE OF 1ST POINT        =',A16/
     .        ' LONGITUDE OF 2ND POINT       =',A16/
     .        ' LATITUDE OF 2ND POINT        =',A16/
     .        ' LATITUDE OF ORIGIN           =',A16)
      IF (DABS(LAT1 - LAT2) .LE. EPSLN) GO TO 150
      CON = DABS (LAT1)
      IF (CON.LE.EPSLN .OR. DABS(CON - HALFPI).LE.EPSLN) GO TO 150
      IF (DABS(DABS(LAT0) - HALFPI) .GT. EPSLN) GO TO 160
  150 IF (IPFILE .NE. 0) WRITE (IPFILE,2020)
      IFLG = 2002
      RETURN
  160 SINGAM = DSIN (GAMMA)
      COSGAM = DCOS (GAMMA)
      SINALF = DSIN (ALPHA)
      COSALF = DCOS (ALPHA)
      IF (IPFILE .NE. 0) WRITE (IPFILE,2040) X0,Y0
 2040 FORMAT (' FALSE EASTING                =',F16.4,' METERS'/
     .        ' FALSE NORTHING               =',F16.4,' METERS')
      SWITCH = ZONE
      RETURN
*
* ......................................................................
*                      .  FORWARD TRANSFORMATION  .
* ......................................................................
*
      ENTRY PF20Z0 (GEOG,PROJ,IFLG)
*
      IFLG = 0
      IF (SWITCH .NE. 0) GO TO 220
      IF (IPFILE .NE. 0) WRITE (IPFILE,2050)
 2050 FORMAT (' UNINITIALIZED TRANSFORMATION')
      IFLG = 2000
      RETURN
  220 SINPHI = DSIN (GEOG(2))
      DLON = ADJLZ0 (GEOG(1) - LON0)
      VL = DSIN (BL * DLON)
      IF (DABS(DABS(GEOG(2)) - HALFPI) .GT. EPSLN) GO TO 230
      UL = SINGAM * DSIGN (ONE , GEOG(2))
      US = AL * GEOG(2) / BL
      GO TO 250
  230 TS = TSFNZ0 (E,GEOG(2),SINPHI)
      Q = EL / TS ** BL
      S = HALF * (Q - ONE / Q)
      T = HALF * (Q + ONE / Q)
      UL = (S * SINGAM - VL * COSGAM) / T
      CON = DCOS (BL * DLON)
      IF (DABS(CON) .LT. TOL) GO TO 240
      US = AL * DATAN ((S * COSGAM + VL * SINGAM) / CON) / BL
      IF (CON .LT. ZERO) US = US + PI * AL / BL
      GO TO 250
  240 US = AL * BL * DLON
  250 IF (DABS(DABS(UL) - ONE) .GT. EPSLN) GO TO 260
      IF (IPFILE .NE. 0) WRITE (IPFILE,2060)
 2060 FORMAT (' POINT PROJECTS INTO INFINITY')
      IFLG = 2001
      RETURN
  260 VS = HALF * AL * DLOG ((ONE - UL) / (ONE + UL)) / BL
      PROJ(1) = X0 + VS * COSALF + US * SINALF
      PROJ(2) = Y0 + US * COSALF - VS * SINALF
      RETURN
*
* ......................................................................
*                      .  INVERSE TRANSFORMATION  .
* ......................................................................
*
      ENTRY PI20Z0 (PROJ,GEOG,IFLG)
*
      IFLG = 0
      IF (SWITCH .NE. 0) GO TO 280
      IF (IPFILE .NE. 0) WRITE (IPFILE,2050)
      IFLG = 2000
      RETURN
  280 X = PROJ(1) - X0
      Y = PROJ(2) - Y0
      VS = X * COSALF - Y * SINALF
      US = Y * COSALF + X * SINALF
      Q = DEXP (- BL * VS / AL)
      S = HALF * (Q - ONE / Q)
      T = HALF * (Q + ONE / Q)
      VL = DSIN (BL * US / AL)
      UL = (VL * COSGAM + S * SINGAM) / T
      IF (DABS (DABS (UL) - ONE) .GE. EPSLN) GO TO 300
      GEOG(1) = LON0
      GEOG(2) = DSIGN (HALFPI , UL)
      RETURN
  300 CON = ONE / BL
      TS = (EL / DSQRT ((ONE + UL) / (ONE - UL))) ** CON
      GEOG(2) = PHI2Z0 (E,TS,IPFILE,IFLG)
      IF (IFLG .NE. 0) RETURN
      CON = DCOS (BL * US / AL)
      LON = LON0 - DATAN2 ((S * COSGAM - VL * SINGAM) , CON) / BL
      GEOG(1) = ADJLZ0 (LON)
      RETURN
*
      END
