* **********************************************************************
* ** NOAA/USGS GENERAL MAP PROJECTION PACKAGE ..... DR. A. A. ELASSAL **
* **          MATHEMATICAL ANALYSIS BY JOHN SNYDER                    **
* ** GCTP/II                 VERSION 1.0.2           SEPTEMBER 1,1986 **
* **********************************************************************
*                        *  VAN DER GRINTEN I  *
* **********************************************************************
*
      SUBROUTINE PJ19Z0
*
      IMPLICIT REAL*8 (A-Z)
      INTEGER*4 SWITCH,I,ZONE,NIT,IPFILE,IFLG
      CHARACTER*16 ANGS
      COMMON /SPHRZ0/ AZZ
* **** PARAMETERS **** A,LON0,X0,Y0 ************************************
      DIMENSION DATA(1),GEOG(1),PROJ(1)
      DATA PI /3.14159265358979323846D0/
      DATA HALFPI /1.57079632679489661923D0/
      DATA EPSLN,TOL,NIT /1.0D-10,0.7D0,35/
      DATA ZERO,HALF,ONE,TWO,FOUR /0.0D0,0.5D0,1.0D0,2.0D0,4.0D0/
      DATA SWITCH /0/
*
      ENTRY IS19Z0 (ZONE,DATA,IPFILE,IFLG)
*
      IFLG = 0
      IF (SWITCH.NE.0 .AND. SWITCH.EQ.ZONE) RETURN
      A = DATA(1)
      IF (A .LE. ZERO) A = AZZ
      CALL UNITZ0 (DATA(5),5,LON0,0,IPFILE,IFLG)
      IF (IFLG .NE. 0) RETURN
      X0 = DATA(7)
      Y0 = DATA(8)
*
* LIST RESULTS OF PARAMETER INITIALIZATION.
*
      CALL DMSLZ0 (LON0,0,ANGS,IPFILE,IFLG)
      IF (IPFILE .NE. 0) WRITE (IPFILE,2000) A,ANGS,X0,Y0
 2000 FORMAT (' INITIALIZATION PARAMETERS (VAN DER GRINTEN I',
     .        ' PROJECTION)'/
     .        ' RADIUS OF SPHERE             =',F16.4,' METERS'/
     .        ' LONGITUDE OF C. MERIDIAN     =',A16/
     .        ' FALSE EASTING                =',F16.4,' METERS'/
     .        ' FALSE NORTHING               =',F16.4,' METERS')
      SWITCH = ZONE
      RETURN
*
* ......................................................................
*                      .  FORWARD TRANSFORMATION  .
* ......................................................................
*
      ENTRY PF19Z0 (GEOG,PROJ,IFLG)
*
      IFLG = 0
      IF (SWITCH .NE. 0) GO TO 120
      IF (IPFILE .NE. 0) WRITE (IPFILE,2010)
 2010 FORMAT (' UNINITIALIZED TRANSFORMATION')
      IFLG = 1900
      RETURN
  120 LON = ADJLZ0 (GEOG(1) - LON0)
      LAT = GEOG(2)
      IF (DABS(LAT) .GT. EPSLN) GO TO 140
      PROJ(1) = X0 + A * LON
      PROJ(2) = Y0
      RETURN
  140 THETA = ASINZ0 (DABS (LAT /HALFPI))
      IF (DABS(LON).GT.EPSLN .AND.
     .    DABS(DABS(LAT)-HALFPI).GT.EPSLN) GO TO 160
      PROJ(1) = X0
      PROJ(2) = Y0 + PI * A * DSIGN( DTAN (HALF * THETA), LAT)
      RETURN
  160 AL = HALF * DABS (PI / LON - LON / PI)
      ASQ = AL * AL
      SINTHT = DSIN (THETA)
      COSTHT = DCOS (THETA)
      G = COSTHT / (SINTHT + COSTHT - ONE)
      GSQ = G * G
      M = G * (TWO / SINTHT - ONE)
      MSQ = M * M
      CON = PI * A * (AL * (G - MSQ) + DSQRT (ASQ * (G - MSQ)**2 -
     .      (MSQ + ASQ) * (GSQ - MSQ))) / (MSQ + ASQ)
      CON = DSIGN (CON , LON)
      PROJ(1) = X0 + CON
      CON = DABS (CON / (PI * A))
      PROJ(2) = Y0 + DSIGN (PI * A * DSQRT (ONE - CON * CON -
     .          TWO * AL * CON) , LAT)
      RETURN
*
* ......................................................................
*                      .  INVERSE TRANSFORMATION  .
* ......................................................................
*
      ENTRY PI19Z0 (PROJ,GEOG,IFLG)
*
      IFLG = 0
      IF (SWITCH .NE. 0) GO TO 220
      IF (IPFILE .NE. 0) WRITE (IPFILE,2010)
      IFLG = 1900
      RETURN
  220 X = PROJ(1) - X0
      Y = PROJ(2) - Y0
      CON = DABS (Y / (PI * A))
      THETA = TWO * DATAN (CON)
      IF (DABS(X) .GT. EPSLN) GO TO 240
      GEOG(1) = LON0
      GEOG(2) = HALFPI * DSIGN( DSIN (THETA), Y)
      RETURN
  240 IF (DABS(Y) .GT. EPSLN) GO TO 260
      GEOG(1) = ADJLZ0 (LON0 + X / A)
      GEOG(2) = ZERO
      RETURN
  260 IF (DSQRT(X*X+Y*Y) .LE. PI*A) GO TO 270
      IF (IPFILE .NE. 0) WRITE (IPFILE,2020)
 2020 FORMAT (' IMPROPER PARAMETER')
      IFLG = 1901
      RETURN
  270 CNN = CON * CON
      COM = DABS (X / (PI * A))
      CMM = COM * COM
      AL = (ONE - CMM - CNN) / (TWO * COM)
      GEOG(1) = ADJLZ0 (LON0 + DSIGN (PI*(-AL + DSQRT (AL*AL+ONE)) , X))
      PHI = THETA
      IF (CON .GT. TOL) GO TO 320
*
* LOW LATITUDE CASE
*
      DO 280 I = 1,NIT
      THETA = ASINZ0 (PHI / HALFPI)
      SINTHT = DSIN (THETA)
      COSTHT = DCOS (THETA)
      G = COSTHT / (SINTHT + COSTHT - ONE)
      D = CON / SINTHT - ONE / (ONE + COSTHT)
      H = TWO - SINTHT
      J = DTAN (HALF * THETA)
      DPHI = (CMM + CNN - TWO * D * G * H - J * J) * PI * COSTHT /
     .       (FOUR * (G * H * (CON * COSTHT / (ONE - COSTHT) + J) /
     .       (ONE + COSTHT) + D * G * ((ONE + TWO * COSTHT * COSTHT) /
     .       COSTHT + H * (COSTHT - SINTHT) / (SINTHT + COSTHT - ONE)) -
     .       J * (J * J + ONE)))
      PHI = PHI - DPHI
      IF (DABS(DPHI) .LT. EPSLN) GO TO 400
  280 CONTINUE
  300 IF (IPFILE .NE. 0) WRITE (IPFILE,2030)
 2030 FORMAT (' LATITUDE FAILED TO CONVERGE')
      IFLG = 1902
      RETURN
*
* HIGH LATITUDE CASE.
*
  320 LON = ADJLZ0 (GEOG(1) - LON0)
      DO 380 I = 1,NIT
      IF (DABS(PHI) .GT. EPSLN) GO TO 330
      Y1 = ZERO
      GO TO 360
  330 THETA = ASINZ0 (DABS (PHI /HALFPI))
      IF (DABS(LON) .GT. EPSLN) GO TO 340
      Y1 = PI * A * DTAN (HALF * THETA)
      GO TO 360
  340 AL = HALF * DABS (PI / LON - LON / PI)
      ASQ = AL * AL
      SINTHT = DSIN (THETA)
      COSTHT = DCOS (THETA)
      G = COSTHT / (SINTHT + COSTHT - ONE)
      GSQ = G * G
      M = G * (TWO / SINTHT - ONE)
      MSQ = M * M
      CON = DABS ((AL * (G - MSQ) + DSQRT (ASQ * (G - MSQ)**2 -
     .      (MSQ + ASQ) * (GSQ - MSQ))) / (MSQ + ASQ))
      Y1 = DSIGN (PI * A * DSQRT (ONE - CON * CON -
     .          TWO * AL * CON) , PHI)
  360 DPHI = ((DABS(Y) - Y1) / (PI * A - Y1)) * (HALFPI - PHI)
      PHI = PHI + DPHI
      IF (DABS(DPHI) .LT. EPSLN) GO TO 400
  380 CONTINUE
      GO TO 300
  400 GEOG(2) = DSIGN (PHI , Y)
      RETURN
*
      END
