/* SCCS @(#)pre_pro.callback.c	1.1  12/2/92 */
/************************************************************************/
/************************************************************************/
/*                                                                      */
/*                          pre_pro.callback.c                          */
/*                                                                      */
/************************************************************************/
/************************************************************************/
/*                                                                      */
/* FILENAME     :   pre_pro.callback.c                                  */
/*                                                                      */
/* DESCRIPTION  :   Interface for preprocessing operations              */
/*                                                                      */
/* AUTHORS      :   Marianne Logean                                     */
/*                                                                      */
/* VERSION      :   1.0                                                 */
/*                                                                      */
/* HISTORY      :   1.12.92                                             */
/*                  MAL         Created    version: 1.0                 */
/*                                                                      */
/* Copyright  1992 by CUI/UIN/HCUG, All rights reserved.                */
/*                                                                      */
/************************************************************************/
/************************************************************************/

#include <math.h>
#include <stdlib.h>
#include <Xm/Text.h>

#include "libwidgets/widgetstructure.h"
#include "pre_pro.layout.h"

#include "define.h"
#include "global.h"

#include "Display/RegionInterestmenu.callback.h"
#include "Display/histogram.h"
#include "rehaus4.h"
#include "convert4.h"
#include "transform4.h"
#include "convol4.h"
#include "contours4.h"
#include "lecture4.h"
#include "histogr4.h"
#include "win4.h"
#include "lcount4.h"

extern void load_proc_growing();
extern void store_c_proc();
extern void store_r_proc();
extern void Ote_ima_des ();

extern  *Histogramme[MAX_IMAGE];

extern Display *gDisplay;
extern Cursor  gWatchcursor;
extern Widget  gLabowidget;

/******************************************************
/   activateCallback for Widget  CANCEL 
/*****************************************************/

void
PRE_PRO_options_CANCEL_callb(CANCEL, PRE_PRO_options_widget, callData)
	Widget CANCEL;
	Widget PRE_PRO_options_widget;
	caddr_t callData;
{
    XUndefineCursor(gDisplay, XtWindow(gLabowidget));
    XUndefineCursor(gDisplay, 
		    XtWindow(XtParent (XtParent (CANCEL))));
    XtUnmanageChild (PRE_PRO_options_widget);
}



/********************************************************/
/* anciennement proc_egal_histo 			*/
/********************************************************/

void
PRE_PRO_histo_equa_OK_callb(options_OK, PRE_PRO_options_widget, callData)
	Widget options_OK;
	Widget PRE_PRO_options_widget;
	caddr_t callData;
{
    float *image, *temp;
    int ngro, ngrn, ligne, colonne, result;

    sprintf (buf, mastertabs[222]);
    write_master(buf);	
    sprintf (buf, "%d --> %d\n", index_image[0], index_image[1]);
    write_master (buf);

    if (dir_image[index_image[0]].image == NULL){
      write_erreur(1);
      return;
    }

    XDefineCursor(gDisplay, XtWindow(gLabowidget), gWatchcursor);
    XDefineCursor(gDisplay, XtWindow(XtParent (XtParent (options_OK))), 
		  gWatchcursor);
    XFlush(gDisplay);

    switch (dir_desc[index_image[0]].type ){
      case 6:
      case -1:
      case 0:
      case 1:
      case 2:
	  image = (float *)conv_float(dir_image[index_image[0]].image,
				      dir_desc[index_image[0]].type,
				      dir_desc[index_image[0]].nligne,
				      dir_desc[index_image[0]].ncolonne);
	  flag_conv = TRUE;
	  break;
      case 3:
      case 4:
      case 5:
	  image = (float *)dir_image[index_image[0]].image;
	  flag_conv = FALSE;
	  break;
      }

    dir_desc[index_image[1]] = dir_desc[index_image[0]];
    dir_desc[index_image[1]].type = 3;
    ngro=(int)dir_desc[index_image[0]].mmax + 1; 
    ngrn = 256;
    ligne = (int)dir_desc[index_image[1]].nligne;
    colonne = (int)dir_desc[index_image[1]].ncolonne;

    /******* TRAITEMENT ********/
    result = histequalize(image, &temp, colonne, ligne, ngro, ngrn);
    /***************************/

    if (dir_image[index_image[1]].image != NULL)
		free (dir_image[index_image[1]].image);
    dir_image[index_image[1]].image = (unsigned char *)temp;
    if (flag_conv) 
      {
	free (image);
	flag_conv = FALSE;
      }
    statis (dir_image[index_image[1]].image,
	    dir_desc[index_image[1]].type, 
	    dir_desc[index_image[1]].nligne,
	    dir_desc[index_image[1]].ncolonne,
	    &(dir_desc[index_image[1]].mmin),
	    &(dir_desc[index_image[1]].mmax), 
	    &(dir_desc[index_image[1]].mu),
	    &(dir_desc[index_image[1]].ecart));

    XUndefineCursor(gDisplay, XtWindow(gLabowidget));
    XUndefineCursor(gDisplay, XtWindow(XtParent (XtParent (options_OK))));
    XtUnmanageChild (XtParent (XtParent (options_OK)));
}



/********************************************************/
/* anciennement proc_linear_filter 			*/
/********************************************************/

void
PRE_PRO_correct_background_OK_callb(options_OK, PREPRO_linear_filter_param_widget, callData)
	Widget options_OK;
	xs_struc_paramprepro *PREPRO_linear_filter_param_widget;
	caddr_t callData;
{
    struct convol *cnv;
    static struct paddi pd;
    static struct description_memoire tmp;
    float *pt, *pt1, *ori_image, *image;
    float *imageOut1, *imageOut2, *pr1, *pr2, *pi2, *pi1;
    float *br1, *bi1, *br2, *bi2, *bz;
    int size, i, j, lin, col, isxf, isyf, result;
    float *im;

    cnv = (struct convol *) malloc (sizeof (struct convol));
    cnv->ligne = atoi (XmTextGetString (PREPRO_linear_filter_param_widget->line));
    cnv->colonne = atoi (XmTextGetString (PREPRO_linear_filter_param_widget->colon));

    sprintf (buf, mastertabs[290]);
    write_master (buf);
    sprintf (buf," (%dx%d):%d --> %d", cnv->colonne, cnv->ligne, 
	     index_image[0], index_image[1]);
    write_master (buf);
    sprintf(buf, mastertabs[291], index_image[3]);
    write_master (buf);
 
    if (cnv->ligne==0 || cnv->colonne==0){ 
      write_erreur(92);
      return;
    }

    if (dir_image[index_image[0]].image == NULL){
      write_erreur(1);
      return;
    }

    if (power_2(dir_desc[index_image[0]].nligne) == FALSE ||
	power_2(dir_desc[index_image[0]].ncolonne) == FALSE){
      write_erreur(15);
      return;
    }

    XDefineCursor(gDisplay, XtWindow(gLabowidget), gWatchcursor);
    XDefineCursor(gDisplay, XtWindow(XtParent (XtParent (options_OK))), 
		  gWatchcursor);
    XFlush(gDisplay);

    if (dir_desc[index_image[0]].type == 3){
      im = (float *)dir_image[index_image[0]].image;
      flag_conv = FALSE;
    }
    else{
      im = (float *)conv_float(dir_image[index_image[0]].image,
			       dir_desc[index_image[0]].type,
			       dir_desc[index_image[0]].nligne,
			       dir_desc[index_image[0]].ncolonne);
      flag_conv = TRUE;
    }

    size = cnv->ligne * cnv->colonne;	   /* size of filter */
    cnv->factmult = (float) 1 / size;

    lin = dir_desc[index_image[0]].nligne;
    col = dir_desc[index_image[0]].ncolonne;
    if (size < lin * col /16) {
      pt1 = (float *)malloc(lin * col * sizeof(float)); 
      dir_image[index_image[3]].image = (unsigned char *)pt1;
      pt = im;  /* [0] */
      for (i = 0; i < lin * col; i++) {
	*pt1 = *pt;
	pt1++; pt++;
      }
      dir_desc[index_image[3]] = dir_desc[index_image[0]];
      dir_desc[index_image[3]].type = 3;
    }		/* copy index_image[0] to index_image[3] */
    else { /* size > 16 */
      while (col < dir_desc[index_image[0]].ncolonne + cnv->colonne) 
	col = col * 2;
      while (lin < dir_desc[index_image[0]].nligne + cnv->ligne) 
	lin = lin * 2;
      pd.ligne = lin;
      pd.colonne = col;
      pd.methode = 2;
      ori_image = (float *)dir_image[index_image[0]].image;
      tmp = dir_desc[index_image[0]];
      dir_image[index_image[0]].image = (unsigned char *)im;
      dir_desc [index_image[0]].type = 3;

      image = (float *)dir_image[index_image[0]].image;

      /******* TRAITEMENT ********/
      /* padding image[0]  --> image[3]*/
      result = padding_prolong(image, col, lin, 
			     dir_desc[index_image[0]].type, &imageOut1,
			     &pd);   
      /***************************/

      if (result != 0) 
	{      
	  XUndefineCursor(gDisplay, XtWindow(gLabowidget));
	  XUndefineCursor(gDisplay, 
			  XtWindow(XtParent (XtParent (options_OK))));
	  return;
	}

      if (dir_image[index_image[3]].image != NULL)
	free (dir_image[index_image[3]].image);
      dir_image[index_image[3]].image = (unsigned char *)imageOut1;

      dir_desc[index_image[3]] = dir_desc[index_image[0]];
      dir_desc[index_image[3]].nligne = pd.ligne;
      dir_desc[index_image[3]].ncolonne = pd.colonne;
      statis (dir_image[index_image[3]].image, 
		dir_desc[index_image[3]].type, 
		dir_desc[index_image[3]].nligne, 
		dir_desc[index_image[3]].ncolonne,
		&(dir_desc[index_image[3]].mmin),
		&(dir_desc[index_image[3]].mmax), 
		&(dir_desc[index_image[3]].mu), 
		&(dir_desc[index_image[3]].ecart));
      dir_image[index_image[0]].image = (unsigned char *)ori_image;
      dir_desc [index_image[0]] = tmp;

      bz = (float *)calloc(col*lin, sizeof(float)); /* calloc */

      /******* TRAITEMENT ********/
			/* fourier transformation of image */
      four_2d((float *)dir_image[index_image[3]].image, bz, 
	      &br1, &bi1, lin, col, 2);
      /***************************/

      ori_image = (float *)dir_image[index_image[0]].image;
      tmp = dir_desc[index_image[0]];
			/*  save the original image[0] --> ori_image */
      pt = (float *)malloc(size * 4);
      dir_image[index_image[0]].image = (unsigned char *)pt;
      for (i = 0; i < size; i++)
      {
	*pt = cnv->factmult;	
	pt++;			/* set the elements of filter*/
      }
      dir_desc[index_image[0]].nligne = (short)cnv->ligne;
      dir_desc[index_image[0]].ncolonne = (short)cnv->colonne;
      dir_desc[index_image[0]].type = 3;
      pd.ligne = lin;
      pd.colonne = col;
      pd.valeur = 0;
      pd.methode = 1;

      image = (float *)dir_image[index_image[0]].image;

      /******* TRAITEMENT ********/
      result = padding_const(image, 
			     dir_desc[index_image[0]].ncolonne,
			     dir_desc[index_image[0]].nligne,
			     dir_desc[index_image[0]].type,
			     &imageOut2, &pd);
		/* padding filter to the same size of index_image[3] */
      /***************************/

      if (result != 0) 
      {  
	XUndefineCursor(gDisplay, XtWindow(gLabowidget));    
	XUndefineCursor(gDisplay, 
			XtWindow(XtParent (XtParent (options_OK))));
	return;
      }

      if (dir_image[index_image[1]].image != NULL)
	   free (dir_image[index_image[1]].image);
      dir_image[index_image[1]].image = (unsigned char *)imageOut2;

      dir_desc[index_image[1]] = dir_desc[index_image[0]];
      dir_desc[index_image[1]].nligne = pd.ligne;
      dir_desc[index_image[1]].ncolonne = pd.colonne;
      statis (dir_image[index_image[1]].image, 
	      dir_desc[index_image[1]].type, 
	      dir_desc[index_image[1]].nligne, 
	      dir_desc[index_image[1]].ncolonne,
	      &(dir_desc[index_image[1]].mmin),
	      &(dir_desc[index_image[1]].mmax), 
	      &(dir_desc[index_image[1]].mu), 
	      &(dir_desc[index_image[1]].ecart));

      free(bz);
      bz = (float *)calloc(col*lin, sizeof(float));

      /******* TRAITEMENT ********/
      four_2d((float *)dir_image[index_image[1]].image, bz, 
	      &br2, &bi2, lin, col, 2);
				/* fourier transformation of filter */
      /***************************/

      pt1 = bz;
      pt = (float *)dir_image[index_image[3]].image;
      pr2 = br2;
      pi2 = bi2;
      pr1 = br1;
      pi1 = bi1;
      for (i = 0; i < lin; i++) 
      {
	for (j = 0; j < col; j++)
	{
	  *pt = *pr1 * *pr2 - *pi1 * *pi2;	/* real part */
	  *pt1 = *pr1 * *pi2 + *pr2 * *pi1;	/* imaginary */
	  pt++; pt1++; pr1++; pi1++; pr2++; pi2++;
	}
      }		/* FT_of_image multiply FT_of_filter */

      /******* TRAITEMENT ********/
      four_2d((float *)dir_image[index_image[3]].image, bz, 
	      &br2, &bi2, lin, col, -2);
      /***************************/

	            /* inverse FT to get background */
      free(dir_image[index_image[0]].image);
      free(dir_image[index_image[1]].image);
      free(dir_image[index_image[3]].image);
      free(br1);
      free(bi1);
      free(bi2);
      free(bz);

      dir_image[index_image[0]].image = (unsigned char *)ori_image;
      dir_desc[index_image[0]] = tmp;
      isyf = dir_desc[index_image[0]].nligne;
      isxf = dir_desc[index_image[0]].ncolonne;
      if (lin > isyf || col > isxf) {
	pt1 = (float *)malloc(isxf * isyf * sizeof(float));
	dir_image[index_image[3]].image = (unsigned char *)pt1;
	pt = br2 + col*(lin - isyf)/2 + (col - isxf)/2;
	for (i = 0; i < isyf; i++) {
	  for (j = 0; j < isxf; j++) {
	    *pt1 = *pt;
	    pt++; pt1++;
	  }
	  pt = pt + (col - isxf);
	}
	free(*br2);
      }	/* make background same size as original image */
      else 
      dir_image[index_image[3]].image = (unsigned char *)br2;

      pt = (float *)malloc(isxf * isyf * sizeof(float));
      dir_image[index_image[1]].image = (unsigned char *)pt;
      pt1 = (float *)dir_image[index_image[3]].image;
      ori_image = im;
      for (i = 0; i < isxf *isyf; i++)
      {
	*pt = *ori_image - *pt1;
	pt++; pt1++; ori_image++;
      }	/* subtract background from original image */

      dir_desc[index_image[1]] = dir_desc[index_image[0]];
      dir_desc[index_image[1]].type = 3;
      statis( dir_image[index_image[1]].image,
	     dir_desc[index_image[1]].type,
	     dir_desc[index_image[1]].nligne,
	     dir_desc[index_image[1]].ncolonne,
	     &(dir_desc[index_image[1]].mmin),
	     &(dir_desc[index_image[1]].mmax),
	     &(dir_desc[index_image[1]].mu),
	     &(dir_desc[index_image[1]].ecart));   

      dir_desc[index_image[3]] = dir_desc[index_image[0]];
      dir_desc[index_image[3]].type = 3;
      statis( dir_image[index_image[3]].image,
	     dir_desc[index_image[3]].type,
	     dir_desc[index_image[3]].nligne,
	     dir_desc[index_image[3]].ncolonne,
	     &(dir_desc[index_image[3]].mmin),
	     &(dir_desc[index_image[3]].mmax),
	     &(dir_desc[index_image[3]].mu),
	     &(dir_desc[index_image[3]].ecart));
    }
    if (flag_conv) 
      {
	free (im);
	flag_conv = FALSE;
      }

    XUndefineCursor(gDisplay, XtWindow(gLabowidget));
    XUndefineCursor(gDisplay, XtWindow(XtParent (XtParent (options_OK))));
    XtUnmanageChild (XtParent (XtParent (options_OK)));
}


/********************************************************/
/* anciennement proc_fourier 				*/
/********************************************************/

void 
PRE_PRO_transf_fourier_OK_callb (options_OK, inv, callData)
	Widget options_OK;
	int inv;
	caddr_t callData;
{
    float *imager, *imagef, *imaresr, *imaresi;
    int result, ligne, colonne;
    int image_real;

    sprintf (buf, "Fourier "); 
    switch (inv) {
      case -2: strcat (buf, mastertabs[281]); 
	break;
      case -1: strcat (buf, "inverse"); 
	break;
      case 20:
      case 2 : strcat (buf, mastertabs[282]);
	break;
      case 10:
      case 1 : break;
    }
    write_master (buf);

    if (inv > 2) image_real = TRUE;
    else image_real = FALSE;

    if (!image_real)
       sprintf (buf, "(%d,%d)-->(%d,%d)\n",
		index_image[0],index_image[2],
		index_image[1],index_image[3]);
    else sprintf (buf, " %d-->(%d,%d)\n",index_image[0], 
		  index_image[1], index_image[3]);
    write_master (buf);

    if (inv == 10) inv = 1;
    else if (inv == 20) inv = 2;


    if ((!image_real) && (dir_desc[index_image[0]].nligne != 
			  dir_desc[index_image[2]].nligne
			  || dir_desc[index_image[0]].ncolonne != 
			  dir_desc[index_image[2]].ncolonne))
    {
      write_erreur(2);
      return;
    }
    if (power_2(dir_desc[index_image[0]].nligne) == FALSE 
	|| power_2(dir_desc[index_image[0]].ncolonne) == FALSE)
    {
      write_erreur(15);
      return;
    }

    if (dir_image[index_image[0]].image == NULL){
      write_erreur(9);
      return;
    }

    if (dir_image[index_image[2]].image == NULL){
      write_erreur(10);
      return;
    }

    XDefineCursor(gDisplay, XtWindow(gLabowidget), gWatchcursor);
    XDefineCursor(gDisplay, XtWindow(XtParent (XtParent (options_OK))), 
		  gWatchcursor);
    XFlush(gDisplay);

    switch (dir_desc[index_image[0]].type ){
        case 6:
        case -1:
        case 0:
        case 1:
        case 2:
	  imager = (float *)conv_float(dir_image[index_image[0]].image,
				       dir_desc[index_image[0]].type,
				       dir_desc[index_image[0]].nligne,
				       dir_desc[index_image[0]].ncolonne);
	  flag_conv = TRUE;
	  break;
	case 3:
	case 4:
	case 5:
	  imager = (float *)dir_image[index_image[0]].image;
	  flag_conv = FALSE;
	  break;
	}
    if (image_real){
	dir_desc[index_image[1]] = dir_desc[index_image[0]];
	dir_desc[index_image[1]].type = 3;
	dir_desc[index_image[3]] = dir_desc[index_image[0]];
	dir_desc[index_image[3]].type = 3;
	ligne = (int)dir_desc[index_image[0]].nligne;
	colonne = (int)dir_desc[index_image[0]].ncolonne;
	imagef = (float *) calloc(ligne * colonne,sizeof(float));
      }
    else 
      {
        switch (dir_desc[index_image[2]].type ){
	  case 6:
	  case -1:
	  case 0:
	  case 1:
	  case 2: 
	    imagef=(float *)conv_float(dir_image[index_image[2]].image,
				       dir_desc[index_image[2]].type,
				       dir_desc[index_image[2]].nligne,
				       dir_desc[index_image[2]].ncolonne);
	    flag_conv = TRUE;
	    break;
	  case 3:
	  case 4:
	  case 5: 
	    imagef=(float *)dir_image[index_image[2]].image;
	    flag_conv = FALSE;
	    break;
	}
	dir_desc[index_image[1]] = dir_desc[index_image[0]];
	dir_desc[index_image[1]].type = 3;
	dir_desc[index_image[3]] = dir_desc[index_image[2]];
	dir_desc[index_image[3]].type = 3;
	ligne = (int)dir_desc[index_image[1]].nligne;
	colonne = (int)dir_desc[index_image[1]].ncolonne;
      }
    
    /******* TRAITEMENT ********/
    result = four_2d(imager, imagef, &imaresr, &imaresi ,colonne,ligne,inv);
    /***************************/

    switch (result)
      {
        case -1: fprintf(stdout, "-1 echoue\n");break;
        case -2: fprintf(stdout, "-2 echoue\n");break;
        case -3: fprintf(stdout, "-3 echoue\n");break;
        case -4: fprintf(stdout, "-4 echoue\n");break;
        case -5: fprintf(stdout, "-5 echoue\n");break;
        case 0:
	default:  break;  
      }
      
    if (dir_image[index_image[1]].image != NULL)
      free (dir_image[index_image[1]].image);
    dir_image[index_image[1]].image = (unsigned char *)imaresr;            
    if (dir_image[index_image[3]].image != NULL)
      free (dir_image[index_image[3]].image); 
    dir_image[index_image[3]].image = (unsigned char *)imaresi;
    if (flag_conv) {
      free (imager);
      if (!image_real) free (imagef);
      flag_conv = FALSE;
    }
    statis (dir_image[index_image[1]].image,
	      dir_desc[index_image[1]].type, 
	      dir_desc[index_image[1]].nligne,
	      dir_desc[index_image[1]].ncolonne,
	      &(dir_desc[index_image[1]].mmin),
	      &(dir_desc[index_image[1]].mmax), 
	      &(dir_desc[index_image[1]].mu),
	      &(dir_desc[index_image[1]].ecart));
    statis (dir_image[index_image[3]].image,
	      dir_desc[index_image[3]].type, 
	      dir_desc[index_image[3]].nligne,
	      dir_desc[index_image[3]].ncolonne,
	      &(dir_desc[index_image[3]].mmin),
	      &(dir_desc[index_image[3]].mmax), 
	      &(dir_desc[index_image[3]].mu),
	      &(dir_desc[index_image[3]].ecart));

    XUndefineCursor(gDisplay, XtWindow(gLabowidget));
    XUndefineCursor(gDisplay, XtWindow(XtParent (XtParent (options_OK))));
    XtUnmanageChild (XtParent (XtParent (options_OK)));
}



/********************************************************/
/* anciennement proc_convol			        */
/********************************************************/

void
PRE_PRO_convol_OK_callb(options_OK, PRO_create_mask_param_widget, callData)
	Widget options_OK;
	xs_struc_paramprepro * PRO_create_mask_param_widget;
	caddr_t callData;
{
    struct convol *conv;
    float *im, *imarr;
    int ligne, colonne, lignearr, colonnearr, select, result;
    int flag_conv2;
    register int i;


    XDefineCursor(gDisplay, XtWindow(gLabowidget), gWatchcursor);
    XDefineCursor(gDisplay, XtWindow(XtParent (XtParent (options_OK))), 
		  gWatchcursor);
    XFlush(gDisplay);

    select = PRO_create_mask_param_widget->type_operation;
    
    switch (select) {
    case 1:  /* avec masque */
    case 11:
        conv = (struct convol *) malloc (sizeof (struct convol));
        conv->ligne = 
	   atoi (XmTextGetString (PRO_create_mask_param_widget->line));
        conv->colonne = 
	   atoi (XmTextGetString (PRO_create_mask_param_widget->colon));
        conv->factmult = 
	   (float)atof (XmTextGetString (PRO_create_mask_param_widget->alpha));

        conv->masque = 
	   (float *) malloc (conv->colonne * conv->ligne * sizeof(float));

        if (PRO_create_mask_param_widget->Text == NULL)
            build_PRO_create_mask_widget(options_OK, conv->ligne,
					   conv->colonne,
					   PRO_create_mask_param_widget);
        for (i=0; i < conv->ligne * conv->colonne; i++)
           conv->masque[i] = 
	      (float)atof(XmTextGetString (PRO_create_mask_param_widget->Text[i]));

        if (select == 1) sprintf (buf, panel_titres[59]); 
	else sprintf (buf, panel_titres[61]);
	write_master(buf);

	sprintf (buf, "Image %d * masque --> %d\n", 
		 index_image[0], index_image[1]);
	write_master (buf);

	if (dir_image[index_image[0]].image == NULL){
	    write_erreur(1);
	    XUndefineCursor(gDisplay, XtWindow(gLabowidget));
	    XUndefineCursor(gDisplay, 
			    XtWindow(XtParent (XtParent (options_OK))));
	    return;
	}

	switch (dir_desc[index_image[0]].type ){
	  case 6:
	  case -1:
	  case 0:
	  case 1:
	  case 2:	    
	    im = (float *)conv_float(dir_image[index_image[0]].image,
				     dir_desc[index_image[0]].type,
				     dir_desc[index_image[0]].nligne,
				     dir_desc[index_image[0]].ncolonne);
	    flag_conv = TRUE;
	    break;
	  case 3:
	  case 4:
	  case 5:
	    im = (float *)dir_image[index_image[0]].image;
	    flag_conv = FALSE;
	    break;
	}
	ligne = dir_desc[index_image[0]].nligne;
	colonne = dir_desc[index_image[0]].ncolonne;
	lignearr = max(dir_desc[index_image[0]].nligne, conv->ligne);
	colonnearr = max(dir_desc[index_image[0]].ncolonne, conv->colonne);
	
        /******* TRAITEMENT ********/
	result = convolue (im, ligne, colonne, &imarr, lignearr, colonnearr, conv, select);
        /***************************/

	if (dir_image[index_image[1]].image != NULL) 
	    free (dir_image[index_image[1]].image);
	dir_image[index_image[1]].image = (unsigned char *)imarr;
	dir_desc[index_image[1]] = dir_desc[index_image[0]];
	dir_desc[index_image[1]].nligne = lignearr;
	dir_desc[index_image[1]].ncolonne = colonnearr;
	dir_desc[index_image[1]].type = 3;

	if (flag_conv) 
	  {
	    free(im);
	    flag_conv = FALSE;
	  }
	break;
    case 2:  /* avec image */
    case 12:
	if (select == 2) sprintf (buf, panel_titres[60]); 
	else sprintf (buf, panel_titres[62]);
	write_master(buf);
	sprintf (buf, " %d *  %d --> %d\n", 
		 index_image[0], index_image[2], index_image[1]);
	write_master(buf);

	if (dir_image[index_image[0]].image == NULL){
	    write_erreur(9);
	    XUndefineCursor(gDisplay, XtWindow(gLabowidget));
	    XUndefineCursor(gDisplay, 
			    XtWindow(XtParent (XtParent (options_OK))));
	    return;
	}
	if (dir_image[index_image[2]].image == NULL){
	    write_erreur(10);
	    XUndefineCursor(gDisplay, XtWindow(gLabowidget));
	    XUndefineCursor(gDisplay, 
			    XtWindow(XtParent (XtParent (options_OK))));
	    return;
	}

	if (dir_desc[index_image[0]].type > 3 || 
	    dir_desc[index_image[2]].type > 3 ) write_erreur(12);

	  switch (dir_desc[index_image[0]].type ){
	    case 6:
	    case -1:
	    case 0:
	    case 1:
	    case 2:
	      im = (float *)conv_float(dir_image[index_image[0]].image,
				       dir_desc[index_image[0]].type,
				       dir_desc[index_image[0]].nligne,
				       dir_desc[index_image[0]].ncolonne);
	      flag_conv = TRUE;
	      break;
	    case 3:
	    case 4:
	    case 5:
	      im = (float *)dir_image[index_image[0]].image;
	      flag_conv = FALSE;
	      break;
	  }
	conv = (struct convol *) malloc(sizeof(*conv));
	if (dir_desc[index_image[2]].type == 3){
	  flag_conv2 = FALSE;
	  conv->masque =(float *)dir_image[index_image[2]].image;
	}
	else{
	  flag_conv2 = TRUE;
	  conv->masque = (float *)conv_float(dir_image[index_image[2]].image,
					     dir_desc[index_image[2]].type,
					     dir_desc[index_image[2]].nligne,
					     dir_desc[index_image[2]].ncolonne);
	}
	conv->colonne = dir_desc[index_image[2]].ncolonne;
	conv->ligne = dir_desc[index_image[2]].nligne;
	conv->factmult = 1.0;

	ligne = dir_desc[index_image[0]].nligne;
	colonne = dir_desc[index_image[0]].ncolonne;
	lignearr = max(dir_desc[index_image[0]].nligne, conv->ligne);
	colonnearr = max(dir_desc[index_image[0]].ncolonne, conv->colonne);

        /******* TRAITEMENT ********/
	result = convolue (im, ligne, colonne, &imarr, lignearr, colonnearr, conv, select);
        /***************************/

	if (dir_image[index_image[1]].image != NULL) 
	    free (dir_image[index_image[1]].image);
	dir_image[index_image[1]].image = (unsigned char *)imarr;
	dir_desc[index_image[1]] = dir_desc[index_image[0]];
	dir_desc[index_image[1]].nligne = lignearr;
	dir_desc[index_image[1]].ncolonne = colonnearr;
	dir_desc[index_image[1]].type = 3;

	if (flag_conv) 
	  {
	    free(im);
	    flag_conv = FALSE;
	  }
	if (flag_conv2) free(conv->masque);
	break;
    case 3:  /* create mask */
	sprintf (buf, panel_titres[58]); 
	write_master(buf);
	sprintf (buf, "--> %d\n", index_image[1]);
	write_master (buf);

        conv = (struct convol *) malloc (sizeof (struct convol));
        conv->ligne = 
	    atoi (XmTextGetString (PRO_create_mask_param_widget->line));
        conv->colonne = 
	    atoi (XmTextGetString (PRO_create_mask_param_widget->colon));
        conv->factmult = 
	    (float)atof (XmTextGetString (PRO_create_mask_param_widget->alpha)); 
        conv->masque = 
	    (float *) malloc (conv->colonne * conv->ligne * sizeof(float));

        if (PRO_create_mask_param_widget->Text == NULL)
            build_PRO_create_mask_widget(options_OK, conv->ligne,
					   conv->colonne,
					   PRO_create_mask_param_widget);
        for (i=0; i < conv->ligne * conv->colonne; i++) 
            conv->masque[i] = 
	      (float)atof(XmTextGetString (PRO_create_mask_param_widget->Text[i]));

	im = (float *)malloc (conv->ligne * conv->colonne * 4);
	if (dir_image[index_image[1]].image != NULL) 
	  free (dir_image[index_image[1]].image);
	dir_image[index_image[1]].image = (unsigned char *)im;
	for (i=0; i < conv->ligne * conv->colonne; i++){
	  *im = *(conv->masque) * conv->factmult;
	  im++;
	  (conv->masque)++;
	}
	dir_desc[index_image[1]].type = 3;
	dir_desc[index_image[1]].nligne = conv->ligne;
	dir_desc[index_image[1]].ncolonne = conv->colonne;
	strcpy (dir_desc[index_image[1]].date, (char *)get_time());
	/* date et heure */
	strcpy (dir_desc[index_image[1]].filename, "-masque-");
	/* nom */
	break;
      default:
	XUndefineCursor(gDisplay, XtWindow(gLabowidget));
	XUndefineCursor(gDisplay, 
			XtWindow(XtParent (XtParent (options_OK))));
	return;
    }
    statis (dir_image[index_image[1]].image,
	    dir_desc[index_image[1]].type, 
	    dir_desc[index_image[1]].nligne,
	    dir_desc[index_image[1]].ncolonne,
	    &(dir_desc[index_image[1]].mmin),
	    &(dir_desc[index_image[1]].mmax), 
	    &(dir_desc[index_image[1]].mu),
	    &(dir_desc[index_image[1]].ecart));

    free(conv);
    XUndefineCursor(gDisplay, XtWindow(gLabowidget));
    XUndefineCursor(gDisplay, XtWindow(XtParent (XtParent (options_OK))));
    XtUnmanageChild (XtParent (XtParent (options_OK)));
}



/********************************************************/
/* anciennement proc_sobel 				*/
/********************************************************/

void 
PRE_PRO_edges_sobel_OK_callb(options_OK, no_select, callData)
    Widget options_OK;
    int no_select;
    caddr_t callData;
{
    int ligne, colonne, result;
    float *image, *temp;

    sprintf (buf, "Sobel "); 
    write_master (buf);
    sprintf (buf, mastertabs[18], no_select); 
    write_master (buf);
    sprintf (buf,"%d --> %d\n", index_image[0],index_image[1]);
    write_master (buf); 

    if (dir_image[index_image[0]].image == NULL){
      write_erreur(1);
      return;
    }

    XDefineCursor(gDisplay, XtWindow(gLabowidget), gWatchcursor);
    XDefineCursor(gDisplay, XtWindow(XtParent (XtParent (options_OK))), 
		  gWatchcursor);
    XFlush(gDisplay);

    switch (dir_desc[index_image[0]].type){
      case -1:
      case 0:
      case 1:
      case 2:
        image = (float *) conv_float(dir_image[index_image[0]].image,
				     dir_desc[index_image[0]].type,
				     dir_desc[index_image[0]].nligne,
				     dir_desc[index_image[0]].ncolonne);
        flag_conv = TRUE;
        break;
      case 3: 
      case 4:
      case 5:
        image = (float *)dir_image[index_image[0]].image;
	flag_conv = FALSE;
        break;
    }
    dir_desc[index_image[1]] = dir_desc[index_image[0]];
    dir_desc[index_image[1]].type = 3;
    ligne = dir_desc[index_image[1]].nligne;
    colonne = dir_desc[index_image[1]].ncolonne;

    /******* TRAITEMENT ********/
    result = edg_sobel(image, &temp, colonne, ligne, no_select);
    /***************************/

    if (dir_image[index_image[1]].image != NULL) 
       free (dir_image[index_image[1]]);
    dir_image[index_image[1]].image = (unsigned char *) temp;
    if (flag_conv)
      {
       free (image);
       flag_conv = FALSE;
     }
    statis (dir_image[index_image[1]].image,
	    dir_desc[index_image[1]].type, 
	    dir_desc[index_image[1]].nligne,
	    dir_desc[index_image[1]].ncolonne,
	    &(dir_desc[index_image[1]].mmin),
	    &(dir_desc[index_image[1]].mmax), 
	    &(dir_desc[index_image[1]].mu),
	    &(dir_desc[index_image[1]].ecart));

    XUndefineCursor(gDisplay, XtWindow(gLabowidget));
    XUndefineCursor(gDisplay, XtWindow(XtParent (XtParent (options_OK))));
    XtUnmanageChild (XtParent (XtParent (options_OK)));
}



/********************************************************/
/* anciennement proc_laplace 				*/
/********************************************************/

void
PRE_PRO_edges_laplace_OK_callb(options_OK, no_select, callData)
    Widget options_OK;
    int no_select;
    caddr_t callData;
{
    int ligne, colonne, result;
    float *image, *temp;

    sprintf (buf, mastertabs[19]); 
    write_master (buf);
    sprintf (buf, mastertabs[20], no_select); 
    write_master (buf);
    sprintf (buf,"%d-->%d\n", index_image[0],index_image[1]);
    write_master (buf);

    if (dir_image[index_image[0]].image == NULL){
      write_erreur(1);
      return;
    }

    XDefineCursor(gDisplay, XtWindow(gLabowidget), gWatchcursor);
    XDefineCursor(gDisplay, XtWindow(XtParent (XtParent (options_OK))), 
		  gWatchcursor);
    XFlush(gDisplay);

    switch (dir_desc[index_image[0]].type){
      case -1:
      case 0:
      case 1:
      case 2:
        image = (float *) conv_float(dir_image[index_image[0]].image,
				     dir_desc[index_image[0]].type,
				     dir_desc[index_image[0]].nligne,
				     dir_desc[index_image[0]].ncolonne);
        flag_conv = TRUE;
        break;
      case 3: 
      case 4:
      case 5:
        image = (float *)dir_image[index_image[0]].image;
	flag_conv = FALSE;
        break;
    }
    dir_desc[index_image[1]] = dir_desc[index_image[0]];
    dir_desc[index_image[1]].type = 3;
    ligne = dir_desc[index_image[1]].nligne;
    colonne = dir_desc[index_image[1]].ncolonne;

    /******* TRAITEMENT ********/
    result = edg_laplace(image, &temp, colonne, ligne, no_select);
    /***************************/

    if (dir_image[index_image[1]].image != NULL) 
       free (dir_image[index_image[1]]);
    dir_image[index_image[1]].image = (unsigned char *) temp;
    if (flag_conv) 
      {
	free (image);
	flag_conv = FALSE;
      }
    statis (dir_image[index_image[1]].image,
	    dir_desc[index_image[1]].type, 
	    dir_desc[index_image[1]].nligne,
	    dir_desc[index_image[1]].ncolonne,
	    &(dir_desc[index_image[1]].mmin),
	    &(dir_desc[index_image[1]].mmax), 
	    &(dir_desc[index_image[1]].mu),
	    &(dir_desc[index_image[1]].ecart));

    XUndefineCursor(gDisplay, XtWindow(gLabowidget));
    XUndefineCursor(gDisplay, XtWindow(XtParent (XtParent (options_OK))));
    XtUnmanageChild (XtParent (XtParent (options_OK)));
}



/********************************************************/
/* anciennement proc_roberts 				*/
/********************************************************/

void 
PRE_PRO_edges_roberts_OK_callb (options_OK, no_select, callData)
    Widget options_OK;
    int no_select;
    caddr_t callData;
{
    int ligne, colonne, result;
    float *image, *temp;

    sprintf (buf, "Roberts"); 
    write_master (buf);
    sprintf (buf, mastertabs[18], no_select); 
    write_master (buf);
    sprintf (buf,"%d --> %d\n", index_image[0],index_image[1]);
    write_master (buf);

    if (dir_image[index_image[0]].image == NULL){
      write_erreur(1);
      return;
    }

    XDefineCursor(gDisplay, XtWindow(gLabowidget), gWatchcursor);
    XDefineCursor(gDisplay, XtWindow(XtParent (XtParent (options_OK))), 
		  gWatchcursor);
    XFlush(gDisplay);

    switch (dir_desc[index_image[0]].type){
      case -1:
      case 0:
      case 1:
      case 2:
        image = (float *) conv_float(dir_image[index_image[0]].image,
				     dir_desc[index_image[0]].type,
				     dir_desc[index_image[0]].nligne,
				     dir_desc[index_image[0]].ncolonne);
        flag_conv = TRUE;
        break;
      case 3: 
      case 4:
      case 5:
        image = (float *)dir_image[index_image[0]].image;
	flag_conv = FALSE;
        break;
    }
    dir_desc[index_image[1]] = dir_desc[index_image[0]];
    dir_desc[index_image[1]].type = 3;
    ligne = dir_desc[index_image[1]].nligne;
    colonne = dir_desc[index_image[1]].ncolonne;

    /******* TRAITEMENT ********/
    result = edg_roberts(image, &temp, colonne, ligne, no_select);
    /***************************/
    
    if (dir_image[index_image[1]].image != NULL) 
      free (dir_image[index_image[1]]);
    dir_image[index_image[1]].image = (unsigned char *) temp;
    if (flag_conv) 
      {
	free (image);
	flag_conv = FALSE;
      }
    statis (dir_image[index_image[1]].image,
	    dir_desc[index_image[1]].type, 
	    dir_desc[index_image[1]].nligne,
	    dir_desc[index_image[1]].ncolonne,
	    &(dir_desc[index_image[1]].mmin),
	    &(dir_desc[index_image[1]].mmax), 
	    &(dir_desc[index_image[1]].mu),
	    &(dir_desc[index_image[1]].ecart));

    XUndefineCursor(gDisplay, XtWindow(gLabowidget));
    XUndefineCursor(gDisplay, XtWindow(XtParent (XtParent (options_OK))));
    XtUnmanageChild (XtParent (XtParent (options_OK)));
}



/********************************************************/
/* anciennement proc_frei_chen			        */
/********************************************************/

void
PRE_PRO_edges_frei_chen_OK_callb (options_OK, clientData, callData)
	Widget options_OK;
	caddr_t clientData;
	caddr_t callData;
{
    int ligne, colonne, result;
    float *image;
    float *imageout;

    sprintf (buf, "Frei & Chen"); 
    write_master (buf);
    sprintf (buf,"%d --> %d\n", index_image[0],index_image[1]);
    write_master (buf);

    if (dir_image[index_image[0]].image == NULL){
      write_erreur(1);
      return;
    }

    XDefineCursor(gDisplay, XtWindow(gLabowidget), gWatchcursor);
    XDefineCursor(gDisplay, XtWindow(XtParent (XtParent (options_OK))), 
		  gWatchcursor);
    XFlush(gDisplay);

    switch (dir_desc[index_image[0]].type){
      case -1:
      case 0:
      case 1:
      case 2:
        image = (float *) conv_float(dir_image[index_image[0]].image,
				     dir_desc[index_image[0]].type,
				     dir_desc[index_image[0]].nligne,
				     dir_desc[index_image[0]].ncolonne);
        flag_conv = TRUE;
        break;
      case 3: 
      case 4:
      case 5:
        image = (float *)dir_image[index_image[0]].image;
	flag_conv = FALSE;
        break;
    }
    dir_desc[index_image[1]] = dir_desc[index_image[0]];
    dir_desc[index_image[1]].type = 3;
    ligne = dir_desc[index_image[1]].nligne;
    colonne = dir_desc[index_image[1]].ncolonne;

    /******* TRAITEMENT ********/
    result = edg_frei_chen(image, &imageout, colonne,ligne);
    /***************************/

    if (dir_image[index_image[1]].image != NULL) 
       free (dir_image[index_image[1]]);
    dir_image[index_image[1]].image = (unsigned char *)imageout;
    if (flag_conv) 
      {
	free (image);
	flag_conv = FALSE;
      }
    statis (dir_image[index_image[1]].image,
	    dir_desc[index_image[1]].type, 
	    dir_desc[index_image[1]].nligne,
	    dir_desc[index_image[1]].ncolonne,
	    &(dir_desc[index_image[1]].mmin),
	    &(dir_desc[index_image[1]].mmax), 
	    &(dir_desc[index_image[1]].mu),
	    &(dir_desc[index_image[1]].ecart));

    XUndefineCursor(gDisplay, XtWindow(gLabowidget));
    XUndefineCursor(gDisplay, XtWindow(XtParent (XtParent (options_OK))));
    XtUnmanageChild (XtParent (XtParent (options_OK)));
}




/********************************************************/
/* anciennement proc_mero_vassy			        */
/********************************************************/

void 
PRE_PRO_edges_mero_vassy_OK_callb (options_OK, clientData, callData)
	Widget options_OK;
	caddr_t clientData;
	caddr_t callData;
{
    int ligne, colonne, result;
    float *image;
    float *imageout;

    sprintf (buf, "Mero Vassy:");
    write_master(buf);
    sprintf (buf, " %d-->%d\n",index_image[0],index_image[1]);
    write_master (buf);

    if (dir_image[index_image[0]].image == NULL){
      write_erreur(1);
      return;
    }

    XDefineCursor(gDisplay, XtWindow(gLabowidget), gWatchcursor);
    XDefineCursor(gDisplay, XtWindow(XtParent (XtParent (options_OK))), 
		  gWatchcursor);
    XFlush(gDisplay);

    switch (dir_desc[index_image[0]].type ){
      case 6:
      case -1:
      case 0:
      case 1:
      case 2:
	 flag_conv = TRUE;
	 image = (float *)conv_float(dir_image[index_image[0]].image,
				  dir_desc[index_image[0]].type,
				  dir_desc[index_image[0]].nligne,
				  dir_desc[index_image[0]].ncolonne);
	 break;
      case 3:
      case 4:
      case 5:
	 flag_conv = FALSE;
	 image = (float *)dir_image[index_image[0]].image;
	 break;
    }

    dir_desc[index_image[1]] = dir_desc[index_image[0]];
    dir_desc[index_image[1]].type = 3;
    ligne = dir_desc[index_image[1]].nligne;
    colonne = dir_desc[index_image[1]].ncolonne;

    /******* TRAITEMENT ********/
    result = edg_mero_vassy(image, &imageout, colonne,  ligne);
    /***************************/
    
    if (dir_image[index_image[1]].image != NULL) 
        free (dir_image[index_image[1]]);
    dir_image[index_image[1]].image = (unsigned char *)imageout;
    if (flag_conv) 
      {
	free(image);
	flag_conv = FALSE;
      }
    statis (dir_image[index_image[1]].image,
	    dir_desc[index_image[1]].type, 
	    dir_desc[index_image[1]].nligne,
	    dir_desc[index_image[1]].ncolonne,
	    &(dir_desc[index_image[1]].mmin),
	    &(dir_desc[index_image[1]].mmax), 
	    &(dir_desc[index_image[1]].mu),
	    &(dir_desc[index_image[1]].ecart));

    XUndefineCursor(gDisplay, XtWindow(gLabowidget));
    XUndefineCursor(gDisplay, XtWindow(XtParent (XtParent (options_OK))));
    XtUnmanageChild (XtParent (XtParent (options_OK)));
}



/********************************************************/
/* anciennement proc_zero_cross 			*/
/********************************************************/

void 
PRE_PRO_edges_zero_cross_OK_callb (options_OK, clientData, callData)
	Widget options_OK;
	caddr_t clientData;
	caddr_t callData;
{
    float *bnf, *im;
    int ligne, colonne, result;
    float valzero;

    sprintf (buf, mastertabs[21]);
    write_master (buf);
    sprintf (buf, "%d --> %d\n",index_image[0],index_image[1]);
    write_master (buf);

    if (dir_image[index_image[0]].image == NULL){
      write_erreur(1);
      return;
    }

    XDefineCursor(gDisplay, XtWindow(gLabowidget), gWatchcursor); 
    XDefineCursor(gDisplay, XtWindow(XtParent (XtParent (options_OK))), 
		  gWatchcursor);
    XFlush(gDisplay);

    switch (dir_desc[index_image[0]].type ){
      case 6:
      case -1:
      case 0:
      case 1:
      case 2:
	 flag_conv = TRUE;
	 im = (float *)conv_float(dir_image[index_image[0]].image,
				  dir_desc[index_image[0]].type,
				  dir_desc[index_image[0]].nligne,
				  dir_desc[index_image[0]].ncolonne);
	 break;
      case 3:
      case 4:
      case 5:
	 flag_conv = FALSE;
	 im = (float *)dir_image[index_image[0]].image;
	 break;
    }

    dir_desc[index_image[1]] = dir_desc[index_image[0]];
    dir_desc[index_image[1]].type = 3;
    ligne = dir_desc[index_image[1]].nligne;
    colonne = dir_desc[index_image[1]].ncolonne;

    valzero = dir_desc[index_image[0]].mu;

    /******* TRAITEMENT ********/
    result = edg_zero_cross(im, &bnf, colonne, ligne, valzero);
    /***************************/

    if (dir_image[index_image[1]].image != NULL) 
       free (dir_image[index_image[1]]);
    dir_image[index_image[1]].image = (unsigned char *)bnf;
    statis (dir_image[index_image[1]].image,
	    dir_desc[index_image[1]].type, 
	    dir_desc[index_image[1]].nligne,
	    dir_desc[index_image[1]].ncolonne,
	    &(dir_desc[index_image[1]].mmin),
	    &(dir_desc[index_image[1]].mmax), 
	    &(dir_desc[index_image[1]].mu),
	    &(dir_desc[index_image[1]].ecart));
    if (flag_conv) 
      {
	free(im);
	flag_conv = FALSE;
      }
    XUndefineCursor(gDisplay, XtWindow(gLabowidget));
    XUndefineCursor(gDisplay, XtWindow(XtParent (XtParent (options_OK))));
    XtUnmanageChild (XtParent (XtParent (options_OK)));
}



/********************************************************/
/* anciennement proc_median 				*/
/********************************************************/

void 
PRE_PRO_enhanc_median_OK_callb(options_OK, PREPRO_linear_filter_param_widget, callData)
	Widget options_OK;
	xs_struc_paramprepro *PREPRO_linear_filter_param_widget;
	caddr_t callData;
{
    int ngr, result, ligne, colonne;
    float  *image, *temp;
    struct filmed *ffilm;

    ffilm = (struct filmed *) malloc (sizeof (struct filmed));
    ffilm->nlin = atoi (XmTextGetString (PREPRO_linear_filter_param_widget->line));
    ffilm->ncol = atoi (XmTextGetString (PREPRO_linear_filter_param_widget->colon));

    sprintf (buf, mastertabs[223]);
    write_master(buf);
    sprintf (buf, "%dx%d: %d --> %d\n", ffilm->ncol, ffilm->nlin, 
	     index_image[0], index_image[1]);
    write_master (buf);	

    if ((ffilm->ncol == 0) && (ffilm->nlin == 0)){
	write_erreur(96);
	return;
    }

    if (dir_image[index_image[0]].image == NULL){
      write_erreur(1);
      return;
    }

    XDefineCursor(gDisplay, XtWindow(gLabowidget), gWatchcursor);
    XDefineCursor(gDisplay, XtWindow(XtParent (XtParent (options_OK))), 
		  gWatchcursor);
    XFlush(gDisplay);

    switch (dir_desc[index_image[0]].type ){
      case 6:
      case -1:
      case 0:
      case 1:
      case 2:
	 flag_conv = TRUE;
	 image = (float *)conv_float(dir_image[index_image[0]].image,
				  dir_desc[index_image[0]].type,
				  dir_desc[index_image[0]].nligne,
				  dir_desc[index_image[0]].ncolonne);
	 break;
      case 3:
      case 4:
      case 5:
	 flag_conv = FALSE;
	 image = (float *)dir_image[index_image[0]].image;
	 break;
    }

    dir_desc[index_image[1]] = dir_desc[index_image[0]];
    dir_desc[index_image[1]].type = 3;
    ngr=(int)dir_desc[index_image[0]].mmax + 1; 
    ligne = (int)dir_desc[index_image[1]].nligne;
    colonne = (int)dir_desc[index_image[1]].ncolonne;

    /******* TRAITEMENT ********/
    result = SlideWindow(image, &temp, colonne, ligne,
			 ffilm->ncol, ffilm->nlin, ngr);
    /***************************/

    if (dir_image[index_image[1]].image != NULL)
	     free (dir_image[index_image[1]].image);
    dir_image[index_image[1]].image = (unsigned char *) temp;
    if (flag_conv)
      {
	free (image);
 	flag_conv = FALSE;
      }
    statis (dir_image[index_image[1]].image,
	    dir_desc[index_image[1]].type, 
	    dir_desc[index_image[1]].nligne,
	    dir_desc[index_image[1]].ncolonne,
	    &(dir_desc[index_image[1]].mmin),
	    &(dir_desc[index_image[1]].mmax), 
	    &(dir_desc[index_image[1]].mu),
	    &(dir_desc[index_image[1]].ecart));

    XUndefineCursor(gDisplay, XtWindow(gLabowidget));
    XUndefineCursor(gDisplay, XtWindow(XtParent (XtParent (options_OK))));
    XtUnmanageChild (XtParent (XtParent (options_OK)));
}



/********************************************************/
/* anciennement proc_high_pas 				*/
/********************************************************/

void 
PRE_PRO_enhanc_high_pass_OK_callb(options_OK, PREPRO_high_pass_filter_param_widget, callData)
	Widget options_OK;
	xs_struc_paramprepro *PREPRO_high_pass_filter_param_widget;
	caddr_t callData;
{
    float *img, *temp, *imagei;
    struct pertile *perc;
    int taille, ligne, colonne, i, t, result;

    perc = (struct pertile *) malloc (sizeof (struct pertile));
    perc->alpha = (float)atof (XmTextGetString (PREPRO_high_pass_filter_param_widget->alpha));

    sprintf (buf, mastertabs[286]);
    write_master (buf);
    sprintf (buf, "%d --> %d ", index_image[0], index_image[1]);
    write_master (buf);
    sprintf (buf, "(coeff = %.4f)\n", perc->alpha);
    write_master (buf);

    if (perc->alpha == 0){
	write_erreur(105);
	return;
    }

    if (dir_image[index_image[0]].image == NULL){
      write_erreur(1);
      return;
    }

    XDefineCursor(gDisplay, XtWindow(gLabowidget), gWatchcursor);
    XDefineCursor(gDisplay, XtWindow(XtParent (XtParent (options_OK))), 
		  gWatchcursor);
    XFlush(gDisplay);

    switch (dir_desc[index_image[0]].type ){
      case 6:
      case -1:
      case 0:
      case 1:
      case 2:
	 flag_conv = TRUE;
	 img = (float *)conv_float(dir_image[index_image[0]].image,
				  dir_desc[index_image[0]].type,
				  dir_desc[index_image[0]].nligne,
				  dir_desc[index_image[0]].ncolonne);
	 break;
      case 3:
      case 4:
      case 5:
	 flag_conv = FALSE;
	 img = (float *)dir_image[index_image[0]].image;
	 break;
    }
    dir_desc[index_image[1]] = dir_desc[index_image[0]];
    dir_desc[index_image[1]].type = 3;
    ligne = (int)dir_desc[index_image[1]].nligne;
    colonne = (int)dir_desc[index_image[1]].ncolonne;
    taille = ligne * colonne * element(dir_desc[index_image[1]].type);
    t = 1;

    /******* TRAITEMENT ********/
    result = edg_laplace(img, &temp, colonne, ligne, t);
    /***************************/

/* imagei jamais utilise?????? */
    imagei = temp;
    for (i = 0; i < ligne * colonne; i++){
      *imagei = *img + *imagei * perc->alpha;
      img++;
      imagei++; 
    }

    if (dir_image[index_image[1]].image != NULL)
		free (dir_image[index_image[1]].image);
    dir_image[index_image[1]].image = (unsigned char *)temp;
    statis (dir_image[index_image[1]].image,
	    dir_desc[index_image[1]].type, 
	    dir_desc[index_image[1]].nligne,
	    dir_desc[index_image[1]].ncolonne,
	    &(dir_desc[index_image[1]].mmin),
	    &(dir_desc[index_image[1]].mmax), 
	    &(dir_desc[index_image[1]].mu),
	    &(dir_desc[index_image[1]].ecart));
    if (flag_conv)
      {
	free (img);
	flag_conv = FALSE;
      }
    XUndefineCursor(gDisplay, XtWindow(gLabowidget));
    XUndefineCursor(gDisplay, XtWindow(XtParent (XtParent (options_OK))));
    XtUnmanageChild (XtParent (XtParent (options_OK)));
}



/********************************************************/
/* anciennement proc_hamming 				*/
/********************************************************/

void 
PRE_PRO_hamming_OK_callb(options_OK, PREPRO_hamming_param_widget, callData)
    Widget options_OK;
    xs_struc_paramprepro * PREPRO_hamming_param_widget;
    caddr_t callData;
{
    int i, j, ligne, colonne, diamet, inv;
    struct rayon_puissan *r_p;
    float *bc, *rp, *ip, *rp1, *ip1;

    inv = PREPRO_hamming_param_widget->type_operation;

    r_p = (struct rayon_puissan *) malloc (sizeof (struct rayon_puissan));
    r_p->r_frequency = atoi (XmTextGetString (PREPRO_hamming_param_widget->alpha));

    if (inv == 1) sprintf (buf, mastertabs[296]);
    else sprintf (buf, mastertabs[300]);
    write_master (buf);
    sprintf (buf, "(%d,%d)-->(%d,%d)", 
             index_image[0], index_image[2], index_image[1],
	     index_image[3]);
    write_master (buf);
    sprintf (buf, mastertabs[295], r_p->r_frequency);
    write_master(buf);

    if (dir_image[index_image[0]].image == NULL){
      write_erreur(9);
      free (r_p);
      XtUnmanageChild (XtParent (XtParent (options_OK)));
      return;
    }

    if (dir_image[index_image[2]].image == NULL){
      write_erreur(10);
      free (r_p);
      XtUnmanageChild (XtParent (XtParent (options_OK)));
      return;
    }

    if (r_p->r_frequency == 0) 
    {
      write_erreur(105);
      free (r_p);
      XtUnmanageChild (XtParent (XtParent (options_OK)));
      return;
    }
    
    if (r_p->r_frequency > dir_desc[index_image[0]].nligne/2) 
    {
      write_erreur(106);
      free (r_p);
      XtUnmanageChild (XtParent (XtParent (options_OK)));
      return;
    }

    if (dir_desc[index_image[0]].type !=3 || dir_desc[index_image[2]].type !=3)
    {
      write_erreur(14);
      free (r_p);
      XtUnmanageChild (XtParent (XtParent (options_OK)));
      return;
    }

    if (dir_desc[index_image[0]].nligne != dir_desc[index_image[2]].nligne
     || dir_desc[index_image[0]].ncolonne != dir_desc[index_image[2]].ncolonne)
    {      
      write_erreur(2);
      free (r_p);
      XtUnmanageChild (XtParent (XtParent (options_OK)));
      return;
    }

    if (power_2(dir_desc[index_image[0]].nligne) == FALSE ||
	power_2(dir_desc[index_image[0]].ncolonne) == FALSE)
    {
      write_erreur(15);
      free (r_p);
      XtUnmanageChild (XtParent (XtParent (options_OK)));
      return;
    }

    if (dir_desc[index_image[0]].nligne != dir_desc[index_image[0]].ncolonne)
    {
      write_erreur(19);
      free (r_p);
      XtUnmanageChild (XtParent (XtParent (options_OK)));
      return;
    }

    XDefineCursor(gDisplay, XtWindow(gLabowidget), gWatchcursor);
    XDefineCursor(gDisplay, XtWindow(XtParent (XtParent (options_OK))), 
		  gWatchcursor);
    XFlush(gDisplay);

    diamet = r_p->r_frequency * 2;
    dir_desc[index_image[1]] = dir_desc[index_image[0]];
    dir_desc[index_image[3]] = dir_desc[index_image[2]];
    ligne = colonne = (int)dir_desc[index_image[0]].nligne;
    bc = (float *)calloc(ligne * colonne, sizeof(float));

    /******* TRAITEMENT ********/
    if (inv == 1) winhamming(bc, colonne, ligne, diamet);
    else winhanning(bc, colonne, ligne, diamet);
    /***************************/

    rp = (float *)calloc(ligne * colonne, sizeof(float));
    ip = (float *)calloc(ligne * colonne, sizeof(float));
    rp1 = (float *)dir_image[index_image[0]].image;
    ip1 = (float *)dir_image[index_image[2]].image;
    for (i = 0; i < ligne; i++)
      {
	for (j = 0; j < colonne; j++)
	  {
	    rp[i * colonne + j] = rp1[i * colonne + j] * bc[i * colonne + j];
	    ip[i * colonne + j] = ip1[i * colonne + j] * bc[i * colonne + j];
	  }
      }   /*multiply hamming window with real&imagenary plane respectively*/

    dir_image[index_image[1]].image = (unsigned char *)rp;
    dir_image[index_image[3]].image = (unsigned char *)ip;
    free (bc);
    statis (dir_image[index_image[1]].image,
	    dir_desc[index_image[1]].type, 
	    dir_desc[index_image[1]].nligne,
	    dir_desc[index_image[1]].ncolonne,
	    &(dir_desc[index_image[1]].mmin),
	    &(dir_desc[index_image[1]].mmax), 
	    &(dir_desc[index_image[1]].mu),
	    &(dir_desc[index_image[1]].ecart));
    statis (dir_image[index_image[3]].image,
	    dir_desc[index_image[3]].type, 
	    dir_desc[index_image[3]].nligne,
	    dir_desc[index_image[3]].ncolonne,
	    &(dir_desc[index_image[3]].mmin),
	    &(dir_desc[index_image[3]].mmax), 
	    &(dir_desc[index_image[3]].mu),
	    &(dir_desc[index_image[3]].ecart));
    free (r_p);
    XUndefineCursor(gDisplay, XtWindow(gLabowidget));
    XUndefineCursor(gDisplay, XtWindow(XtParent (XtParent (options_OK))));
    XtUnmanageChild (XtParent (XtParent (options_OK)));
}



/********************************************************/
/* anciennement proc_gaussian 				*/
/********************************************************/

void 
PRE_PRO_gaussian_OK_callb(options_OK, PREPRO_gaussian_param_widget, callData)
	Widget options_OK;
	xs_struc_paramprepro * PREPRO_gaussian_param_widget;
	caddr_t callData;
{
    struct gaussian_p *gp;
    int i, j, ligne, colonne, MINT;
    float *bc, *rp, *ip, *rp1, *ip1, EN;

    gp = (struct gaussian_p *) malloc (sizeof (struct gaussian_p));
    gp->en_mint = (float)atof (XmTextGetString (PREPRO_gaussian_param_widget->alpha));
    gp->mint = atoi (XmTextGetString (PREPRO_gaussian_param_widget->diameter));

    sprintf (buf, mastertabs[297]);
    write_master (buf);
    sprintf (buf, " (%d,%d)-->(%d,%d)", 
	     index_image[0], index_image[2], 
	     index_image[1], index_image[3]);
    write_master (buf);
    sprintf (buf, "diam=%d,param=%.4f\n", gp->mint, gp->en_mint);
    write_master (buf);

    if (dir_image[index_image[0]].image == NULL){
      write_erreur(9);
      free (gp);
      XtUnmanageChild (XtParent (XtParent (options_OK)));
      return;
    }

    if (dir_image[index_image[2]].image == NULL){
      write_erreur(10);
      free (gp);
      XtUnmanageChild (XtParent (XtParent (options_OK)));
      return;
    }

    if ((gp->mint == 0) || gp->en_mint == 0){
      write_erreur(97);
      free (gp);
      XtUnmanageChild (XtParent (XtParent (options_OK)));
      return;
    }

    if (dir_image[index_image[0]].image == NULL){
      write_erreur(9);
      free (gp);
      XtUnmanageChild (XtParent (XtParent (options_OK)));
      return;
    }

    if (dir_image[index_image[2]].image == NULL){
      write_erreur(10);
      free (gp);
      XtUnmanageChild (XtParent (XtParent (options_OK)));
      return;
    }

    if (dir_desc[index_image[0]].type !=3 
	    || dir_desc[index_image[2]].type !=3){
      write_erreur(14);
      free (gp);
      XtUnmanageChild (XtParent (XtParent (options_OK)));
      return;
    }

    if (dir_desc[index_image[0]].nligne 
		!= dir_desc[index_image[2]].nligne
	    || dir_desc[index_image[0]].ncolonne 
		!= dir_desc[index_image[2]].ncolonne){
      write_erreur(2);
      free (gp);
      XtUnmanageChild (XtParent (XtParent (options_OK)));
      return;
    }

    if (power_2(dir_desc[index_image[0]].nligne) == FALSE 
	    || power_2(dir_desc[index_image[0]].ncolonne) == FALSE){
      write_erreur(15);
      free (gp);
      XtUnmanageChild (XtParent (XtParent (options_OK)));
      return;
    }

    if (dir_desc[index_image[0]].nligne 
		!= dir_desc[index_image[0]].ncolonne){
      write_erreur(19);
      free (gp);
      XtUnmanageChild (XtParent (XtParent (options_OK)));
      return;
    }

    XDefineCursor(gDisplay, XtWindow(gLabowidget), gWatchcursor);
    XDefineCursor(gDisplay, XtWindow(XtParent (XtParent (options_OK))), 
		  gWatchcursor);
    XFlush(gDisplay);

    MINT = gp->mint;
    EN = gp->mint * gp->en_mint;
    dir_desc[index_image[1]] = dir_desc[index_image[0]];
    dir_desc[index_image[3]] = dir_desc[index_image[2]];
    ligne = colonne = (int)dir_desc[index_image[0]].nligne;
    bc = (float *)calloc(ligne * colonne, sizeof(float));
    
    /******* TRAITEMENT ********/
    wingauss(bc, colonne, ligne, EN, MINT);
    /***************************/

    rp = (float *)calloc(ligne * colonne, sizeof(float));
    ip = (float *)calloc(ligne * colonne, sizeof(float));
    rp1 = (float *)dir_image[index_image[0]].image;
    ip1 = (float *)dir_image[index_image[2]].image;
    for (i = 0; i < ligne; i++)
      {
	for (j = 0; j < colonne; j++)
	{
	  rp[i * colonne + j] = rp1[i * colonne + j] * bc[i * colonne + j];
	  ip[i * colonne + j] = ip1[i * colonne + j] * bc[i * colonne + j];
	}
      }  /*multiply gaussian window with real&imagenary plane respectively*/

    dir_image[index_image[1]].image = (unsigned char *)rp;
    dir_image[index_image[3]].image = (unsigned char *)ip;
    free (bc);
    statis (dir_image[index_image[1]].image,
	    dir_desc[index_image[1]].type, 
	    dir_desc[index_image[1]].nligne,
	    dir_desc[index_image[1]].ncolonne,
	    &(dir_desc[index_image[1]].mmin),
	    &(dir_desc[index_image[1]].mmax), 
	    &(dir_desc[index_image[1]].mu),
	    &(dir_desc[index_image[1]].ecart));
    statis (dir_image[index_image[3]].image,
	    dir_desc[index_image[3]].type, 
	    dir_desc[index_image[3]].nligne,
	    dir_desc[index_image[3]].ncolonne,
	    &(dir_desc[index_image[3]].mmin),
	    &(dir_desc[index_image[3]].mmax), 
	    &(dir_desc[index_image[3]].mu),
	    &(dir_desc[index_image[3]].ecart));

    free (gp);
    XUndefineCursor(gDisplay, XtWindow(gLabowidget));
    XUndefineCursor(gDisplay, XtWindow(XtParent (XtParent (options_OK))));
    XtUnmanageChild (XtParent (XtParent (options_OK)));
}



/********************************************************/
/* anciennement proc_ptile_seuil 			*/
/********************************************************/

void 
PRE_PRO_lapl_percent_histo_OK_callb(options_OK,  PRO_threshold_laplac_param_widget, callData)
	Widget options_OK;
	xs_struc_paramprepro *PRO_threshold_laplac_param_widget;
	caddr_t callData;
{
    float *image;
    struct pertile *perc;
    float *imageout;
    int ligne, colonne, ligneout, result;
   
    perc = (struct pertile *) malloc (sizeof (struct pertile));
    perc->ptiledata = (float)atof (XmTextGetString (PRO_threshold_laplac_param_widget->alpha));

    sprintf (buf, mastertabs[287]);
    write_master (buf);
    sprintf (buf, "%d --> %d ", index_image[0], index_image[1]);
    write_master (buf);
    sprintf (buf, "(coeff = %.4f)\n", perc->ptiledata);
    write_master (buf);

    if (dir_image[index_image[0]].image == NULL){
      write_erreur(1);
      free(perc);
      XtUnmanageChild (XtParent (XtParent (options_OK)));
      return;
    }

    if (perc->ptiledata == NULL){
      write_erreur(93);
      free(perc);
      XtUnmanageChild (XtParent (XtParent (options_OK)));
      return;
    }

    XDefineCursor(gDisplay, XtWindow(gLabowidget), gWatchcursor);
    XDefineCursor(gDisplay, XtWindow(XtParent (XtParent (options_OK))), 
		  gWatchcursor);
    XFlush(gDisplay);

    switch (dir_desc[index_image[0]].type ){
      case 6:
      case -1:
      case 0:
      case 1:
      case 2:
	 flag_conv = TRUE;
	 image = (float *)conv_float(dir_image[index_image[0]].image,
				  dir_desc[index_image[0]].type,
				  dir_desc[index_image[0]].nligne,
				  dir_desc[index_image[0]].ncolonne);
	 break;
      case 3:
      case 4:
      case 5:
	 flag_conv = FALSE;
	 image = (float *)dir_image[index_image[0]].image;
	 break;
    }
    ligne = dir_desc[index_image[0]].nligne;
    colonne = dir_desc[index_image[0]].ncolonne;

    /******* TRAITEMENT ********/
    result = lapla_ptl(image, &imageout, ligne, colonne, &ligneout, 
		       perc->ptiledata);
    /***************************/

    dir_desc[index_image[1]] = dir_desc[index_image[0]];
    dir_desc[index_image[1]].nligne = ligneout;
    dir_desc[index_image[1]].ncolonne = 2;    
    dir_desc[index_image[1]].type = 3;

    if (dir_image[index_image[1]].image != NULL)
	free (dir_image[index_image[1]].image);

    dir_image[index_image[1]].image = (unsigned char*)imageout;
    
    statis( dir_image[index_image[1]].image,
	    dir_desc[index_image[1]].type,
	    dir_desc[index_image[1]].nligne,
	    dir_desc[index_image[1]].ncolonne,
	    &(dir_desc[index_image[1]].mmin),
	    &(dir_desc[index_image[1]].mmax),
	    &(dir_desc[index_image[1]].mu),
	    &(dir_desc[index_image[1]].ecart));
    if (flag_conv)
      {
	free (image);
	flag_conv = FALSE;
      }

    free(perc);
    XUndefineCursor(gDisplay, XtWindow(gLabowidget));
    XUndefineCursor(gDisplay, XtWindow(XtParent (XtParent (options_OK))));
    XtUnmanageChild (XtParent (XtParent (options_OK)));
}



/********************************************************/
/* anciennement proc_dyna_seuil 			*/
/********************************************************/

void
PRE_PRO_dynamic_thres_OK_callb(options_OK, PREPRO_dynamic_threshold_param_widget, callData)
	Widget options_OK;
	xs_struc_paramprepro *PREPRO_dynamic_threshold_param_widget;
	caddr_t callData;
{
    struct pertile *perc;
    static struct paddi pd;
    float *imdep, *imdep2, *imarr, *imarr2;
    int *imref,  *tprc, ISW, ligne, colonne, ligne1, colonne1, result;

    perc = (struct pertile *) malloc (sizeof (struct pertile));
    perc->n_block = atoi (XmTextGetString (PREPRO_dynamic_threshold_param_widget->alpha));

    sprintf (buf, mastertabs[288]);
    write_master (buf);
    sprintf (buf, "%d --> %d", index_image[0], index_image[1]);
    write_master(buf);
    sprintf (buf,"(ref pln--> %d)", index_image[3]);
    write_master(buf);
    sprintf (buf, mastertabs[299]);
    sprintf (buf, "= %d)\n", perc->n_block);
    write_master (buf);


    if (dir_image[index_image[0]].image == NULL){
      write_erreur(1);
      free(perc);
      XtUnmanageChild (XtParent (XtParent (options_OK)));
      return;
    }

    if (perc->n_block == 0){
      write_erreur(94);
      free(perc);
      XtUnmanageChild (XtParent (XtParent (options_OK)));
      return;
    }

    XDefineCursor(gDisplay, XtWindow(gLabowidget), gWatchcursor);
    XDefineCursor(gDisplay, XtWindow(XtParent (XtParent (options_OK))), 
		  gWatchcursor);
    XFlush(gDisplay);

    switch (dir_desc[index_image[0]].type ){
      case 6:
      case -1:
      case 0:
      case 1:
      case 2:
	 flag_conv = TRUE;
	 imdep = (float *)conv_float(dir_image[index_image[0]].image,
				  dir_desc[index_image[0]].type,
				  dir_desc[index_image[0]].nligne,
				  dir_desc[index_image[0]].ncolonne);
	 break;
      case 3:
      case 4:
      case 5:
	 flag_conv = FALSE;
	 imdep = (float *)dir_image[index_image[0]].image;
	 break;
    }

    ligne =  dir_desc[index_image[0]].nligne;
    colonne =  dir_desc[index_image[0]].ncolonne;

    /******* TRAITEMENT ********/
    /* create threshold reference plane --> image[1] */
    result = cre_plan_ref(imdep, colonne, ligne, &imarr, perc->n_block);
    /***************************/

    dir_image[index_image[1]].image = (unsigned char *)imarr;
    dir_desc[index_image[1]].type = 3;
    dir_desc[index_image[1]].nligne = ligne - perc->n_block;
    dir_desc[index_image[1]].ncolonne = colonne - perc->n_block;
    statis( dir_image[index_image[1]].image,
	    dir_desc[index_image[1]].type,
	    dir_desc[index_image[1]].nligne,
	    dir_desc[index_image[1]].ncolonne,
	    &(dir_desc[index_image[1]].mmin),
	    &(dir_desc[index_image[1]].mmax),
	    &(dir_desc[index_image[1]].mu),
	    &(dir_desc[index_image[1]].ecart));    

    pd.ligne = ligne;
    pd.colonne = colonne;
    pd.methode = 2;

    ligne1 =  dir_desc[index_image[1]].nligne;
    colonne1 =  dir_desc[index_image[1]].ncolonne;

    imdep2 = (float *)dir_image[index_image[1]].image;

    /******* TRAITEMENT ********/
    /* pad image[1] to the same size of image[0]--> image[3] */
    result = padding_prolong(imdep2, colonne1, ligne1, 
			     dir_desc[index_image[1]].type, &imarr2,
			     &pd);
    /***************************/

    if (result != 0) 
    {
      XUndefineCursor(gDisplay, XtWindow(gLabowidget));
      XUndefineCursor(gDisplay, 
		      XtWindow(XtParent (XtParent (options_OK))));
      return;
    }
    
    if (dir_image[index_image[3]].image != NULL)
	   free (dir_image[index_image[3]].image);
    dir_image[index_image[3]].image = (unsigned char *)imarr2;

    dir_desc[index_image[3]] = dir_desc[index_image[1]];
    dir_desc[index_image[3]].nligne = pd.ligne;
    dir_desc[index_image[3]].ncolonne = pd.colonne;
    statis (dir_image[index_image[3]].image, 
	    dir_desc[index_image[3]].type, 
            dir_desc[index_image[3]].nligne,
	    dir_desc[index_image[3]].ncolonne,
            &(dir_desc[index_image[3]].mmin),
	    &(dir_desc[index_image[3]].mmax), 
            &(dir_desc[index_image[3]].mu), 
	    &(dir_desc[index_image[3]].ecart));


    imref = (int *)dir_image[index_image[3]].image;
    ISW = 2;

    /******* TRAITEMENT ********/
    refplane_binary_thresh(imdep, imref, &tprc, ligne, colonne, ISW);
    /***************************/

    if (dir_image[index_image[1]].image != NULL)
      free (dir_image[index_image[1]].image);
    dir_image[index_image[1]].image = (unsigned char *)tprc;
    dir_desc[index_image[1]].nligne = ligne;
    dir_desc[index_image[1]].ncolonne = colonne;
    statis (dir_image[index_image[1]].image,
	    dir_desc[index_image[1]].type, 
	    dir_desc[index_image[1]].nligne,
	    dir_desc[index_image[1]].ncolonne,
	    &(dir_desc[index_image[1]].mmin),
	    &(dir_desc[index_image[1]].mmax), 
	    &(dir_desc[index_image[1]].mu),
	    &(dir_desc[index_image[1]].ecart));

    if (flag_conv)
      {
	free (imdep);
	flag_conv = FALSE;
      }
    free(perc);
    XUndefineCursor(gDisplay, XtWindow(gLabowidget));
    XUndefineCursor(gDisplay, XtWindow(XtParent (XtParent (options_OK))));
    XtUnmanageChild (XtParent (XtParent (options_OK)));
}



/************************************************************************/
/* anciennement proc_ridge_ride 	(poursuite des sommets)		*/
/************************************************************************/

#define BS(x, y) bs[x * col + y]

void
PRE_PRO_edges_ridge_riding_OK_callb(options_OK, PRO_edge_ridge_riding_param_widget, callData)
	Widget options_OK;
	xs_struc_paramprepro * PRO_edge_ridge_riding_param_widget;
	caddr_t callData;
{
    struct sommet *psmt;
    float *bs, *brub, *p0, *pb;
    float aval, bval,cval;
    int first, l, spi, spj, lin, col, i;
    int segment;
    unsigned char *bres;
    struct prcd *bfpxl;
    char valdefmin[20], valdefmax[20], valdeflen[20];

    psmt = (struct sommet *) malloc (sizeof (struct sommet));
    psmt->min_thr = (float)atof (XmTextGetString (PRO_edge_ridge_riding_param_widget->line));
    psmt->max_thr = (float)atof (XmTextGetString (PRO_edge_ridge_riding_param_widget->colon));
    psmt->length = atoi (XmTextGetString (PRO_edge_ridge_riding_param_widget->alpha));

    sprintf (buf, mastertabs[22]);
    write_master (buf);
    sprintf (buf, "%d --> %d ",index_image[0],index_image[1]);
    write_master (buf);
    sprintf (buf, "(%.4f %.4f %d)\n", 
	     psmt->min_thr, psmt->max_thr, psmt->length);
    write_master (buf);

    if (dir_image[index_image[0]].image == NULL){
      write_erreur(1);
      free(psmt);
      XtUnmanageChild (XtParent (XtParent (options_OK)));
      return;
    }

    XDefineCursor(gDisplay, XtWindow(gLabowidget), gWatchcursor);
    XDefineCursor(gDisplay, XtWindow(XtParent (XtParent (options_OK))), 
		  gWatchcursor);
    XFlush(gDisplay);

    aval = dir_desc[index_image[0]].mmin ;
    bval = dir_desc[index_image[0]].mmax ;
    cval = dir_desc[index_image[0]].mu ;
    sprintf(valdefmin,"%f", aval + (cval - aval)/2);
    sprintf(valdefmax,"%f", bval - (bval - cval)/2);
    sprintf(valdeflen,"%d", (int)(dir_desc[index_image[0]].nligne/10));

    switch (dir_desc[index_image[0]].type ){
      case 6:
      case -1:
      case 0:
      case 1:
      case 2:
	 flag_conv = TRUE;
	 p0 = (float *)conv_float(dir_image[index_image[0]].image,
				  dir_desc[index_image[0]].type,
				  dir_desc[index_image[0]].nligne,
				  dir_desc[index_image[0]].ncolonne);
	 break;
      case 3:
      case 4:
      case 5:
	 flag_conv = FALSE;
	 p0 = (float *)dir_image[index_image[0]].image;
	 break;
    }

    segment = 0;
    dir_desc[index_image[1]] = dir_desc[index_image[0]];
    dir_desc[index_image[1]].type = -1;
    lin = dir_desc[index_image[1]].nligne;
    col = dir_desc[index_image[1]].ncolonne;
    bfpxl = (struct prcd *) calloc(psmt->length + 1, sizeof(struct prcd));
    bs = (float *)calloc(lin * col, sizeof(float));
    brub = (float *)calloc(lin * col, sizeof(float));
    bres = (unsigned char *)calloc(lin * col, sizeof(unsigned char));
    pb = bs;
    for (i = 0; i < lin * col; i++) {
      *pb = *p0; pb++; p0++;
    }				    /*copy image[0] to bs */

    for (spi = 0; spi < lin; spi++) {
      for (spj = 0; spj < col; spj++) {
	if (BS(spi, spj) >= psmt->max_thr) {
	  l = 0;		    /* l passed frm 1st to 2nd half */
	  first = 1;	    /* 1st half contour */
	  draw(spi,spj, &l, psmt->length, bfpxl,
	       bs, bres, brub, psmt->min_thr, first, lin, col);
	
	  permut_buf(bfpxl, l, psmt->length); 
					    /*permutates buf btw. halves*/

	  first = 0;	    /* 2nd half contour */
	  draw(spi,spj, &l, psmt->length, bfpxl,
	       bs, bres, brub, psmt->min_thr, first, lin, col);

	  /* stores only contours >= length; others are destroyed */
	  if (l>=psmt->length) {	    /* incr counter */
	    segment++;
	  }		    /* if (length >=lt)  */
	}			    /* if (BS(spi,spj) > ...) */
      }
    }
    free(bfpxl);
    free(bs);
    free(brub);
    if (dir_image[index_image[1]].image != NULL) 
      free (dir_image[index_image[1]]);
    dir_image[index_image[1]].image = (unsigned char *)bres;
    statis (dir_image[index_image[1]].image,
	    dir_desc[index_image[1]].type, 
	    dir_desc[index_image[1]].nligne,
	    dir_desc[index_image[1]].ncolonne,
	    &(dir_desc[index_image[1]].mmin),
	    &(dir_desc[index_image[1]].mmax), 
	    &(dir_desc[index_image[1]].mu),
	    &(dir_desc[index_image[1]].ecart));
    free(psmt);
    XUndefineCursor(gDisplay, XtWindow(gLabowidget));
    XUndefineCursor(gDisplay, XtWindow(XtParent (XtParent (options_OK))));
    XtUnmanageChild (XtParent (XtParent (options_OK)));
}


/***************************************************************************/
/* MORPHOLOGIE A NIVEAU DE GRIS 					   */
/* ============================ 					   */
/***************************************************************************/


void proc_choix_elem (type, elem)
    char *type;
    struct element *elem;
{
    int choix;
    short *image;

    sprintf (buf, type);         /* nom de l'operation */
    write_master (buf);

    switch (*buf) {
    case 'e' : case 'E' : choix = 10; break;  /*erosion*/
    case 'd' : case 'D' : choix = 11; break;  /*dilatation*/
    case 'o' : case 'O' : choix = 12; break;  /*ouverture*/
    case 'f' : case 'F' : choix = 13; break;  /*fermeture*/
    case 'c' : case 'C' : choix = 13; break; /* anglais => closure */
    }	

    switch (elem->type){
    case 0: sprintf (buf, mastertabs[106], elem->param1);
       break;
    case 1: sprintf (buf, mastertabs[107],
                     elem->param1, elem->param2);  
       break;
    case 2: sprintf (buf, mastertabs[108],
		     elem->param1, elem->param2); 
       break;
    case 3: sprintf (buf, mastertabs[109],elem->param3, 
                     elem->param4, elem->param5);  
       break;
    case 10: sprintf (buf, mastertabs[110], elem->param1); 
       break;
    }
    write_master (buf);

    sprintf(buf, "%d --> %d\n", index_image[0], index_image[1]);    
    write_master (buf);

    if (dir_image[index_image[0]].image == NULL){
      write_erreur(1);
      return;
    }

    entree_morpho_nivgris(choix, index_image[0], index_image[1], elem);    
}


void 
PRE_PRO_ero_sphere_OK_callb(options_OK, PRO_gray_scale_morpho_widget, callData)
	Widget options_OK;
	xs_struc_paramprepro * PRO_gray_scale_morpho_widget;
	caddr_t callData;
{
    struct element *elem;
    char type[30];

    elem = (struct element *) malloc (sizeof (struct element));
    elem->param1 = (short) atoi (XmTextGetString 
				 (PRO_gray_scale_morpho_widget->alpha));
    elem->type = 0;

    XDefineCursor(gDisplay, XtWindow(gLabowidget), gWatchcursor);
    XDefineCursor(gDisplay, XtWindow(XtParent (XtParent (options_OK))), 
		  gWatchcursor);
    XFlush(gDisplay);

    sprintf (type, panel_titres[80]);
    proc_choix_elem(type, elem);

    XUndefineCursor(gDisplay, XtWindow(gLabowidget));
    XUndefineCursor(gDisplay, XtWindow(XtParent (XtParent (options_OK))));
    XtUnmanageChild (PRO_gray_scale_morpho_widget->GenerParamparent);
}


void 
PRE_PRO_ero_cone_OK_callb(options_OK, PRO_gray_scale_morpho_widget, callData)
	Widget options_OK;
	xs_struc_paramprepro * PRO_gray_scale_morpho_widget;
	caddr_t callData;
{
    struct element *elem;
    char type[30];

    elem = (struct element *) malloc (sizeof (struct element));
    elem->param1 = (short) atoi (XmTextGetString 
				 (PRO_gray_scale_morpho_widget->line));
    elem->param2 = (short) atoi (XmTextGetString 
				 (PRO_gray_scale_morpho_widget->colon));
    elem->type = 1;

    XDefineCursor(gDisplay, XtWindow(gLabowidget), gWatchcursor);
    XDefineCursor(gDisplay, XtWindow(XtParent (XtParent (options_OK))), 
		  gWatchcursor);
    XFlush(gDisplay);

    sprintf (type, panel_titres[81]);
    proc_choix_elem(type, elem);

    XUndefineCursor(gDisplay, XtWindow(gLabowidget));
    XUndefineCursor(gDisplay, XtWindow(XtParent (XtParent (options_OK))));
    XtUnmanageChild (PRO_gray_scale_morpho_widget->GenerParamparent);
}


void 
PRE_PRO_ero_cylinder_OK_callb(options_OK, PRO_gray_scale_morpho_widget, callData)
	Widget options_OK;
	xs_struc_paramprepro * PRO_gray_scale_morpho_widget;
	caddr_t callData;
{
    struct element *elem;
    char type[30];

    elem = (struct element *) malloc (sizeof (struct element));
    elem->param1 = (short) atoi (XmTextGetString 
				 (PRO_gray_scale_morpho_widget->line));
    elem->param2 = (short) atoi (XmTextGetString 
				 (PRO_gray_scale_morpho_widget->colon));
    elem->type = 2;

    XDefineCursor(gDisplay, XtWindow(gLabowidget), gWatchcursor);
    XDefineCursor(gDisplay, XtWindow(XtParent (XtParent (options_OK))), 
		  gWatchcursor);
    XFlush(gDisplay);

    sprintf (type, panel_titres[82]);
    proc_choix_elem(type, elem);

    XUndefineCursor(gDisplay, XtWindow(gLabowidget));
    XUndefineCursor(gDisplay, XtWindow(XtParent (XtParent (options_OK))));
    XtUnmanageChild (PRO_gray_scale_morpho_widget->GenerParamparent);
}


void 
PRE_PRO_ero_gauss_OK_callb(options_OK, PRO_gray_scale_morpho_widget, callData)
	Widget options_OK;
	xs_struc_paramprepro * PRO_gray_scale_morpho_widget;
	caddr_t callData;
{
    struct element *elem;
    char type[30];

    elem = (struct element *) malloc (sizeof (struct element));
    elem->param3 = (float)atof (XmTextGetString (PRO_gray_scale_morpho_widget->alpha));
    elem->param4 = (float)atof (XmTextGetString (PRO_gray_scale_morpho_widget->line));
    elem->param5 = (float)atof (XmTextGetString (PRO_gray_scale_morpho_widget->colon));
    elem->type = 3;

    XDefineCursor(gDisplay, XtWindow(gLabowidget), gWatchcursor);
    XDefineCursor(gDisplay, XtWindow(XtParent (XtParent (options_OK))), 
		  gWatchcursor);
    XFlush(gDisplay);

    sprintf (type, panel_titres[83]);
    proc_choix_elem(type, elem);

    XUndefineCursor(gDisplay, XtWindow(gLabowidget));
    XUndefineCursor(gDisplay, XtWindow(XtParent (XtParent (options_OK))));
    XtUnmanageChild (PRO_gray_scale_morpho_widget->GenerParamparent);
}


void 
PRE_PRO_ero_plan_OK_callb(options_OK, PRE_PRO_options_widget, callData)
	Widget options_OK;
	Widget PRE_PRO_options_widget;
	caddr_t callData;
{
    struct element *elem;
    char type[30];

    elem = (struct element *) malloc (sizeof (struct element));
    elem->param1 = index_image[0];

    elem->type = 10;

    XDefineCursor(gDisplay, XtWindow(gLabowidget), gWatchcursor);
    XDefineCursor(gDisplay, XtWindow(XtParent (XtParent (options_OK))), 
		  gWatchcursor);
    XFlush(gDisplay);

    sprintf (type, panel_titres[84]);
    proc_choix_elem(type, elem);

    XUndefineCursor(gDisplay, XtWindow(gLabowidget));
    XUndefineCursor(gDisplay, XtWindow(XtParent (XtParent (options_OK))));
    XtUnmanageChild (PRE_PRO_options_widget);
}


void 
PRE_PRO_dila_sphere_OK_callb(options_OK, PRO_gray_scale_morpho_widget, callData)
	Widget options_OK;
	xs_struc_paramprepro * PRO_gray_scale_morpho_widget;
	caddr_t callData;
{   
    struct element *elem;
    char type[30];

    elem = (struct element *) malloc (sizeof (struct element));
    elem->param1 = (short) atoi (XmTextGetString 
				 (PRO_gray_scale_morpho_widget->alpha));
    elem->type = 0;

    XDefineCursor(gDisplay, XtWindow(gLabowidget), gWatchcursor);
    XDefineCursor(gDisplay, XtWindow(XtParent (XtParent (options_OK))), 
		  gWatchcursor);
    XFlush(gDisplay);

    sprintf (type, panel_titres[85]);
    proc_choix_elem(type, elem);

    XUndefineCursor(gDisplay, XtWindow(gLabowidget));
    XUndefineCursor(gDisplay, XtWindow(XtParent (XtParent (options_OK))));
    XtUnmanageChild (PRO_gray_scale_morpho_widget->GenerParamparent);
}


void 
PRE_PRO_dila_cone_OK_callb(options_OK, PRO_gray_scale_morpho_widget, callData)
	Widget options_OK;
	xs_struc_paramprepro * PRO_gray_scale_morpho_widget;
	caddr_t callData;
{
    struct element *elem;
    char type[30];

    elem = (struct element *) malloc (sizeof (struct element));
    elem->param1 = (short) atoi (XmTextGetString
				 (PRO_gray_scale_morpho_widget->line));
    elem->param2 = (short) atoi (XmTextGetString 
				 (PRO_gray_scale_morpho_widget->colon));
    elem->type = 1;

    XDefineCursor(gDisplay, XtWindow(gLabowidget), gWatchcursor);
    XDefineCursor(gDisplay, XtWindow(XtParent (XtParent (options_OK))), 
		  gWatchcursor);
    XFlush(gDisplay);

    sprintf (type, panel_titres[86]);
    proc_choix_elem(type, elem);

    XUndefineCursor(gDisplay, XtWindow(gLabowidget));
    XUndefineCursor(gDisplay, XtWindow(XtParent (XtParent (options_OK))));
    XtUnmanageChild (PRO_gray_scale_morpho_widget->GenerParamparent);
}


void 
PRE_PRO_dila_cylinder_OK_callb(options_OK, PRO_gray_scale_morpho_widget, callData)
	Widget options_OK;
	xs_struc_paramprepro * PRO_gray_scale_morpho_widget;
	caddr_t callData;
{
    struct element *elem;
    char type[30];

    elem = (struct element *) malloc (sizeof (struct element));
    elem->param1 = (short) atoi (XmTextGetString 
				 (PRO_gray_scale_morpho_widget->line));
    elem->param2 = (short) atoi (XmTextGetString 	
				 (PRO_gray_scale_morpho_widget->colon));
    elem->type = 2;

    XDefineCursor(gDisplay, XtWindow(gLabowidget), gWatchcursor);
    XDefineCursor(gDisplay, XtWindow(XtParent (XtParent (options_OK))), 
		  gWatchcursor);
    XFlush(gDisplay);

    sprintf (type, panel_titres[87]);
    proc_choix_elem(type, elem);

    XUndefineCursor(gDisplay, XtWindow(gLabowidget));
    XUndefineCursor(gDisplay, XtWindow(XtParent (XtParent (options_OK))));
    XtUnmanageChild (PRO_gray_scale_morpho_widget->GenerParamparent);
}


void 
PRE_PRO_dila_gauss_OK_callb(options_OK, PRO_gray_scale_morpho_widget, callData)
	Widget options_OK;
	xs_struc_paramprepro * PRO_gray_scale_morpho_widget;
	caddr_t callData;
{
    struct element *elem;
    char type[30];

    elem = (struct element *) malloc (sizeof (struct element));
    elem->param3 = (float)atof (XmTextGetString (PRO_gray_scale_morpho_widget->alpha));
    elem->param4 = (float)atof (XmTextGetString (PRO_gray_scale_morpho_widget->line));
    elem->param5 = (float)atof (XmTextGetString (PRO_gray_scale_morpho_widget->colon));
    elem->type = 3;

    XDefineCursor(gDisplay, XtWindow(gLabowidget), gWatchcursor);
    XDefineCursor(gDisplay, XtWindow(XtParent (XtParent (options_OK))), 
		  gWatchcursor);
    XFlush(gDisplay);

    sprintf (type, panel_titres[88]);
    proc_choix_elem(type, elem);

    XUndefineCursor(gDisplay, XtWindow(gLabowidget));
    XUndefineCursor(gDisplay, XtWindow(XtParent (XtParent (options_OK))));
    XtUnmanageChild (PRO_gray_scale_morpho_widget->GenerParamparent);
}


void 
PRE_PRO_dila_plan_OK_callb(options_OK, PRE_PRO_options_widget, callData)
	Widget options_OK;
	Widget PRE_PRO_options_widget;
	caddr_t callData;
{
    struct element *elem;
    char type[30];

    elem = (struct element *) malloc (sizeof (struct element));
    elem->param1 = index_image[0];

    elem->type = 10;

    XDefineCursor(gDisplay, XtWindow(gLabowidget), gWatchcursor);
    XDefineCursor(gDisplay, XtWindow(XtParent (XtParent (options_OK))), 
		  gWatchcursor);
    XFlush(gDisplay);

    sprintf (type, panel_titres[89]);
    proc_choix_elem(type, elem);

    XUndefineCursor(gDisplay, XtWindow(gLabowidget));
    XUndefineCursor(gDisplay, XtWindow(XtParent (XtParent (options_OK))));
    XtUnmanageChild (PRE_PRO_options_widget);
}


void 
PRE_PRO_open_sphere_OK_callb(options_OK, PRO_gray_scale_morpho_widget, callData)
	Widget options_OK;
	xs_struc_paramprepro * PRO_gray_scale_morpho_widget;
	caddr_t callData;
{
    struct element *elem;
    char type[30];

    elem = (struct element *) malloc (sizeof (struct element));
    elem->param1 = (short) atoi (XmTextGetString 
				 (PRO_gray_scale_morpho_widget->alpha));
    elem->type = 0;

    XDefineCursor(gDisplay, XtWindow(gLabowidget), gWatchcursor);
    XDefineCursor(gDisplay, XtWindow(XtParent (XtParent (options_OK))), 
		  gWatchcursor);
    XFlush(gDisplay);

    sprintf (type, panel_titres[90]);
    proc_choix_elem(type, elem);

    XUndefineCursor(gDisplay, XtWindow(gLabowidget));
    XUndefineCursor(gDisplay, XtWindow(XtParent (XtParent (options_OK))));
    XtUnmanageChild (PRO_gray_scale_morpho_widget->GenerParamparent);
}


void 
PRE_PRO_open_cone_OK_callb(options_OK, PRO_gray_scale_morpho_widget, callData)
	Widget options_OK;
	xs_struc_paramprepro * PRO_gray_scale_morpho_widget;
	caddr_t callData;
{
    struct element *elem;
    char type[30];

    elem = (struct element *) malloc (sizeof (struct element));
    elem->param1 = (short) atoi (XmTextGetString 
				 (PRO_gray_scale_morpho_widget->line));
    elem->param2 = (short) atoi (XmTextGetString 
				 (PRO_gray_scale_morpho_widget->colon));
    elem->type = 1;

    XDefineCursor(gDisplay, XtWindow(gLabowidget), gWatchcursor);
    XDefineCursor(gDisplay, XtWindow(XtParent (XtParent (options_OK))), 
		  gWatchcursor);
    XFlush(gDisplay);

    sprintf (type, panel_titres[91]);
    proc_choix_elem(type, elem);

    XUndefineCursor(gDisplay, XtWindow(gLabowidget));
    XUndefineCursor(gDisplay, XtWindow(XtParent (XtParent (options_OK))));
    XtUnmanageChild (PRO_gray_scale_morpho_widget->GenerParamparent);
}


void 
PRE_PRO_open_cylinder_OK_callb(options_OK, PRO_gray_scale_morpho_widget, callData)
	Widget options_OK;
	xs_struc_paramprepro * PRO_gray_scale_morpho_widget;
	caddr_t callData;
{
    struct element *elem;
    char type[30];

    elem = (struct element *) malloc (sizeof (struct element));
    elem->param1 = (short) atoi (XmTextGetString 
				 (PRO_gray_scale_morpho_widget->line));
    elem->param2 = (short) atoi (XmTextGetString 
				 (PRO_gray_scale_morpho_widget->colon));
    elem->type = 2;

    XDefineCursor(gDisplay, XtWindow(gLabowidget), gWatchcursor);
    XDefineCursor(gDisplay, XtWindow(XtParent (XtParent (options_OK))), 
		  gWatchcursor);
    XFlush(gDisplay);

    sprintf (type, panel_titres[92]);
    proc_choix_elem(type, elem);

    XUndefineCursor(gDisplay, XtWindow(gLabowidget));
    XUndefineCursor(gDisplay, XtWindow(XtParent (XtParent (options_OK))));
    XtUnmanageChild (PRO_gray_scale_morpho_widget->GenerParamparent);
}


void 
PRE_PRO_open_gauss_OK_callb(options_OK, PRO_gray_scale_morpho_widget, callData)
	Widget options_OK;
	xs_struc_paramprepro * PRO_gray_scale_morpho_widget;
	caddr_t callData;
{
    struct element *elem;
    char type[30];

    elem = (struct element *) malloc (sizeof (struct element));
    elem->param3 = (float)atof (XmTextGetString (PRO_gray_scale_morpho_widget->alpha));
    elem->param4 = (float)atof (XmTextGetString (PRO_gray_scale_morpho_widget->line));
    elem->param5 = (float)atof (XmTextGetString (PRO_gray_scale_morpho_widget->colon));
    elem->type = 3;

    XDefineCursor(gDisplay, XtWindow(gLabowidget), gWatchcursor);
    XDefineCursor(gDisplay, XtWindow(XtParent (XtParent (options_OK))), 
		  gWatchcursor);
    XFlush(gDisplay);

    sprintf (type, panel_titres[93]);
    proc_choix_elem(type, elem);

    XUndefineCursor(gDisplay, XtWindow(gLabowidget));
    XUndefineCursor(gDisplay, XtWindow(XtParent (XtParent (options_OK))));
    XtUnmanageChild (PRO_gray_scale_morpho_widget->GenerParamparent);
}


void 
PRE_PRO_open_plan_OK_callb(options_OK, PRE_PRO_options_widget, callData)
	Widget options_OK;
	Widget PRE_PRO_options_widget;
	caddr_t callData;
{
    struct element *elem;
    char type[30];

    elem = (struct element *) malloc (sizeof (struct element));
    elem->param1 = index_image[0];

    elem->type = 10;

    XDefineCursor(gDisplay, XtWindow(gLabowidget), gWatchcursor);
    XDefineCursor(gDisplay, XtWindow(XtParent (XtParent (options_OK))), 
		  gWatchcursor);
    XFlush(gDisplay);

    sprintf (type, panel_titres[94]);
    proc_choix_elem(type, elem);

    XUndefineCursor(gDisplay, XtWindow(gLabowidget));
    XUndefineCursor(gDisplay, XtWindow(XtParent (XtParent (options_OK))));
    XtUnmanageChild (PRE_PRO_options_widget);
}


void 
PRE_PRO_clos_sphere_OK_callb(options_OK, PRO_gray_scale_morpho_widget, callData)
	Widget options_OK;
	xs_struc_paramprepro * PRO_gray_scale_morpho_widget;
	caddr_t callData;
{
    struct element *elem;
    char type[30];

    XDefineCursor(gDisplay, XtWindow(gLabowidget), gWatchcursor);
    XDefineCursor(gDisplay, XtWindow(XtParent (XtParent (options_OK))), 
		  gWatchcursor);
    XFlush(gDisplay);

    elem = (struct element *) malloc (sizeof (struct element));
    elem->param1 = (short) atoi (XmTextGetString 
				 (PRO_gray_scale_morpho_widget->alpha));
    elem->type = 0;
    sprintf (type, panel_titres[95]);
    proc_choix_elem(type, elem);

    XUndefineCursor(gDisplay, XtWindow(gLabowidget));
    XUndefineCursor(gDisplay, XtWindow(XtParent (XtParent (options_OK))));
    XtUnmanageChild (PRO_gray_scale_morpho_widget->GenerParamparent);
}


void 
PRE_PRO_clos_cone_OK_callb(options_OK, PRO_gray_scale_morpho_widget, callData)
	Widget options_OK;
	xs_struc_paramprepro * PRO_gray_scale_morpho_widget;
	caddr_t callData;
{
    struct element *elem;
    char type[30];

    XDefineCursor(gDisplay, XtWindow(gLabowidget), gWatchcursor);
    XDefineCursor(gDisplay, XtWindow(XtParent (XtParent (options_OK))), 
		  gWatchcursor);
    XFlush(gDisplay);

    elem = (struct element *) malloc (sizeof (struct element));
    elem->param1 = (short) atoi (XmTextGetString 
				 (PRO_gray_scale_morpho_widget->line));
    elem->param2 = (short) atoi (XmTextGetString 
				 (PRO_gray_scale_morpho_widget->colon));
    elem->type = 1;
    sprintf (type, panel_titres[96]);
    proc_choix_elem(type, elem);

    XUndefineCursor(gDisplay, XtWindow(gLabowidget));
    XUndefineCursor(gDisplay, XtWindow(XtParent (XtParent (options_OK))));
    XtUnmanageChild (PRO_gray_scale_morpho_widget->GenerParamparent);
}


void 
PRE_PRO_clos_cylinder_OK_callb(options_OK, PRO_gray_scale_morpho_widget, callData)
	Widget options_OK;
	xs_struc_paramprepro * PRO_gray_scale_morpho_widget;
	caddr_t callData;
{
    struct element *elem;
    char type[30];

    XDefineCursor(gDisplay, XtWindow(gLabowidget), gWatchcursor);
    XDefineCursor(gDisplay, XtWindow(XtParent (XtParent (options_OK))), 
		  gWatchcursor);
    XFlush(gDisplay);

    elem = (struct element *) malloc (sizeof (struct element));
    elem->param1 = (short) atoi (XmTextGetString 
				 (PRO_gray_scale_morpho_widget->line));
    elem->param2 = (short) atoi (XmTextGetString 
				 (PRO_gray_scale_morpho_widget->colon));
    elem->type = 2;
    sprintf (type, panel_titres[97]);
    proc_choix_elem(type, elem);

    XUndefineCursor(gDisplay, XtWindow(gLabowidget));
    XUndefineCursor(gDisplay, XtWindow(XtParent (XtParent (options_OK))));
    XtUnmanageChild (PRO_gray_scale_morpho_widget->GenerParamparent);
}


void
PRE_PRO_clos_gauss_OK_callb(options_OK, PRO_gray_scale_morpho_widget, callData)
	Widget options_OK;
	xs_struc_paramprepro * PRO_gray_scale_morpho_widget;
	caddr_t callData;
{
    struct element *elem;
    char type[30];

    XDefineCursor(gDisplay, XtWindow(gLabowidget), gWatchcursor);
    XDefineCursor(gDisplay, XtWindow(XtParent (XtParent (options_OK))), 
		  gWatchcursor);
    XFlush(gDisplay);

    elem = (struct element *) malloc (sizeof (struct element));
    elem->param3 = (float)atof (XmTextGetString (PRO_gray_scale_morpho_widget->alpha));
    elem->param4 = (float)atof (XmTextGetString (PRO_gray_scale_morpho_widget->line));
    elem->param5 = (float)atof (XmTextGetString (PRO_gray_scale_morpho_widget->colon));
    elem->type = 3;
    sprintf (type, panel_titres[98]);
    proc_choix_elem(type, elem);

    XUndefineCursor(gDisplay, XtWindow(gLabowidget));
    XUndefineCursor(gDisplay, XtWindow(XtParent (XtParent (options_OK))));
    XtUnmanageChild (PRO_gray_scale_morpho_widget->GenerParamparent);
}


void 
PRE_PRO_clos_plan_OK_callb(options_OK, PRE_PRO_options_widget, callData)
	Widget options_OK;
	Widget PRE_PRO_options_widget;
	caddr_t callData;
{
    struct element *elem;
    char type[30];

    XDefineCursor(gDisplay, XtWindow(gLabowidget), gWatchcursor);
    XDefineCursor(gDisplay, XtWindow(XtParent (XtParent (options_OK))), 
		  gWatchcursor);
    XFlush(gDisplay);

    elem = (struct element *) malloc (sizeof (struct element));
    elem->param1 = index_image[0];
    
    elem->type = 10;
    sprintf (type, panel_titres[99]);
    proc_choix_elem(type, elem);

    XUndefineCursor(gDisplay, XtWindow(gLabowidget));
    XUndefineCursor(gDisplay, XtWindow(XtParent (XtParent (options_OK))));
    XtUnmanageChild (PRE_PRO_options_widget);
}



/********************************************************/
/* anciennement proc_histo 				*/
/********************************************************/

void 
MEAS_hist_OK_callb(options_OK, MEAS_histogramme, callData)
	Widget options_OK;
	xs_struc_paramprepro * MEAS_histogramme;
	caddr_t callData;
{
    unsigned char *imageIn;
    int *vecteurOut;
    int type, colonne, ligne;
    struct description_vecteur *histo;
    struct histogr *histogra;
    struct fname *fn;
    char * filedes;
    int mode;
    
    XDefineCursor(gDisplay, XtWindow(gLabowidget), gWatchcursor);
    XDefineCursor(gDisplay, XtWindow(XtParent (XtParent (options_OK))), 
		  gWatchcursor);
    XFlush(gDisplay);

    mode = MEAS_histogramme->type_operation;

    switch (mode){
    case 0: /*calculer*/
      {
	int ncase, b_min, b_max;

	ncase = atoi (XmTextGetString (MEAS_histogramme->alpha));
	b_min = atoi (XmTextGetString (MEAS_histogramme->line));
	b_max = atoi (XmTextGetString (MEAS_histogramme->colon));

	sprintf (buf, mastertabs[91]);
	write_master (buf);
	sprintf (buf, mastertabs[92], index_image[0], index_vect[1]);
	write_master (buf);
	sprintf (buf, "(%d %d %d)\n", b_min, b_max, ncase);
	write_master(buf);

	if (dir_image[index_image[0]].image == NULL){
	  write_erreur(1);
	  XUndefineCursor(gDisplay, XtWindow(gLabowidget));
	  XUndefineCursor(gDisplay, 
			  XtWindow(XtParent (XtParent (options_OK))));
	  return;
	}

	histogra = (struct histogr *) malloc (sizeof (*histogra));
	histo = (struct description_vecteur *) malloc 
	  (sizeof (struct description_vecteur));
	histo->prive = (char *) histogra;
	histo->ncase = ncase;
	if (histo->ncase <= 0) 
	  histo->ncase = (int)(rint(dir_desc[index_image[0]].mmax)
			       -rint(dir_desc[index_image[0]].mmin)+1);
	histo->b_min = b_min;
	if (histo->b_min <= 0)
	  histo->b_min = (int)rint(dir_desc[index_image[0]].mmin);
	histo->b_max = b_max;
	if (histo->b_max <= 0)
	  histo->b_max = (int)rint(dir_desc[index_image[0]].mmax);
	histo->type = 2;
	histo->genre = 0;

	ligne = dir_desc[index_image[0]].nligne;
	colonne = dir_desc[index_image[0]].ncolonne;
	type = dir_desc[index_image[0]].type;
	    
	imageIn = dir_image[index_image[0]].image;

	/******* TRAITEMENT ********/
	calcul_histo (imageIn, type, colonne, ligne, &vecteurOut, histo);
	/***************************/

	if (dir_vecteur[index_vect[1]].image != NULL) 
	  free (dir_vecteur[index_vect[1]].image);
	dir_vecteur[index_vect[1]].image = (unsigned char *)vecteurOut;
	dir_desc_vect[index_vect[1]] = *histo;

	XUndefineCursor(gDisplay, XtWindow(gLabowidget));
	XUndefineCursor(gDisplay, XtWindow(XtParent (XtParent (options_OK))));
	XtUnmanageChild (XtParent (XtParent (options_OK)));  

	break;
      }
    case 1: /*afficher*/
      {
	int larg_barre, haut_barre;

	larg_barre = atoi (XmTextGetString (MEAS_histogramme->colon));
	haut_barre = atoi (XmTextGetString (MEAS_histogramme->line));

	sprintf (buf, mastertabs[93]);
	write_master (buf);
	sprintf (buf, mastertabs[94], index_vect[0]);
	write_master (buf);
	sprintf (buf, "(%d %d)\n", larg_barre, haut_barre);
	write_master(buf);

	if (dir_vecteur[index_vect[0]].image == NULL){
	  write_erreur(21);
	  XUndefineCursor(gDisplay, XtWindow(gLabowidget));
	  XUndefineCursor(gDisplay, 
			  XtWindow(XtParent (XtParent (options_OK))));
	  return;
	}

	histo = (struct description_vecteur *) malloc 
	  (sizeof (struct description_vecteur));
	*histo = dir_desc_vect[index_vect[0]];
	histogra = (struct histogr *)histo->prive;
	
	histogra->larg_barre = larg_barre;
	if (histogra->larg_barre <= 0) 
	  histogra->larg_barre = (int)rint(dir_desc[index_image[0]].mmax);

	histogra->haut_barre = haut_barre;
	if (histogra->haut_barre <= 0) 
	  histogra->haut_barre = (int)rint(dir_desc[index_image[0]].mmin);

	dir_desc_vect[index_vect[0]].prive = histo->prive;

	/******* TRAITEMENT ********/
	affiche_histo(index_vect[0],&dir_desc_vect[index_vect[0]]);
	/***************************/

	free(histo);

	XUndefineCursor(gDisplay, XtWindow(gLabowidget));
	XUndefineCursor(gDisplay, XtWindow(XtParent (XtParent (options_OK))));
	XtUnmanageChild (XtParent (XtParent (options_OK)));  
	
	break;
      }
    case 2: /*imprimer*/
      {
	int larg_barre, haut_barre;

	larg_barre = atoi (XmTextGetString (MEAS_histogramme->colon));
	haut_barre = atoi (XmTextGetString (MEAS_histogramme->line));

	if (filedes != NULL) free (filedes);

	filedes = XmTextGetString (XmFileSelectionBoxGetChild 
			 (MEAS_histogramme->Generparent, XmDIALOG_TEXT));

	sprintf (buf, mastertabs[95]);
	write_master (buf);
	sprintf (buf, mastertabs[94], index_vect[0]);
	write_master (buf);
	sprintf (buf, "(%d %d) : %s\n", larg_barre, haut_barre, filedes);
	write_master (buf);

	if (strlen (filedes) == 0) 
	{
	  write_erreur(20);
	  XUndefineCursor(gDisplay, XtWindow(gLabowidget));
	  XUndefineCursor(gDisplay, 
			      XtWindow(XtParent (XtParent (options_OK))));
	  free(filedes);
	  return;
	}

	else Ote_ima_des(&filedes);

	if (dir_vecteur[index_vect[0]].image == NULL){
	  write_erreur(21);
	  XUndefineCursor(gDisplay, XtWindow(gLabowidget));
	  XUndefineCursor(gDisplay, 
			  XtWindow(XtParent (XtParent (options_OK))));
	  free(filedes);
	  return;
	}

	histo = (struct description_vecteur *) malloc 
	                (sizeof (struct description_vecteur));
	*histo = dir_desc_vect[index_vect[0]];
	histogra = (struct histogr *)histo->prive;	
	histogra->larg_barre = larg_barre;
	histogra->haut_barre = haut_barre;

	dir_desc_vect[index_vect[0]].prive = histo->prive;

	fn = lire_fname (filedes, 21);

	imageIn = dir_vecteur[index_vect[0]].image;

	/******* TRAITEMENT ********/
	imprimer_histo(imageIn, &dir_desc_vect[index_vect[0]], fn);
	/***************************/

	free(histo);

	XUndefineCursor(gDisplay, XtWindow(gLabowidget));
	XUndefineCursor(gDisplay, XtWindow(XtParent (XtParent (XtParent (options_OK)))));
	XtUnmanageChild (XtParent (XtParent (XtParent (options_OK))));  

	break;
      }
    }
}



/********************************************************/
/* anciennement proc_calc_stat 				*/
/********************************************************/

void 
MEAS_ima_sta_OK_callb(options_OK, PRE_PRO_options_widget, callData)
	Widget options_OK;
	Widget PRE_PRO_options_widget;
	caddr_t callData;
{
    sprintf (buf, mastertabs[5]);
    write_master(buf);
    sprintf (buf, " -->%d\n", index_image[0]);
    write_master (buf);

    if (dir_image[index_image[0]].image == NULL){
      write_erreur(1);
      return;
    }

    XDefineCursor(gDisplay, XtWindow(gLabowidget), gWatchcursor);
    XDefineCursor(gDisplay, XtWindow(XtParent (XtParent (options_OK))), 
		  gWatchcursor);
    XFlush(gDisplay);

    statis (dir_image[index_image[0]].image,
	    dir_desc[index_image[0]].type, 
	    dir_desc[index_image[0]].nligne,
	    dir_desc[index_image[0]].ncolonne,
	    &(dir_desc[index_image[0]].mmin),
	    &(dir_desc[index_image[0]].mmax), 
	    &(dir_desc[index_image[0]].mu),
	    &(dir_desc[index_image[0]].ecart));

    XUndefineCursor(gDisplay, XtWindow(gLabowidget));
    XUndefineCursor(gDisplay, XtWindow(XtParent (XtParent (options_OK))));
    XtUnmanageChild (PRE_PRO_options_widget);
}



/********************************************************/
/* anciennement proc_remplir_c 				*/
/********************************************************/

void 
MEAS_ima_col_OK_callb(options_OK, num_option, callData)
	Widget 	options_OK;
	int 	num_option;
	caddr_t callData;
{
    int ligne, colonne, current_color, result;
    unsigned char *imageIn, *imageOut;
    
    switch (num_option)
    {
    case 1:
      sprintf(buf,mastertabs[113]); 
      write_master(buf);
      break;
    case 3:
      sprintf(buf, mastertabs[114]);
      write_master(buf);
      break;
    case 2:
      sprintf(buf, mastertabs[115]);
      write_master(buf);
      break;
    case 4:
      sprintf(buf, mastertabs[116]);
      write_master(buf);
      break;
    }
    sprintf(buf, "%d --> %d ", index_image[0], index_image[1]);
    write_master(buf);

    if (dir_image[index_image[0]].image == NULL){
      write_erreur(1);
      XtUnmanageChild (XtParent (XtParent (options_OK))); 
      return;
    }

    if (dir_desc[index_image[0]].type != -1)
    {
      write_erreur(17);
      XtUnmanageChild (XtParent (XtParent (options_OK)));  
      return;
    }

    XDefineCursor(gDisplay, XtWindow(gLabowidget), gWatchcursor);
    XDefineCursor(gDisplay, XtWindow(XtParent (XtParent (options_OK))), 
		  gWatchcursor);
    XFlush(gDisplay);

    dir_desc[index_image[1]] = dir_desc[index_image[0]];
    dir_desc[index_image[1]].type = 1;

    ligne = dir_desc[index_image[0]].nligne;
    colonne = dir_desc[index_image[0]].ncolonne;

    imageIn = dir_image[index_image[0]].image;
    
    /******* TRAITEMENT ********/
    result =  make_count(imageIn, &imageOut, index_image[1], ligne, colonne, 
			 num_option, &current_color);
    /***************************/

    if (result == -1)
    {
	write_erreur(900);
	XUndefineCursor(gDisplay, XtWindow(gLabowidget));
	XUndefineCursor(gDisplay, 
			XtWindow(XtParent (XtParent (options_OK))));
        XtUnmanageChild (XtParent (XtParent (options_OK)));  
	return;
    }      
    if (result != 0) 
    {
      XUndefineCursor(gDisplay, XtWindow(gLabowidget));
      XUndefineCursor(gDisplay, 
			XtWindow(XtParent (XtParent (options_OK))));
      XtUnmanageChild (XtParent (XtParent (options_OK)));  
      return;
    }
    
    sprintf(buf,mastertabs[117], current_color);
    write_master(buf);

    if (dir_image[index_image[1]].image != NULL)
       free(dir_image[index_image[1]].image);
    dir_image[index_image[1]].image = (unsigned char *)imageOut;

    statis(dir_image[index_image[1]].image,
	   dir_desc[index_image[1]].type,
	   dir_desc[index_image[1]].nligne,
	   dir_desc[index_image[1]].ncolonne,
	   &(dir_desc[index_image[1]].mmin),
	   &(dir_desc[index_image[1]].mmax),
	   &(dir_desc[index_image[1]].mu),
	   &(dir_desc[index_image[1]].ecart));

    XUndefineCursor(gDisplay, XtWindow(gLabowidget));
    XUndefineCursor(gDisplay, XtWindow(XtParent (XtParent (options_OK))));
    XtUnmanageChild (XtParent (XtParent (options_OK)));  
}



/********************************************************/
/* anciennement proc_write_N 				*/
/********************************************************/

void 
MEAS_ima_save_OK_callb(options_OK, MEAS_histogramme, callData)
    Widget options_OK;
    xs_struc_paramprepro * MEAS_histogramme;
    caddr_t callData;
{
    int taille;
    unsigned short *Adr;
    struct count_s *params;

    sprintf(buf, "Image %d", index_image[0]);
    write_master(buf);

    params = (struct count_s *) malloc (sizeof (*params));
    params->SMin = atoi (XmTextGetString (MEAS_histogramme->diameter));
    params->XEt = atoi (XmTextGetString (MEAS_histogramme->colon));
    params->YEt = atoi (XmTextGetString (MEAS_histogramme->line));
    params->SEt = atoi (XmTextGetString (MEAS_histogramme->alpha));

    strcpy (params->FN_Res, XmTextGetString (XmFileSelectionBoxGetChild 
		       (MEAS_histogramme->Generparent, XmDIALOG_TEXT)));
	    
    sprintf(buf, mastertabs[112],
	    params->FN_Res,params->XEt, params->YEt, 
	    params->SEt, params->SMin);
    write_master(buf);

    if (dir_image[index_image[0]].image == NULL){
      write_erreur(1);
      return;
    }

    if (strlen (params->FN_Res) == 0) 
    {
      write_erreur(20);
      return;
    }

    Adr = (unsigned short *) dir_image[index_image[0]].image;

    if (Histogramme[index_image[0]] == NULL)
    {
      write_erreur(930);
      XtUnmanageChild (XtParent (XtParent (XtParent (options_OK))));  
      return;
    }
    taille = dir_desc[index_image[0]].ncolonne *
             dir_desc[index_image[0]].nligne;
    if ((*(Adr + taille - 2) != 11) &&
	(*(Adr + taille - 1) != 22))
    {
      write_erreur(930);
      free(Histogramme[index_image[0]]);
      Histogramme[index_image[0]] = NULL;
      XtUnmanageChild (XtParent (XtParent (XtParent (options_OK))));  
      return;
    }

    XDefineCursor(gDisplay, XtWindow(gLabowidget), gWatchcursor);
    XDefineCursor(gDisplay, XtWindow(XtParent (XtParent (options_OK))), 
		  gWatchcursor);
    XFlush(gDisplay);


    /******* TRAITEMENT ********/
    write_res_count(index_image[0], dir_desc[index_image[0]].ncolonne, 
		    dir_desc[index_image[0]].nligne, params);
    /***************************/

    free(params);
    XUndefineCursor(gDisplay, XtWindow(gLabowidget));
    XUndefineCursor(gDisplay, XtWindow(XtParent (XtParent (options_OK))));
    XtUnmanageChild (XtParent (XtParent (XtParent (options_OK))));  
}



/********************************************************/
/* anciennement proc_puissance 				*/
/********************************************************/

void
MEAS_pow_cal_OK_callb(options_OK, MEAS_param, callData)
	Widget options_OK;
	xs_struc_paramprepro * MEAS_param;
	caddr_t callData;
{
    struct rayon_puissan *r_p;
    float angle, pi, *cosine, *sine, p, step;
    int i, j, side, k, n, size_file, size_table, r;
    int lup, ldn, clft, crgt;
    float  **tab, *bp, sum, sum1;
    float *im;

    r_p = (struct rayon_puissan *) malloc (sizeof (struct rayon_puissan));
    r_p->p_energy = (float)atof (XmTextGetString (MEAS_param->alpha));

    sprintf (buf, mastertabs[292]);
    write_master (buf);
    sprintf (buf, "--> %d ", index_image[0]);
    write_master (buf);
    sprintf (buf, "(%.4f)\n", r_p->p_energy);
    write_master(buf);

    if (r_p->p_energy <= 0 || r_p->p_energy >= 1) {
      write_erreur(95);
      free(r_p);
      XtUnmanageChild (XtParent (XtParent (options_OK)));
      return;
    }

    if (dir_desc[index_image[0]].nligne != dir_desc[index_image[0]].ncolonne){
      write_erreur(19);
      free(r_p);
      XtUnmanageChild (XtParent (XtParent (options_OK)));
      return;
    }
	    
    if (power_2(dir_desc[index_image[0]].nligne) == FALSE){
      write_erreur(15);
      free(r_p);
      XtUnmanageChild (XtParent (XtParent (options_OK)));
      return;
    }

    if (dir_image[index_image[0]].image == NULL){
      write_erreur(1);
      free(r_p);
      XtUnmanageChild (XtParent (XtParent (options_OK)));
      return;
    }

    if (dir_desc[index_image[0]].type == 3){
      im = (float *)dir_image[index_image[0]].image;
      flag_conv = FALSE;
    }
    else
      {
        im = (float *)conv_float(dir_image[index_image[0]].image,
				  dir_desc[index_image[0]].type,
				  dir_desc[index_image[0]].nligne,
				  dir_desc[index_image[0]].ncolonne);
        flag_conv = TRUE;
      }

    XDefineCursor(gDisplay, XtWindow(gLabowidget), gWatchcursor);
    XDefineCursor(gDisplay, XtWindow(XtParent (XtParent (options_OK))), 
		  gWatchcursor);
    XFlush(gDisplay);

    p = r_p->p_energy;
    pi = PI;
    side = (int)dir_desc[index_image[0]].nligne;
    step = (float)1 / side;   /* angle step for sine & cosine table */
    size_table = (int)(pi / 2/ step) + 1; 
    cosine = (float *)malloc(size_table * 4);
    sine = (float *)malloc(size_table * 4);
    angle = 0;
    n = 0;
    while (angle < pi / 2) {
      cosine[n] = (float)cos(angle);
      sine[n] = (float)sin(angle);
      angle = angle + step;
      n++;
    }			     /* create sine & cosine table */

    tab = (float **)calloc(side, sizeof(float *));
    for (i = 0; i < side ; i++)
      tab[i] = (float *)calloc(side, sizeof(float));
    sum = 0;
    bp = im;    
    for (i = 0; i < side; i++){
      for (j = 0; j < side; j++){
	tab[i][j] = (*bp) * (*bp);
	sum = sum + tab[i][j];
	bp++;
      }
    }		    /* calculate energy of the whole module*/

    sum1 = 0;
    for (j = 0; j < side; j++) {
      sum1 += tab[0][j];
      tab[0][j] = 0; 
    }
    r = side / 2;
    for (n = 0; n < size_table ; n++)
      {
	i = (int)(r * (float)sine[n]);
	j = (int)(r * (float)cosine[n]);
	crgt = side / 2 + j;
	clft = side / 2 - j;
	lup = side / 2 - i;
	ldn = side / 2 + i;
	if (ldn < side) {
	  if (crgt < side) {
	    for (k = crgt; k < side; k++) {
	      sum1 = sum1 + tab[ldn][k];
	      tab[ldn][k] = 0;
	    }
	  }				/* right, down */
	  for (k = clft; k >= 0; k--) {
	    sum1 = sum1 + tab[ldn][k];
	    tab[ldn][k] = 0; 
	  }				/* left, down  */
	}
	if (crgt < side) {
	  for (k = crgt; k < side; k++) {
	    sum1 = sum1 + tab[lup][k];
	    tab[lup][k] = 0;	/* right, up */
	  }
	}
        for (k = clft; k >= 0; k--) {
	  sum1 = sum1 + tab[lup][k];
	  tab[lup][k] = 0;		/* left, up  */
	}
      }
    if (sum1 >= sum - sum * p) goto found;
 
    for (r = side / 2 - 1; r > 0; r--) {
      for (n = 0; n < size_table ; n++){
	i = (int)(r * (float)sine[n]);
	j = (int)(r * (float)cosine[n]);
	crgt = side / 2 + j;
	clft = side / 2 - j;
	lup = side / 2 - i;
	ldn = side / 2 + i;
	if (ldn < side) {
	  if (crgt < side) {
	    for (k = crgt; k < side; k++) {
	      sum1 = sum1 + tab[ldn][k];
	      tab[ldn][k] = 0;
	    }
	  }			/* right, down */
	  for (k = clft; k >= 0; k--) {
	    sum1 = sum1 + tab[ldn][k];
	    tab[ldn][k] = 0; 
	  }			/* left, down  */
	}
	if (crgt < side) {
	  for (k = crgt; k < side; k++) {
	    sum1 = sum1 + tab[lup][k];
	    tab[lup][k] = 0;	
	  }			/* right, up */
	}
	for (k = clft; k >= 0; k--) {
	  sum1 = sum1 + tab[lup][k];
	  tab[lup][k] = 0;
	}				/* left, up  */
      }
      if (sum1 >= sum - sum * p) goto found;
    }
    found:  free(cosine);
	    free(sine);
	    for (i = 0; i < side + 1; i++)
		free(tab[i]);
	    free(tab);
    sprintf (buf,  mastertabs[293],r - 1);
    write_master (buf);
    if (flag_conv)
      {
	free (im);
	flag_conv = TRUE;
      }
    free(r_p);
    
    XUndefineCursor(gDisplay, XtWindow(gLabowidget));
    XUndefineCursor(gDisplay, XtWindow(XtParent (XtParent (options_OK))));
    XtUnmanageChild (XtParent (XtParent (options_OK)));
}



/********************************************************/
/* anciennement proc_cut_frequncy		        */
/********************************************************/

void
MEAS_cut_freq_OK_callb(options_OK, MEAS_param, callData)
	Widget options_OK;
	xs_struc_paramprepro * MEAS_param;
	caddr_t callData;
{
    struct rayon_puissan *r_p;
    float angle, pi, *cosine, *sine, step;
    int n, i, j, side, k, size_table, r2, r;
    int lup, ldn, clft, crgt;
    float *br, *bi, **tabr, **tabi, *brr, *bri;

    r_p = (struct rayon_puissan *) malloc (sizeof (struct rayon_puissan));
    r_p->r_frequency = (int) atoi (XmTextGetString (MEAS_param->alpha));

    sprintf (buf, mastertabs[294]);
    write_master (buf);

    sprintf (buf, "(%d,%d)-->(%d,%d)", index_image[0], 
		index_image[2], index_image[1], index_image[3]);
    write_master (buf);
    sprintf (buf,mastertabs[295], r_p->r_frequency);
    write_master(buf);

    if (dir_image[index_image[0]].image == NULL){
      write_erreur(9);
      free(r_p);
      XtUnmanageChild (XtParent (XtParent (options_OK)));
      return;
    }

    if (dir_image[index_image[2]].image == NULL){
      write_erreur(10);
      free(r_p);
      XtUnmanageChild (XtParent (XtParent (options_OK)));
      return;
    }

    if (r_p->r_frequency == 0)
    {
      write_erreur(105);
      free(r_p);
      XtUnmanageChild (XtParent (XtParent (options_OK))); 
      return;    
    }
    
    if (r_p->r_frequency > dir_desc[index_image[0]].nligne/2)
    {
      write_erreur(106);
      free(r_p);
      XtUnmanageChild (XtParent (XtParent (options_OK))); 
      return;    
    }

    if (dir_desc[index_image[0]].type !=3 
	|| dir_desc[index_image[2]].type !=3){
      write_erreur(14);
      free(r_p);
      XtUnmanageChild (XtParent (XtParent (options_OK))); 
      return;    
    }

    if  (dir_desc[index_image[0]].nligne != 
		dir_desc[index_image[2]].nligne
	    || dir_desc[index_image[0]].ncolonne != 
	       dir_desc[index_image[2]].ncolonne){
      write_erreur(2);
      free(r_p);
      XtUnmanageChild (XtParent (XtParent (options_OK))); 
      return;    
    }

    if (power_2(dir_desc[index_image[0]].nligne) == FALSE 
       || power_2(dir_desc[index_image[0]].ncolonne) == FALSE){
      write_erreur(15);
      free(r_p);
      XtUnmanageChild (XtParent (XtParent (options_OK))); 
      return;    
    }

    if (dir_desc[index_image[0]].nligne != 
		 dir_desc[index_image[0]].ncolonne){
      write_erreur(19);
      free(r_p);
      XtUnmanageChild (XtParent (XtParent (options_OK))); 
      return;    
    }

    XDefineCursor(gDisplay, XtWindow(gLabowidget), gWatchcursor);
    XDefineCursor(gDisplay, XtWindow(XtParent (XtParent (options_OK))), 
		  gWatchcursor);
    XFlush(gDisplay);

    r2 = r_p->r_frequency;
    side = (int)dir_desc[index_image[0]].nligne;

    pi = PI;
    step = (float)1 / side; 
    size_table = (int)(pi / 2 / step) + 1; 
    cosine = (float *)malloc(size_table * 4);
    sine = (float *)malloc(size_table * 4);
    angle = 0;
    n = 0;
    while (angle < pi / 2) {
      cosine[n] = (float)cos(angle);
      sine[n] = (float)sin(angle);
      angle = angle + step;
      n++;
    }		    /* create sine & cosine table */
	
    tabr = (float **)calloc(side, sizeof(float *));
    tabi = (float **)calloc(side, sizeof(float *));
    for (i = 0; i < side; i++){
      tabr[i] = (float *)calloc(side, sizeof(float));
      tabi[i] = (float *)calloc(side, sizeof(float));
    }
    br = (float *)dir_image[index_image[0]].image;
    bi = (float *)dir_image[index_image[2]].image;
    for (i = 0; i < side; i++)
      for (j = 0; j < side; j++) {
	tabr[i][j] = *br;
	tabi[i][j] = *bi;
	bi++; br++;
      }

    for (j = 0; j < side; j++) {
      tabr[0][j] = 0;
      tabi[0][j] = 0;
    }
    if (r2 <= side / 2) {
      for (r = side / 2; r > r2; r--) {
	for (n = 0; n < size_table ; n++) {
	  i = (int)(r * (float)sine[n]);
	  j = (int)(r * (float)cosine[n]);
	  crgt = side / 2 + j;
	  clft = side / 2 - j;
	  lup = side / 2 - i;
	  ldn = side / 2 + i;
	  if (ldn < side) {
	    if (crgt < side) {
	      for (k = crgt; k < side; k++) {
		tabr[ldn][k] = 0;
		tabi[ldn][k] = 0;
	      }
	    }			/* right, down */
	    for (k = clft; k >= 0; k--) {
	      tabr[ldn][k] = 0;
	      tabi[ldn][k] = 0;
	    }			/* left, down  */
	  }
	  if (crgt < side) {
	    for (k = crgt; k < side; k++) {
	      tabr[lup][k] = 0;	
	      tabi[lup][k] = 0;	
	    }			/* right, up */
	  }
	  for (k = clft; k >= 0; k--) {
	    tabr[lup][k] = 0;
	    tabi[lup][k] = 0;
	  }	/* left, up  */
	}
      }
    }
    brr = (float *)calloc(side * side, sizeof(float));
    bri = (float *)calloc(side * side, sizeof(float));

    dir_image[index_image[1]].image = (unsigned char *)brr;
    dir_image[index_image[3]].image = (unsigned char *)bri;
    for (i = 0; i < side; i++)
      for (j = 0; j < side; j++) {
	*brr = tabr[i][j];
	*bri = tabi[i][j];
	brr++; bri++;
      }

    free(sine); free(cosine);
    for (i = 0; i < side; i++) {
      free(tabr[i]);  free(tabi[i]);
    }
    free(tabr); free(tabi); 

    dir_desc[index_image[1]] = dir_desc[index_image[0]];
    dir_desc[index_image[3]] = dir_desc[index_image[2]];
    statis (dir_image[index_image[1]].image,
	    dir_desc[index_image[1]].type, 
	    dir_desc[index_image[1]].nligne,
	    dir_desc[index_image[1]].ncolonne,
	    &(dir_desc[index_image[1]].mmin),
	    &(dir_desc[index_image[1]].mmax), 
	    &(dir_desc[index_image[1]].mu),
	    &(dir_desc[index_image[1]].ecart));
    statis (dir_image[index_image[3]].image,
	    dir_desc[index_image[3]].type, 
	    dir_desc[index_image[3]].nligne,
	    dir_desc[index_image[3]].ncolonne,
	    &(dir_desc[index_image[3]].mmin),
	    &(dir_desc[index_image[3]].mmax), 
	    &(dir_desc[index_image[3]].mu),
	    &(dir_desc[index_image[3]].ecart));

    free(r_p);
    XUndefineCursor(gDisplay, XtWindow(gLabowidget));
    XUndefineCursor(gDisplay, XtWindow(XtParent (XtParent (options_OK))));
    XtUnmanageChild (XtParent (XtParent (options_OK)));
}




/********************* G E L *************************/


void
GEL_init_OK_callb(options_OK, GEL_param, callData)
	Widget options_OK;
	xs_struc_paramprepro * GEL_param;
	caddr_t callData;
{
    int *Parami;    

    XDefineCursor(gDisplay, XtWindow(gLabowidget), gWatchcursor);
    XDefineCursor(gDisplay, XtWindow(XtParent (XtParent (options_OK))), 
		  gWatchcursor);
    XFlush(gDisplay);

    Parami = (int *)malloc(sizeof(int *));
    *Parami = (int) atoi (XmTextGetString (GEL_param->alpha));
/*    proc_gel_init(40, Parami);  */
    proc_gel1d (40, Parami);

    XUndefineCursor(gDisplay, XtWindow(gLabowidget));
    XUndefineCursor(gDisplay, XtWindow(XtParent (XtParent (options_OK))));
    XtUnmanageChild (GEL_param->GenerParamparent);
}


void 
ROI_save_display_OK_callb(options_OK, PRE_PRO_options_widget, callData)
	Widget options_OK;
	Widget PRE_PRO_options_widget;
	caddr_t callData;
{
    XDefineCursor(gDisplay, XtWindow(gLabowidget), gWatchcursor);
    XDefineCursor(gDisplay, XtWindow(XtParent (XtParent (options_OK))), 
		  gWatchcursor);
    XFlush(gDisplay);

    sauver_image();

    XUndefineCursor(gDisplay, XtWindow(gLabowidget));
    XUndefineCursor(gDisplay, XtWindow(XtParent (XtParent (options_OK))));
    XtUnmanageChild (PRE_PRO_options_widget);
}


void 
ROI_lire_zone_OK_callb(options_OK, PRE_PRO_options_widget, callData)
	Widget options_OK;
	Widget PRE_PRO_options_widget;
	caddr_t callData;
{
    XDefineCursor(gDisplay, XtWindow(gLabowidget), gWatchcursor);
    XDefineCursor(gDisplay, XtWindow(XtParent (XtParent (options_OK))), 
		  gWatchcursor);
    XFlush(gDisplay);

    lire_zone(); 
 
    XUndefineCursor(gDisplay, XtWindow(gLabowidget));
    XUndefineCursor(gDisplay, XtWindow(XtParent (XtParent (options_OK))));
    XtUnmanageChild (PRE_PRO_options_widget);
}

void 
Reg_growing_OK_callb(options_OK, PRE_PRO_options_widget, callData)
	Widget options_OK;
	Widget PRE_PRO_options_widget;
	caddr_t callData;
{
    XDefineCursor(gDisplay, XtWindow(gLabowidget), gWatchcursor);
    XDefineCursor(gDisplay, XtWindow(XtParent (XtParent (options_OK))), 
		  gWatchcursor);
    XFlush(gDisplay);

    load_proc_growing();

    XUndefineCursor(gDisplay, XtWindow(gLabowidget));
    XUndefineCursor(gDisplay, XtWindow(XtParent (XtParent (options_OK))));
    XtUnmanageChild (PRE_PRO_options_widget);
}


void 
Reg_growing_save_contour_OK_callb(options_OK, PRE_PRO_options_widget, callData)
	Widget options_OK;
	Widget PRE_PRO_options_widget;
	caddr_t callData;
{
    XDefineCursor(gDisplay, XtWindow(gLabowidget), gWatchcursor);
    XDefineCursor(gDisplay, XtWindow(XtParent (XtParent (options_OK))), 
		  gWatchcursor);
    XFlush(gDisplay);

    store_c_proc();

    XUndefineCursor(gDisplay, XtWindow(gLabowidget));
    XUndefineCursor(gDisplay, XtWindow(XtParent (XtParent (options_OK))));
    XtUnmanageChild (PRE_PRO_options_widget);
}


void 
Reg_growing_save_region_OK_callb(options_OK, PRE_PRO_options_widget, callData)
	Widget options_OK;
	Widget PRE_PRO_options_widget;
	caddr_t callData;
{
    XDefineCursor(gDisplay, XtWindow(gLabowidget), gWatchcursor);
    XDefineCursor(gDisplay, XtWindow(XtParent (XtParent (options_OK))), 
		  gWatchcursor);
    XFlush(gDisplay);

    store_r_proc();

    XUndefineCursor(gDisplay, XtWindow(gLabowidget));
    XUndefineCursor(gDisplay, XtWindow(XtParent (XtParent (options_OK))));
    XtUnmanageChild (PRE_PRO_options_widget);
}

