/* SCCS @(#)preenhhpf.layout.c	1.1  12/2/92 */
/************************************************************************/
/************************************************************************/
/*                                                                      */
/*                      preenhhpf.layout.c                              */
/*                                                                      */
/************************************************************************/
/************************************************************************/
/*                                                                      */
/* FILENAME     :   preenhhpf.layout.c                                  */
/*                                                                      */
/* DESCRIPTION  :   Preprocessing enhancement (High pass filter)        */
/*                                                                      */
/* AUTHORS      :   Marianne Logean                                     */
/*                                                                      */
/* VERSION      :   1.0                                                 */
/*                                                                      */
/* HISTORY      :   1.12.92                                             */
/*                  MAL         Created    version: 1.0                 */
/*                                                                      */
/* Copyright  1992 by CUI/UIN/HCUG, All rights reserved.                */
/*                                                                      */
/************************************************************************/
/************************************************************************/

#include "widgetstructure.h"
#include "preenhhpf.layout.h"
#define MAX_ARGS 100

extern XmFontList gFontlist, gSmall_fontlist;

/********************************************************
/   Creation Function for PREPRO_high_pass_filter_param_widget 
/*******************************************************/

xs_struc_paramprepro 
* build_PREPRO_high_pass_filter_param_widget(PREPRO_high_pass_filter_param)
	Widget PREPRO_high_pass_filter_param;
{
	Widget PREPRO_high_pass_filter_param_widget;
	Widget coefficient_Label_2;
	Widget Coefficient_text;
	xs_struc_paramprepro *Paramprepro;
	Widget PREPRO_enhanc_high_pass_Label_3;
	Arg args[MAX_ARGS];
	int n;

	Paramprepro = 
	  (xs_struc_paramprepro *) malloc (sizeof (xs_struc_paramprepro));

	/* Creating PREPRO_high_pass_filter_param_widget Widget */ 

	n = 0;
	XtSetArg(args[n],XmNheight,113); n++;
	XtSetArg(args[n],XmNresizePolicy,XmRESIZE_NONE); n++;
	XtSetArg(args[n],XmNwidth,199); n++;
	XtSetArg(args[n],XmNx,1); n++;

	PREPRO_high_pass_filter_param_widget = 
	     XmCreateForm(PREPRO_high_pass_filter_param,
			  "PREPRO_high_pass_filter_param_widget",args,n);
	XtManageChild(PREPRO_high_pass_filter_param_widget);

	Paramprepro->parent = PREPRO_high_pass_filter_param_widget;

	/* Creating coefficient_Label_2 Widget */ 

	n = 0;
	XtSetArg(args[n],XmNalignment,XmALIGNMENT_BEGINNING); n++;
	XtSetArg(args[n],XmNfontList, gFontlist); n++;
	XtSetArg(args[n],XmNlabelString,
		XmStringLtoRCreate(paneltabs[483],
			XmSTRING_DEFAULT_CHARSET)); n++;
	XtSetArg(args[n],XmNleftAttachment,XmATTACH_POSITION); n++;
	XtSetArg(args[n],XmNleftPosition,10); n++;
	XtSetArg(args[n],XmNtopAttachment,XmATTACH_POSITION); n++;
	XtSetArg(args[n],XmNtopPosition,30); n++;

	coefficient_Label_2 = 
	       XmCreateLabel(PREPRO_high_pass_filter_param_widget,
			     "coefficient_Label_2",args,n);
	XtManageChild(coefficient_Label_2);

	/* Creating Coefficient_text Widget */ 

	n = 0;
	XtSetArg(args[n],XmNleftAttachment,XmATTACH_WIDGET); n++;
	XtSetArg(args[n],XmNleftWidget,coefficient_Label_2); n++;
	XtSetArg(args[n],XmNrightAttachment,XmATTACH_POSITION); n++;
	XtSetArg(args[n],XmNrightPosition,95); n++;
	XtSetArg(args[n],XmNtopAttachment,XmATTACH_POSITION); n++;
	XtSetArg(args[n],XmNtopPosition,30); n++;
	XtSetArg(args[n],XmNfontList, gSmall_fontlist); n++;
	XtSetArg(args[n],XmNvalue, "1"); n++;

	Coefficient_text = 
	          XmCreateText(PREPRO_high_pass_filter_param_widget,
			       "Coefficient_text",args,n);
	XtManageChild(Coefficient_text);

	Paramprepro->alpha = Coefficient_text;

	/* Creating PREPRO_enhanc_high_pass_Label_3 Widget */ 

	n = 0;
	XtSetArg(args[n],XmNfontList, gFontlist); n++;
	XtSetArg(args[n],XmNlabelString,
		XmStringLtoRCreate(paneltabs[491],
			XmSTRING_DEFAULT_CHARSET)); n++;

	PREPRO_enhanc_high_pass_Label_3 = 
	      XmCreateLabel(PREPRO_high_pass_filter_param_widget,
			    "PREPRO_enhanc_high_pass_Label_3",args,n);
	XtManageChild(PREPRO_enhanc_high_pass_Label_3);

	return(Paramprepro);
}
