/* SCCS @(#)oplogic4.c	1.1  12/2/92 */
/************************************************************************/
/************************************************************************/
/*                                                                      */
/*                      oplogic4.c                                      */
/*                                                                      */
/************************************************************************/
/************************************************************************/
/*                                                                      */
/* FILENAME     :   oplogic4.c                                          */
/*                                                                      */
/* DESCRIPTION  :   Logical operations                                  */
/*                                                                      */
/* AUTHORS      :   Marianne Logean                                     */
/*                                                                      */
/* VERSION      :   1.0                                                 */
/*                                                                      */
/* HISTORY      :   1.12.92                                             */
/*                  MAL         Created    version: 1.0                 */
/*                                                                      */
/* Copyright  1992 by CUI/UIN/HCUG, All rights reserved.                */
/*                                                                      */
/************************************************************************/
/************************************************************************/

#include <math.h>
#include "oplogic4.h"
#include "define.h"


int 
op_logic (mode, imageIn, type, colonne, ligne, masque, imageOut, colonnearr, lignearr)
    int mode, type, colonne, ligne, *colonnearr, *lignearr;
    unsigned char *imageIn, *masque;
    unsigned char **imageOut;
{
    unsigned char *resultat_inter, *resultat_u, *source_u, *cu, *ptr_u;
    short *source_s, *resultat_s, *ptr_s;
    int *source_i, *resultat_i, *ptr_i;
    float *source_f, *resultat_f, *ptr_f;
    int	    taille_im, taille_im_arr, taille_el;
    int	    xmin, xmax, ymin, ymax;		/* bounding box */
    int	    k, x, y;


    switch (mode){

      /* Operation AND entre une image source de n'importe quel type     */
      /* et une image masque de type -1 c'est a dire binarisee ( 0-255). */
      /* Elles doivent etre de la meme taille.                           */

    case AND:

      taille_im = ligne * colonne;
      taille_el = element(type); 
      *imageOut = (unsigned char*) malloc (taille_im * taille_el);
	    
      switch (type)
	{
	case -1:
	case  0:   
	  resultat_u = *imageOut; 
	  source_u = imageIn; 
	  cu = masque;   
	    
	  for (k = 0; k < taille_im ; k++)
	    {
	      if (*source_u && *cu)
		*resultat_u = *source_u;
	      else 
		*resultat_u = 0;
	      source_u++;
	      cu++;
	      resultat_u++;
	    }
	  break;

	case 1: 
	  resultat_s = (short *) *imageOut; 
	  source_s = (short *) imageIn; 
	  cu = masque;   
		    
	  for (k = 0; k < taille_im ; k++)
	    {
	      if (*source_s && *cu)
		*resultat_s = *source_s;
	      else 
		*resultat_s = 0;
	      source_s++;
	      cu++;
	      resultat_s++;
	    }
	  break;
	
	case 2: 
	  resultat_i = (int *) *imageOut;
	  source_i = (int *) imageIn;
	  cu = masque;   
		    
	  for (k = 0; k < taille_im ; k++)
	    {
	      if (*source_i && *cu)
		*resultat_i = *source_i;
	      else 
		*resultat_i = 0;
	      source_i++;
	      cu++;
	      resultat_i++;
	    }
	  break;

	case 3: 
	  resultat_f = (float *) *imageOut;
	  source_f = (float *) imageIn;
	  cu = masque;   
		    
	  for (k = 0; k < taille_im ; k++)
	    {
	      if (*source_f && *cu)
		*resultat_f = *source_f;
	      else 
		*resultat_f = 0;
	      source_f++;
	      cu++;
	      resultat_f++;
	    }
	  break;
	}
      break;

      /* Operation AND restreinte a la bounding box du masque sur une */
      /* image source de n'importe quel type et une image masque de   */
      /* type -1 c'est a dire binarisee (0-255)                       */
      /* Elles doivent etre de la meme taille			      */
    case AND_BOUNDED :

      xmin = colonne - 1;   /* Initialisation de la */  
      xmax = 0;	            /* bounding box	    */  
      ymin = ligne - 1;
      ymax = 0; 

      taille_im = ligne * colonne;
      taille_el = element(type);  
      resultat_inter = (unsigned char*) malloc (taille_im * taille_el);

      switch (type)
	{
	case -1:
	case  0:   
	  resultat_u = resultat_inter; 
	  source_u = imageIn; 
	  cu = masque;   
	    
	  for (y = 0; y < ligne ; y++)
	    for (x = 0; x < colonne ; x++)
	      {
		if (*cu == 255)		
		  {
		    if (x < xmin)  xmin = x;    /* Mise a jour de la */
		    if (x > xmax)  xmax = x;    /* bounding box	 */
		    if (y < ymin)  ymin = y;
		    if (y > ymax)  ymax = y;
		  }
		  
		if (*source_u && *cu)
		  *resultat_u = *source_u;
		else 
		  *resultat_u = 0;
		source_u++;
		cu++;
		resultat_u++;
	      }
	  /* Creation d'une image de la grandeur de la bouding box */
	  /* du masque	*/
	  *colonnearr = xmax - xmin + 1;
	  *lignearr = ymax - ymin + 1;

	  taille_im_arr = *lignearr * *colonnearr;
	  *imageOut = (unsigned char*) malloc (taille_im_arr * taille_el);
	  resultat_u = resultat_inter; 
	  ptr_u = *imageOut;
	  for (y = 0; y < ligne ; y++)
	    for (x = 0; x < colonne ; x++)
	      {		    
		if ((x >= xmin) && (x <= xmax) && (y >= ymin) && (y <= ymax))
		  {	/* Appartient a la bounding box */
		    *ptr_u = *resultat_u;
		    ptr_u++;
		  }
		resultat_u++;
	      }

	  break;

	case 1: 
	  resultat_s = (short *) resultat_inter;  
	  source_s = (short *) imageIn; 
	  cu = masque;  
	  
	  for (y = 0; y < ligne ; y++)
	    for (x = 0; x < colonne ; x++)
	    {
	      if (*cu)		
		{
		  if (x < xmin)  xmin = x;
		  if (x > xmax)  xmax = x;
		  if (y < ymin)  ymin = y;
		  if (y > ymax)  ymax = y;
		}
	      if (*source_s && *cu)
		*resultat_s = *source_s;
	      else 
		*resultat_s = 0;
	      source_s++;
	      cu++;
	      resultat_s++;
	    }
	  /* Creation d'une image de la grandeur de la bouding box du masque  */
	  
	  *colonnearr = xmax - xmin + 1;
	  *lignearr = ymax - ymin + 1;

	  taille_im_arr = *lignearr * *colonnearr;
	  *imageOut = (unsigned char*) malloc (taille_im_arr * taille_el);

	  ptr_u = *imageOut;
	  resultat_s = (short *) resultat_inter; 
	  ptr_s = (short *) *imageOut;
	  for (y = 0; y < ligne ; y++)
	    for (x = 0; x < colonne ; x++)
	      {		    
		if ((x >= xmin) && (x <= xmax) && (y >= ymin) && (y <= ymax))
		  {	/* Appartient a la bounding box */
		    *ptr_s = *resultat_s;
		    ptr_s++;
		  }
		resultat_s++;
	      }

	  break;
	
	case 2: 
	  resultat_i = (int *) resultat_inter; 
	  source_i = (int *) imageIn;
	  cu = masque;   
		
	  for (y = 0; y < ligne ; y++)
	    for (x = 0; x < colonne ; x++)
	      {
		if (*cu)		
		  {
		    if (x < xmin)  xmin = x;
		    if (x > xmax)  xmax = x;
		    if (y < ymin)  ymin = y;
		    if (y > ymax)  ymax = y;
		  }	    
		if (*source_i && *cu)
		  *resultat_i = *source_i;
		else 
		  *resultat_i = 0;
		  
		source_i++;
		cu++;
		resultat_i++;
	      }

	  /* Creation d'une image de la grandeur de la bouding box du masque */
	  *colonnearr = xmax - xmin + 1;
	  *lignearr = ymax - ymin + 1;
	  
	  taille_im_arr = *lignearr * *colonnearr;
	  *imageOut = (unsigned char*) malloc (taille_im_arr * taille_el);
	  resultat_i = (int *) resultat_inter; 
	  ptr_i = (int *) *imageOut;
	  for (y = 0; y < ligne ; y++)
	    for (x = 0; x < colonne ; x++)
	      {		    
		if ((x >= xmin) && (x <= xmax) && (y >= ymin) && (y <= ymax))
		  {	/* Appartient a la bounding box */
		    *ptr_i = *resultat_i;
		    ptr_i++;
		  }
		resultat_i++;
	      }
	  break;
	  
	case 3: 
	  resultat_f = (float *) resultat_inter; 
	  source_f = (float *) imageIn;
	  cu = masque; 
  
	  for (y = 0; y < ligne ; y++)
	    for (x = 0; x < colonne ; x++)
	      {
		if (*cu)		
		  {
		    if (x < xmin)  xmin = x;
		    if (x > xmax)  xmax = x;
		    if (y < ymin)  ymin = y;
		    if (y > ymax)  ymax = y;
		  }
		if (*source_f && *cu)
		  *resultat_f = *source_f;
		else 
		  *resultat_f = 0;
		source_f++;
		cu++;
		resultat_f++;
				}
	  /* Creation d'une image de la grandeur de la bouding box du masque */
	  *colonnearr = xmax - xmin + 1;
	  *lignearr = ymax - ymin + 1;

	  taille_im_arr = *lignearr * *colonnearr;
	  *imageOut = (unsigned char*)  malloc (taille_im_arr * taille_el);
	  resultat_f = (float *) resultat_inter; 
	  ptr_f = (float *) *imageOut;
	  for (y = 0; y < ligne ; y++)
	    for (x = 0; x < colonne ; x++)
	      {		    
		if ((x >= xmin) && (x <= xmax) && (y >= ymin) && (y <= ymax))
		  {	/* Appartient a la bounding box */
		    *ptr_f = *resultat_f;
		    ptr_f++;
		  }
		resultat_f++;
	      }
	  break;
	}
      break;

      /* Operation OR entre deux images de type masque.  */
      /* Elles doivent etre de la meme taille            */
	
    case OR : 
      taille_im = ligne * colonne;
      taille_el = element(type);  
      *imageOut = (unsigned char*) malloc (taille_im * taille_el);

      resultat_u = *imageOut; 
      source_u = imageIn; 
      cu = masque;   
	    
      for (k = 0; k < taille_im ; k++)
	{
	  if (!*source_u && !*cu )	/* Les deux sont a 0 */
	    *resultat_u = 0 ;
	  else
	    {
	      if (*source_u)
		*resultat_u = *source_u ;
	      if (*cu)
		*resultat_u = *cu ;
	    }
	  source_u++;
	  cu++;
	  resultat_u++; 
	}
      break;

      /* Operation XOR entre deux images de type masque.  */
      /* Elles doivent etre de la meme taille             */
	
    case XOR:
      taille_im = ligne * colonne;
      taille_el = element(type);  
      *imageOut = (unsigned char*) malloc (taille_im * taille_el);

      resultat_u = *imageOut; 
      source_u = imageIn; 
      cu = masque;   
	    
      for (k = 0; k < taille_im ; k++)
	{
	  if ((*source_u) && (*cu))
	    *resultat_u = 0 ;
	  else
	    {
	      if (*cu)
		*resultat_u = *cu ;
	      else
		if (*source_u)
		  *resultat_u = *source_u;
		else
		  *resultat_u = 0;
	    }  
	  source_u++;
	  cu++;
	  resultat_u++; 
	}
      break;

      /* Operation NOT d'une image.                     */
      /* Elle doit etre de type binaire ou de type byte */

    case NOT:
      taille_im = ligne * colonne;
      taille_el = element(type);  
      *imageOut = (unsigned char*) malloc (taille_im * taille_el);

      resultat_u = *imageOut;
      source_u = imageIn; 
	    
      for (k = 0; k < taille_im ; k++)
	{
	  *resultat_u = abs((int)(*source_u - 255));
	  source_u++;
	  resultat_u++; 
	}
      break;
    }
}
