/* SCCS @(#)image_generation.layout.c	1.1  12/2/92 */
/************************************************************************/
/************************************************************************/
/*                                                                      */
/*                   image_generation.layout.c                          */
/*                                                                      */
/************************************************************************/
/************************************************************************/
/*                                                                      */
/* FILENAME     :   image_generation.layout.c                           */
/*                                                                      */
/* DESCRIPTION  :   LaboImage (Image Generation Tool)                   */
/*                                                                      */
/* AUTHORS      :   Marianne Logean                                     */
/*                                                                      */
/* VERSION      :   1.0                                                 */
/*                                                                      */
/* HISTORY      :   1.12.92                                             */
/*                  MAL         Created    version: 1.0                 */
/*                                                                      */
/* Copyright  1992 by CUI/UIN/HCUG, All rights reserved.                */
/*                                                                      */
/************************************************************************/
/************************************************************************/

#include "image_generation.layout.h"
#include "libwidgets/widgetstructure.h"
#define MAX_ARGS 100


extern Widget   gLabowidget;
extern Display 	*gDisplay;
extern XmFontList gFontlist, gSmall_fontlist;
extern char *paneltabs[];

	
Widget
Build_image_graytone(BulletinBoard_0, tab_widgets, ima_gen_graytone_colormap)
        Widget BulletinBoard_0;
        xs_struc_ima_gener *tab_widgets;
	Colormap ima_gen_graytone_colormap;
{
	Widget Label_3_0;
	Widget Text_4;
	Widget Label_6;
	Widget Text_8;
	Widget Back_Label_0;
	Widget Back_Label_255;
	Widget Back_Scale;
	Widget Segment_Label_0;
	Widget Segment_Label_255;
	Widget Segment_Scale;	
	Arg args[MAX_ARGS];
	int n;


	/* Creating Label_3_0 Widget */ 

	n = 0;
	XtSetArg(args[n],XmNfontList, gFontlist); n++;
	XtSetArg(args[n],XmNlabelString,
		XmStringLtoRCreate("Background color :",
			XmSTRING_DEFAULT_CHARSET)); n++;
	XtSetArg(args[n],XmNx,250); n++;
	XtSetArg(args[n],XmNy,15); n++;

	Label_3_0 = XmCreateLabel(BulletinBoard_0,"Label_3_0",args,n);
	XtManageChild(Label_3_0);

	/* Creating Text_4 Widget */ 

	n = 0;
	XtSetArg(args[n],XmNx,375); n++;
	XtSetArg(args[n],XmNy,15); n++;
	XtSetArg(args[n],XmNcolumns, 7); n++;
	XtSetArg(args[n],XmNfontList, gSmall_fontlist); n++;
	XtSetArg(args[n],XmNvalue, "0"); n++;

	Text_4 = XmCreateText(BulletinBoard_0,"Text_4",args,n);
	XtManageChild(Text_4);

        tab_widgets->Back_color = Text_4;
	
	/* Creating Back_Label_0 Widget */ 

	n = 0;
	XtSetArg(args[n],XmNfontList, gFontlist); n++;
	XtSetArg(args[n],XmNlabelString,
		XmStringLtoRCreate("0",
			XmSTRING_DEFAULT_CHARSET)); n++;
	XtSetArg(args[n],XmNx,220); n++;
	XtSetArg(args[n],XmNy,62); n++;

	Back_Label_0 = XmCreateLabel(BulletinBoard_0,"Back_Label_0",args,n);
	XtManageChild(Back_Label_0);

	/* Creating Back_Scale Widget */ 

	n = 0;
	XtSetArg(args[n],XmNfontList, gSmall_fontlist); n++;
	XtSetArg(args[n],XmNforeground, 0); n++;
	XtSetArg(args[n],XmNmaximum,255); n++;
	XtSetArg(args[n],XmNorientation,XmHORIZONTAL); n++;
	XtSetArg(args[n],XmNprocessingDirection,XmMAX_ON_RIGHT); n++;
	XtSetArg(args[n],XmNscaleHeight,20); n++;
	XtSetArg(args[n],XmNscaleWidth,256); n++; 
	XtSetArg(args[n],XmNshowValue,true); n++;
	XtSetArg(args[n],XmNx,240); n++;
	XtSetArg(args[n],XmNy,52); n++;

	Back_Scale = XmCreateScale(BulletinBoard_0,"Back_Scale",args,n);
	XtManageChild(Back_Scale);

        XtAddCallback (Back_Scale, XmNdragCallback, 
					change_color_back, tab_widgets);
	XtAddCallback (Back_Scale, XmNvalueChangedCallback,
					change_color_back, tab_widgets);
        XtAddCallback (Back_Scale, XmNvalueChangedCallback,
					uninstall_colormap, ima_gen_graytone_colormap);
        XtAddCallback (Back_Scale, XmNdragCallback, 
					install_colormap, ima_gen_graytone_colormap);

	/* Creating Back_Label_255 Widget */ 

	n = 0;
	XtSetArg(args[n],XmNfontList, gFontlist); n++;
	XtSetArg(args[n],XmNlabelString,
		XmStringLtoRCreate("255",
			XmSTRING_DEFAULT_CHARSET)); n++;
	XtSetArg(args[n],XmNx,500); n++;
	XtSetArg(args[n],XmNy,62); n++;

	Back_Label_255 = XmCreateLabel(BulletinBoard_0,"Back_Label_255",args,n);
	XtManageChild(Back_Label_255);


	/* Creating Label_6 Widget */ 

	n = 0;
	XtSetArg(args[n],XmNfontList, gFontlist); n++;
	XtSetArg(args[n],XmNlabelString,
		XmStringLtoRCreate("Segment color :",
			XmSTRING_DEFAULT_CHARSET)); n++;
	XtSetArg(args[n],XmNx,250); n++;
	XtSetArg(args[n],XmNy,100); n++;

	Label_6 = XmCreateLabel(BulletinBoard_0,"Label_6",args,n);
	XtManageChild(Label_6);

	/* Creating Text_8 Widget */ 

	n = 0;
	XtSetArg(args[n],XmNx,370); n++;
	XtSetArg(args[n],XmNy,100); n++;
	XtSetArg(args[n],XmNcolumns, 7); n++;
	XtSetArg(args[n],XmNfontList, gSmall_fontlist); n++;
	XtSetArg(args[n],XmNvalue, "0"); n++;

	Text_8 = XmCreateText(BulletinBoard_0,"Text_8",args,n);
	XtManageChild(Text_8);

        tab_widgets->Seg_color = Text_8;

	/* Creating Segment_Label_0 Widget */ 

	n = 0;
	XtSetArg(args[n],XmNfontList, gFontlist); n++;
	XtSetArg(args[n],XmNlabelString,
		XmStringLtoRCreate("0",
			XmSTRING_DEFAULT_CHARSET)); n++;
	XtSetArg(args[n],XmNx,220); n++;
	XtSetArg(args[n],XmNy,142); n++;

	Segment_Label_0 = XmCreateLabel(BulletinBoard_0,"Segment_Label_0",args,n);
	XtManageChild(Segment_Label_0);

	/* Creating Segment_Scale Widget */ 

	n = 0;
	XtSetArg(args[n],XmNfontList, gSmall_fontlist); n++;
	XtSetArg(args[n],XmNforeground, 0); n++;
	XtSetArg(args[n],XmNmaximum,255); n++;
	XtSetArg(args[n],XmNorientation,XmHORIZONTAL); n++;
	XtSetArg(args[n],XmNprocessingDirection,XmMAX_ON_RIGHT); n++;
	XtSetArg(args[n],XmNscaleHeight,20); n++;
	XtSetArg(args[n],XmNscaleWidth,256); n++;
	XtSetArg(args[n],XmNshowValue,true); n++;
	XtSetArg(args[n],XmNx,240); n++;
	XtSetArg(args[n],XmNy,130); n++;

	Segment_Scale = XmCreateScale(BulletinBoard_0,"Segment_Scale",args,n);
	XtManageChild(Segment_Scale);

        XtAddCallback (Segment_Scale, XmNdragCallback, 
					change_color_seg, tab_widgets);
	XtAddCallback (Segment_Scale, XmNvalueChangedCallback,
					change_color_seg, tab_widgets);
        XtAddCallback (Segment_Scale, XmNvalueChangedCallback,
					uninstall_colormap, ima_gen_graytone_colormap);
        XtAddCallback (Segment_Scale, XmNdragCallback, 
					install_colormap, ima_gen_graytone_colormap);

	/* Creating Segment_Label_255 Widget */ 

	n = 0;
	XtSetArg(args[n],XmNfontList, gFontlist); n++;
	XtSetArg(args[n],XmNlabelString,
		XmStringLtoRCreate("255",
			XmSTRING_DEFAULT_CHARSET)); n++;
	XtSetArg(args[n],XmNx,500); n++;
	XtSetArg(args[n],XmNy,142); n++;

	Segment_Label_255 = XmCreateLabel(BulletinBoard_0,"Segment_Label_255",args,n);
	XtManageChild(Segment_Label_255);


}

Widget
Build_image_monochrome(BulletinBoard_0, tab_widgets)
        Widget BulletinBoard_0;
        xs_struc_ima_gener *tab_widgets;
{
	Widget Label_0;
	Widget RadioBox_1;
	Widget RadioButton_2;
	Widget RadioButton_3;
	Arg args[MAX_ARGS];
	int n;

	/* Creating Label_0 Widget */ 

	n = 0;
	XtSetArg(args[n],XmNfontList, gFontlist); n++;
	XtSetArg(args[n],XmNlabelString,
		XmStringLtoRCreate("Segment/Background Color: ",
			XmSTRING_DEFAULT_CHARSET)); n++;
	XtSetArg(args[n],XmNx,230); n++;
	XtSetArg(args[n],XmNy,20); n++;

	Label_0 = XmCreateLabel(BulletinBoard_0,"Label_0",args,n);
	XtManageChild(Label_0);

	/* Creating RadioBox_1 Widget */ 

	n = 0;
	XtSetArg(args[n],XmNentryClass,xmToggleButtonWidgetClass); n++;
	XtSetArg(args[n],XmNorientation,XmVERTICAL); n++;
	XtSetArg(args[n],XmNx,270); n++;
	XtSetArg(args[n],XmNy,50); n++;

	RadioBox_1 = XmCreateRadioBox(BulletinBoard_0,"RadioBox_1",args,n);
	XtManageChild(RadioBox_1);

	/* Creating RadioButton_2 Widget */ 

	n = 0;
	XtSetArg(args[n],XmNfontList, gFontlist); n++;
	XtSetArg(args[n],XmNindicatorType,XmONE_OF_MANY); n++;
	XtSetArg(args[n],XmNlabelString,
		XmStringLtoRCreate("white/black",
			XmSTRING_DEFAULT_CHARSET)); n++;
	XtSetArg(args[n],XmNset,true); n++;

	RadioButton_2 = XmCreateToggleButton(RadioBox_1,
					     "RadioButton_2",args,n);

	/* Adding Callbacks for RadioButton_2 */ 

	XtAddCallback(RadioButton_2,XmNvalueChangedCallback,
		      set_color_wb, tab_widgets);

	XtManageChild(RadioButton_2);

	/* Creating RadioButton_3 Widget */ 

	n = 0;
	XtSetArg(args[n],XmNfontList, gFontlist); n++;
	XtSetArg(args[n],XmNindicatorType,XmONE_OF_MANY); n++;
	XtSetArg(args[n],XmNlabelString,
		XmStringLtoRCreate("black/white",
			XmSTRING_DEFAULT_CHARSET)); n++;

	RadioButton_3 = XmCreateToggleButton(RadioBox_1,
					     "RadioButton_3",args,n);


	/* Adding Callbacks for RadioButton_3 */ 

	XtAddCallback(RadioButton_3,XmNvalueChangedCallback,
		      set_color_bw, tab_widgets);


	XtManageChild(RadioButton_3);
}

/********************************************************
/   Creation Function for Build_image_generation 
/*******************************************************/

/* type: 0 = monochrome; 1 = gray_tone */

Widget
Build_image_generation(type)
        int type;
{
	Widget image_gen_mainwidget;
	Widget image_gen_separator;
	Widget image_gen_command;
	Widget image_gen_CREATE;
	Widget image_gen_HELP;
	Widget image_gen_SAVE;
	Widget image_gen_QUIT;
	Widget BulletinBoard_0;
	Widget Label_1;
	Widget Label_2;
	Widget Label_3;
	Widget Text_0;
	Widget Text_1;
	Widget Separator_2;
	Widget SegmentPB;
	Widget Segment_RadioBox_1;
	Widget Segment_RadioButton_2;
	Widget Segment_RadioButton_3;
	Widget ClearPB;
	Widget Clear_RadioBox_1;
	Widget Clear_RadioButton_2;
	Widget Clear_RadioButton_3;
	Widget HV_label;
	Widget HV_RadioBox_1;
	Widget HV_RadioButton_2;
	Widget HV_RadioButton_3;
	Widget XY_Label;
        Widget reg_growing_mainwidget;
        Widget ScrolledWindow_1;
        Widget drawing_1;
	Colormap ima_gen_graytone_colormap;
        xs_struc_ima_gener *tab_widgets;
	Arg args[MAX_ARGS];
	int n;


	if (type == 0)
	{
	  gen_pts_controle_mono();
	  strcpy(buf, mastertabs[379]);
	} 
	else if (type == 1)
	{
	  gen_pts_controle_couleur();
	  strcpy(buf, mastertabs[380]);
	}
	
        write_master(buf);

	tab_widgets = (xs_struc_ima_gener *) malloc (sizeof (xs_struc_ima_gener));
	
	tab_widgets->pixmap_drawing = NULL;
	
	/* Creating image_gen_mainwidget Widget */ 

	n = 0;
        XtSetArg(args[n],XmNwidth,550); n++;
        XtSetArg(args[n],XmNheight,360); n++;
	XtSetArg(args[n],XmNresizePolicy,XmRESIZE_NONE); n++;
        if (type == 0)
	  XtSetArg(args[n],XmNdialogTitle, 
	   XmStringLtoRCreate(paneltabs[556], XmSTRING_DEFAULT_CHARSET)); 
	else if (type == 1)
	  XtSetArg(args[n],XmNdialogTitle, 
	   XmStringLtoRCreate(paneltabs[557], XmSTRING_DEFAULT_CHARSET));
	n++;

	image_gen_mainwidget =
		XmCreateFormDialog(gLabowidget,"image_gen_mainwidget",args,n);

	/* Creating image_gen_command Widget */ 

	n = 0;
	XtSetArg(args[n],XmNbottomAttachment,XmATTACH_FORM); n++;
	XtSetArg(args[n],XmNleftAttachment,XmATTACH_FORM); n++;
	XtSetArg(args[n],XmNresizePolicy,XmRESIZE_NONE); n++;
	XtSetArg(args[n],XmNrightAttachment,XmATTACH_FORM); n++;
	XtSetArg(args[n],XmNtopAttachment,XmATTACH_NONE); n++;

	image_gen_command = 
	  XmCreateForm(image_gen_mainwidget,"image_gen_command",args,n);
	XtManageChild(image_gen_command);

	/* Creating image_gen_SAVE Widget */ 

	n = 0;
	XtSetArg(args[n],XmNbottomAttachment,XmATTACH_FORM); n++;
	XtSetArg(args[n],XmNfontList, gFontlist); n++;
	XtSetArg(args[n],XmNlabelString,
		XmStringLtoRCreate(paneltabs[304],
			XmSTRING_DEFAULT_CHARSET)); n++;
	XtSetArg(args[n],XmNleftAttachment,XmATTACH_POSITION); n++;
	XtSetArg(args[n],XmNleftPosition,4); n++;
	XtSetArg(args[n],XmNrightAttachment,XmATTACH_POSITION); n++;
	XtSetArg(args[n],XmNrightPosition,32); n++;
	XtSetArg(args[n],XmNtopAttachment,XmATTACH_FORM); n++;

	image_gen_SAVE = 
		XmCreatePushButton(image_gen_command,"image_gen_SAVE",args,n);

	XtManageChild(image_gen_SAVE);

	/* Adding Callbacks for image_gen_SAVE */ 

	XtAddCallback(image_gen_SAVE,
		XmNactivateCallback,image_gen_SAVE_callb, tab_widgets);

	/* Creating image_gen_HELP Widget */

	n = 0;
	XtSetArg(args[n],XmNbottomAttachment,XmATTACH_FORM); n++;
	XtSetArg(args[n],XmNfontList, gFontlist); n++;
	XtSetArg(args[n],XmNlabelString,
		XmStringLtoRCreate(paneltabs[312],
			XmSTRING_DEFAULT_CHARSET)); n++;
	XtSetArg(args[n],XmNleftAttachment,XmATTACH_POSITION); n++;
	XtSetArg(args[n],XmNleftPosition,36); n++;
	XtSetArg(args[n],XmNrightAttachment,XmATTACH_POSITION); n++;
	XtSetArg(args[n],XmNrightPosition,64); n++;
	XtSetArg(args[n],XmNtopAttachment,XmATTACH_FORM); n++;
	XtSetArg(args[n],XmNsensitive, False); n++;

	image_gen_HELP = 
		XmCreatePushButton(image_gen_command,"image_gen_HELP",args,n);
	XtManageChild(image_gen_HELP);

	/* Adding Callbacks for image_gen_HELP */ 

	XtAddCallback(image_gen_HELP,
		XmNactivateCallback,image_gen_HELP_callb, image_gen_mainwidget);

	/* Creating image_gen_QUIT Widget */ 

	n = 0;
	XtSetArg(args[n],XmNbottomAttachment,XmATTACH_FORM); n++;
	XtSetArg(args[n],XmNfontList, gFontlist); n++;
	XtSetArg(args[n],XmNlabelString,
		XmStringLtoRCreate(paneltabs[313],
			XmSTRING_DEFAULT_CHARSET)); n++;
	XtSetArg(args[n],XmNleftAttachment,XmATTACH_POSITION); n++;
	XtSetArg(args[n],XmNleftPosition,68); n++;
	XtSetArg(args[n],XmNrightAttachment,XmATTACH_POSITION); n++;
	XtSetArg(args[n],XmNrightPosition,96); n++;
	XtSetArg(args[n],XmNtopAttachment,XmATTACH_FORM); n++;

	image_gen_QUIT = 
		XmCreatePushButton(image_gen_command,"image_gen_QUIT",args,n);
	XtManageChild(image_gen_QUIT);

	/* Adding Callbacks for image_gen_QUIT */ 

	XtAddCallback(image_gen_QUIT,
		XmNactivateCallback,image_gen_QUIT_callb, tab_widgets);

	/* Creating image_gen_separator Widget */ 

	n = 0;
	XtSetArg(args[n],XmNbottomAttachment,XmATTACH_WIDGET); n++;
	XtSetArg(args[n],XmNbottomWidget, image_gen_command); n++;
	XtSetArg(args[n],XmNleftAttachment,XmATTACH_FORM); n++;
	XtSetArg(args[n],XmNrightAttachment,XmATTACH_FORM); n++;

	image_gen_separator = 
		XmCreateSeparator(image_gen_mainwidget,
				  "image_gen_separator",args,n);

	XtManageChild(image_gen_separator);

	
	/* Creating BulletinBoard_0 Widget */ 

	n = 0;
	XtSetArg(args[n],XmNheight,300); n++;
	XtSetArg(args[n],XmNresizePolicy,XmRESIZE_NONE); n++;
	XtSetArg(args[n],XmNwidth,550); n++;
	XtSetArg(args[n],XmNbottomAttachment,XmATTACH_WIDGET); n++;
	XtSetArg(args[n],XmNbottomWidget, image_gen_separator); n++;
	XtSetArg(args[n],XmNtopAttachment,XmATTACH_FORM); n++;
	XtSetArg(args[n],XmNleftAttachment,XmATTACH_FORM); n++;
	XtSetArg(args[n],XmNrightAttachment,XmATTACH_FORM); n++;

	BulletinBoard_0 = XmCreateBulletinBoard(image_gen_mainwidget,"BulletinBoard_0",args,n);

	XtManageChild(BulletinBoard_0);

	/* Creating Label_1 Widget */ 

	n = 0;
	XtSetArg(args[n],XmNy,10); n++;
	XtSetArg(args[n],XmNx,10); n++;
	XtSetArg(args[n],XmNfontList, gFontlist); n++;
	XtSetArg(args[n],XmNlabelString,
		XmStringLtoRCreate("Image Dimensions:",
			XmSTRING_DEFAULT_CHARSET)); n++;

	Label_1 = XmCreateLabel(BulletinBoard_0,"Label_1",args,n);
	XtManageChild(Label_1);

	/* Creating Label_2 Widget */ 

	n = 0;
	XtSetArg(args[n],XmNfontList, gFontlist); n++;
	XtSetArg(args[n],XmNlabelString,
		XmStringLtoRCreate("Width: ",
			XmSTRING_DEFAULT_CHARSET)); n++;
	XtSetArg(args[n],XmNy,60); n++;
	XtSetArg(args[n],XmNx,10); n++;

	Label_2 = XmCreateLabel(BulletinBoard_0,"Label_2",args,n);
	XtManageChild(Label_2);

	/* Creating Label_3 Widget */ 

	n = 0;
	XtSetArg(args[n],XmNfontList, gFontlist); n++;
	XtSetArg(args[n],XmNlabelString,
		XmStringLtoRCreate("Height: ",
			XmSTRING_DEFAULT_CHARSET)); n++;
	XtSetArg(args[n],XmNy,115); n++;
	XtSetArg(args[n],XmNx,10); n++;

	Label_3 = XmCreateLabel(BulletinBoard_0,"Label_3",args,n);
	XtManageChild(Label_3);

	/* Creating Text_0 Widget */ 

	n = 0;
	XtSetArg(args[n],XmNx,65); n++;
	XtSetArg(args[n],XmNy,60); n++;
	XtSetArg(args[n],XmNfontList, gSmall_fontlist); n++;
	XtSetArg(args[n],XmNvalue, "256"); n++;
	XtSetArg(args[n],XmNcolumns, 5); n++;

	Text_0 = XmCreateText(BulletinBoard_0,"Text_0",args,n);
	XtManageChild(Text_0);

	tab_widgets->Width_text = Text_0;
	
	/* Creating Text_1 Widget */ 

	n = 0;
	XtSetArg(args[n],XmNx,65); n++;
	XtSetArg(args[n],XmNy,115); n++;
	XtSetArg(args[n],XmNfontList, gSmall_fontlist); n++;
	XtSetArg(args[n],XmNvalue, "256"); n++;
	XtSetArg(args[n],XmNcolumns, 5); n++;

	Text_1 = XmCreateText(BulletinBoard_0,"Text_1",args,n);
	XtManageChild(Text_1);

	tab_widgets->Height_text = Text_1;

	/* Creating image_gen_CREATE Widget */ 

	n = 0;
	XtSetArg(args[n],XmNfontList, gFontlist); n++;
	XtSetArg(args[n],XmNlabelString,
		XmStringLtoRCreate("CREATE",
			XmSTRING_DEFAULT_CHARSET)); n++;
	XtSetArg(args[n],XmNx, 40); n++;
	XtSetArg(args[n],XmNy, 160); n++;
	XtSetArg(args[n],XmNwidth, 100); n++;

	image_gen_CREATE = 
		XmCreatePushButton(BulletinBoard_0,"image_gen_CREATE",args,n);
	XtManageChild(image_gen_CREATE);


	/* Adding Callbacks for image_gen_CREATE */ 

	XtAddCallback(image_gen_CREATE,
		XmNactivateCallback,image_gen_CREATE_callb, tab_widgets);


	/* Creating HV_label Widget */ 

	n = 0;
	XtSetArg(args[n],XmNfontList, gFontlist); n++;
	XtSetArg(args[n],XmNlabelString,
		XmStringLtoRCreate("H/V constraints :",
			XmSTRING_DEFAULT_CHARSET)); n++;
	XtSetArg(args[n],XmNx,10); n++;
	XtSetArg(args[n],XmNy,210); n++;

	HV_label = XmCreateLabel(BulletinBoard_0,"HV_label",args,n);
	XtManageChild(HV_label);

	/* Creating HV_RadioBox_1 Widget */ 

	n = 0;
	XtSetArg(args[n],XmNentryClass,xmToggleButtonWidgetClass); n++;
	XtSetArg(args[n],XmNorientation,XmHORIZONTAL); n++;
        XtSetArg(args[n],XmNx,40); n++;
	XtSetArg(args[n],XmNy,240); n++;

	HV_RadioBox_1 = XmCreateRadioBox(BulletinBoard_0,"HV_RadioBox_1",args,n);
	XtManageChild(HV_RadioBox_1);

	/* Creating HV_RadioButton_2 Widget */ 

	n = 0;
	XtSetArg(args[n],XmNfontList, gFontlist); n++;
	XtSetArg(args[n],XmNindicatorType,XmONE_OF_MANY); n++;
	XtSetArg(args[n],XmNlabelString,
		XmStringLtoRCreate("ON",
			XmSTRING_DEFAULT_CHARSET)); n++;

	HV_RadioButton_2 = XmCreateToggleButton(HV_RadioBox_1,
					     "HV_RadioButton_2",args,n);

	/* Adding Callbacks for HV_RadioButton_2 */ 

	XtAddCallback(HV_RadioButton_2,XmNvalueChangedCallback,
		      set_constraint, 1);

	XtManageChild(HV_RadioButton_2);

	/* Creating HV_RadioButton_3 Widget */ 

	n = 0;
	XtSetArg(args[n],XmNfontList, gFontlist); n++;
	XtSetArg(args[n],XmNindicatorType,XmONE_OF_MANY); n++;
	XtSetArg(args[n],XmNlabelString,
		XmStringLtoRCreate("OFF",
			XmSTRING_DEFAULT_CHARSET)); n++;
	XtSetArg(args[n],XmNset,true); n++;

	HV_RadioButton_3 = XmCreateToggleButton(HV_RadioBox_1,
					     "HV_RadioButton_3",args,n);


	/* Adding Callbacks for RadioButton_3 */ 

	XtAddCallback(HV_RadioButton_3,XmNvalueChangedCallback,
		      set_constraint, 0);

	XtManageChild(HV_RadioButton_3);

	/* Creating XY_Label Widget */ 

	n = 0;
	XtSetArg(args[n],XmNfontList, gFontlist); n++;
	XtSetArg(args[n],XmNforeground, 255); n++;
	XtSetArg(args[n],XmNbackground, 0); n++;
	XtSetArg(args[n],XmNlabelString,
		XmStringLtoRCreate("X:            Y:    ",
			XmSTRING_DEFAULT_CHARSET)); n++;
	XtSetArg(args[n],XmNx,10); n++;
	XtSetArg(args[n],XmNy,280); n++;

	XY_Label = XmCreateLabel(BulletinBoard_0,"XY_Label",args,n);
	XtManageChild(XY_Label);

	tab_widgets->XY_label = XY_Label;
	

	/* Creating Separator_2 Widget */ 

	n = 0;
	XtSetArg(args[n],XmNheight,370); n++;
	XtSetArg(args[n],XmNwidth,3); n++;
	XtSetArg(args[n],XmNx,200); n++;
        XtSetArg(args[n],XmNorientation,XmVERTICAL); n++;


	Separator_2 = XmCreateSeparator(BulletinBoard_0,"Separator_2",args,n);
	XtManageChild(Separator_2);


        if (type == 0)
	{
	  Build_image_monochrome(BulletinBoard_0, tab_widgets);
	}
	else if (type == 1)
	{
	  ima_gen_graytone_colormap = init_color_lin ();
	  Build_image_graytone(BulletinBoard_0, tab_widgets, ima_gen_graytone_colormap);
	}


	/* Creating SegmentPB Widget */ 

	n = 0;
	XtSetArg(args[n],XmNfontList, gFontlist); n++;
	XtSetArg(args[n],XmNlabelString,
		XmStringLtoRCreate("APPLY",
			XmSTRING_DEFAULT_CHARSET)); n++;
	XtSetArg(args[n],XmNx,220); n++;
	XtSetArg(args[n],XmNy,190); n++;

	SegmentPB = XmCreatePushButton(BulletinBoard_0,"SegmentPB",args,n);
	XtManageChild(SegmentPB);

	/* Adding Callbacks for SegmentPB */ 

	XtAddCallback(SegmentPB,XmNactivateCallback,
		      create_segment, tab_widgets);

	/* Creating Segment_RadioBox_1 Widget */ 

	n = 0;
	XtSetArg(args[n],XmNentryClass,xmToggleButtonWidgetClass); n++;
	XtSetArg(args[n],XmNorientation,XmHORIZONTAL); n++;
        XtSetArg(args[n],XmNx,310); n++;
	XtSetArg(args[n],XmNy,190); n++;

	Segment_RadioBox_1 = XmCreateRadioBox(BulletinBoard_0,"RadioBox_1",args,n);
	XtManageChild(Segment_RadioBox_1);

	/* Creating Segment_RadioButton_2 Widget */ 

	n = 0;
	XtSetArg(args[n],XmNfontList, gFontlist); n++;
	XtSetArg(args[n],XmNindicatorType,XmONE_OF_MANY); n++;
	XtSetArg(args[n],XmNlabelString,
		XmStringLtoRCreate("Fill",
			XmSTRING_DEFAULT_CHARSET)); n++;
	XtSetArg(args[n],XmNset,true); n++;

	Segment_RadioButton_2 = XmCreateToggleButton(Segment_RadioBox_1,
					     "Segment_RadioButton_2",args,n);

	/* Adding Callbacks for Segment_RadioButton_2 */ 

	XtAddCallback(Segment_RadioButton_2,XmNvalueChangedCallback,
		      set_type_segment, 1);

	XtManageChild(Segment_RadioButton_2);

	/* Creating Segment_RadioButton_3 Widget */ 

	n = 0;
	XtSetArg(args[n],XmNfontList, gFontlist); n++;
	XtSetArg(args[n],XmNindicatorType,XmONE_OF_MANY); n++;
	XtSetArg(args[n],XmNlabelString,
		XmStringLtoRCreate("Borders",
			XmSTRING_DEFAULT_CHARSET)); n++;

	Segment_RadioButton_3 = XmCreateToggleButton(Segment_RadioBox_1,
					     "Segment_RadioButton_3",args,n);


	/* Adding Callbacks for RadioButton_3 */ 

	XtAddCallback(Segment_RadioButton_3,XmNvalueChangedCallback,
		      set_type_segment, 0);

	XtManageChild(Segment_RadioButton_3);

	/* Creating ClearPB Widget */ 

	n = 0;
	XtSetArg(args[n],XmNfontList, gFontlist); n++;
	XtSetArg(args[n],XmNlabelString,
		XmStringLtoRCreate("CLEAR",
			XmSTRING_DEFAULT_CHARSET)); n++;
	XtSetArg(args[n],XmNx,220); n++;
	XtSetArg(args[n],XmNy,260); n++;

	ClearPB = XmCreatePushButton(BulletinBoard_0,"ClearPB",args,n);
	XtManageChild(ClearPB);

	/* Adding Callbacks for ClearPB */ 

	XtAddCallback(ClearPB,XmNactivateCallback,
		      clear, tab_widgets);

	/* Creating Clear_RadioBox_1 Widget */ 

	n = 0;
	XtSetArg(args[n],XmNentryClass,xmToggleButtonWidgetClass); n++;
	XtSetArg(args[n],XmNorientation,XmHORIZONTAL); n++;
        XtSetArg(args[n],XmNx,310); n++;
	XtSetArg(args[n],XmNy,255); n++;

	Clear_RadioBox_1 = XmCreateRadioBox(BulletinBoard_0,"Clear_RadioBox_1",args,n);
	XtManageChild(Clear_RadioBox_1);

	/* Creating Clear_RadioButton_2 Widget */ 

	n = 0;
	XtSetArg(args[n],XmNfontList, gFontlist); n++;
	XtSetArg(args[n],XmNindicatorType,XmONE_OF_MANY); n++;
	XtSetArg(args[n],XmNlabelString,
		XmStringLtoRCreate("All",
			XmSTRING_DEFAULT_CHARSET)); n++;
	XtSetArg(args[n],XmNset,true); n++;

	Clear_RadioButton_2 = XmCreateToggleButton(Clear_RadioBox_1,
					     "Clear_RadioButton_2",args,n);

	/* Adding Callbacks for Clear_RadioButton_2 */ 

	XtAddCallback(Clear_RadioButton_2,XmNvalueChangedCallback,
		      set_type_clear, 0);

	XtManageChild(Clear_RadioButton_2);

	/* Creating Clear_RadioButton_3 Widget */ 

	n = 0;
	XtSetArg(args[n],XmNfontList, gFontlist); n++;
	XtSetArg(args[n],XmNindicatorType,XmONE_OF_MANY); n++;
	XtSetArg(args[n],XmNlabelString,
		XmStringLtoRCreate("Segment",
			XmSTRING_DEFAULT_CHARSET)); n++;

	Clear_RadioButton_3 = XmCreateToggleButton(Clear_RadioBox_1,
					     "Clear_RadioButton_3",args,n);


	/* Adding Callbacks for Clear_RadioButton_3 */ 

	XtAddCallback(Clear_RadioButton_3,XmNvalueChangedCallback,
		      set_type_clear, 1);

	XtManageChild(Clear_RadioButton_3);


	/* Creating reg_growing_mainwidget Widget */ 

	n = 0;
	XtSetArg(args[n],XmNresizePolicy,XmRESIZE_NONE); n++;
	XtSetArg(args[n],XmNx, 100); n++;
	XtSetArg(args[n],XmNy, 100); n++;
	XtSetArg(args[n],XmNdialogTitle, 
		XmStringLtoRCreate("Drawing", 
				   XmSTRING_DEFAULT_CHARSET)); n++;

	reg_growing_mainwidget =
	    XmCreateFormDialog(gLabowidget,
			       "reg_growing_mainwidget",args,n);

	if (type == 1)
	{
	  XSetWindowColormap (gDisplay, 
			      XtWindow (XtParent (reg_growing_mainwidget)), 
			      ima_gen_graytone_colormap);
	}

	tab_widgets->Draw_dialog = reg_growing_mainwidget;
	
	/* Creating ScrolledWindow_1 Widget */ 

	n = 0;
	XtSetArg(args[n], XmNtopAttachment, XmATTACH_FORM); n++;
	XtSetArg(args[n], XmNrightAttachment, XmATTACH_FORM); n++;
	XtSetArg(args[n], XmNleftAttachment, XmATTACH_FORM);n++;
	XtSetArg(args[n], XmNbottomAttachment, XmATTACH_FORM);n++;
	XtSetArg(args[n], XmNscrollingPolicy, XmAUTOMATIC);n++;
	ScrolledWindow_1 = XtCreateManagedWidget("ScrolledWindow_1", 
					  xmScrolledWindowWidgetClass,
					  reg_growing_mainwidget, args, n);

	n = 0;
	drawing_1 = XtCreateWidget("drawing_1", xmDrawingAreaWidgetClass,
				   ScrolledWindow_1, args, n);

	tab_widgets->Drawing_area = drawing_1;
	
	XtAddEventHandler((Widget) drawing_1, 
			  PointerMotionMask,	False,
			  (XtEventHandler)track_mouse_image_generation,
			  tab_widgets);
 
	n = 0;
	XtSetArg(args[n], XmNworkWindow, drawing_1); n++;
	XtSetValues(ScrolledWindow_1, args, n);
	XtManageChild(ScrolledWindow_1);

	return(image_gen_mainwidget);
}
