/* SCCS @(#)mm.c	1.1  12/2/92 */
/*****************************************************************************/
/* module mm.c								     */
/*									     */
/* Author: Rene Perrier							     */
/*	   Labo Image							     */
/*	   Computing Science Center					     */
/*	   University of Geneva, Switzerland				     */
/* Date:   June 1988							     */
/* Modifications:   April 2, 1989: some cleaning.			     */
/* Copyright (c) A. Jacot-Descombes, T. Pun, C. Pellegrini, Uni. of Geneva   */
/* (This copyright notice should appear).				     */
/*									     */
/*****************************************************************************/

/* programme de Morphologie Mathematique a niveau de gris */
/* utilise par le programme "win" du labo de traitement des images */
/* RENE PERRIER  27.6.88 */
/* A.JACOT-DESCCOMBES 25.11.88 mise-a-jour de la gaussienne */

#include <stdio.h>
#include <ctype.h>
#include <string.h>
#include <math.h>

#include "../define.h"
#include "../structure.h"
#include "../global.h"
#include "../type.h"

#define MAX(x,y)   (((x) < (y))  ?  (y) : (x))
#define MIN(x,y)   (((x) < (y))  ?  (x) : (y))

#define  TYPE_SHORT  1

#define IMAGE       short

#define EL_STRUCT   struct el_struct
EL_STRUCT
         {
	 short      x;
         short      y;
         short      z;
         EL_STRUCT  *next;
	 };

#define ELEMENT struct element

static int flag_autoconvert;

short type, nligne, ncolonne;   /* variables globales */

/* fonctions definies dans el.c  :   */
EL_STRUCT *sphere();
EL_STRUCT *cone();
EL_STRUCT *cylindre();
EL_STRUCT *gaussienne();
EL_STRUCT *plan_image();

/********************************************/
int autoconvert_short (no_dep)
int no_dep;
{
    short *im, *debut;
    register int j;
    int taille;
    register float delta, minim;
    register int minarr;
    struct convert *conv;

    sprintf (buf, mastertabs[350]);
    write_master (buf);

    sprintf(buf, "short img %d", no_dep);
    write_master (buf);

    taille = dir_desc[no_dep].ncolonne * dir_desc[no_dep].nligne;
    debut = im = (short *) malloc (taille * 2);
    /* 2 bytes par short */
    sprintf (buf, "(%.2f,%.2f -> %.2f,%.2f)\n\0", 
	     conv->mind, conv->maxd, conv->mina, conv->maxa);
    write_master (buf);

    if (dir_desc[no_dep].mmin >= MINSHORT &&
	dir_desc[no_dep].mmax <= MAXSHORT &&
	dir_desc[no_dep].mmin == conv->mind &&
	conv->mind  == conv->mina &&
	dir_desc[no_dep].mmax == conv->maxd &&
	conv->maxd==conv->maxa)
    {
      /* image depart comprise dans l'intervalle des short    */
      /* +pas changement dynamique = convertir avec les "cast" */

      switch (dir_desc[no_dep].type) {
      case -1:
      case 0 : {  /* image de depart de type unsigned char */
	unsigned char *b;
	b = (unsigned char *)dir_image[no_dep].image;
	for (j=0; j < taille; j++) {
	  *im = (short)*b;
	  im++;  b++;
	}
	break;
      }        
      case 1 : { /* image de depart de type short (recopie)*/
	short *s;
	s = (short *)dir_image[no_dep].image;
	for (j=0; j < taille; j++) {
	  *im = (short)*s;
	  im++;  s++;
	}
	break; 
      } 
      case 2 : {   /* image de depart de type int */
	int *i;
	i = (int *)dir_image[no_dep].image;
	for (j=0; j < taille; j++) {
	  *im = (short)*i;
	  im++;  i++;
	}
	break;
      }        
      case 3 : {   /* image de depart de type float */
	float *f;
	f = (float *)dir_image[no_dep].image;
	for (j=0; j < taille; j++) {
	  *im = (short)*f;
	  im++;  f++;
	}
	break;
      }        
      }
     /* les statistiques de l'image d'arrivee sont inchangees */
      if (buffer_image[0].image != NULL) 
        free(buffer_image[0].image);
      buffer_image[0].image = (unsigned char *)debut;
      buffer_desc[0] = dir_desc[no_dep];
      buffer_desc[0].type = 1;
    }
    else { 
      /* on fait une regle de trois en etalant la dynamique de */
      /* l'intervalle de depart sur la dynamique choisie	*/
      delta=(conv->maxa - conv->mina)/(conv->maxd - conv->mind);
      minim = conv->mind;
      minarr = (int)conv->mina;
      switch (dir_desc[no_dep].type) {
      case -1:
      case 0 : {   /* l'image de depart est de type byte */
	unsigned char *b, bb;
	b = (unsigned char *)dir_image[no_dep].image;
	for (j=0; j < taille; j++) {
	  if (*b > conv->maxd) bb = conv->maxd;
	  else if (*b < conv->mind) bb = conv->mind;
	  else bb = *b;
	  *im = (short) (((bb - minim) * delta + minarr) + 0.5);
	  im++;  b++;
	}
	break;
      }
      case 1 : {   /* l'image de depart est de type short */
	short *s, ss;
	s = (short *)dir_image[no_dep].image;
	for (j=0; j < taille; j++) {
	  if (*s > conv->maxd) ss = conv->maxd;
	  else if (*s < conv->mind) ss = conv->mind;
	  else ss = *s;
	  *im = (short)(((ss - minim) * delta + minarr) + 0.5);
	  im++;  s++;
	}
	break;
      }
      case 2 : {   /* l'image de depart est de type int */
	int *i, ii;
	i = (int *)dir_image[no_dep].image;
	for (j=0; j < taille; j++) {
	  if (*i > conv->maxd) ii = conv->maxd;
	  else if (*i < conv->mind) ii = conv->mind;
	  else ii = *i;
	  *im = (short)(((ii - minim) * delta + minarr) + 0.5);
	  im++;  i++;
	}
	break;
      }
      case 3 : {   /* l'image de depart est de type float */
	float *f, ff;
	f = (float *)dir_image[no_dep].image;
	for (j=0; j < taille; j++) {
	  if (*f > conv->maxd) ff = conv->maxd;
	  else if (*f < conv->mind) ff = conv->mind;
	  else ff = *f;
	  *im = (short)(((ff - minim) * delta + minarr) + 0.5);
	  im++;  f++;
	}
	break;
      }
      }
      /* on doit recalculer les statistiques de l'image */
      if (buffer_image[0].image != NULL) 
        free(buffer_image[0].image);
      buffer_image[0].image = (unsigned char *)debut;
      buffer_desc[0] = dir_desc[no_dep];
      buffer_desc[0].mmin = conv->mina;
      buffer_desc[0].mmax = conv->maxa;
      buffer_desc[0].type = 1;
      statis (buffer_image[0].image, buffer_desc[0].type, 
	      buffer_desc[0].nligne, buffer_desc[0].ncolonne,
	      &(buffer_desc[0].mmin), &(buffer_desc[0].mmax), 
	      &(buffer_desc[0].mu), &(buffer_desc[0].ecart));
    }
}

/********************************************/

/*===========================================================================*/
/*   erosion :                                                               */
/*   ~~~~~~~~~                                                               */
/*              La procedure erosion erode l'image pointee par im_dep avec   */
/*    l'element structurant pointe par b et place le resultat dans l'image   */
/*    pointee par im_arr. L'image de depart n'est pas modifiee.              */
/*                                                                           */
/*    im_arr(x,y) = MIN [ im_dep(x+i,y+j) - b(i,j) ]    avec (x+i,y+j) dans  */
/*                  i,j                                   le support(im_dep) */
/*===========================================================================*/


 void erosion_ng(im_dep,im_arr,b)

   IMAGE      *im_dep, *im_arr;
   EL_STRUCT  *b;

   {
   int        register k;
   short      register i,j,r,s;
   short      register min;
   EL_STRUCT  *ptr;
   int        *indice, *p;

   /* construction du tableau indice tel que  indice[i] = i * ncolonne */
   k = 0;
   indice = (int *) malloc (nligne * sizeof(int));
   p = indice;
   for (i = 0; i < nligne; i++)
      {
      *p = k;
      p ++;
      k += ncolonne;
      };

   k = 0;
   for (i = 0; i < nligne; i++)           /* boucle de parcours des points de l'image */
      for (j = 0; j < ncolonne; j++)
         {
	 ptr = b;
         min = MAXSHORT;  /* valeur sentinelle */
         while (ptr != NULL)        /* parcours des vecteurs de l'element structurant */
            {
            if (((r = i + ptr->x) >= nligne) || (r < 0) ||
                  ((s = j + ptr->y) >= ncolonne) || (s < 0));
            else
               {  
                                        /* (x+i,y+j) appartient au support de l'image */
               min = im_arr[k] = MIN(min,(im_dep[indice[r] + s] - ptr->z));
	       };
            ptr = ptr->next;
	    };
         k++;
	 };
   };

/*===========================================================================*/
/*   dilatation :                                                            */
/*   ~~~~~~~~~~~~                                                            */
/*              La procedure dilatation dilate l'image pointee par im_dep    */
/*    avec l'element structurant pointe par b et place le resultat dans      */
/*    l'image pointee par im_arr. L'image de depart n'est pas modifiee.      */
/*                                                                           */
/*    im_arr(x,y) = MAX [ im_dep(x-i,y-j) + b(i,j) ]    avec (x-i,y-j) dans  */
/*                  i,j                                   le support(im_dep) */
/*===========================================================================*/


 void dilatation_ng(im_dep,im_arr,b)

   IMAGE      *im_dep, *im_arr;
   EL_STRUCT  *b;

   {
   int   register k;
   short register i,j,r,s;
   short register max;
   EL_STRUCT *ptr;
   int        *indice, *p;

   k = 0;
   indice = (int *) malloc (nligne * sizeof(int));
   p = indice;
   for (i = 0; i < nligne; i++)
      {
      *p = k;
      p ++;
      k += ncolonne;
      };

   k = 0;
   for (i = 0; i < nligne; i++)
      for (j = 0; j < ncolonne; j++)
         {
	 ptr = b;
         max = MINSHORT;
         while (ptr != NULL)
            {
            if (((r = i - ptr->x) >= nligne) || (r < 0) ||
                  ((s = j - ptr->y) >= ncolonne) || (s < 0));
            else
               {
               max = im_arr[k] = MAX(max,(im_dep[indice[r] + s] + ptr->z));
	       };
            ptr = ptr->next;
	    };
         k++;
	 };
   };


/*===========================================================================*/
/*   ouverture  :                                                            */
/*   ~~~~~~~~~~~~                                                            */
/*              La procedure ouverture ouvre l'image pointee par im_dep      */
/*    avec l'element structurant pointe par b et place le resultat dans      */
/*    l'image pointee par im_arr. L'image de depart n'est pas modifiee.      */
/*                                                                           */
/*    ouverture = erosion, puis dilatation                                   */
/*===========================================================================*/

void ouverture_ng(im_dep,im_arr,b)

   IMAGE      *im_dep, *im_arr;
   EL_STRUCT  *b;

   {
   IMAGE *im_temp;

   im_temp = (IMAGE *) malloc (nligne * ncolonne * 2);
   erosion_ng(im_dep,im_temp,b);
   dilatation_ng(im_temp,im_arr,b);
   free(im_temp);
   };


/*===========================================================================*/
/*   fermeture  :                                                            */
/*   ~~~~~~~~~~~~                                                            */
/*              La procedure fermeture ferme l'image pointee par im_dep      */
/*    avec l'element structurant pointe par b et place le resultat dans      */
/*    l'image pointee par im_arr. L'image de depart n'est pas modifiee.      */
/*                                                                           */
/*    fermeture = dilatation, puis erosion                                   */
/*===========================================================================*/

void fermeture_ng(im_dep,im_arr,b)

   IMAGE      *im_dep, *im_arr;
   EL_STRUCT  *b;

   {
   IMAGE *im_temp;

   im_temp = (IMAGE *) malloc (nligne * ncolonne * 2);
   dilatation_ng(im_dep,im_temp,b);
   erosion_ng(im_temp,im_arr,b);
   free(im_temp);
   };


/*###########################################################################*/
/*   MENU  PRINCIPAL                                                         */ 
/*###########################################################################*/

void entree_morpho_nivgris(op,im_dep,im_arr,ptr)

   int      op;      /* operation a effectuer */
   int      im_dep;  /* numero du plan image de depart */
   int      im_arr;  /* numero du plan image d'arrivee */
   ELEMENT  *ptr;    /* parametres concernant l'element structurant */

   {
   EL_STRUCT  *b;
   IMAGE      *image_arr, *image_dep;
   int	      flag_conv;
   
   nligne = dir_desc[im_dep].nligne;
   ncolonne = dir_desc[im_dep].ncolonne;

   image_arr = (IMAGE *) malloc (nligne * ncolonne * 2);

   /* construction de l'element structurant a utiliser */
   switch(ptr->type)
      {
      case 0:
             b = sphere(ptr->param1);
             break;

      case 1:
             b = cone(ptr->param1,ptr->param2);
             break;

      case 2:
             b = cylindre(ptr->param1,ptr->param2);
             break;

      case 3 :
             b = gaussienne(ptr->param3, ptr->param4, ptr->param5);
             break;

      case 10:
	     switch (dir_desc[ptr->param1].type){
	     case -1:
	     case 0: flag_conv = TRUE;
	       image_dep = (short *)conv_short(
					       dir_image[ptr->param1].image,
					       dir_desc[ptr->param1].type,
					       dir_desc[ptr->param1].nligne,
					       dir_desc[ptr->param1].ncolonne);
	       break;
	     case 1: flag_conv = FALSE;
	       image_dep = (short *)dir_image[ptr->param1].image;
	       break;
	     case 2:
	     case 3:
	     case 4:
	     case 5:flag_autoconvert = TRUE;
	       autoconvert_short(ptr->param1);
	       image_dep = (short *)buffer_image[0].image;
	       break;
	     }


	     b = plan_image(image_dep,
			    dir_desc[ptr->param1].nligne,
			    dir_desc[ptr->param1].ncolonne);

	     if ((flag_conv) || (flag_autoconvert))
	       {
		 free (image_dep);
		 flag_conv = FALSE;
		 flag_autoconvert = FALSE;
	       }
	     break;
	   };

   /* execution de l'operation a effectuer */

   switch (dir_desc[im_dep].type)
     {
     case -1:
     case 0: flag_conv = TRUE;
       image_dep = (short *)conv_short(
				     dir_image[im_dep].image,
				     dir_desc[im_dep].type,
				     dir_desc[im_dep].nligne,
				     dir_desc[im_dep].ncolonne);
       break;
     case 1: flag_conv = FALSE;
       image_dep = (short *)dir_image[im_dep].image;
       break;
     case 2:
     case 3:
     case 4:
     case 5:flag_autoconvert = TRUE;
       autoconvert_short(im_dep);
       image_dep = (short *)buffer_image[0].image;
       break;
     };

   switch(op)
     {
     case 10:erosion_ng (image_dep, image_arr, b);
       break;
     case 11:dilatation_ng (image_dep, image_arr, b);
       break;
     case 12:ouverture_ng (image_dep, image_arr, b);
       break;
     case 13:fermeture_ng (image_dep, image_arr, b);
       break;
     };


   if ((flag_conv) || (flag_autoconvert))
     {
       free (image_dep);
       flag_conv = FALSE;
       flag_autoconvert = FALSE;
     }

   if (dir_image[im_arr].image != NULL)  free(dir_image[im_arr].image);
   dir_image[im_arr].image = (unsigned char *) image_arr;

   /* mise a jour des statistiques de l'image resultante */

   dir_desc[im_arr] = dir_desc[im_dep];
/*
   dir_desc[im_arr].nligne = nligne;
   dir_desc[im_arr].ncolonne = ncolonne;
*/
   dir_desc[im_arr].type = TYPE_SHORT;

   statis (dir_image[im_arr].image,
           dir_desc[im_arr].type,
           dir_desc[im_arr].nligne,
           dir_desc[im_arr].ncolonne,
           &(dir_desc[im_arr].mmin),
           &(dir_desc[im_arr].mmax),
           &(dir_desc[im_arr].mu),
           &(dir_desc[im_arr].ecart));

   return;
   };
