/* SCCS @(#)pixeledit.layout.c	1.1  12/2/92 */
/************************************************************************/
/************************************************************************/
/*                                                                      */
/*                            pixeledit.layout.c                        */
/*                                                                      */
/************************************************************************/
/************************************************************************/
/*                                                                      */
/* FILENAME     :   pixeledit.layout.c                                  */
/*                                                                      */
/* DESCRIPTION  :   LaboImage (Pixel editing Tool)                      */
/*                                                                      */
/* AUTHORS      :   Marianne Logean                                     */
/*                                                                      */
/* VERSION      :   1.0                                                 */
/*                                                                      */
/* HISTORY      :   1.12.92                                             */
/*                  MAL         Created    version: 1.0                 */
/*                                                                      */
/* Copyright  1992 by CUI/UIN/HCUG, All rights reserved.                */
/*                                                                      */
/************************************************************************/
/************************************************************************/


#include "pixeledit.layout.h"
#include "libwidgets/widgetstructure.h"
#include <X11/cursorfont.h>

#define MAX_ARGS 100

extern XmFontList gFontlist, gSmall_fontlist;
extern Display *gDisplay;
extern Visual *gVisual;

extern  GC default_gc;   

extern void keep_sensitive_button();

Pixmap pixeleditpixmap;
Pixmap flechepixmap_pixeledit;
Widget XmDrawingAreapixeledit;
XImage *ximage_pixeledit;
Widget Magnify_drawing;

/********************************************************
/   Creation Function for Correction_zone
/*******************************************************/

Widget
build_Correction_zone(pixeledit_widget)
	Widget pixeledit_widget;
{
	Widget Correction_zone_Frame;
	Widget RadioBox_1;
	Widget RadioButton_2;
	Widget RadioButton_3;
	Arg args[MAX_ARGS];
	int n;

	/* Creating Correction_zone_Frame Widget */ 

	n = 0;
	XtSetArg(args[n],XmNleftAttachment,XmATTACH_POSITION); n++;
	XtSetArg(args[n],XmNleftPosition, 15); n++;
	XtSetArg(args[n],XmNtopAttachment,XmATTACH_POSITION); n++;
	XtSetArg(args[n],XmNtopPosition,18); n++;

	Correction_zone_Frame = XmCreateFrame(pixeledit_widget,
				     "Correction_zone_Frame",args,n);
	XtManageChild(Correction_zone_Frame);

	/* Creating RadioBox_1 Widget */ 

	n = 0;
	XtSetArg(args[n],XmNentryClass,xmToggleButtonWidgetClass); n++;
	XtSetArg(args[n],XmNorientation,XmHORIZONTAL); n++;

	RadioBox_1 = 
	   XmCreateRadioBox(Correction_zone_Frame,"RadioBox_1",args,n);
	XtManageChild(RadioBox_1);


	/* Creating RadioButton_2 Widget */ 

	n = 0;
	XtSetArg(args[n],XmNindicatorType,XmONE_OF_MANY); n++;
	XtSetArg(args[n],XmNfontList, gSmall_fontlist); n++;
	XtSetArg(args[n],XmNlabelString,
		XmStringLtoRCreate("Pixel",
			XmSTRING_DEFAULT_CHARSET)); n++;
	XtSetArg(args[n],XmNset,true); n++;

	RadioButton_2 = XmCreateToggleButton(RadioBox_1,
					     "RadioButton_2",args,n);

	/* Adding Callbacks for RadioButton_2 */ 

	XtAddCallback(RadioButton_2,XmNvalueChangedCallback,
			Choose_Correction_zone, 0);

	XtManageChild(RadioButton_2);

	/* Creating RadioButton_3 Widget */ 

	n = 2;
	XtSetArg(args[n],XmNlabelString,
		XmStringLtoRCreate("Rectangle",
			XmSTRING_DEFAULT_CHARSET)); n++;

	RadioButton_3 = XmCreateToggleButton(RadioBox_1,
					     "RadioButton_3",args,n);
		
	/* Adding Callbacks for RadioButton_3 */ 

	XtAddCallback(RadioButton_3,XmNvalueChangedCallback,
			Choose_Correction_zone, 1);

	XtManageChild(RadioButton_3);

	return(Correction_zone_Frame);
}


/********************************************************
/   Creation Function for Display 
/*******************************************************/

Widget
build_Display_Lin_Log(pixeledit_widget)
	Widget pixeledit_widget;
{
	Widget Display_Frame;
	Widget RadioBox_1;
	Widget RadioButton_2;
	Widget RadioButton_3;
	Arg args[MAX_ARGS];
	int n;

	/* Creating Display_Frame Widget */ 

	n = 0;
	XtSetArg(args[n],XmNleftAttachment,XmATTACH_POSITION); n++;
	XtSetArg(args[n],XmNleftPosition, 15); n++;
	XtSetArg(args[n],XmNtopAttachment,XmATTACH_POSITION); n++;
	XtSetArg(args[n],XmNtopPosition,48); n++;

	Display_Frame = XmCreateFrame(pixeledit_widget,
				      "Display_Frame",args,n);
	XtManageChild(Display_Frame);

	/* Creating RadioBox_1 Widget */ 

	n = 0;
	XtSetArg(args[n],XmNentryClass,xmToggleButtonWidgetClass); n++;
	XtSetArg(args[n],XmNorientation,XmHORIZONTAL); n++;

	RadioBox_1 = XmCreateRadioBox(Display_Frame,
				      "RadioBox_1",args,n);
	XtManageChild(RadioBox_1);

	/* Creating RadioButton_2 Widget */ 

	n = 0;
	XtSetArg(args[n],XmNindicatorType,XmONE_OF_MANY); n++;
	XtSetArg(args[n],XmNfontList, gSmall_fontlist); n++;
	XtSetArg(args[n],XmNlabelString,
		XmStringLtoRCreate("lin gray",
			XmSTRING_DEFAULT_CHARSET)); n++;
	XtSetArg(args[n],XmNset,true); n++;

	RadioButton_2 = XmCreateToggleButton(RadioBox_1,
					     "RadioButton_2",args,n);

	/* Adding Callbacks for RadioButton_2 */ 

	XtAddCallback(RadioButton_2,XmNvalueChangedCallback, Choose_Display_Lin_log, G_LIN);

	XtManageChild(RadioButton_2);

	/* Creating RadioButton_3 Widget */ 

	n = 2;
	XtSetArg(args[n],XmNlabelString,
		XmStringLtoRCreate("log gray",
			XmSTRING_DEFAULT_CHARSET)); n++;

	RadioButton_3 = XmCreateToggleButton(RadioBox_1,
					     "RadioButton_3",args,n);

	/* Adding Callbacks for RadioButton_3 */ 

	XtAddCallback(RadioButton_3,XmNvalueChangedCallback, Choose_Display_Lin_log, G_LOG);

	XtManageChild(RadioButton_3);

	return(Display_Frame);
}



/********************************************************
/   Creation Function for InverseVideo 
/*******************************************************/

Widget
build_InverseVideo(pixeledit_widget)
	Widget pixeledit_widget;
{
	Widget InverseVideo_Frame;
	Widget RadioBox_1;
	Widget RadioButton_2;
	Widget RadioButton_3;
	Arg args[MAX_ARGS];
	int n;

	/* Creating InverseVideo_Frame Widget */ 

	n = 0;
	XtSetArg(args[n],XmNleftAttachment,XmATTACH_POSITION); n++;
	XtSetArg(args[n],XmNleftPosition, 15); n++;
	XtSetArg(args[n],XmNtopAttachment,XmATTACH_POSITION); n++;
	XtSetArg(args[n],XmNtopPosition,78); n++;

	InverseVideo_Frame = XmCreateFrame(pixeledit_widget,
				      "InverseVideo_Frame",args,n);
	XtManageChild(InverseVideo_Frame);

	/* Creating RadioBox_1 Widget */ 

	n = 0;
	XtSetArg(args[n],XmNentryClass,xmToggleButtonWidgetClass); n++;
	XtSetArg(args[n],XmNorientation,XmHORIZONTAL); n++;

	RadioBox_1 = XmCreateRadioBox(InverseVideo_Frame,
				      "RadioBox_1",args,n);
	XtManageChild(RadioBox_1);

	/* Creating RadioButton_2 Widget */ 

	n = 0;
	XtSetArg(args[n],XmNindicatorType,XmONE_OF_MANY); n++;
	XtSetArg(args[n],XmNfontList, gSmall_fontlist); n++;
	XtSetArg(args[n],XmNlabelString,
		XmStringLtoRCreate("Yes",
			XmSTRING_DEFAULT_CHARSET)); n++;

	RadioButton_2 = XmCreateToggleButton(RadioBox_1,
					     "RadioButton_2",args,n);

	/* Adding Callbacks for RadioButton_2 */ 

	XtAddCallback(RadioButton_2,XmNvalueChangedCallback, Choose_InverseVideo, INVERSE);

	XtManageChild(RadioButton_2);

	/* Creating RadioButton_3 Widget */ 

	n = 2;
	XtSetArg(args[n],XmNlabelString,
		XmStringLtoRCreate("No",
			XmSTRING_DEFAULT_CHARSET)); n++;
	XtSetArg(args[n],XmNset,true); n++;

	RadioButton_3 = XmCreateToggleButton(RadioBox_1,
					     "RadioButton_3",args,n);

	/* Adding Callbacks for RadioButton_3 */ 

	XtAddCallback(RadioButton_3,XmNvalueChangedCallback, Choose_InverseVideo, DIRECT);

	XtManageChild(RadioButton_3);

	return(InverseVideo_Frame);
}



/********************************************************
/   Creation Function for pixeledit_widget 
/*******************************************************/

void
build_pixelparam1_widget(pixeledit, pixeleditseparator, data_display)
	Widget pixeledit;
        Widget pixeleditseparator;
        xs_struc_display_menu * data_display;
{
	Widget pixeledit_widget;
	Widget Image_label;
	Widget Type_label;
	Widget Size_label;
	Widget Coordinate_label;
	Widget X_label;
	Widget Y_label;
	Widget Color_label;
	Widget separator;
	char *repfloat;
	Arg args[MAX_ARGS];
	int n;
	
	repfloat = (char *) malloc (20);

	/* Creating pixeledit_widget Widget */ 

	n = 0;

	XtSetArg(args[n],XmNbottomAttachment,XmATTACH_WIDGET); n++;
	XtSetArg(args[n],XmNbottomWidget,pixeleditseparator); n++;
	XtSetArg(args[n],XmNleftAttachment,XmATTACH_FORM); n++;
	XtSetArg(args[n],XmNresizePolicy,XmRESIZE_NONE); n++;
	XtSetArg(args[n],XmNrightAttachment,XmATTACH_POSITION); n++;
	XtSetArg(args[n],XmNrightPosition, 25); n++;
	XtSetArg(args[n],XmNtopAttachment,XmATTACH_FORM); n++;

	pixeledit_widget = 
           XmCreateForm(pixeledit,"pixeledit_widget",args,n);

	/* Creating Image_label Widget */ 

	sprintf(repfloat,"IMAGE: %s",data_display->im_desc->filename);
	n = 0;
	XtSetArg(args[n],XmNfontList, gFontlist); n++;
	XtSetArg(args[n],XmNlabelString,
		XmStringLtoRCreate(repfloat,
			XmSTRING_DEFAULT_CHARSET)); n++;
	XtSetArg(args[n],XmNleftAttachment,XmATTACH_POSITION); n++;
	XtSetArg(args[n],XmNleftPosition, 2); n++;
	XtSetArg(args[n],XmNtopAttachment,XmATTACH_POSITION); n++;
	XtSetArg(args[n],XmNtopPosition,5); n++;

	Image_label = 
	    XmCreateLabel(pixeledit_widget,"Image_label",args,n);
	XtManageChild(Image_label);

	/* Creating Type_label Widget */ 

/* data_display->im_desc->type: int ou char ???*/

	sprintf(repfloat,"TYPE: %s",data_display->im_desc->type);
	n = 0;
	XtSetArg(args[n],XmNfontList, gFontlist); n++;
	XtSetArg(args[n],XmNlabelString,
		XmStringLtoRCreate(repfloat,
			XmSTRING_DEFAULT_CHARSET)); n++;
	XtSetArg(args[n],XmNleftAttachment,XmATTACH_POSITION); n++;
	XtSetArg(args[n],XmNleftPosition, 2); n++;
	XtSetArg(args[n],XmNtopAttachment,XmATTACH_POSITION); n++;
	XtSetArg(args[n],XmNtopPosition,20); n++;

	Type_label = XmCreateLabel(pixeledit_widget,
				      "Type_label",args,n);
	XtManageChild(Type_label);

	/* Creating Size_label Widget */ 

	sprintf(repfloat,"SIZE: %d x %d pixels", 
	       data_display->im_desc->nligne,
	       data_display->im_desc->ncolonne);
	
	n = 0;
	XtSetArg(args[n],XmNfontList, gFontlist); n++;
	XtSetArg(args[n],XmNlabelString,
		XmStringLtoRCreate(repfloat,
			XmSTRING_DEFAULT_CHARSET)); n++;
	XtSetArg(args[n],XmNleftAttachment,XmATTACH_POSITION); n++;
	XtSetArg(args[n],XmNleftPosition,2); n++;
	XtSetArg(args[n],XmNtopAttachment,XmATTACH_POSITION); n++;
	XtSetArg(args[n],XmNtopPosition,30); n++;

	Size_label = XmCreateLabel(pixeledit_widget,"Size_label",args,n);

	XtManageChild(Size_label);

	/* Creating Coordinate_label Widget */ 

	n = 0;
	XtSetArg(args[n],XmNfontList, gFontlist); n++;
	XtSetArg(args[n],XmNlabelString,
		XmStringLtoRCreate("Coordinate tracker: ",
			XmSTRING_DEFAULT_CHARSET)); n++;
	XtSetArg(args[n],XmNleftAttachment,XmATTACH_POSITION); n++;
	XtSetArg(args[n],XmNleftPosition, 2); n++;
	XtSetArg(args[n],XmNtopAttachment,XmATTACH_POSITION); n++;
	XtSetArg(args[n],XmNtopPosition,45); n++;

	Coordinate_label = 
	    XmCreateLabel(pixeledit_widget,"Coordinate_label",args,n);
	XtManageChild(Coordinate_label);

	/* Creating X_label Widget */ 

	n = 0;
	XtSetArg(args[n],XmNfontList, gFontlist); n++;
	XtSetArg(args[n],XmNforeground, 255); n++;
	XtSetArg(args[n],XmNbackground, 0); n++;
	XtSetArg(args[n],XmNlabelString,
		XmStringLtoRCreate("X: ",
			XmSTRING_DEFAULT_CHARSET)); n++;
	XtSetArg(args[n],XmNleftAttachment,XmATTACH_POSITION); n++;
	XtSetArg(args[n],XmNleftPosition, 2); n++;
	XtSetArg(args[n],XmNtopAttachment,XmATTACH_POSITION); n++;
	XtSetArg(args[n],XmNtopPosition, 55); n++;

	X_label = XmCreateLabel(pixeledit_widget,"X_label",args,n);
	XtManageChild(X_label);

	data_display->label_pixeledit[0] = X_label;
	
	/* Creating Y_label Widget */ 

	n = 0;
	XtSetArg(args[n],XmNfontList, gFontlist); n++;
	XtSetArg(args[n],XmNforeground, 255); n++;
	XtSetArg(args[n],XmNbackground, 0); n++;
	XtSetArg(args[n],XmNlabelString,
		XmStringLtoRCreate("Y: ",
			XmSTRING_DEFAULT_CHARSET)); n++;
	XtSetArg(args[n],XmNleftAttachment,XmATTACH_POSITION); n++;
	XtSetArg(args[n],XmNleftPosition, 2); n++;
	XtSetArg(args[n],XmNtopAttachment,XmATTACH_POSITION); n++;
	XtSetArg(args[n],XmNtopPosition, 65); n++;

	Y_label = XmCreateLabel(pixeledit_widget,"Y_label",args,n);
	XtManageChild(Y_label);

	data_display->label_pixeledit[1] = Y_label;

	/* Creating Color_label Widget */ 

	n = 0;
	XtSetArg(args[n],XmNfontList, gFontlist); n++;
	XtSetArg(args[n],XmNforeground, 255); n++;
	XtSetArg(args[n],XmNbackground, 0); n++;
	XtSetArg(args[n],XmNlabelString,
		XmStringLtoRCreate("Color: ",
			XmSTRING_DEFAULT_CHARSET)); n++;
	XtSetArg(args[n],XmNleftAttachment,XmATTACH_POSITION); n++;
	XtSetArg(args[n],XmNleftPosition, 2); n++;
	XtSetArg(args[n],XmNtopAttachment,XmATTACH_POSITION); n++;
	XtSetArg(args[n],XmNtopPosition, 75); n++;

	Color_label = XmCreateLabel(pixeledit_widget,"Color_label",args,n);
	XtManageChild(Color_label);

	data_display->label_pixeledit[2] = Color_label;

	/* Creating separator Widget */ 

	n = 0;
	XtSetArg(args[n],XmNbottomAttachment,XmATTACH_FORM); n++;
	XtSetArg(args[n],XmNtopAttachment,XmATTACH_FORM); n++;
	XtSetArg(args[n],XmNleftAttachment,XmATTACH_NONE); n++;
	XtSetArg(args[n],XmNrightAttachment,XmATTACH_FORM); n++;
	XtSetArg(args[n],XmNorientation,XmVERTICAL); n++;

	separator = XmCreateSeparator(pixeledit_widget,
				      "separator",args,n);

	XtManageChild(separator);

	XtManageChild(pixeledit_widget);

	free(repfloat);
}




/********************************************************
/   Creation Function for pixeledit_widget 
/*******************************************************/

void
build_pixelparam2_widget(pixeledit, pixeleditseparator)
	Widget pixeledit;
        Widget pixeleditseparator;
{
	Widget pixeledit_widget;
	Widget Correction_zone_label;
	Widget Correction_zone_Frame;
	Widget Display_label;
	Widget Display_Frame;
	Widget InverseVideo_label;
	Widget InverseVideo_Frame;
	Widget separator;
	Arg args[MAX_ARGS];
	int n;

	/* Creating pixeledit_widget Widget */ 

	n = 0;

	XtSetArg(args[n],XmNbottomAttachment,XmATTACH_WIDGET); n++;
	XtSetArg(args[n],XmNbottomWidget,pixeleditseparator); n++;
	XtSetArg(args[n],XmNleftAttachment,XmATTACH_POSITION); n++;
	XtSetArg(args[n],XmNleftPosition, 26); n++;
	XtSetArg(args[n],XmNresizePolicy,XmRESIZE_NONE); n++;
	XtSetArg(args[n],XmNrightAttachment,XmATTACH_POSITION); n++;
	XtSetArg(args[n],XmNrightPosition, 64); n++;
	XtSetArg(args[n],XmNtopAttachment,XmATTACH_FORM); n++;

	pixeledit_widget = 
           XmCreateForm(pixeledit,"pixeledit_widget",args,n);

	/* Creating Correction_zone_label Widget */ 

	n = 0;
	XtSetArg(args[n],XmNfontList, gFontlist); n++;
	XtSetArg(args[n],XmNlabelString,
		XmStringLtoRCreate(paneltabs[408],
			XmSTRING_DEFAULT_CHARSET)); n++;
	XtSetArg(args[n],XmNleftAttachment,XmATTACH_POSITION); n++;
	XtSetArg(args[n],XmNleftPosition, 2); n++;
	XtSetArg(args[n],XmNtopAttachment,XmATTACH_POSITION); n++;
	XtSetArg(args[n],XmNtopPosition,8); n++;

	Correction_zone_label = 
	    XmCreateLabel(pixeledit_widget,"Correction_zone_label",args,n);
	XtManageChild(Correction_zone_label);

	/* Creating Correction_zone_Frame Widget */ 

	Correction_zone_Frame = build_Correction_zone(pixeledit_widget);

	/* Creating Display_label Widget */ 

	n = 0;
	XtSetArg(args[n],XmNfontList, gFontlist); n++;
	XtSetArg(args[n],XmNlabelString,
		XmStringLtoRCreate(paneltabs[409],
			XmSTRING_DEFAULT_CHARSET)); n++;
	XtSetArg(args[n],XmNleftAttachment,XmATTACH_POSITION); n++;
	XtSetArg(args[n],XmNleftPosition, 2); n++;
	XtSetArg(args[n],XmNtopAttachment,XmATTACH_POSITION); n++;
	XtSetArg(args[n],XmNtopPosition,38); n++;

	Display_label = XmCreateLabel(pixeledit_widget,
				      "Display_label",args,n);
	XtManageChild(Display_label);

	/* Creating Display_Frame Widget */ 

        Display_Frame = build_Display_Lin_Log(pixeledit_widget);

	/* Creating InverseVideo_label Widget */ 

	n = 0;
	XtSetArg(args[n],XmNfontList, gFontlist); n++;
	XtSetArg(args[n],XmNlabelString,
		XmStringLtoRCreate(paneltabs[412],
			XmSTRING_DEFAULT_CHARSET)); n++;
	XtSetArg(args[n],XmNleftAttachment,XmATTACH_POSITION); n++;
	XtSetArg(args[n],XmNleftPosition,2); n++;
	XtSetArg(args[n],XmNtopAttachment,XmATTACH_POSITION); n++;
	XtSetArg(args[n],XmNtopPosition,68); n++;

	InverseVideo_label = 
	       XmCreateLabel(pixeledit_widget,"InverseVideo_label",args,n);
	XtManageChild(InverseVideo_label);

	/* Creating InverseVideo_Frame Widget */ 

	InverseVideo_Frame = build_InverseVideo(pixeledit_widget);

	/* Creating separator Widget */ 

	n = 0;
	XtSetArg(args[n],XmNbottomAttachment,XmATTACH_FORM); n++;
	XtSetArg(args[n],XmNtopAttachment,XmATTACH_FORM); n++;
	XtSetArg(args[n],XmNleftAttachment,XmATTACH_NONE); n++;
	XtSetArg(args[n],XmNrightAttachment,XmATTACH_FORM); n++;
	XtSetArg(args[n],XmNorientation,XmVERTICAL); n++;

	separator = XmCreateSeparator(pixeledit_widget,
				      "separator",args,n);

	XtManageChild(separator);

	XtManageChild(pixeledit_widget);
}




Widget
build_pixel_edit_widget (Pixel_Edit_button, data_display, Couleur_Corr)
    Widget Pixel_Edit_button;
    xs_struc_display_menu * data_display;
    float Couleur_Corr;
{
	Widget pixeledit_mainwidget;
	Widget pixeledit_separator;
	Widget pixeledit_command;
	Widget pixeledit_REFRESH;
	Widget pixeledit_SAVE;
	Widget pixeledit_HELP;
	Widget pixeledit_QUIT;
	Widget pixeleditview;
	Widget Correct_color;
	Widget Correct_color_text;
	Widget Min_label;
	Widget Max_label;
	Window Windowview;
	int i, j, size, colorvalue;
        XImage *ximage_fleche, *ximage_color;
	Widget XmDrawingAreafleche_pixeledit, Color_pixeledit;
	Pixmap colorpixmap_pixeledit;
	unsigned char *pixeledit_data;
 	Widget pixeleditview_separator;
	Widget ScrolledWindow;
	Cursor cross_cursor;
	Arg args[MAX_ARGS];
	int n;
	Position  x, y;
	char *repfloat;
	
	repfloat = (char *) malloc (20);

	/* Creating pixeledit_mainwidget Widget */ 

	n = 0;
        XtSetArg(args[n],XmNwidth,720); n++;
        XtSetArg(args[n],XmNheight,370); n++;
	XtSetArg(args[n],XmNresizePolicy,XmRESIZE_NONE); n++;
	XtSetArg(args[n],XmNdialogTitle, 
	   XmStringLtoRCreate("pixeledit", XmSTRING_DEFAULT_CHARSET)); n++;

	pixeledit_mainwidget =
	     XmCreateFormDialog(Pixel_Edit_button,"pixeledit_mainwidget",args,n);

	/* Creating pixeledit_command Widget */ 

	n = 0;
	XtSetArg(args[n],XmNbottomAttachment,XmATTACH_FORM); n++;
	XtSetArg(args[n],XmNleftAttachment,XmATTACH_FORM); n++;
	XtSetArg(args[n],XmNresizePolicy,XmRESIZE_NONE); n++;
	XtSetArg(args[n],XmNrightAttachment,XmATTACH_FORM); n++;
	XtSetArg(args[n],XmNtopAttachment,XmATTACH_NONE); n++;

	pixeledit_command = 
	  XmCreateForm(pixeledit_mainwidget,"pixeledit_command",args,n);
	XtManageChild(pixeledit_command);

	/* Creating pixeledit_REFRESH Widget */ 

	n = 0;
	XtSetArg(args[n],XmNbottomAttachment,XmATTACH_FORM); n++;
	XtSetArg(args[n],XmNfontList, gFontlist); n++;
	XtSetArg(args[n],XmNlabelString,
		XmStringLtoRCreate(paneltabs[316],
			XmSTRING_DEFAULT_CHARSET)); n++;
	XtSetArg(args[n],XmNleftAttachment,XmATTACH_POSITION); n++;
	XtSetArg(args[n],XmNleftPosition,4); n++;
	XtSetArg(args[n],XmNrightAttachment,XmATTACH_POSITION); n++;
	XtSetArg(args[n],XmNrightPosition,24); n++;
	XtSetArg(args[n],XmNtopAttachment,XmATTACH_FORM); n++;

	pixeledit_REFRESH = 
	    XmCreatePushButton(pixeledit_command,"pixeledit_REFRESH",args,n);
	XtManageChild(pixeledit_REFRESH);


	/* Creating pixeledit_SAVE Widget */ 

	n = 0;
	XtSetArg(args[n],XmNbottomAttachment,XmATTACH_FORM); n++;
	XtSetArg(args[n],XmNfontList, gFontlist); n++;
	XtSetArg(args[n],XmNlabelString,
		XmStringLtoRCreate(paneltabs[304],
			XmSTRING_DEFAULT_CHARSET)); n++;
	XtSetArg(args[n],XmNleftAttachment,XmATTACH_POSITION); n++;
	XtSetArg(args[n],XmNleftPosition,28); n++;
	XtSetArg(args[n],XmNrightAttachment,XmATTACH_POSITION); n++;
	XtSetArg(args[n],XmNrightPosition,48); n++;
	XtSetArg(args[n],XmNtopAttachment,XmATTACH_FORM); n++;

	pixeledit_SAVE = 
		XmCreatePushButton(pixeledit_command,"pixeledit_SAVE",args,n);
	XtManageChild(pixeledit_SAVE);

	/* Creating pixeledit_HELP Widget */

	n = 0;
	XtSetArg(args[n],XmNbottomAttachment,XmATTACH_FORM); n++;
	XtSetArg(args[n],XmNfontList, gFontlist); n++;
	XtSetArg(args[n],XmNlabelString,
		XmStringLtoRCreate(paneltabs[312],
			XmSTRING_DEFAULT_CHARSET)); n++;
	XtSetArg(args[n],XmNleftAttachment,XmATTACH_POSITION); n++;
	XtSetArg(args[n],XmNleftPosition,52); n++;
	XtSetArg(args[n],XmNrightAttachment,XmATTACH_POSITION); n++;
	XtSetArg(args[n],XmNrightPosition,72); n++;
	XtSetArg(args[n],XmNtopAttachment,XmATTACH_FORM); n++;
	XtSetArg(args[n],XmNsensitive,False); n++;

	pixeledit_HELP = 
		XmCreatePushButton(pixeledit_command,"pixeledit_HELP",args,n);
	XtManageChild(pixeledit_HELP);

	/* Adding Callbacks for pixeledit_HELP */ 

/*	XtAddCallback(pixeledit_HELP, XmNactivateCallback,
		      pixeledit_HELP_callb, pixeledit_mainwidget);
*/
	/* Creating pixeledit_QUIT Widget */ 

	n = 0;
	XtSetArg(args[n],XmNbottomAttachment,XmATTACH_FORM); n++;
	XtSetArg(args[n],XmNfontList, gFontlist); n++;
	XtSetArg(args[n],XmNlabelString,
		XmStringLtoRCreate(paneltabs[313],
			XmSTRING_DEFAULT_CHARSET)); n++;
	XtSetArg(args[n],XmNleftAttachment,XmATTACH_POSITION); n++;
	XtSetArg(args[n],XmNleftPosition,76); n++;
	XtSetArg(args[n],XmNrightAttachment,XmATTACH_POSITION); n++;
	XtSetArg(args[n],XmNrightPosition,96); n++;
	XtSetArg(args[n],XmNtopAttachment,XmATTACH_FORM); n++;

	pixeledit_QUIT = 
		XmCreatePushButton(pixeledit_command,"pixeledit_QUIT",args,n);
	XtManageChild(pixeledit_QUIT);

	/* Adding Callbacks for pixeledit_QUIT */ 

	XtAddCallback(pixeledit_QUIT,
	      XmNactivateCallback,pixeledit_QUIT_callb, data_display);
	XtAddCallback(pixeledit_QUIT,
	   XmNactivateCallback, keep_sensitive_button, Pixel_Edit_button);

	/* Creating pixeledit_separator Widget */ 

	n = 0;
	XtSetArg(args[n],XmNbottomAttachment,XmATTACH_WIDGET); n++;
	XtSetArg(args[n],XmNbottomWidget, pixeledit_command); n++;
	XtSetArg(args[n],XmNleftAttachment,XmATTACH_FORM); n++;
	XtSetArg(args[n],XmNrightAttachment,XmATTACH_FORM); n++;

	pixeledit_separator = 
		XmCreateSeparator(pixeledit_mainwidget,
				  "pixeledit_separator",args,n);

	XtManageChild(pixeledit_separator);


	/* Creating pixeleditview Widget */ 

	n = 0;
/*        XtSetArg(args[n],XmNwidth,530); n++;*/
        XtSetArg(args[n],XmNheight,90); n++;
	XtSetArg(args[n],XmNbottomAttachment,XmATTACH_WIDGET); n++;
	XtSetArg(args[n],XmNbottomWidget,pixeledit_separator); n++;
	XtSetArg(args[n],XmNleftAttachment,XmATTACH_FORM); n++;
	XtSetArg(args[n],XmNresizePolicy,XmRESIZE_NONE); n++;
	XtSetArg(args[n],XmNrightAttachment,XmATTACH_FORM); n++;
	XtSetArg(args[n],XmNtopAttachment,XmATTACH_NONE); n++;

	pixeleditview = 
	  XmCreateForm(pixeledit_mainwidget,"pixeleditview",args,n);

	XtManageChild(pixeleditview);

	pixeleditpixmap = XCreatePixmap(gDisplay,
				  XDefaultRootWindow(gDisplay),
				  512, 20, 8);
	size = 512 * 20;
	
	pixeledit_data = (unsigned char *)malloc(size); 

	ximage_pixeledit = XCreateImage(gDisplay, gVisual,
			8, ZPixmap, 0, (char *)pixeledit_data,
			512, 20, 8, 0);
	for (j = 0; j<20; j++) 
	  for (i = 0; i<256; i++) 
	  {
	  *pixeledit_data = i;
	  pixeledit_data++;
	  *pixeledit_data = i;
	  pixeledit_data++;
	  }
	XPutImage(gDisplay, pixeleditpixmap, default_gc,
	    ximage_pixeledit, 0, 0, 0, 0, 512, 20);
/*	XDestroyImage(ximage_pixeledit);*/
	free(pixeledit_data);

	n = 0;
	XtSetArg(args[n],XmNbackgroundPixmap, pixeleditpixmap); n++;
	XtSetArg(args[n],XmNtopAttachment,XmATTACH_POSITION); n++;
	XtSetArg(args[n],XmNtopPosition, 70); n++;
	XtSetArg(args[n],XmNleftAttachment,XmATTACH_POSITION); n++;
	XtSetArg(args[n],XmNleftPosition, 12); n++;
	XtSetArg(args[n],XmNwidth, 512); n++;
	XtSetArg(args[n],XmNheight, 20); n++;
	XmDrawingAreapixeledit = XtCreateWidget("XmDrawingAreapixeledit",
					      xmDrawingAreaWidgetClass,
					      pixeleditview, args, n);
 
	XtManageChild(XmDrawingAreapixeledit);

	/* Correct_color label */

	n = 0;
	XtSetArg(args[n],XmNfontList, gFontlist); n++;
	XtSetArg(args[n],XmNlabelString,
		XmStringLtoRCreate("Correction color : ",
			XmSTRING_DEFAULT_CHARSET)); n++;
	XtSetArg(args[n],XmNtopAttachment,XmATTACH_POSITION); n++;
	XtSetArg(args[n],XmNtopPosition, 17); n++;
	XtSetArg(args[n],XmNleftAttachment,XmATTACH_POSITION); n++;
	XtSetArg(args[n],XmNleftPosition, 15); n++;

	Correct_color = 
	     XtCreateWidget("Correct_color", xmLabelWidgetClass,
			    pixeleditview, args, n);

	XtManageChild(Correct_color);


	/* Create Correct_color_text Widget */

	n = 0;
	XtSetArg(args[n],XmNtopAttachment,XmATTACH_POSITION); n++;
	XtSetArg(args[n],XmNtopPosition, 15); n++;
	XtSetArg(args[n],XmNleftAttachment,XmATTACH_WIDGET); n++;
	XtSetArg(args[n],XmNleftWidget, Correct_color); n++;
	XtSetArg(args[n],XmNfontList, gSmall_fontlist); n++;

	Correct_color_text = 
	     XtCreateWidget("Correct_color_text", xmTextWidgetClass,
			    pixeleditview, args, n);
	XtManageChild(Correct_color_text);

	data_display->Couleur_correct = Correct_color_text;
	
        sprintf(repfloat,"%f", Couleur_Corr);
	XmTextSetString(Correct_color_text, repfloat); 


	colorpixmap_pixeledit = XCreatePixmap(gDisplay,
				  XDefaultRootWindow(gDisplay),
				  35, 35, 8);
	size = 35 * 35;
	
	pixeledit_data = (unsigned char *)malloc(size); 

	ximage_color = XCreateImage(gDisplay, gVisual,
			8, ZPixmap, 0, (char *)pixeledit_data,
		        35, 35, 8, 0);

	colorvalue = nint((double)Couleur_Corr);
	
        for (i = 0; i<size; i++) 
        {
	  *pixeledit_data = colorvalue;
	  pixeledit_data++;
	}

	XPutImage(gDisplay, colorpixmap_pixeledit, default_gc,
	    ximage_color, 0, 0, 0, 0, 35, 35);
	XDestroyImage(ximage_color);
	free(pixeledit_data);

	n = 0;
	XtSetArg(args[n],XmNbackgroundPixmap, colorpixmap_pixeledit); n++;
	XtSetArg(args[n],XmNtopAttachment,XmATTACH_POSITION); n++;
	XtSetArg(args[n],XmNtopPosition,12); n++;
	XtSetArg(args[n],XmNleftAttachment,XmATTACH_POSITION); n++;
	XtSetArg(args[n],XmNleftPosition, 55); n++;
	XtSetArg(args[n],XmNwidth, 35); n++;
	XtSetArg(args[n],XmNheight, 35); n++;
	Color_pixeledit = XtCreateWidget("Color_pixeledit",
				     xmDrawingAreaWidgetClass,
				     pixeleditview, args, n);

	XtManageChild(Color_pixeledit);

	/* Min et Max labels */

	n = 0;
	XtSetArg(args[n],XmNfontList, gFontlist); n++;
	XtSetArg(args[n],XmNalignment, XmALIGNMENT_END); n++;
	XtSetArg(args[n],XmNlabelString,
		XmStringLtoRCreate("0",
			XmSTRING_DEFAULT_CHARSET)); n++;
	XtSetArg(args[n],XmNtopAttachment,XmATTACH_POSITION); n++;
	XtSetArg(args[n],XmNtopPosition, 70); n++;
	XtSetArg(args[n],XmNleftAttachment,XmATTACH_POSITION); n++;
	XtSetArg(args[n],XmNleftPosition, 2); n++;
	XtSetArg(args[n],XmNrightAttachment,XmATTACH_POSITION); n++;
	XtSetArg(args[n],XmNrightPosition, 10); n++;

	Min_label = XtCreateWidget("Min_label", xmLabelWidgetClass,
				   pixeleditview, args, n);
	XtManageChild(Min_label);

	n = 0;
	XtSetArg(args[n],XmNfontList, gFontlist); n++;
	XtSetArg(args[n],XmNalignment, XmALIGNMENT_BEGINNING); n++;
	XtSetArg(args[n],XmNlabelString,
		XmStringLtoRCreate("255",
			XmSTRING_DEFAULT_CHARSET)); n++;
	XtSetArg(args[n],XmNtopAttachment,XmATTACH_POSITION); n++;
	XtSetArg(args[n],XmNtopPosition, 70); n++;
	XtSetArg(args[n],XmNrightAttachment,XmATTACH_POSITION); n++;
	XtSetArg(args[n],XmNrightPosition, 98); n++;
	XtSetArg(args[n],XmNleftAttachment,XmATTACH_POSITION); n++;
	XtSetArg(args[n],XmNleftPosition, 88); n++;

	Max_label = XtCreateWidget("Max_label", xmLabelWidgetClass,
				   pixeleditview, args, n);
 
	XtManageChild(Max_label);

	flechepixmap_pixeledit = XCreatePixmap(gDisplay,
				  XDefaultRootWindow(gDisplay),
				  512, 10, 8);
	size = 512 * 10;
	
	pixeledit_data = (unsigned char *)malloc(size); 

	ximage_fleche = XCreateImage(gDisplay, gVisual,
			8, ZPixmap, 0, (char *)pixeledit_data,
			512, 10, 8, 0);
        for (i = 0; i<size; i++) 
	  {
	  *pixeledit_data = 0;
	  pixeledit_data++;
	  }
	XPutImage(gDisplay, flechepixmap_pixeledit, default_gc,
	    ximage_fleche, 0, 0, 0, 0, 512, 10);
	XDestroyImage(ximage_fleche);
	free(pixeledit_data);

	n = 0;
	XtSetArg(args[n],XmNbackgroundPixmap, flechepixmap_pixeledit); n++;
	XtSetArg(args[n],XmNtopAttachment,XmATTACH_POSITION); n++;
	XtSetArg(args[n],XmNtopPosition,60); n++;
	XtSetArg(args[n],XmNleftAttachment,XmATTACH_POSITION); n++;
	XtSetArg(args[n],XmNleftPosition, 12); n++;
	XtSetArg(args[n],XmNbottomAttachment,XmATTACH_POSITION); n++;
	XtSetArg(args[n],XmNbottomPosition, 70); n++;
	XtSetArg(args[n],XmNwidth, 512); n++;
	XmDrawingAreafleche_pixeledit = 
	              XtCreateWidget("XmDrawingAreafleche_pixeledit",
				     xmDrawingAreaWidgetClass,
				     pixeleditview, args, n);
 
	XtManageChild(XmDrawingAreafleche_pixeledit);

	/* Creating pixeleditview_separator Widget */ 

	n = 0;
	XtSetArg(args[n],XmNbottomAttachment,XmATTACH_WIDGET); n++;
	XtSetArg(args[n],XmNbottomWidget, pixeleditview); n++;
	XtSetArg(args[n],XmNleftAttachment,XmATTACH_FORM); n++;
	XtSetArg(args[n],XmNrightAttachment,XmATTACH_FORM); n++;

	pixeleditview_separator = 
	XmCreateSeparator(pixeledit_mainwidget,"pixeleditview_separator",args,n);

	XtManageChild(pixeleditview_separator);


	build_pixelparam1_widget(pixeledit_mainwidget, 
				 pixeleditview_separator, data_display);

	build_pixelparam2_widget(pixeledit_mainwidget, 
				 pixeleditview_separator);       


	/* Creating ScrolledWindow Widget */ 

	n = 0;
	XtSetArg(args[n], XmNtopAttachment, XmATTACH_FORM); n++;
	XtSetArg(args[n], XmNrightAttachment, XmATTACH_FORM); n++;
	XtSetArg(args[n], XmNleftAttachment, XmATTACH_POSITION);n++;
	XtSetArg(args[n], XmNleftPosition, 65);n++;
	XtSetArg(args[n], XmNbottomAttachment, XmATTACH_WIDGET);n++;
	XtSetArg(args[n], XmNbottomWidget,pixeleditview_separator); n++;
	XtSetArg(args[n], XmNscrollingPolicy, XmAUTOMATIC);n++;
	ScrolledWindow = XtCreateManagedWidget("ScrolledWindow", 
					  xmScrolledWindowWidgetClass,
					  pixeledit_mainwidget, args, n);

	n = 0;
	XtSetArg(args[n], XmNwidth, 240);n++;
	XtSetArg(args[n], XmNheight, 240);n++;
	Magnify_drawing = 
	  XtCreateWidget("Magnify_drawing", xmDrawingAreaWidgetClass,
				   ScrolledWindow, args, n);
	XtManageChild(Magnify_drawing);

	n = 0;
	XtSetArg(args[n], XmNworkWindow, Magnify_drawing); n++;
	XtSetValues(ScrolledWindow, args, n);
	XtManageChild(ScrolledWindow);


	/* Adding Callbacks for pixeledit_REFRESH */ 

	XtAddCallback(pixeledit_REFRESH,
		XmNactivateCallback,pixeledit_REFRESH_callb, data_display);

	/* Adding Callbacks for pixeledit_SAVE */ 

	XtAddCallback(pixeledit_SAVE,
		XmNactivateCallback,pixeledit_SAVE_callb, data_display);


	/* Adding Callbacks for XmDrawingAreafleche_pixeledit */ 

	XtAddEventHandler((Widget)XmDrawingAreafleche_pixeledit, 
			  ButtonPressMask,False,
			  (XtEventHandler)Color_selected, 
			  data_display->Couleur_correct);

	cross_cursor = XCreateFontCursor(gDisplay, XC_tcross);

	XDefineCursor(gDisplay, XtWindow(data_display->Drawing_Area),
		      cross_cursor);

	XtAddEventHandler(data_display->Drawing_Area, 
			  PointerMotionMask, 
			  FALSE,track_mouse_pixeledit, data_display);

	XtAddEventHandler(data_display->Drawing_Area, 
			  LeaveWindowMask, 
			  FALSE, uninstall_pixeledit, data_display);
	  
	XtAddEventHandler(data_display->Drawing_Area, 
		      ButtonPressMask | ButtonReleaseMask | ButtonMotionMask, 
			 FALSE, PIXEL_Couleur_Corr_Notify_Proc, data_display);

	/* Adding Callbacks for Correct_color_text */ 

        XtAddCallback (Correct_color_text, XmNvalueChangedCallback,
		       update_fleche_color, XmDrawingAreafleche_pixeledit);

        XtAddCallback (Correct_color_text, XmNvalueChangedCallback,
		       change_color_value, Color_pixeledit);


	free(repfloat);
	
	return(pixeledit_mainwidget);

}



