/* SCCS @(#)histogram.c	1.1  12/2/92 */
/************************************************************************/
/************************************************************************/
/*                                                                      */
/*                       histogram.c                                    */
/*                                                                      */
/************************************************************************/
/************************************************************************/
/*                                                                      */
/* FILENAME     :   histogram.c                                         */
/*                                                                      */
/* DESCRIPTION  :   LaboImage (Histogram Image)                         */
/*                                                                      */
/* AUTHORS      :   Marianne Logean                                     */
/*                                                                      */
/* VERSION      :   1.0                                                 */
/*                                                                      */
/* HISTORY      :   1.12.92                                             */
/*                  MAL         Created    version: 1.0                 */
/*                                                                      */
/* Copyright  1992 by CUI/UIN/HCUG, All rights reserved.                */
/*                                                                      */
/************************************************************************/
/************************************************************************/

#include <math.h>
#include <stdio.h>

#include <X11/Intrinsic.h>

#include "libwidgets/widgetstructure.h"
#include "Display/displayplane.h"
#include "Display/displayplane.callback.h"

extern  GC default_gc;   

/***************************************************************************/

Pixmap 	data_pixmap;

get_pixel_by_name (w, colorname)
   Widget w;
   char *colorname;
{
 Display *dpy = XtDisplay(w);
 int scr = DefaultScreen(dpy);
 Colormap cmap = DefaultColormap (dpy, scr);
 XColor color, ignore;

 if (XAllocNamedColor (dpy, cmap, colorname, &color, &ignore))
    return (color.pixel);
 else
 {
   printf("Warning: Coudn't allocate color %s\n", colorname);
   return (BlackPixel(dpy, scr));
 }
}



/*****************************************************************************/


affiche_histo (nodep, histo)
    int	nodep;
    struct description_vecteur *histo;
{
    int fli, fco, haut, maxhist, pas, *tab_hist, *temp, drawNb, curr_x;
    char titre[80];
    register int i,j;
    struct histogr *ih;
    struct description_vecteur *dv;
    xs_struc_histo * histoparam;

    dv = (struct description_vecteur *)malloc(sizeof(*dv));
    *dv = *histo;

    ih = (struct histogr *)histo->prive;
    fli = ih->haut_barre;
    fco = histo->ncase * ih->larg_barre;

    histoparam = display_histogram(fco, fli, dv);

    data_pixmap = NULL;

    data_pixmap = XCreatePixmap(XtDisplay(histoparam->canvas),
			 XtWindow(histoparam->canvas), fco, fli, 
			 DefaultDepthOfScreen (XtScreen(histoparam->canvas)));

    XtAddCallback (histoparam->canvas, XmNexposeCallback, redisplay, 
		   data_pixmap);

    XSetForeground (XtDisplay(histoparam->canvas), default_gc, 
		    get_pixel_by_name (histoparam->canvas, "white"));
    XFillRectangle(XtDisplay(histoparam->canvas), data_pixmap, default_gc, 
		   0, 0, fco, fli);
    pas = 0;
    temp = (int *)malloc(histo->ncase * sizeof(*temp));
    ((struct histogr *)(dv->prive))->tab_hist = temp;
    tab_hist = (int *)dir_vecteur[nodep].image;
    XSetForeground (XtDisplay(histoparam->canvas), default_gc, 
		    get_pixel_by_name (histoparam->canvas, "black"));
    curr_x = 0;
    for (i=0; i<histo->ncase; i++){
        haut = *(tab_hist) * ih->haut_barre / histo->vmax;
	for (drawNb = 0; drawNb < ih->larg_barre; drawNb++)
	{
	   XDrawLine (XtDisplay(histoparam->canvas), data_pixmap, default_gc, 
		      curr_x, fli-haut, curr_x, fli);
	   curr_x++;
	}
	*temp = *tab_hist;
	tab_hist++;  temp++;
	pas += ih->larg_barre;
    }
    XCopyArea (XtDisplay(histoparam->canvas), data_pixmap, 
	       XtWindow (histoparam->canvas), default_gc, 0, 0, 
	       fco, fli, 0, 0);
}


