;**************************************************************************
;** psmacs.cl                                                            **
;**                                                                      **
;**  Ce programme contient les macros auxilieres de PSYCHOSES            **
;**                                                                      **
;**  Claudia Rosu-Coiteux                                   Juillet 1989 **
;**************************************************************************
;** Macros:                                                              **
;**   push-cdr                psy-error             psy-warn             **
;**************************************************************************
;** Cette macro ajoute des elements a la fin d'une liste                 **
(defmacro push-cdr (lst &rest x)
  (cond ((onep (length x))
	   `(rplacd ,lst (cons ,(car x) (cdr ,lst))))
	(t `(rplacd ,lst (append ,x (cdr ,lst))))))


;** Cette macro indique une erreur dans le systeme                       **
(defmacro psy-error (&rest msg)
 `(progn (msg "Erreur: " ,@msg #\N)
	 (setq *System-Production-Error* t)))


;** Cette macro previent sur une possible erreur l'utilisateur           **
(defmacro psy-warn (&rest msg)
 `(msg "ATTENTION DANGER: " ,@msg  #\N))

