 /*****************************************************************************/
/* module geometrie.c							     */
/*									     */
/* Author: Alain Jacot-Descombes					     */
/*	   Labo Image							     */
/*	   Computing Science Center					     */
/*	   University of Geneva, Switzerland				     */
/* Date:   January 1989							     */
/* Modifications:   April 2, 1989: some cleaning.			     */
/* Copyright (c) A. Jacot-Descombes, T. Pun, C. Pellegrini, Uni. of Geneva   */
/* (This copyright notice should appear).				     */
/*									     */
/*****************************************************************************/
#include <suntool/sunview.h>
#include <suntool/panel.h>
#include <math.h>

#include "define.h"
#include "structure.h"
#include "global.h"
#include "type.h"

#define EPSILON 0.0000001

Frame	    frame_affin;
Panel	    panel_affin;
Panel_item  affin_c1, affin_c2;

extern void hproc_opgeom_rotate();
extern void hproc_opgeom_translate();
extern void hproc_opgeom_scaleT();
extern void hproc_opgeom_scaleF();
extern void hproc_opgeom_transpose();
extern void hproc_opgeom_sym_x();
extern void hproc_opgeom_sym_y();

extern char *paneltabs[];
extern char *mastertabs[];
extern char *labeltabs[];

int AffineTransf();

/*****************************************************************************/

static	Panel_setting lire_affin(item, event)
    Panel_item	item;
    Event	*event;

{
    static  struct  affin   affi;
    
    if (event_id(event) == CTRLC) {
        /* demande d'interruption de l'interaction par l'utilisateur */
	flag_break = TRUE;
        window_return (NULL);
        window_destroy (frame_affin);
        return;
    }
    else { 
        if (event_id(event) == '\t')
	    return (PANEL_NEXT);
        else {
	    affi.c1 = atof((char *) panel_get (affin_c1, PANEL_VALUE));
	    if (affin_c2 != NULL) affi.c2 = atof((char *) panel_get (affin_c2, PANEL_VALUE));
	    window_return(&affi);
	    window_destroy (frame_affin);
	    return;
	}
    }
}

/*****************************************************************************/

struct	affin	*affin_panel (mode)
    int	mode;
{
    Panel_item titre;
    char stitre[30], rep[20];
    struct affin *affi;
    
    frame_affin = window_create (frame, FRAME, WIN_X, 500, WIN_Y, 500,
                         FRAME_NO_CONFIRM, TRUE, 0);
    panel_affin = window_create (frame_affin, PANEL, PANEL_LABEL_BOLD,
			 TRUE, 0);
    
    if (flag_exec == MANUEL || flag_exec == FROMTO_AUTO)
	affi = (struct affin *)(macro_cour->param);
    else affi = NULL;

    switch (mode) {
	case 0 : strcpy (stitre, "ROTATION\n"); break;
	case 1 : strcpy (stitre, "TRANSLATION\n"); break;
    	case 2 : strcpy (stitre, paneltabs[194]); break;
	case 3 : strcpy (stitre, paneltabs[195]); break;
    }
    titre = panel_create_item (panel_affin, PANEL_MESSAGE,
                       PANEL_SHOW_ITEM, TRUE,
		       PANEL_LABEL_X, ATTR_COL(0),
		       PANEL_LABEL_Y, ATTR_ROW(0),
                       PANEL_LABEL_STRING, stitre,
                       0);
    switch (mode) {
	case 0 : strcpy (stitre, paneltabs[196]); break;
	case 1 :
	case 2 :
        case 3 : strcpy (stitre, "x : \n"); break;
    }
    if (flag_exec == MANUEL || flag_exec == FROMTO_AUTO)
	sprintf (rep, "%f", affi->c1);
    else strcpy (rep, "");    
    affin_c1 = panel_create_item (panel_affin, PANEL_TEXT,
                       PANEL_SHOW_ITEM, TRUE,
		       PANEL_LABEL_X, ATTR_COL(1),
		       PANEL_LABEL_Y, ATTR_ROW(2),
                       PANEL_VALUE_DISPLAY_LENGTH, 20,
                       PANEL_VALUE_STORED_LENGTH, 20,
                       PANEL_LABEL_STRING, stitre,
                       PANEL_VALUE, rep,
                       PANEL_NOTIFY_STRING, "\r\n\t\03",
                       PANEL_NOTIFY_PROC, lire_affin,
                       0);
    if (mode != 0) {
	strcpy (stitre, "y : \n");
	if (flag_exec == MANUEL || flag_exec == FROMTO_AUTO)
	    sprintf (rep, "%f", affi->c2);
	else strcpy (rep, "");    
        affin_c2 = panel_create_item (panel_affin, PANEL_TEXT,
                       PANEL_SHOW_ITEM, TRUE,
		       PANEL_LABEL_X, ATTR_COL(1),
		       PANEL_LABEL_Y, ATTR_ROW(3),
                       PANEL_VALUE_DISPLAY_LENGTH, 20,
                       PANEL_VALUE_STORED_LENGTH, 20,
                       PANEL_LABEL_STRING, stitre,
                       PANEL_VALUE, rep,
                       PANEL_NOTIFY_STRING, "\r\n\t\03",
                       PANEL_NOTIFY_PROC, lire_affin,
                       0);
    }
    else affin_c2 = NULL;
    window_fit (panel_affin);
    window_fit (frame_affin);
    window_set (panel_affin, PANEL_CARET_ITEM, affin_c1, 0);
    affi = (struct affin *)window_loop(frame_affin);
    return (affi);
}

/*****************************************************************************/

caddr_t proc_affin (m, mi)
    Menu	m;
    Menu_item	mi;
{ /* beg */
    struct  affin   *affi, *copyaffi;
    int	    mode, isx1, isy1, isx2, isy2, isw, *jp;
    float   t[3][2];
    float   anglerad;
    int	    *image, flag_conv, flag_autoconvert;

	mode = (int) menu_get (mi, MENU_VALUE);
        if (flag_bother){
	    switch (mode){
		case 0:    if (flag_bother) hproc_opgeom_rotate();
			break;
		case 1:    if (flag_bother) hproc_opgeom_translate();
			break;
		case 2:    if (flag_bother) hproc_opgeom_scaleT();
			break;
		case 3:    if (flag_bother) hproc_opgeom_scaleF();
			break;
	    }
	    return;
	}
        if (flag_help){
	    switch (mode){
		case 0:    if (flag_help) hproc_opgeom_rotate();
			break;
		case 1:    if (flag_help) hproc_opgeom_translate();
			break;
		case 2:    if (flag_help) hproc_opgeom_scaleT();
			break;
		case 3:    if (flag_help) hproc_opgeom_scaleF();
			break;
	    }
	}

    t[0][0] = t[0][1] = t[1][0] = t[1][1] = t[2][0] = t[2][1] = 0.0;

    if (!flag_creer) {
	sprintf (buf, mastertabs[85]);
	write_master (buf);
    }
    if (flag_exec == AUTO || flag_exec == FROMTO_AUTO){
	index_image[0] = macro_cour->from[0];
	index_image[1] = macro_cour->to[0];
    }
    else fromto (FROMTO, DEFAUT);
    if (flag_break) interruption();
    else {
	if (!flag_creer){
	    sprintf (buf, "%d  --> %d ",
		    index_image[0],index_image[1]);
	    write_master (buf);
	}

	if (flag_exec == AUTO || flag_exec == PARAM_AUTO){
	    affi = (struct affin *)malloc(sizeof(*affi));
	    *affi = *((struct affin *)macro_cour->param);
	}
	else affi = affin_panel(mode);
	if (flag_break) interruption();
	else{
	    if (flag_creer){
		struct commande *com;
		com = (struct commande *)new_commande (&macro_cour);
		com->from[0] = index_image[0];
		com->to[0] = index_image[1];
		switch (mode){
		    case 0:
			sprintf (buf, "AUXGOPROT FROM %d TO %d WITH %f\n",
				index_image[0], index_image[1], affi->c1);
			sprintf (com->nom, "AUXGOPROT");
			com->code = 110;
			break;
		    case 1:
			sprintf (buf, "AUXGOPTRA FROM %d TO %d WITH %d %d\n",
				index_image[0],index_image[1],
				(int)affi->c1,(int)affi->c2);
			sprintf (com->nom, "AUXGOPTRA");
			com->code = 111;
			break;
		    case 2:
			sprintf (buf, "AUXGOPSCS FROM %d TO %d WITH %d %d\n",
				index_image[0],index_image[1],
				(int)affi->c1,(int)affi->c2);
			sprintf (com->nom, "AUXGOPSCS");
			com->code = 112;
			break;
		    case 3:
			sprintf (buf, "AUXGOPSCF FROM %d TO %d WITH %f %f\n",
				index_image[0], index_image[1],
				affi->c1, affi->c2);
			sprintf (com->nom, "AUXGOPSCF");
			com->code = 113;
			break;
		}
		write_macro(buf);
		copyaffi = (struct affin *)malloc(sizeof(*affi));
		*copyaffi = *affi;
		com->param = (char *)copyaffi;
	    }
	    else{
		switch (dir_desc[index_image[0]].type){
		    case -1:
		    case 0:
		    case 1:flag_conv = TRUE;
			   image = (int *) conv_int (index_image[0]);
			   break;
		    case 2:flag_conv = FALSE;
			   image = (int *)dir_image[index_image[0]].image;
			   break;
		    case 3:
		    case 4:
		    case 5:flag_autoconvert = TRUE;
			   autoconvert_integer (index_image[0]);
			   image = (int *)buffer_image[0].image;
			   break;
		}
 
/*		if (dir_desc[index_image[0]].type > 2)
		    write_erreur(11);
		else { 
		    if (dir_desc[index_image[0]].type == 2) {
			flag_conv = FALSE;
			image = (int *)dir_image[index_image[0]].image;
		    }
		    else {
			flag_conv = TRUE;
			image = (int *) conv_int (index_image[0]);
		    }
*/
		    switch (mode){  /* construction matrice+logfile */
			case 0:	{   /* rotation */
			    sprintf (buf, mastertabs[86],affi->c1);
			    isx2 = dir_desc[index_image[0]].ncolonne;
			    isy2 = dir_desc[index_image[0]].nligne;
			    anglerad = affi->c1 / 180 * M_PI;		    
			    t[0][0] = t[1][1] = cos(anglerad);
			    t[0][1] = -sin(anglerad);
			    t[1][0] = sin(anglerad);
			    t[2][0] =(isx2+1)/2*(1-t[0][0])-(isy2+1)/2*t[1][0];
			    t[2][1] = -(isx2+1)/2*t[0][1] +
				      (isy2+1)/2*(1-t[1][1]);
			    break;
			}
			case 1:	{   /* translation */
			    sprintf (buf, 
				    "  Translation x = %d y = %d\n",
				    (int)rint(affi->c1),(int)rint(affi->c2));
			    isx2 = dir_desc[index_image[0]].ncolonne;
			    isy2 = dir_desc[index_image[0]].nligne;
			    t[0][0] = t[1][1] = 1;
			    t[2][0] = affi->c1;
			    t[2][1] = -affi->c2;
			    break;
			}
			case 2:	{   /* scaling taille */
			    sprintf (buf, mastertabs[87], (int)rint(affi->c1),(int)rint(affi->c2));
			    isx2 = (int)rint((double)affi->c1);
			    isy2 = (int)rint((double)affi->c2);
			    t[0][0]=affi->c1/dir_desc[index_image[0]].ncolonne;
			    t[1][1] = affi->c2/dir_desc[index_image[0]].nligne;
			    break;
			}
			case 3:	{   /* scaling facteur */
			    sprintf (buf, mastertabs[88], affi->c1,affi->c2);
			    isx2 = (int)rint(dir_desc[index_image[0]].ncolonne
				    * affi->c1);
			    isy2 = (int)rint(dir_desc[index_image[0]].nligne
				    * affi->c2);
			    t[0][0] = affi->c1;
			    t[1][1] = affi->c2;
			    break;
			}
		    }
		    write_master (buf);
		    isx1 = dir_desc[index_image[0]].ncolonne;
		    isy1 = dir_desc[index_image[0]].nligne;
		    isw = 1;
		    jp = (int *) malloc(isx2 * isy2 * sizeof(int));
		    AffineTransf(image, isx1, isy1, jp, isx2, isy2, t, isw);
		    if (dir_image[index_image[1]].image != NULL)
			free (dir_image[index_image[1]].image);
		    dir_image[index_image[1]].image = (unsigned char *)jp;
		    dir_desc[index_image[1]] = dir_desc[index_image[0]];
		    dir_desc[index_image[1]].ncolonne = isx2;
		    dir_desc[index_image[1]].nligne = isy2;
		    dir_desc[index_image[1]].type = 2;
		    if ((flag_conv == TRUE) || 
			(flag_autoconvert == TRUE)){
		      free (image);
		      free(buffer_image[0].image);
		    }
		    statis (dir_image[index_image[1]].image,
			    dir_desc[index_image[1]].type, 
			    dir_desc[index_image[1]].nligne,
			    dir_desc[index_image[1]].ncolonne,
			    &(dir_desc[index_image[1]].mmin),
			    &(dir_desc[index_image[1]].mmax), 
			    &(dir_desc[index_image[1]].mu),
			    &(dir_desc[index_image[1]].ecart));
	/*	} */
	    }
	}
    }
}

/* *************************************************************************** */

unsigned char *sym_x (no)

    int no;

{
    int elem, taille;
    unsigned char *b;

    unsigned char *u, *cu;
    short *s, *cs;
    int *i, *ci;
    float *f, *cf;
    int k, l;

    elem = element (dir_desc[no].type);
    taille = dir_desc[no].ncolonne * dir_desc[no].nligne;
    b = (unsigned char *) malloc (taille * elem);
    switch (dir_desc[no].type) {
    case -1:
    case 0: 
        u = (unsigned char *) b;
        cu = (unsigned char *)(dir_image[no].image) + taille;
        for (k=0; k<dir_desc[no].nligne; k++) {
	    cu -= dir_desc[no].ncolonne; 
            for (l=0; l<dir_desc[no].ncolonne; l++) {
                *u = *(cu + l);
                u++;
            }
	}
        break;
    case 1: 
        s = (short *) b;
        cs = (short *)(dir_image[no].image) + taille;
        for (k=0; k<dir_desc[no].nligne; k++) {
	    cs -= dir_desc[no].ncolonne; 
            for (l=0; l<dir_desc[no].ncolonne; l++) {
                *s = *(cs + l);
                s++;
            }
	}
        break;
    case 2: 
        i = (int *) b;
        ci = (int *)(dir_image[no].image) + taille;
        for (k=0; k<dir_desc[no].nligne; k++) {
	    ci -= dir_desc[no].ncolonne; 
            for (l=0; l<dir_desc[no].ncolonne; l++) {
                *i = *(ci + l);
                i++;
            }
	}
        break;
    case 3: 
        f = (float *) b;
        cf = (float *)(dir_image[no].image) + taille;
        for (k=0; k<dir_desc[no].nligne; k++) {
	    cf -= dir_desc[no].ncolonne; 
            for (l=0; l<dir_desc[no].ncolonne; l++) {
                *f = *(cf + l);
                f++;
            }
	}
        break;
    }
    return (b);
}

/*****************************************************************************/

unsigned char *sym_y (no)

    int no;

{
    int elem, taille;
    unsigned char *b;

    unsigned char *u, *cu;
    short *s, *cs;
    int *i, *ci;
    float *f, *cf;
    int k, l;

    elem = element (dir_desc[no].type);
    taille = dir_desc[no].ncolonne * dir_desc[no].nligne;
    b = (unsigned char *) malloc (taille * elem);
    switch (dir_desc[no].type) {
    case -1:
    case 0: 
        u = (unsigned char *) b;
        cu = (unsigned char *) dir_image[no].image;
        for (k=0; k<dir_desc[no].nligne; k++) {
            for (l=1; l<=dir_desc[no].ncolonne; l++) {
                *u = *(cu + dir_desc[no].ncolonne - l);
                u++;
            }
            cu += dir_desc[no].ncolonne;
	}
        break;
    case 1: 
        s = (short *) b;
        cs = (short *) dir_image[no].image;
        for (k=0; k<dir_desc[no].nligne; k++) {
            for (l=1; l<=dir_desc[no].ncolonne; l++) {
                *s = *(cs + dir_desc[no].ncolonne-l);
                s++;
            }
            cs += dir_desc[no].ncolonne;
	}
        break;
    case 2: 
        i = (int *) b;
        ci = (int *) dir_image[no].image;
        for (k=0; k<dir_desc[no].nligne; k++) {
            for (l=1; l<=dir_desc[no].ncolonne; l++) {
                *i = *(ci + dir_desc[no].ncolonne-l);
                i++;
            }
            ci += dir_desc[no].ncolonne;
	}
        break;
    case 3: 
        f = (float *) b;
        cf = (float *) dir_image[no].image;
        for (k=0; k<dir_desc[no].nligne; k++) {
            for (l=1; l<=dir_desc[no].ncolonne; l++) {
                *f = *(cf + dir_desc[no].ncolonne-l);
                f++;
            }
            cf += dir_desc[no].ncolonne;
	}
        break;
    }
    return (b);
}

/*****************************************************************************/

unsigned char *transpose (no)

    int no;

{
    int elem, taille;
    unsigned char *b;

    unsigned char *u, *cu;
    short *s, *cs;
    int *i, *ci;
    float *f, *cf;
    int k, l;

    elem = element (dir_desc[no].type);
    taille = dir_desc[no].ncolonne * dir_desc[no].nligne;
    b = (unsigned char *) malloc (taille * elem);
    switch (dir_desc[no].type) {
    case -1:
    case 0: 
        u = (unsigned char *) b;
        cu = (unsigned char *) dir_image[no].image;
        for (k=0; k<dir_desc[no].ncolonne; k++)
            for (l=k; l<taille; l+=dir_desc[no].ncolonne) {
                *u = *(cu + l);
                u++;
            }
        break;
    case 1: 
        s = (short *) b;
        cs = (short *) dir_image[no].image;
        for (k=0; k<dir_desc[no].ncolonne; k++)
            for (l=k; l<taille; l+=dir_desc[no].ncolonne) {
                *s = *(cs + l);
                s++;
            }
        break;
    case 2: 
        i = (int *) b;
        ci = (int *) dir_image[no].image;
        for (k=0; k<dir_desc[no].ncolonne; k++)
            for (l=k; l<taille; l+=dir_desc[no].ncolonne) {
                *i = *(ci + l);
                i++;
            }
        break;
    case 3: 
        f = (float *) b;
        cf = (float *) dir_image[no].image;
        for (k=0; k<dir_desc[no].ncolonne; k++)
            for (l=k; l<taille; l+=dir_desc[no].ncolonne) {
                *f = *(cf + l);
                f++;
            }
        break;
    }
    return (b);
}

/*****************************************************************************/

caddr_t proc_transpose (m, mi)

    Menu m;
    Menu_item mi;

{
    short tf;
    unsigned char *temp;


    if (flag_bother){
	hproc_opgeom_transpose();
	return;
    }
    if (flag_help) hproc_opgeom_transpose();
    if (!flag_creer){
	sprintf (buf, "Transposition: ");
	write_master (buf);
    }
    if (flag_exec == AUTO || flag_exec == FROMTO_AUTO){
	index_image[0] = macro_cour->from[0];
	index_image[1] = macro_cour->to[0];
    }
    else
	fromto (FROMTO, DEFAUT);
    if (flag_break) interruption();
    else{
	if (flag_creer){
	    struct commande *com;
	    com = (struct commande *)new_commande (&macro_cour);
	    sprintf (com->nom, "AUXGOPTRP");
	    com->code = 114;
	    com->from[0] = index_image[0];
	    com->to[0] = index_image[1];
	    sprintf (buf, "AUXGOPTRP FROM %d TO %d\n",
		    index_image[0], index_image[1]);
	    write_macro (buf);	
	}
	else {
	    sprintf (buf, "%d --> %d\n",
		    index_image[0], index_image[1]);
	    write_master (buf);
	    if (dir_image[index_image[0]].image == NULL) {
		write_erreur(1);
		return;
	    }
	    temp = transpose (index_image[0]);
	    if (dir_image[index_image[1]].image != NULL)
		free (dir_image[index_image[1]].image);
	    dir_image[index_image[1]].image = temp;
	    dir_desc[index_image[1]] = dir_desc[index_image[0]];
	    tf = dir_desc[index_image[1]].ncolonne;
	    dir_desc[index_image[1]].ncolonne=dir_desc[index_image[1]].nligne;
	    dir_desc[index_image[1]].nligne = tf;
	}
    }
}

/*****************************************************************************/

caddr_t proc_sym_x (m, mi)

    Menu m;
    Menu_item mi;

{
    unsigned char *temp;


    if (flag_bother){
	hproc_opgeom_sym_x();
	return;
    }
    if (flag_help) hproc_opgeom_sym_x();
    if (!flag_creer){
	sprintf (buf, mastertabs[89]);
	write_master (buf);
    }
    if (flag_exec == AUTO || flag_exec == FROMTO_AUTO){
	index_image[0] = macro_cour->from[0];
	index_image[1] = macro_cour->to[0];
    }
    else
	fromto (FROMTO, DEFAUT);
    if (flag_break) interruption();
    else{
	if (flag_creer){
	    struct commande *com;
	    com = (struct commande *)new_commande (&macro_cour);
	    sprintf (com->nom, "AUXGOPSYX");
	    com->code = 115;
	    com->from[0] = index_image[0];
	    com->to[0] = index_image[1];
	    sprintf (buf, "AUXGOPSYX FROM %d TO %d\n",
		    index_image[0], index_image[1]);
	    write_macro (buf);	
	}
	else {
	    sprintf (buf, "%d --> %d\n",
		    index_image[0], index_image[1]);
	    write_master (buf);
	    if (dir_image[index_image[0]].image == NULL) {
		write_erreur(1);
		return;
	    }
	    temp = sym_x (index_image[0]);
	    if (dir_image[index_image[1]].image != NULL)
		free (dir_image[index_image[1]].image);
	    dir_image[index_image[1]].image = temp;
	    dir_desc[index_image[1]] = dir_desc[index_image[0]];
	}
    }
}
/*****************************************************************************/

caddr_t proc_sym_y (m, mi)

    Menu m;
    Menu_item mi;

{
    unsigned char *temp;



    if (flag_bother){
	hproc_opgeom_sym_y();
	return;
    }
    if (flag_help) hproc_opgeom_sym_y();
    if (!flag_creer){
	sprintf (buf, mastertabs[90]);
	write_master (buf);
    }
    if (flag_exec == AUTO || flag_exec == FROMTO_AUTO){
	index_image[0] = macro_cour->from[0];
	index_image[1] = macro_cour->to[0];
    }
    else
	fromto (FROMTO, DEFAUT);
    if (flag_break) interruption();
    else{
	if (flag_creer){
	    struct commande *com;
	    com = (struct commande *)new_commande (&macro_cour);
	    sprintf (com->nom, "AUXGOPSYY");
	    com->code = 116;
	    com->from[0] = index_image[0];
	    com->to[0] = index_image[1];
	    sprintf (buf, "AUXGOPSYY FROM %d TO %d\n",
		    index_image[0], index_image[1]);
	    write_macro (buf);	
	}
	else {
	    sprintf (buf, "%d --> %d\n",
		    index_image[0], index_image[1]);
	    write_master (buf);
	    if (dir_image[index_image[0]].image == NULL) {
		write_erreur(1);
		return;
	    }
	    temp = sym_y (index_image[0]);
	    if (dir_image[index_image[1]].image != NULL)
		free (dir_image[index_image[1]].image);
	    dir_image[index_image[1]].image = temp;
	    dir_desc[index_image[1]] = dir_desc[index_image[0]];
	}
    }
}



/* ************************************************************************* */


/* funtion for affine transformation of an image using linear
   interpolation
*/

/* ************************************************************************ */
 int AffineTransf(InImage,DimInX, DimInY, OutImage, DimOutX, DimOutY,
                  TransfMat, ContentP)
  int *InImage, DimInX, DimInY, *OutImage, DimOutX, DimOutY, ContentP;
  float TransfMat[3][2];
{
    float mat00, mat01, mat02, mat10, mat11, mat12, det;
    float Xf1, Yf1, Xf2, Yf2, Xf2prime, Yf2prime, fi, fj;
    int i, j, index; 
    int Xvali, Yvali, DimOutX1, DimOutY1, DimInX1, DimInY1; 
    int indexX1, indexY1, indexX2, indexY2;
    
    DimOutX1=DimOutX -1;
    DimOutY1=DimOutY -1;
    DimInX1=DimInX -1;
    DimInY1=DimInY -1;
    if (ContentP == 1){
	det = TransfMat[0][0] * TransfMat[1][1] - TransfMat[1][0] * TransfMat[0][1];
        if (fabs(det) < EPSILON) return(-1);

        mat00 = TransfMat[1][1]/det; 
        mat01 = - TransfMat[1][0]/det; 
        mat10 = - TransfMat[0][1]/det;
        mat11 = TransfMat[0][0]/det;
        mat02 = (TransfMat[1][0] * TransfMat[2][1] - TransfMat[2][0] * TransfMat[1][1]) / det;
        mat12 = (TransfMat[0][1] * TransfMat[2][0] - TransfMat[0][0] * TransfMat[2][1]) /det;
    }
    else{
        mat00 = TransfMat[0][0]; 
        mat01 = TransfMat[1][0]; 
        mat02 = TransfMat[2][0];
        mat10 = TransfMat[0][1]; 
        mat11 = TransfMat[1][1];
        mat12 = TransfMat[2][1]; 
	
    }
    for(i=0; (i < DimOutY); ++i){
        fi = (float)i; 
	Xf1 = fi*mat01 + mat02;
	Yf1 = fi*mat11 + mat12;
        index= DimOutX * i;
        for(j=0; (j < DimOutX); ++j){
	   fj = (float) j;
	   Xf2 = fj*mat00 + Xf1; 
	   Yf2 = fj*mat10 + Yf1;
           indexX1 = (int)Xf2; 
           indexY1 = (int)Yf2; 
           if ((( indexX1 < 0) || indexX1 > DimInX1) || (( indexY1 < 0) || (indexY1 > DimInY1))){
		*(OutImage + index + j)=0;
	   }
           else{
	       Xf2= Xf2 - (float)indexX1;
	       Yf2= Yf2 - (float)indexY1;
               indexX2 = indexX1;
               indexY2 = indexY1;
               Xf2prime = 1 - Xf2;
               Yf2prime = 1 - Yf2;
		*(OutImage + index + j) = (int) 
(  (Yf2prime * 
       (   (Xf2prime * ((float)(*(InImage+DimInX*indexY1 + indexX1))))
         + (Xf2 * ((float)(*(InImage+DimInX*indexY1 + indexX2))))
       )
   )   
+   
   (Yf2 *
       (   (Xf2prime * ((float)(*(InImage+DimInX*indexY2 + indexX1))))
         + (Xf2 * ((float)(*(InImage+DimInX*indexY2 + indexX2))))
       )
   )
+   0.5);
	   }
	}
    }
}

