/*
  File: devI/DEVICE.c
  Author: K.R. Sloan
  Last Modified: 10 February 1991
  Purpose: definitions for the generic graphics device used by SGP
           this version prints out imPRESS commands.

           The intended usage is to pipe PostScript-style output (see dev0)
           through a version of sgpServer linked to devI, and then feed
           that to an Imagen printer.  Hack, hack, hack...

           Everything here is output-only.  For other assumptions/decisions,
           read the code.

           devPick always fails...
 */
#include <stdio.h>
#include "DEVICE.h"

#define MINSIZE 3

/*  Device state  - made global for convenience ... */
int devLeft, devBottom, devRight, devTop;
int devClipL, devClipB, devClipR, devClipT;
int devCurrentColor;
FILE *devOutputStream = stdout;
double devAspectRatio = 1.0;

/* 
   imPRESS does it's own clipping, but has a very limited range of
   coordinate values.  This is damage control - if it ever does the
   wrong thing, you're pushing the limits too hard.
 */
static void Limit(x)
 int *x;
 {
  if (*x < -16000) *x = -16000; else if (16000 < *x) *x = 16000;
 } 

static void ImagenGrayScales(OutputStream)
 {
  fprintf(OutputStream,"@BGLY 0 40 0 32 32 0 32 32\n");
  fprintf(OutputStream,"OOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOO\n");
  fprintf(OutputStream,"OOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOO\n");
  fprintf(OutputStream,"OOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOO\n");
  fprintf(OutputStream,"OOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOO\n");
  fprintf(OutputStream,"OOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOO\n");
  fprintf(OutputStream,"OOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOO\n");
  fprintf(OutputStream,"OOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOO\n");
  fprintf(OutputStream,"OOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOO\n");
  fprintf(OutputStream,"OOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOO\n");
  fprintf(OutputStream,"OOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOO\n");
  fprintf(OutputStream,"OOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOO\n");
  fprintf(OutputStream,"OOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOO\n");
  fprintf(OutputStream,"OOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOO\n");
  fprintf(OutputStream,"OOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOO\n");
  fprintf(OutputStream,"OOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOO\n");
  fprintf(OutputStream,"OOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOO\n");
  fprintf(OutputStream,"OOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOO\n");
  fprintf(OutputStream,"OOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOO\n");
  fprintf(OutputStream,"OOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOO\n");
  fprintf(OutputStream,"OOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOO\n");
  fprintf(OutputStream,"OOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOO\n");
  fprintf(OutputStream,"OOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOO\n");
  fprintf(OutputStream,"OOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOO\n");
  fprintf(OutputStream,"OOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOO\n");
  fprintf(OutputStream,"OOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOO\n");
  fprintf(OutputStream,"OOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOO\n");
  fprintf(OutputStream,"OOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOO\n");
  fprintf(OutputStream,"OOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOO\n");
  fprintf(OutputStream,"OOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOO\n");
  fprintf(OutputStream,"OOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOO\n");
  fprintf(OutputStream,"OOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOO\n");
  fprintf(OutputStream,"OOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOO@\n");

  fprintf(OutputStream,"@BGLY 0 40 1 32 32 0 32 32\n");
  fprintf(OutputStream,"OOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOO\n");
  fprintf(OutputStream,"O..OOOOO..OOOOOO..OOOOOO..OOOOOO\n");
  fprintf(OutputStream,"O..OOOOO..OOOOOO..OOOOOO..OOOOOO\n");
  fprintf(OutputStream,"OOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOO\n");
  fprintf(OutputStream,"OOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOO\n");
  fprintf(OutputStream,"OOOOO..OOOOOO..OOOOOO..OOOOOO..O\n");
  fprintf(OutputStream,"OOOOO..OOOOOO..OOOOOO..OOOOOO..O\n");
  fprintf(OutputStream,"OOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOO\n");
  fprintf(OutputStream,"OOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOO\n");
  fprintf(OutputStream,"O..OOOOO..OOOOOO..OOOOOO..OOOOOO\n");
  fprintf(OutputStream,"O..OOOOO..OOOOOO..OOOOOO..OOOOOO\n");
  fprintf(OutputStream,"OOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOO\n");
  fprintf(OutputStream,"OOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOO\n");
  fprintf(OutputStream,"OOOOO..OOOOOO..OOOOOO..OOOOOO..O\n");
  fprintf(OutputStream,"OOOOO..OOOOOO..OOOOOO..OOOOOO..O\n");
  fprintf(OutputStream,"OOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOO\n");
  fprintf(OutputStream,"OOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOO\n");
  fprintf(OutputStream,"O..OOOOO..OOOOOO..OOOOOO..OOOOOO\n");
  fprintf(OutputStream,"O..OOOOO..OOOOOO..OOOOOO..OOOOOO\n");
  fprintf(OutputStream,"OOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOO\n");
  fprintf(OutputStream,"OOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOO\n");
  fprintf(OutputStream,"OOOOO..OOOOOO..OOOOOO..OOOOOO..O\n");
  fprintf(OutputStream,"OOOOO..OOOOOO..OOOOOO..OOOOOO..O\n");
  fprintf(OutputStream,"OOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOO\n");
  fprintf(OutputStream,"OOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOO\n");
  fprintf(OutputStream,"O..OOOOO..OOOOOO..OOOOOO..OOOOOO\n");
  fprintf(OutputStream,"O..OOOOO..OOOOOO..OOOOOO..OOOOOO\n");
  fprintf(OutputStream,"OOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOO\n");
  fprintf(OutputStream,"OOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOO\n");
  fprintf(OutputStream,"OOOOO..OOOOOO..OOOOOO..OOOOOO..O\n");
  fprintf(OutputStream,"OOOOO..OOOOOO..OOOOOO..OOOOOO..O\n");
  fprintf(OutputStream,"OOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOO@\n");

  fprintf(OutputStream,"@BGLY 0 40 2 32 32 0 32 32\n");
  fprintf(OutputStream,"OOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOO\n");
  fprintf(OutputStream,"O..OOOOOO..OOOOOO..OOOOOO..OOOOO\n");
  fprintf(OutputStream,"O...OOOOO...OOOOO...OOOOO...OOOO\n");
  fprintf(OutputStream,"O...OOOOO...OOOOO...OOOOO...OOOO\n");
  fprintf(OutputStream,"OOOO...OOOOO...OOOOO...OOOOO...O\n");
  fprintf(OutputStream,"OOOO...OOOOO...OOOOO...OOOOO...O\n");
  fprintf(OutputStream,"OOOOO..OOOOOO..OOOOOO..OOOOOO..O\n");
  fprintf(OutputStream,"OOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOO\n");
  fprintf(OutputStream,"OOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOO\n");
  fprintf(OutputStream,"O..OOOOOO..OOOOOO..OOOOOO..OOOOO\n");
  fprintf(OutputStream,"O...OOOOO...OOOOO...OOOOO...OOOO\n");
  fprintf(OutputStream,"O...OOOOO...OOOOO...OOOOO...OOOO\n");
  fprintf(OutputStream,"OOOO...OOOOO...OOOOO...OOOOO...O\n");
  fprintf(OutputStream,"OOOO...OOOOO...OOOOO...OOOOO...O\n");
  fprintf(OutputStream,"OOOOO..OOOOOO..OOOOOO..OOOOOO..O\n");
  fprintf(OutputStream,"OOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOO\n");
  fprintf(OutputStream,"OOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOO\n");
  fprintf(OutputStream,"O..OOOOOO..OOOOOO..OOOOOO..OOOOO\n");
  fprintf(OutputStream,"O...OOOOO...OOOOO...OOOOO...OOOO\n");
  fprintf(OutputStream,"O...OOOOO...OOOOO...OOOOO...OOOO\n");
  fprintf(OutputStream,"OOOO...OOOOO...OOOOO...OOOOO...O\n");
  fprintf(OutputStream,"OOOO...OOOOO...OOOOO...OOOOO...O\n");
  fprintf(OutputStream,"OOOOO..OOOOOO..OOOOOO..OOOOOO..O\n");
  fprintf(OutputStream,"OOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOO\n");
  fprintf(OutputStream,"OOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOO\n");
  fprintf(OutputStream,"O..OOOOOO..OOOOOO..OOOOOO..OOOOO\n");
  fprintf(OutputStream,"O...OOOOO...OOOOO...OOOOO...OOOO\n");
  fprintf(OutputStream,"O...OOOOO...OOOOO...OOOOO...OOOO\n");
  fprintf(OutputStream,"OOOO...OOOOO...OOOOO...OOOOO...O\n");
  fprintf(OutputStream,"OOOO...OOOOO...OOOOO...OOOOO...O\n");
  fprintf(OutputStream,"OOOOO..OOOOOO..OOOOOO..OOOOOO..O\n");
  fprintf(OutputStream,"OOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOO@\n");

  fprintf(OutputStream,"@BGLY 0 40 3 32 32 0 32 32\n");
  fprintf(OutputStream,"O...OOOOO...OOOOO...OOOOO...OOOO\n");
  fprintf(OutputStream,"O...OOOOO...OOOOO...OOOOO...OOOO\n");
  fprintf(OutputStream,"O...OOOOO...OOOOO...OOOOO...OOOO\n");
  fprintf(OutputStream,"O...OOOOO...OOOOO...OOOOO...OOOO\n");
  fprintf(OutputStream,"OOOO...OOOOO...OOOOO...OOOOO...O\n");
  fprintf(OutputStream,"OOOO...OOOOO...OOOOO...OOOOO...O\n");
  fprintf(OutputStream,"OOOO...OOOOO...OOOOO...OOOOO...O\n");
  fprintf(OutputStream,"OOOO...OOOOO...OOOOO...OOOOO...O\n");
  fprintf(OutputStream,"O...OOOOO...OOOOO...OOOOO...OOOO\n");
  fprintf(OutputStream,"O...OOOOO...OOOOO...OOOOO...OOOO\n");
  fprintf(OutputStream,"O...OOOOO...OOOOO...OOOOO...OOOO\n");
  fprintf(OutputStream,"O...OOOOO...OOOOO...OOOOO...OOOO\n");
  fprintf(OutputStream,"OOOO...OOOOO...OOOOO...OOOOO...O\n");
  fprintf(OutputStream,"OOOO...OOOOO...OOOOO...OOOOO...O\n");
  fprintf(OutputStream,"OOOO...OOOOO...OOOOO...OOOOO...O\n");
  fprintf(OutputStream,"OOOO...OOOOO...OOOOO...OOOOO...O\n");
  fprintf(OutputStream,"O...OOOOO...OOOOO...OOOOO...OOOO\n");
  fprintf(OutputStream,"O...OOOOO...OOOOO...OOOOO...OOOO\n");
  fprintf(OutputStream,"O...OOOOO...OOOOO...OOOOO...OOOO\n");
  fprintf(OutputStream,"O...OOOOO...OOOOO...OOOOO...OOOO\n");
  fprintf(OutputStream,"OOOO...OOOOO...OOOOO...OOOOO...O\n");
  fprintf(OutputStream,"OOOO...OOOOO...OOOOO...OOOOO...O\n");
  fprintf(OutputStream,"OOOO...OOOOO...OOOOO...OOOOO...O\n");
  fprintf(OutputStream,"OOOO...OOOOO...OOOOO...OOOOO...O\n");
  fprintf(OutputStream,"O...OOOOO...OOOOO...OOOOO...OOOO\n");
  fprintf(OutputStream,"O...OOOOO...OOOOO...OOOOO...OOOO\n");
  fprintf(OutputStream,"O...OOOOO...OOOOO...OOOOO...OOOO\n");
  fprintf(OutputStream,"O...OOOOO...OOOOO...OOOOO...OOOO\n");
  fprintf(OutputStream,"OOOO...OOOOO...OOOOO...OOOOO...O\n");
  fprintf(OutputStream,"OOOO...OOOOO...OOOOO...OOOOO...O\n");
  fprintf(OutputStream,"OOOO...OOOOO...OOOOO...OOOOO...O\n");
  fprintf(OutputStream,"OOOO...OOOOO...OOOOO...OOOOO...O@\n");

  fprintf(OutputStream,"@BGLY 0 40 4 32 32 0 32 32\n");
  fprintf(OutputStream,"....OOOO....OOOO....OOOO....OOOO\n");
  fprintf(OutputStream,"....OOOO....OOOO....OOOO....OOOO\n");
  fprintf(OutputStream,"....OOOO....OOOO....OOOO....OOOO\n");
  fprintf(OutputStream,"....OOOO....OOOO....OOOO....OOOO\n");
  fprintf(OutputStream,"OOOO....OOOO....OOOO....OOOO....\n");
  fprintf(OutputStream,"OOOO....OOOO....OOOO....OOOO....\n");
  fprintf(OutputStream,"OOOO....OOOO....OOOO....OOOO....\n");
  fprintf(OutputStream,"OOOO....OOOO....OOOO....OOOO....\n");
  fprintf(OutputStream,"....OOOO....OOOO....OOOO....OOOO\n");
  fprintf(OutputStream,"....OOOO....OOOO....OOOO....OOOO\n");
  fprintf(OutputStream,"....OOOO....OOOO....OOOO....OOOO\n");
  fprintf(OutputStream,"....OOOO....OOOO....OOOO....OOOO\n");
  fprintf(OutputStream,"OOOO....OOOO....OOOO....OOOO....\n");
  fprintf(OutputStream,"OOOO....OOOO....OOOO....OOOO....\n");
  fprintf(OutputStream,"OOOO....OOOO....OOOO....OOOO....\n");
  fprintf(OutputStream,"OOOO....OOOO....OOOO....OOOO....\n");
  fprintf(OutputStream,"....OOOO....OOOO....OOOO....OOOO\n");
  fprintf(OutputStream,"....OOOO....OOOO....OOOO....OOOO\n");
  fprintf(OutputStream,"....OOOO....OOOO....OOOO....OOOO\n");
  fprintf(OutputStream,"....OOOO....OOOO....OOOO....OOOO\n");
  fprintf(OutputStream,"OOOO....OOOO....OOOO....OOOO....\n");
  fprintf(OutputStream,"OOOO....OOOO....OOOO....OOOO....\n");
  fprintf(OutputStream,"OOOO....OOOO....OOOO....OOOO....\n");
  fprintf(OutputStream,"OOOO....OOOO....OOOO....OOOO....\n");
  fprintf(OutputStream,"....OOOO....OOOO....OOOO....OOOO\n");
  fprintf(OutputStream,"....OOOO....OOOO....OOOO....OOOO\n");
  fprintf(OutputStream,"....OOOO....OOOO....OOOO....OOOO\n");
  fprintf(OutputStream,"....OOOO....OOOO....OOOO....OOOO\n");
  fprintf(OutputStream,"OOOO....OOOO....OOOO....OOOO....\n");
  fprintf(OutputStream,"OOOO....OOOO....OOOO....OOOO....\n");
  fprintf(OutputStream,"OOOO....OOOO....OOOO....OOOO....\n");
  fprintf(OutputStream,"OOOO....OOOO....OOOO....OOOO....@\n");

  fprintf(OutputStream,"@BGLY 0 40 5 32 32 0 32 32\n");
  fprintf(OutputStream,"....OOO.....OOO.....OOO.....OOO.\n");
  fprintf(OutputStream,"....OOO.....OOO.....OOO.....OOO.\n");
  fprintf(OutputStream,"....OOO.....OOO.....OOO.....OOO.\n");
  fprintf(OutputStream,"....OOO.....OOO.....OOO.....OOO.\n");
  fprintf(OutputStream,".OOO.....OOO.....OOO.....OOO....\n");
  fprintf(OutputStream,".OOO.....OOO.....OOO.....OOO....\n");
  fprintf(OutputStream,".OOO.....OOO.....OOO.....OOO....\n");
  fprintf(OutputStream,".OOO.....OOO.....OOO.....OOO....\n");
  fprintf(OutputStream,"....OOO.....OOO.....OOO.....OOO.\n");
  fprintf(OutputStream,"....OOO.....OOO.....OOO.....OOO.\n");
  fprintf(OutputStream,"....OOO.....OOO.....OOO.....OOO.\n");
  fprintf(OutputStream,"....OOO.....OOO.....OOO.....OOO.\n");
  fprintf(OutputStream,".OOO.....OOO.....OOO.....OOO....\n");
  fprintf(OutputStream,".OOO.....OOO.....OOO.....OOO....\n");
  fprintf(OutputStream,".OOO.....OOO.....OOO.....OOO....\n");
  fprintf(OutputStream,".OOO.....OOO.....OOO.....OOO....\n");
  fprintf(OutputStream,"....OOO.....OOO.....OOO.....OOO.\n");
  fprintf(OutputStream,"....OOO.....OOO.....OOO.....OOO.\n");
  fprintf(OutputStream,"....OOO.....OOO.....OOO.....OOO.\n");
  fprintf(OutputStream,"....OOO.....OOO.....OOO.....OOO.\n");
  fprintf(OutputStream,".OOO.....OOO.....OOO.....OOO....\n");
  fprintf(OutputStream,".OOO.....OOO.....OOO.....OOO....\n");
  fprintf(OutputStream,".OOO.....OOO.....OOO.....OOO....\n");
  fprintf(OutputStream,".OOO.....OOO.....OOO.....OOO....\n");
  fprintf(OutputStream,"....OOO.....OOO.....OOO.....OOO.\n");
  fprintf(OutputStream,"....OOO.....OOO.....OOO.....OOO.\n");
  fprintf(OutputStream,"....OOO.....OOO.....OOO.....OOO.\n");
  fprintf(OutputStream,"....OOO.....OOO.....OOO.....OOO.\n");
  fprintf(OutputStream,".OOO.....OOO.....OOO.....OOO....\n");
  fprintf(OutputStream,".OOO.....OOO.....OOO.....OOO....\n");
  fprintf(OutputStream,".OOO.....OOO.....OOO.....OOO....\n");
  fprintf(OutputStream,".OOO.....OOO.....OOO.....OOO....@\n");


  fprintf(OutputStream,"@BGLY 0 40 6 32 32 0 32 32\n");
  fprintf(OutputStream,"................................\n");
  fprintf(OutputStream,".....OO......OO......OO......OO.\n");
  fprintf(OutputStream,"....OOO.....OOO.....OOO.....OOO.\n");
  fprintf(OutputStream,"....OOO.....OOO.....OOO.....OOO.\n");
  fprintf(OutputStream,".OOO.....OOO.....OOO.....OOO....\n");
  fprintf(OutputStream,".OOO.....OOO.....OOO.....OOO....\n");
  fprintf(OutputStream,".OO......OO......OO......OO.....\n");
  fprintf(OutputStream,"................................\n");
  fprintf(OutputStream,"................................\n");
  fprintf(OutputStream,".....OO......OO......OO......OO.\n");
  fprintf(OutputStream,"....OOO.....OOO.....OOO.....OOO.\n");
  fprintf(OutputStream,"....OOO.....OOO.....OOO.....OOO.\n");
  fprintf(OutputStream,".OOO.....OOO.....OOO.....OOO....\n");
  fprintf(OutputStream,".OOO.....OOO.....OOO.....OOO....\n");
  fprintf(OutputStream,".OO......OO......OO......OO.....\n");
  fprintf(OutputStream,"................................\n");
  fprintf(OutputStream,"................................\n");
  fprintf(OutputStream,".....OO......OO......OO......OO.\n");
  fprintf(OutputStream,"....OOO.....OOO.....OOO.....OOO.\n");
  fprintf(OutputStream,"....OOO.....OOO.....OOO.....OOO.\n");
  fprintf(OutputStream,".OOO.....OOO.....OOO.....OOO....\n");
  fprintf(OutputStream,".OOO.....OOO.....OOO.....OOO....\n");
  fprintf(OutputStream,".OO......OO......OO......OO.....\n");
  fprintf(OutputStream,"................................\n");
  fprintf(OutputStream,"................................\n");
  fprintf(OutputStream,".....OO......OO......OO......OO.\n");
  fprintf(OutputStream,"....OOO.....OOO.....OOO.....OOO.\n");
  fprintf(OutputStream,"....OOO.....OOO.....OOO.....OOO.\n");
  fprintf(OutputStream,".OOO.....OOO.....OOO.....OOO....\n");
  fprintf(OutputStream,".OOO.....OOO.....OOO.....OOO....\n");
  fprintf(OutputStream,".OO......OO......OO......OO.....\n");
  fprintf(OutputStream,"................................@\n");

  fprintf(OutputStream,"@BGLY 0 40 7 32 32 0 32 32\n");
  fprintf(OutputStream,"................................\n");
  fprintf(OutputStream,".....OO......OO......OO......OO.\n");
  fprintf(OutputStream,".....OO......OO......OO......OO.\n");
  fprintf(OutputStream,"................................\n");
  fprintf(OutputStream,"................................\n");
  fprintf(OutputStream,"..OO......OO......OO......OO....\n");
  fprintf(OutputStream,"..OO......OO......OO......OO....\n");
  fprintf(OutputStream,"................................\n");
  fprintf(OutputStream,"................................\n");
  fprintf(OutputStream,".....OO......OO......OO......OO.\n");
  fprintf(OutputStream,".....OO......OO......OO......OO.\n");
  fprintf(OutputStream,"................................\n");
  fprintf(OutputStream,"................................\n");
  fprintf(OutputStream,"..OO......OO......OO......OO....\n");
  fprintf(OutputStream,"..OO......OO......OO......OO....\n");
  fprintf(OutputStream,"................................\n");
  fprintf(OutputStream,"................................\n");
  fprintf(OutputStream,".....OO......OO......OO......OO.\n");
  fprintf(OutputStream,".....OO......OO......OO......OO.\n");
  fprintf(OutputStream,"................................\n");
  fprintf(OutputStream,"................................\n");
  fprintf(OutputStream,"..OO......OO......OO......OO....\n");
  fprintf(OutputStream,"..OO......OO......OO......OO....\n");
  fprintf(OutputStream,"................................\n");
  fprintf(OutputStream,"................................\n");
  fprintf(OutputStream,".....OO......OO......OO......OO.\n");
  fprintf(OutputStream,".....OO......OO......OO......OO.\n");
  fprintf(OutputStream,"................................\n");
  fprintf(OutputStream,"................................\n");
  fprintf(OutputStream,"..OO......OO......OO......OO....\n");
  fprintf(OutputStream,"..OO......OO......OO......OO....\n");
  fprintf(OutputStream,"................................@\n");

  fprintf(OutputStream,"@BGLY 0 40 8 32 32 0 32 32\n");
  fprintf(OutputStream,"................................\n");
  fprintf(OutputStream,"................................\n");
  fprintf(OutputStream,"................................\n");
  fprintf(OutputStream,"................................\n");
  fprintf(OutputStream,"................................\n");
  fprintf(OutputStream,"................................\n");
  fprintf(OutputStream,"................................\n");
  fprintf(OutputStream,"................................\n");
  fprintf(OutputStream,"................................\n");
  fprintf(OutputStream,"................................\n");
  fprintf(OutputStream,"................................\n");
  fprintf(OutputStream,"................................\n");
  fprintf(OutputStream,"................................\n");
  fprintf(OutputStream,"................................\n");
  fprintf(OutputStream,"................................\n");
  fprintf(OutputStream,"................................\n");
  fprintf(OutputStream,"................................\n");
  fprintf(OutputStream,"................................\n");
  fprintf(OutputStream,"................................\n");
  fprintf(OutputStream,"................................\n");
  fprintf(OutputStream,"................................\n");
  fprintf(OutputStream,"................................\n");
  fprintf(OutputStream,"................................\n");
  fprintf(OutputStream,"................................\n");
  fprintf(OutputStream,"................................\n");
  fprintf(OutputStream,"................................\n");
  fprintf(OutputStream,"................................\n");
  fprintf(OutputStream,"................................\n");
  fprintf(OutputStream,"................................\n");
  fprintf(OutputStream,"................................\n");
  fprintf(OutputStream,"................................\n");
  fprintf(OutputStream,"................................@\n");

 } 

/*
   devInit initializes the display, loading color maps if necessary
   There are two modes: color and mono.  Here, we assume a full-color
   display, and the two modes are identical

   devInit may also need to fill in the "physical" size of the display
   here, we output the "physical" limits to help your interpreter 
 */
int devInit(color, OutputStream)
 int color;
 FILE *OutputStream;
 {
  devOutputStream = OutputStream;
  /* assume letter size, 300 dpi */
  /* but, allow for a one inch border all around */
  /*  devLeft = 0;  devBottom = 3328; devRight = 2560; devTop = 0; */
  devLeft = 300;  devBottom = 3028; devRight = 2260; devTop = 300;

  /*
     h,v coordinate system is at the upper left, 
     h increasing to the right, v increasing down
     text goes right to left, top to bottom
     ask for brand new PATHs every time,
     establish a pen width,
     and start off with clipping to the page boundaries
   */
  ImagenGrayScales(OutputStream);
  fprintf(devOutputStream,"@SET_HV_SYSTEM 0 2 2 4@\n");
  fprintf(devOutputStream,"@SET_ADV_DIRS 0 0 0@\n");
  fprintf(devOutputStream,"@SET_PUM 0@\n");
  fprintf(devOutputStream,"@SET_PEN %d@\n",MINSIZE);
  fprintf(devOutputStream,"@PAGE@\n");
  fprintf(devOutputStream,"@RESET_CLIP_REGION@\n");

  /*
    indirectly set up clipping to the device boundaries 
    and establish a color to draw with
   */
  devSetClipWin(devLeft,devBottom,devRight,devTop);
  devCurrentColor = devColorCode(1.0, 1.0, 1.0);
  return(0); /* success */ 
 }

/*
  devClose insures that all operations have completed, and closes up
 */
int devClose()
 {
  fprintf(devOutputStream,"@ENDPAGE@\n");
  fflush(devOutputStream);
  return(0); /* success */
 }  

/*
  devSetClipWin establishes a clipping window
  restrictions such as (L<R) must be enforced here!

  we're upside down, so we want L<R, and T<B
 */
int devSetClipWin(L, B, R, T)
 int L, B, R, T;
 {
  if (L<R) { devClipL=L; devClipR=R; } else { devClipL=R; devClipR=L;} 
  if (T<B) { devClipB=B; devClipT=T; } else { devClipB=T; devClipT=B;} 

  if (devLeft < devRight)
   {
    if (devClipL < devLeft)   devClipL = devLeft;
    if (devClipR > devRight)  devClipR = devRight;
   }
  else
   {
    if (devClipL < devRight)  devClipL = devRight;
    if (devClipR > devLeft)   devClipR = devLeft;
   }

  if (devBottom < devTop)
   {
    if (devClipB < devBottom) devClipB = devBottom;
    if (devClipT > devTop)    devClipT = devTop;
   }
  else 
   {
    if (devClipB < devTop)    devClipB = devTop;
    if (devClipT > devBottom) devClipT = devBottom;
   }

  fprintf(devOutputStream,"@SET_ABS_H %d@\n", devClipL);
  fprintf(devOutputStream,"@SET_ABS_V %d@\n", devClipT);
  fprintf(devOutputStream,"@SET_CLIP_REGION %d %d@\n",
            devClipR-devClipL+1, devClipB-devClipT+1);

  return(0); /* success */
 }

/*
 devClearScreen fills the entire screen with a particular color

 */
int devClearScreen(color)
 int color;
 {
  int oldColor;
 
  oldColor = devCurrentColor;
  devSetClipWin(devLeft,devBottom,devRight,devTop);
  devSetColor(color);
  fprintf(devOutputStream,"@CREATE_PATH 4  %d %d  %d %d  %d %d  %d %d@\n",
                    devLeft, devBottom,
                    devLeft, devTop,
                    devRight,devTop,
                    devRight,devBottom);
  fprintf(devOutputStream,"@FILL_PATH 3@\n");
  devSetClipWin(devClipL,devClipB,devClipR,devClipT);
  devSetColor(oldColor);
  return(0); /* success */
 }

/*
   the following routines draw primitive shapes on the physical device
   All of them clip against the device's clipping window.
   All of them paint in the device's current color
 */

/*
  devLine draws a line
 */
int devLine(x0, y0, x1, y1)
 int x0, y0, x1, y1; 
 {
  Limit(&x0); Limit(&y0);
  Limit(&x1); Limit(&y1);
  fprintf(devOutputStream,"@CREATE_PATH 2 %d %d %d %d@\n", x0, y0, x1, y1);
  fprintf(devOutputStream,"@DRAW_PATH 3@\n");
  return(0); /* success */
 }

/*
 devRect fills a rectangle
 */
int devRect(L, B, R, T)
 int L, B, R, T;
 {
  Limit(&L); Limit(&B); Limit(&R); Limit(&T);
  fprintf(devOutputStream,"@CREATE_PATH 4\n%d %d\n%d %d\n%d %d\n%d %d\n@",
                    L,B, L,T, R,T, R,B); 
  fprintf(devOutputStream,"@DRAW_PATH 3@\n");
  fprintf(devOutputStream,"@FILL_PATH 3@\n");
  return(0); /* success */
 }

/*
 devDisc fills a disc
 */
int devDisc(x, y, r)
 int x, y, r;
 {
  Limit(&x); Limit(&y);
  fprintf(devOutputStream,"@SET_ABS_H %d@\n",x);
  fprintf(devOutputStream,"@SET_ABS_V %d@\n",y);
  fprintf(devOutputStream,"@CIRC_ARC %d 0 16383@\n",r);
  fprintf(devOutputStream,"@DRAW_PATH 3@\n");
  fprintf(devOutputStream,"@FILL_PATH 3@\n");
  return(0); /* success */
 }

/*
 devCircle draws a circle
 */
int devCircle(x,y,r)
 int x,y,r;
 {
  Limit(&x); Limit(&y);
  fprintf(devOutputStream,"@SET_ABS_H %d@\n",x);
  fprintf(devOutputStream,"@SET_ABS_V %d@\n",y);
  fprintf(devOutputStream,"@CIRC_ARC %d 0 16383@\n",r);
  fprintf(devOutputStream,"@DRAW_PATH 3@\n");
  return(0); /* success */
 }

/*
 devSolidTriangle fills a triangle
 */
int devSolidTriangle(x0, y0, x1, y1, x2, y2)
 int x0, y0, x1, y1, x2, y2;
 {
  Limit(&x0); Limit(&y0);
  Limit(&x1); Limit(&y1);
  Limit(&x2); Limit(&y2);
  fprintf(devOutputStream,"@CREATE_PATH 3\n%d %d\n%d %d\n%d %d\n@",
                    x0, y0, x1, y1, x2, y2);
  fprintf(devOutputStream,"@DRAW_PATH 3@\n");
  fprintf(devOutputStream,"@FILL_PATH 3@\n");
  return(0); /* success */
 }

/*
 devShadeTriangle shades a triangle
   with color codes specified at each vertex
 */
int devShadeTriangle(x0, y0, c0, x1, y1, c1, x2, y2, c2)
 int x0, y0, c0, x1, y1, c1, x2, y2, c2;
 {
  int oldColor;
  double R0,G0,B0,R1,G1,B1,R2,G2,B2,R,G,B;
  Limit(&x0); Limit(&y0);
  Limit(&x1); Limit(&y1);
  Limit(&x2); Limit(&y2);
  /* we can't do that - so use the average color*/
  devColorDecode(c0,&R0,&G0,&B0);
  devColorDecode(c1,&R1,&G1,&B1);
  devColorDecode(c2,&R2,&G2,&B2);
  R = 0.333333*(R0+R1+R2);
  G = 0.333333*(G0+G1+G2);
  B = 0.333333*(B0+B1+B2);
  oldColor = devCurrentColor;
  devSetColor(devColorCode(R,G,B));
  devSolidTriangle(x0,y0,x1,y1,x2,y2);
  devSetColor(oldColor);
  return(0); /* success */
 }

/*
 devSetColor establishes the current color
 */
int devSetColor(color)
 int color;
 {
  devCurrentColor = color;
  fprintf(devOutputStream,"@SET_TEXTURE 0 40 %d@\n",devCurrentColor);
  return(0); /* success */
 }

/*
   devColorCode returns a framebuffer value - here, we use textures 0-8

 */ 
int devColorCode(R, G, B)
 double R,G,B; 
 {
  double I;
  int code;

  I = (0.3*R)+(0.59*G)+(0.11*B);
  code = (int)(I*9.0); if (9 <= code) code = 8;
  return (code);
 }

/*
  devColorDecode generates r,g,b values in [0.0, 1.0] 
 */
int devColorDecode(code, R, G, B)
 int code;
 double *R, *G, *B;
 {
  *R = *G = *B = ((double)code+0.5) / 9.0;
  return (0);
 }

int devPick(x,y,button)
 int *x,*y,*button;
 {
  *x = 0; *y = 0; *button = 0; return(-1);  /* what pointer? */
 }
/*       -30-         */

