/*
  File: Wireframe.c
  Author: K.R. Sloan
  Last Modified: 4 November 1988
  Purpose: Display trivial wireframe data in the form:
                x0 y0 z0    x1 y1 z1
           Each pair of endpoints specifies a line.

           Viewing specifications are given on the command line
               -e ex ey ez : specifies the eyepoint
                               (default [ 4.0,  5.0,  6.0])
               -o ox ox oz : specifies the viewing direction
                               (default [-4.0, -5.0, -6.0])
               -u ux uy uz : specifies the "up" vector
                               (default [0.0, 1.0, 0.0])
               -f f        : specifies the focal length lens

            
            The image is displayed in a window approximately the size and
            shape of a 35mm frame (36x24mm),  centered on the screen and
            oriented horizontally
 */

#include <stdio.h>
#include <3D.h>

double atof();

static char *RoutineName;
static void usage()
 {
  fprintf(stderr,"Usage is\n\t%s [-e x y z][-o x y z][-u x y z][-f f]\n",
                 RoutineName);
 }


int main(argc, argv)
 int argc; 
 char *argv[];
 {
  int ArgsParsed = 0;
  static sgpRectangleType Window   = {-18.00,  12.00, 18.00, -12.00};
  static sgpRectangleType Viewport = { -0.25,   1.00,  1.25,   0.00};  
  static PointType3D EyePoint    = { 10.0,  20.0, 30.0};
  static VectorType3D OpticalAxis = { -1.0,  -2.0, -3.0};
  static VectorType3D Up = {0.0, 1.0, 0.0};
  static double FocalLength = 200.0;

  PointType3D Vertex[2];
  static sgpColorType White = {1.0, 1.0, 1.0};
  static sgpColorType Gray18= {0.49, 0.49, 0.49};
  int coordinates;

  RoutineName = argv[ArgsParsed++];

  while (ArgsParsed < argc)
   {
    if ('-' == argv[ArgsParsed][0])
     {
      switch (argv[ArgsParsed++][1])
       {
        case 'e':
         if ((argc-ArgsParsed)<3) { usage(); exit (-1); }
         EyePoint.x = atof(argv[ArgsParsed++]);
         EyePoint.y = atof(argv[ArgsParsed++]);
         EyePoint.z = atof(argv[ArgsParsed++]);
         break;
        case 'o':
         if ((argc-ArgsParsed)<3) { usage(); exit (-1); }
         OpticalAxis.dx = atof(argv[ArgsParsed++]);
         OpticalAxis.dy = atof(argv[ArgsParsed++]);
         OpticalAxis.dz = atof(argv[ArgsParsed++]);
         break;
        case 'u':
         if ((argc-ArgsParsed)<3) { usage(); exit (-1); }
         Up.dx = atof(argv[ArgsParsed++]);
         Up.dy = atof(argv[ArgsParsed++]);
         Up.dz = atof(argv[ArgsParsed++]);
         break;
        case 'f':
         if ((argc-ArgsParsed)<1) { usage(); exit (-1); }
         FocalLength = atof(argv[ArgsParsed++]);
         break;
        case 'h': 
        default:
         usage(); exit(-1);
       }
     }
    else { usage(); exit (-1); }
   }   
  sgpInit(ColorDisplay);
  sgpSetWindow(Window);
  sgpSetViewport(Viewport);
  sgpColor(Gray18); sgpClearScreen();

  Camera3D(EyePoint, OpticalAxis, Up);
  Lens3D(FocalLength);

  sgpColor(White);
  for (;;)
   {
     coordinates = fscanf(stdin," %lf %lf %lf %lf %lf %lf",
                                &Vertex[0].x,&Vertex[0].y,&Vertex[0].z,
                                &Vertex[1].x,&Vertex[1].y,&Vertex[1].z);

     if      (6 == coordinates)
      {
       Line3D(Vertex[0], Vertex[1]);
      }
     else if (EOF == coordinates) break;
     else
      { 
       fprintf(stderr,"%s: error [%d] reading input file\n",
                RoutineName,coordinates);
       break;
      }
   }
  sgpQuit();
  exit(0);
 }


