/*
  File: Test4D.c
  Author: K.R. Sloan, Jr.
          Tony DeRose
  Last Modified: 23 May 1986
  Purpose: Test 4D homogeneous coordinate manipulation package
 */

#include <stdio.h>
#include <4D.h>
#define PI  3.1415926

static char *RoutineName;
static void usage()
 {
  fprintf(stderr,"Usage is\n\t%s\n",RoutineName);
 }


main(argc, argv)
 int argc; 
 char *argv[];
 {
  int ArgsParsed = 0;
  PointType4D P, Q, PT;
  TransformType4D A,B,C,I,T,S,R,Per;
  double Radians = PI;
  double f = 35.0;

  int i,j;

  RoutineName = argv[ArgsParsed++];

  while (ArgsParsed < argc) { usage(); exit (-1); }

  /* for Tony */
  P.P[0] = 0.0; P.P[1] = 0.0; P.P[2] = 0.0; P.P[3] = 1.0;
  Q.P[0] = 1.0; Q.P[1] = 0.0; Q.P[2] = 0.0; Q.P[3] = 1.0;
  Radians = 0.707;
  R = Rotate4D(P, Q, Radians);
  fprintf(stderr,"R is\n"); printT(R);
  /* for Tony */

  I = Identity4D();
  fprintf(stderr,"I is\n");  printT(I);

  P.P[0] = 1.0; P.P[1] = 2.0; P.P[2] = 3.0; P.P[3] = 1.0;
  Q = PxT4D(P,I);
  fprintf(stderr,"P is\n"); printP(P);
  fprintf(stderr,"Q is\n"); printP(Q);
  T = Translate4D(P);
  fprintf(stderr,"T is\n"); printT(T);
  S = Scale4D(P);
  fprintf(stderr,"S is\n"); printT(S);
  R = Rotate4D(P, Q, Radians);
  fprintf(stderr,"R is\n"); printT(R);
  Per = Perspective4D(f);
  fprintf(stderr,"Per is\n"); printT(Per);
  C = TxT4D(T, S);
  fprintf(stderr,"TS is\n"); printT(C);
  C = TxT4D(C, R);
  fprintf(stderr,"TSR is\n"); printT(C);
  C = TxT4D(C, Per);
  fprintf(stderr,"TSRPer is\n"); printT(C); 
  Q = PxT4D(P,C);
  fprintf(stderr,"P is\n"); printP(P);
  fprintf(stderr,"PTSRPer is\n"); printP(Q);
 }


