/*
  File: EulerOps.c
  Author: David Meyers
  Last Modified: 21 August 1990
  Purpose: A set of Euler operators.
 */

#include<stdio.h>
#include<WingEdge.h>
#include<WETraversal.h>
#define FALSE (0)
#define TRUE (1)

extern char *malloc();
extern void free();
extern void exit();

extern void MakeVertexFaceShell(TheFace, TheVertex)
 WEFaceNode **TheFace;
 WEVertexNode **TheVertex;
{
 *TheFace = (WEFaceNode *) malloc(sizeof(WEFaceNode));
 if(NULL == *TheFace)
  {
   (void) fprintf(stderr,"Unable to allocate memory: MakeVertexFaceShell\n");
   exit(-1);
  }
 *TheVertex = (WEVertexNode *) malloc(sizeof(WEVertexNode));
 if(NULL == *TheVertex)
  {
   (void) fprintf(stderr,"Unable to allocate memory: MakeVertexFaceShell\n");
   exit(-1);
  }
 (*TheFace)->Edges = NULL;
 (*TheFace)->Vertices = *TheVertex;
 (*TheFace)->next = *TheFace; (*TheFace)->prev = *TheFace;
 (*TheVertex)->Edges = NULL;
}

/* extern void KillVertexFaceShell(); */

extern void MakeEdgeVertex(TheFace, TheVertex, CCWEdge)
 WEFaceNode *TheFace;
 WEVertexNode *TheVertex;
 WingEdgeNode *CCWEdge;
{
 WEVertexNode *NewVertex;
 WingEdgeNode *NewEdge;

 NewVertex = (WEVertexNode *) malloc(sizeof(WEVertexNode));
 if(NULL == NewVertex)
  {
   (void) fprintf(stderr,"Unable to allocate memory: MakeEdgeVertex\n");
   exit(-1);
  }
 NewEdge = (WingEdgeNode *) malloc(sizeof(WingEdgeNode));
 if(NULL == NewEdge)
  {
   (void) fprintf(stderr,"Unable to allocate memory: MakeEdgeVertex\n");
   exit(-1);
  }
 NewEdge->Org = TheVertex;
 NewEdge->Dest = NewVertex;
 NewEdge->Left = TheFace;
 NewEdge->Right = TheFace;
 NewEdge->DCCW = NewEdge;
 NewEdge->DCW = NewEdge;
 NewVertex->Edges = NewEdge;

 if(NULL != CCWEdge)
  {
   NewEdge->OCCW = CCWEdge;
   if(TheVertex == CCWEdge->Org)
    {
     NewEdge->OCW = CCWEdge->OCW;
     CCWEdge->OCW = NewEdge;
    }
   else
    {
     NewEdge->OCW = CCWEdge->DCW;
     CCWEdge->DCW = NewEdge;
    }
   /* fix up the pointers on the edge, need to determine orientation */
   if(TheVertex == NewEdge->OCW->Org)
    {
     NewEdge->OCW->OCCW = NewEdge;
    }
   else
    {
     NewEdge->OCW->DCCW = NewEdge;
    }
  }
 else /* adding an edge and vertex to an isolated vertex here */
  {
   TheFace->Edges = NewEdge;
   TheVertex->Edges = NewEdge;
   NewEdge->OCCW = NewEdge;
   NewEdge->OCW = NewEdge;
  }
}

/* extern void KillEdgeVertex(); */

extern void MakeEdgeFace(V1, V2, OldFace, V1CCW, V2CCW)
 WEVertexNode *V1, *V2;
 WEFaceNode *OldFace;
 WingEdgeNode *V1CCW, *V2CCW;
{
 WEFaceNode *NewFace;
 WEVertexNode *CurrentVertex;
 WingEdgeNode *CurrentEdge, *NewEdge, *Temp;

 NewFace = (WEFaceNode *) malloc(sizeof(WEFaceNode));
 NewEdge = (WingEdgeNode *) malloc(sizeof(WingEdgeNode));
 NewEdge->Org = V1; NewEdge->Dest = V2;
 NewEdge->OCCW = V1CCW;
 if(V1 == V1CCW->Org)
  {
   NewEdge->OCW = V1CCW->OCW;
   Temp = V1CCW->OCW;
   V1CCW->OCW = NewEdge;
   if(V1 == Temp->Org) 
    Temp->OCCW = NewEdge;
   else
    Temp->DCCW = NewEdge;
  }
 else /* V1 == V1CCW->Dest here */
  {
   NewEdge->OCW = V1CCW->DCW;
   Temp = V1CCW->DCW;
   V1CCW->DCW = NewEdge;
   if(V1 == Temp->Org) 
    Temp->OCCW = NewEdge;
   else
    Temp->DCCW = NewEdge;
  }
 NewEdge->DCCW = V2CCW;
 if(V2 == V2CCW->Org)
  {
   NewEdge->DCW = V2CCW->OCW;
   Temp = V2CCW->OCW;
   V2CCW->OCW = NewEdge;
   if(V2 == Temp->Org) 
    Temp->OCCW = NewEdge;
   else
    Temp->DCCW = NewEdge;
  }
 else
  {
   NewEdge->DCW = V2CCW->DCW;
   Temp = V2CCW->DCW;
   V2CCW->DCW = NewEdge;
   if(V2 == Temp->Org) 
    Temp->OCCW = NewEdge;
   else
    Temp->DCCW = NewEdge;
  }
 /* now fix up the Face pointers */
 NewEdge->Left = NewFace;
 NewEdge->Right = OldFace;
 NewFace->Edges = NewEdge;
 OldFace->Edges = NewEdge;
 NewFace->Vertices = NewEdge->Org;
 OldFace->Vertices = NewEdge->Org;
 NewFace->next = OldFace->next;
 NewFace->prev = OldFace;
 NewFace->next->prev = NewFace;
 OldFace->next = NewFace;
 CurrentVertex = V2;
 CurrentEdge = NewEdge->DCW;
 while(CurrentVertex != V1)
  {
   if(CurrentVertex == CurrentEdge->Org)
    {
     CurrentEdge->Left = NewFace;
     CurrentVertex = CurrentEdge->Dest;
     CurrentEdge = CurrentEdge->DCW;
    }
   else
    {
     CurrentEdge->Right = NewFace;
     CurrentVertex = CurrentEdge->Org;
     CurrentEdge = CurrentEdge->OCW;
    }
  }
}

extern WEFaceNode *KillEdgeFace(DeadEdge)
 WingEdgeNode *DeadEdge;
{
 WingEdgeNode *OCCW, *OCW, *DCCW, *DCW, *Current;
 WEFaceNode *DeadFace, *LiveFace;

 OCCW = DeadEdge->OCCW; OCW = DeadEdge->OCW;
 DCCW = DeadEdge->DCCW; DCW = DeadEdge->DCW;
 DeadFace = DeadEdge->Right; LiveFace = DeadEdge->Left;
 Current = DeadEdge;

 /* change the face pointers for the edges in the face to be removed */
 do /* while Current != DeadEdge */
  {
   if(Current->Left == DeadFace)
    Current->Left = LiveFace;
   else if(Current->Right == DeadFace)
    Current->Right = LiveFace;
   else /* Error condition here */
    {
     (void)fprintf(stderr,"KillEdgeFace: inconsistent Wing Edge structure\n");
     exit(1);
    }
   if(Current->Right == LiveFace)
    Current = Current->OCW;
   else
    Current = Current->DCW;
  } while (Current != DeadEdge);

 /* fix up the edge connections at the vertices of the edge to be deleted */
 if(OCCW->Org == DeadEdge->Org)
  OCCW->OCW = OCW;
 else
  OCCW->DCW = OCW;

 if(OCW->Org == DeadEdge->Org)
  OCW->OCCW = OCCW;
 else
  OCW->DCCW = OCCW;

 if(DCCW->Org == DeadEdge->Dest)
  DCCW->OCW = DCW;
 else
  DCCW->DCW = DCW;

 if(DCW->Org == DeadEdge->Dest)
  DCW->OCCW = DCCW;
 else
  DCW->DCCW = DCCW;

 /* 
   Just in case the deleted edge is the canonical edge for the LiveFace, fix
   the LiveFace canonical edge pointer to point to one we know is still here.
  */
 if(LiveFace->Edges == DeadEdge)
  LiveFace->Edges = OCCW;

 /* Remove the DeadFace from the circular list of faces */
 DeadFace->prev->next = DeadFace->next;
 DeadFace->next->prev = DeadFace->prev;
 DeadFace->next = NULL; DeadFace->prev = NULL;
 DeadFace->Vertices = NULL;
 DeadFace->Edges = NULL;
 free((char *) DeadFace);

 /* 
   Just in case we have deleted the face at which our global shell points,
   we will return a pointer to the LiveFace, which will ensure that we don't
   loose the whole subdivision.
  */
 return(LiveFace);
}

/* extern void KillEdgeMakeRing(); */

/* extern void MakeEdgeKillRing(); */

/* extern void KillFaceMakeRingHole(); */

/* extern void MakeFaceKillRingHole(); */

extern void KillFaceMakeBoundary(DeadFace)
 WEFaceNode *DeadFace;
{
 int Debug = FALSE;
 WingEdgeNode *CurrentEdge, *FirstEdge;

 CurrentEdge = DeadFace->Edges; FirstEdge = CurrentEdge;
 do
  {
   if(CurrentEdge->Right == DeadFace)
    {
     if(Debug)
      {
       (void)fprintf(stderr,"Right is dead\n"); (void)fflush(stderr);
       (void)fprintf(stderr, "Hit return in this window to continue: \n");
       (void)fscanf(stdin,"%*c");
      }
     CurrentEdge->Right = NULL;
     CurrentEdge = CurrentEdge->DCCW;
    }
   else
    {
     if(Debug)
      {
       (void)fprintf(stderr,"Left is dead\n"); (void)fflush(stderr);
       (void)fprintf(stderr, "Hit return in this window to continue: \n");
       (void)fscanf(stdin,"%*c");
      }
     CurrentEdge->Left = NULL;
     CurrentEdge = CurrentEdge->OCCW;
    }
  } while(CurrentEdge != FirstEdge);
 /* excise the dead face from the face list... */
 DeadFace->prev->next = DeadFace->next;
 DeadFace->next->prev = DeadFace->prev;
 DeadFace->prev = NULL; DeadFace->next = NULL; DeadFace->Edges = NULL;
 free((char *) DeadFace);
}

/* extern void MakeFaceKillBoundary(); */

