/*
 * tif2ps/tifdump -- convert TIFF to PostScript
 *
 * written by:
 * Andreas Lampen, TU-Berlin (andy@coma.UUCP)
 *			     (andy@db0tui62.BITNET)
 *
 * Copyright (C) 1988 by the author.
 * Permission is granted to copy and distribute this program
 * without charge, provided this copyright notice is included
 * in the copy.
 * This Software is distributed on an as-is basis. There will be
 * ABSOLUTELY NO WARRANTY for any part of this software to work
 * correct. In no case will the author be liable to you for damages
 * caused by the usage of this software.
 */

/*
 * tif.h -- type and constant definitions
 * 
 * $Header: tif.h[1.0] Thu Dec 29 20:10:15 1988 andy@coma published $
 */

/*
 * installation dependent definitions
 */

#define MAXIFDS 16
#define MAXVAL  128

/*===========================
 * General Types
 *===========================*/

/* Input file descriptor */
typedef struct {
  FILE    *fdes;
  USHORT  order;              /* Byte order */
} DATAFILE;

/*===========================
 * Picture Data Types
 *===========================*/

/* strips */
typedef struct {
  ULONG    byteCount;
  CHAR     *data;
} STRIP;

/* general image data */
typedef struct {
  USHORT subfileType;
  USHORT imWidth;
  USHORT imLength;
  ULONG  rowsPerStrip;		/* may be SHORT -- not implemented */
  USHORT stripsPerImage;	/* number of strips */
  STRIP  *strips;		/* List of pointers to Strips */
  USHORT samplesPerPixel;	/* always 1 -- handle only monochrome picts. */
  USHORT bitsPerSample;		/* should be capable to hold multiple values */
				/* for color pictures */
  USHORT planConf;		/* Planar Configuration */
  USHORT compression;		/* should be capable to hold multiple values */
				/* for color pictures */
  ULONG  gr3Options;
  ULONG  gr4Options;
  USHORT fillOrder;
  USHORT threshholding;
  USHORT cellWidth;
  USHORT cellLength;  
} IMAGE;
/* photometrics */
typedef struct {
  USHORT minSampleValue;
  USHORT maxSampleValue;
  USHORT photometInterpr;	/* Photometric Interpretation */
  USHORT grayResponseUnit;
  USHORT *grayResponseCurve;	/* Array of grayvalues */
} PHMETRIC;

/* correspondence to the physical world */
typedef struct {
  DOUBLE   xRes;                 /* XResolution */
  DOUBLE   yRes;                 /* YResolution */
  USHORT   resUnit;              /* ResolutionUnit */
  USHORT   orientation;
} PHYS;

/* document context */
typedef struct {
  CHAR     *docName;
  CHAR     *pageName;
  DOUBLE   xPos;		/* XPosition -- lower left corner */
  DOUBLE   yPos;		/* YPosition -- lower left corner */
  DOUBLE   xMax;		/* XMaximum -- upper right corner */
  DOUBLE   yMax;		/* YMaximum -- upper right corner */
  USHORT   pageNo;		/* page number */
  USHORT   noOfPages;		/* total number of pages */
} CONTEXT;

/* a whole picture */
typedef struct {
  IMAGE    image;
  PHMETRIC photoMetric;
  PHYS     physWorld;
  CONTEXT  context;
} PICTURE;
	
/*===========================
 * TIFF Types
 *===========================*/

/* IFD Entry */
typedef struct {
  USHORT   tag;			/* entry Tag */
  USHORT   type;		/* entry type */
  ULONG    length;		/* entry length */
  ULONG    valoffset;		/* value or value offset */
  CHAR     *value;		/* pointer to value */
} ENTRY;

/* Image File Directory (IFD) */
typedef struct {
  USHORT   entrycount;		/* number of entries in IFD */
  ENTRY    *entrylist;		/* list of IFD entries */
  ULONG    nextifd;		/* Offset of next IFD */
} IFD;

/* TIF-file Header */
typedef struct {
  USHORT  byteorder;		/* Byte order "II" or "MM" */
  USHORT  version;		/* TIFF Version (current 42) */
  ULONG   offset;		/* offset of first IFD */
} HEADER;
  
/* general structure */
typedef struct {
  HEADER  header;               /* Header of TIF-file */
  IFD     ifdlist[MAXIFDS];	/* List of IFDs */
} TIFF;

/*==============================
 * constants
 *==============================*/

#define TIFFBYTE     1
#define TIFFASCII    2
#define TIFFSHORT    3
#define TIFFLONG     4
#define TIFFRATIONAL 5

#define INTELTIFF    0x4949
#define MOTOROLATIFF 0x4d4d

/*** Fields ***/

#define SUBFILETYPE        	255
#define IMAGEWIDTH         	256
#define IMAGELENGTH        	257
#define BITSPERSAMPLE      	258
#define COMPRESSION        	259
#define PHOTOMETRICINTERPR	262
#define THRESHHOLDING      	263
#define CELLWIDTH          	264
#define CELLLENGTH         	265
#define FILLORDER          	266
#define DOCUMENTNAME       	269
#define IMAGEDESCRIPTION   	270
#define MAKE               	271
#define MODEL              	272
#define STRIPOFFSETS       	273
#define ORIENTATION        	274
#define SAMPLESPERPIXEL    	277
#define ROWSPERSTRIP       	278
#define STRIPBYTECOUNTS    	279
#define MINSAMPLEVALUE     	280
#define MAXSAMPLEVALUE     	281
#define XRESOLUTION        	282
#define YRESOLUTION        	283
#define PLANARCONFIGURATION	284
#define PAGENAME           	285
#define XPOSITION          	286
#define YPOSITION          	287
#define FREEOFFSETS        	288
#define FREEBYTECOUNTS     	289
#define GRAYRESPONSEUNIT   	290
#define GRAYRESPONSECURVE  	291
#define GROUP3OPTIONS      	292
#define GROUP4OPTIONS      	293
#define RESOLUTIONUNIT     	296
#define PAGENUMBER         	297
#define COLORRESPONSEUNIT  	300
#define COLORRESPONSECURVES	301
