
#include <stdio.h>
#include "bitmap.h"

extern char *malloc();
extern FILE *fopen();

#define MAX_IN_MEMORY	500000L

static int Bitmasks[] = { 1, 2, 4, 8, 16, 32, 64, 128 };
static int bitcount = 0;

static int
NumBits( colors )
int colors;
{
	int  val;
	int  bits;

	val = 2;
	bits = 1;

	while( colors > val ) {
		val *= 2;
		bits++;
	}

	return bits;
}


void
Bitmap_GetScanLine( bitmap, scanline, ptr )
Bitmap *bitmap;
int scanline;
char **ptr;
{
	if( bitmap->BFlags == BITMAP_IN_MEMORY ) {
		*ptr = bitmap->lineptr[scanline];
		return;
	}

	if( scanline == bitmap->BCached ) {
		*ptr = (char *)(bitmap->lineptr);
		return;
	}

	if( bitmap->BCached >= 0 ) {
		fseek( bitmap->BFile, 
		       (long)bitmap->BCached * (long)bitmap->BBytes,
		       0 );
		fwrite( (char *)(bitmap->lineptr), 1, 
			bitmap->BBytes, bitmap->BFile );
	}

	fseek( bitmap->BFile, (long)scanline * (long)bitmap->BBytes, 0 );
	fread( (char *)(bitmap->lineptr), 1, 
	       bitmap->BBytes, bitmap->BFile );

	bitmap->BCached = scanline;

	*ptr = bitmap->lineptr;
}

char *
Bitmap_Name( count )
int count;
{
	static char buffer[ 80 ];
	char temp[ 20 ];
	char *ptr;
	extern char *getenv();

	ptr = getenv( "TMPDIR" );
	if( ptr == (char *)0 )
		strcpy( buffer, "" );
	else {
		strcpy( buffer, ptr );
		if( buffer[ strlen( buffer ) - 1 ] != '\\' )
			strcat( buffer, "\\" );
	}
	sprintf( temp, "bitmap%d", bitcount );
	strcat( buffer, temp );

	return buffer;
}

Bitmap *
Bitmap_Create( width, height, colors )
int width, height;
int colors;
{
	int i, j;
	int bytes;
	int bits;
	Bitmap *bitmap;
	long total_size;
	char *bname;
	char *ptr;

	bitmap = (Bitmap *) malloc( sizeof( Bitmap ) );
	if( bitmap == (Bitmap *)0 )
		return (Bitmap *)0;
		
	/* 
	 * Find out how many bits we need for 'colors' colors
	 */
	bits = NumBits( colors );

	/*
	 * Save sizes of bitmap
	 */
	bitmap->BWidth  = width;
	bitmap->BHeight = height;
	bitmap->BBits   = bits;
	bitmap->BColors = colors;

	bitmap->pal = (struct PAL_ENTRY *) malloc( sizeof( struct PAL_ENTRY ) *
			colors );

	if( bitmap->pal == (char *)0 )
		return NIL;

	bzermem( bitmap->pal, sizeof( struct PAL_ENTRY ) * colors );


	bytes = ((width + 7) * bits) / 8;
	bitmap->BBytes = bytes;

	total_size = (long)bytes * (long)height;
	if( total_size > MAX_IN_MEMORY ) {

on_file:
		bname = Bitmap_Name( bitcount );
		printf( "Bitmap_Create: file '%s' for %ld byte bitmap\n", 
				bname, total_size );

		bitmap->BNumber = bitcount++;
		bitmap->BFile = fopen( bname, "wb" );

		if( bitmap->BFile == (FILE *)0 ) {
			free( bitmap->pal );
			free( bitmap );
			return NIL;
		}

		bitmap->lineptr = (char **) malloc( bytes );

		bzermem( bitmap->lineptr, bytes );
		bitmap->BCached = -1;
		bitmap->BFlags = BITMAP_IN_FILE;

		for( i=0; i<height; i++ ) {
			fwrite( bitmap->lineptr, 1, bytes, bitmap->BFile );
		}

		printf( "Created bitmap file.\n" );
		fclose( bitmap->BFile );
		bitmap->BFile = fopen( bname, "rb+" );

	} else {

		bitmap->lineptr = (char **) malloc( sizeof( char * ) * height );
		if( bitmap->lineptr == (char **)0 ) {
			free( bitmap->pal );
			free( bitmap );
			return NIL;
		}

		for( i=0; i<height; i++ ) {
			bitmap->lineptr[i] = (char *) malloc( bytes );
	
			/*
			 * If the malloc failed, free up all the memory 
			 * allocated so far
			 */
			if( bitmap->lineptr[i] == (char *)0 ) {
				for( j=0; j<i; j++ ) {
					free( bitmap->lineptr[j] );
				}
				free( bitmap->lineptr );
				goto on_file;
			}
			bzermem( bitmap->lineptr[i], bytes );
		}
		bitmap->BFlags = BITMAP_IN_MEMORY;
	}
	return bitmap;
}

/*
 * Plots a pixel at (x,y)
 */
Bitmap_Plot( bitmap, x, y, value )
Bitmap *bitmap;
int x, y;
int value;
{
	int byteoffset;
	int mask;
	char *ptr;
	int i;

	if( x >= bitmap->BWidth || x < 0 ) return NIL;
	if( y >= bitmap->BHeight || y < 0 ) return NIL;
		
	x *= bitmap->BBits;
	byteoffset = x / 8;
	mask = Bitmasks[ x % 8 ];

	if( bitmap->BFlags == BITMAP_IN_MEMORY )
		ptr = &bitmap->lineptr[ y ][ byteoffset ];
	else {
		Bitmap_GetScanLine( bitmap, y, &ptr );
		ptr += byteoffset;
	}
	
	i = bitmap->BBits;
	while( i > 0 ) {
		if( value & 1 )
			*ptr |= mask;
		else
			*ptr &= ~mask;

		value >>= 1;
		mask <<= 1;
		if( mask > 128 ) {
			mask = 1;
			ptr++;
		}
		i--;
	}

	return NIL;
}

/*
 * Returns the pixel at (x,y)
 */
int
Bitmap_Get( bitmap, x, y )
Bitmap *bitmap;
int x, y;
{
	int byteoffset;
	int mask;
	char *ptr;
	int value;
	int i, vmask;
	
	if( x >= bitmap->BWidth || x < 0 ) return 0;
	if( y >= bitmap->BHeight || y < 0 ) return 0;
		
	x *= bitmap->BBits;
	byteoffset = x / 8;
	mask = Bitmasks[ x % 8 ];

	ptr = &bitmap->lineptr[ y ][ byteoffset ];

	if( bitmap->BFlags == BITMAP_IN_MEMORY )
		ptr = &bitmap->lineptr[ y ][ byteoffset ];
	else {
		Bitmap_GetScanLine( bitmap, y, &ptr );
		ptr += byteoffset;
	}
	
	value = 0;
	i = bitmap->BBits;
	vmask = 1;
	while( i > 0 ) {
		if( *ptr & mask )
			value |= vmask;

		vmask <<= 1;
		mask <<= 1;
		if( mask > 128 ) {
			mask = 1;
			ptr++;
		}
		i--;
	}

	return value;
}

Bitmap_Free( bitmap )
Bitmap *bitmap;
{
	int i;
	char *ptr;

	if( bitmap->BFlags == BITMAP_IN_MEMORY ) {
		for( i=0; i<bitmap->BHeight; i++ )
			free( bitmap->lineptr[i] );
	} else {
		fclose( bitmap->BFile );
		ptr = Bitmap_Name( bitmap->BNumber );
#if unix || MarkWilliams
		unlink( ptr );
#else
		remove( ptr );
#endif
		/*
		 * Unlink the file
		 */
	}

	free( bitmap->lineptr );
	free( bitmap->pal );
	free( bitmap );
}

bzermem( ptr, size )
register char *ptr;
register unsigned int size;
{
	while( size-- ) *ptr++ = 0;
}	
