/**********************************************************************
 *
 * vlistbrowserclass.cpp -- 
 * Copyright (C) 1999  The New Zealand Digital Library Project
 *
 * A component of the Greenstone digital library software
 * from the New Zealand Digital Library Project at the
 * University of Waikato, New Zealand.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 *********************************************************************/

#include "vlistbrowserclass.h"
#include <assert.h>
#include "OIDtools.h"

vlistbrowserclass::vlistbrowserclass () {
}

vlistbrowserclass::~vlistbrowserclass () {
}

// returns the name that specifies the browserclass type
text_t vlistbrowserclass::get_browser_name () {
  return "VList";
}

void vlistbrowserclass::load_metadata_defaults (text_tset &metadata) {
  metadata.insert ("haschildren");
  metadata.insert ("doctype");
}

text_t vlistbrowserclass::get_default_formatstring () {
  return "<td>[link][icon][/link]</td><td>[highlight]{Or}{[Title],Untitled}[/highlight]</td>";
}

int vlistbrowserclass::output_section_group (ResultDocInfo_t &section, cgiargsclass &args,
					     const text_t &collection, int colnumber, 
					     format_t *formatlistptr, bool use_table, 
					     text_tset &/*metadata*/, bool &/*getParents*/, 
					     recptproto * collectproto, displayclass &disp, 
					     outconvertclass &outconvert, ostream &textout, 
					     ostream& logout) {

  text_t link, icon;

  text_t collink = collection;
  if (!collink.empty()) collink = "&c=" + collink;

  get_link_icon (section, args, collink, link, icon);
  bool highlight = false;
  if (!args["d"].empty()) {
    if (args["d"] == section.OID) highlight = true;
  } else 
    if (args["cl"] == section.OID) highlight = true;


  if (use_table || colnumber > 0) {
    textout << "<table><tr valign=top>";
    // get tab size
    text_t tab; int itab;
    disp.expandstring ("Global", "_tabwidth_", tab);
    itab = tab.getint();
    if (colnumber > 0) textout << outconvert << disp 
			       << "<td><img src=\"_httpimg_/space.gif\" width=" 
			       << (itab*colnumber) << "></td>";
  }

  textout << outconvert << disp 
	  << get_formatted_string (collection, collectproto, 
				   section, disp, formatlistptr, 
				   link, icon, highlight, logout);
  
  if (use_table  || colnumber > 0) textout << "</tr></table>\n";

  return 1;
}

int vlistbrowserclass::output_section_group (FilterResponse_t &sections, cgiargsclass &args,
					     const text_t &collection, int colnumber, 
					     format_t *formatlistptr, bool use_table, 
					     text_tset &/*metadata*/, bool &/*getParents*/, 
					     recptproto * collectproto, displayclass &disp, 
					     outconvertclass &outconvert, ostream &textout, 
					     ostream& logout) {

  text_t link, icon;
  text_t &arg_d = args["d"];
  text_t &arg_cl = args["cl"];

  text_t collink = collection;
  if (!collink.empty()) collink = "&c=" + collink;

  if (colnumber > 0) {
    textout << "<table><tr valign=top>";
    // get tab size
    text_t tab; int itab;
    disp.expandstring ("Global", "_tabwidth_", tab);
    itab = tab.getint();
    if (colnumber > 0) textout << outconvert << disp 
			       << "<td><img src=\"_httpimg_/space.gif\" width=" 
			       << (itab*colnumber) << "></td>";
    textout << "<td>";
  }
  if (use_table) textout << "<table>\n";

  ResultDocInfo_tarray::iterator thissection = sections.docInfo.begin();
  ResultDocInfo_tarray::iterator endsection = sections.docInfo.end();

  while (thissection != endsection) {

    get_link_icon (*thissection, args, collink, link, icon);
    bool highlight = false;
    if (!arg_d.empty()) {
      if (arg_d == (*thissection).OID) highlight = true;
    } else 
      if (arg_cl == (*thissection).OID) highlight = true;

    if (use_table || colnumber > 0) textout << "<tr valign=top>";
    textout << outconvert << disp 
	    << get_formatted_string (collection, collectproto, 
				     *thissection, disp, formatlistptr, 
				     link, icon, highlight, logout);

    if (use_table || colnumber > 0) textout << "</tr>";
    textout << "\n";
    thissection ++;
  }

  if (use_table) textout << "</table>\n";
  if (colnumber > 0) textout << "</table></td></tr></table>\n";

  return 1;
}


// get_link_icon attempts to work out what type of icon should be displayed for
// the given section and what it should link to.
void vlistbrowserclass::get_link_icon (ResultDocInfo_t &section, cgiargsclass &args,
				       const text_t &collink, text_t &link, text_t &icon) {

  link = "<a href=\"_httpdocument_" + collink;
  icon = "_document:icontext_";
  int haschildren = 0;

  if (section.metadata.count("haschildren")>0)
    haschildren = section.metadata["haschildren"].values[0].getint();

  text_t doctype;
  if (section.metadata.count("doctype")>0)
    doctype = section.metadata["doctype"].values[0];

  text_t &arg_d = args["d"];
  text_t &arg_cl = args["cl"];

  if (args["a"] == "q") {
    // query results
    if (is_top (section.OID)) icon = "_document:iconclosedbook_";
    else if (haschildren == 1) icon = "_document:iconclosedfolder_";
    link += "&cl=search&d=" + section.OID + "\">";

  } else if (!arg_d.empty()) {
    // document level
    if (is_top(section.OID)) {
      icon = "_document:iconopenbook_";
      if (arg_cl == "search") link = "<a href=\"_httpquery_\">";
      else link += "&cl=" + arg_cl + "\">";
    
    } else if (haschildren == 1) {
      if ((args["gc"] == "1") || 
	  (is_child_of (section.OID, arg_d)) ||
	  (section.OID == arg_d)) {
	icon = "_document:iconopenfolder_";
	link += "&cl=" + arg_cl + "&d=" + section.OID + ".pr\">";
      } else {
	icon = "_document:iconclosedfolder_";
	link += "&cl=" + arg_cl + "&d=" + section.OID + "\">";
      }
    } else link += "&cl=" + arg_cl + "&d=" + section.OID + "\">";

  } else {
    // classification level
    if (haschildren == 1) {
      if (doctype == "classify") {
	if ((args["gc"] == "1") || 
	    (is_child_of (section.OID, arg_cl)) || 
	    (section.OID == arg_cl)) {
	  icon = "_document:iconopenbookshelf_";
	  link += "&cl=" + section.OID + ".pr\">";
	} else {
	  icon = "_document:iconclosedbookshelf_";
	  link += "&cl=" + section.OID + "\">";
	}
      } else {
	icon = "_document:iconclosedbook_";
	link += "&cl=" + arg_cl + "&d=" + section.OID + "\">";
      }
    } else {
      if (doctype == "classify") link = "";
      else link += "&cl=" + arg_cl + "&d=" + section.OID + "\">";
    }
  }
}
