/**********************************************************************
 *
 * nullproto.h -- 
 * Copyright (C) 1999  The New Zealand Digital Library Project
 *
 * A component of the Greenstone digital library software
 * from the New Zealand Digital Library Project at the
 * University of Waikato, New Zealand.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 *********************************************************************/


#ifndef NULLPROTO_H
#define NULLPROTO_H

#include "gsdlconf.h"
#include "collectserver.h"
#include "collectset.h"
#include "recptproto.h"
#include "receptionist.h"

class nullproto : public recptproto {
protected:
  collectset           *cset;
public:
  nullproto();
  virtual ~nullproto();

  // add_collection sets up the collectionserver and calls
  // add_collectserver
  virtual void add_collection (const text_t &collection, void *recpt, 
			       const text_t &gsdlhome, const text_t &gdbmhome);

  void set_collectset(collectset *set) { this->cset = set; }

  // remove_collection deletes the collection server of collection.
  // This only needs to be called if a collectionserver is to be
  // removed while the library is running as the destructor function
  // cleans up all collectservers when the program exits.
  void remove_collection (const text_t &collection, ostream &logout);

  // this configure will configure each of the collection servers
  void configure (const text_t &key, const text_tarray &cfgline);

  // this init will init each of the collection servers
  bool init (ostream &logout);

  text_t get_protocol_name ();
  text_t get_site_name ();

  void get_collection_list (text_tarray &collist, comerror_t &err, 
			    ostream &logout);
  void has_collection (const text_t &collection, bool &hascollection, 
		       comerror_t &err, ostream &logout);
  void ping (const text_t &collection, bool &wassuccess, 
	     comerror_t &err, ostream &logout);
  void get_collectinfo (const text_t &collection, 
			ColInfoResponse_t &collectinfo,
			comerror_t &err, ostream &logout);
  void get_filterinfo (const text_t &collection,
		       InfoFiltersResponse_t &response,
		       comerror_t &err, ostream &logout);
  void get_filteroptions (const text_t &collection,
			  const InfoFilterOptionsRequest_t &request,
			  InfoFilterOptionsResponse_t &response, 
			  comerror_t &err, ostream &logout);
  void filter (const text_t &collection,
	       FilterRequest_t &request,
	       FilterResponse_t &response,
	       comerror_t &err, ostream &logout);

  void get_document (const text_t &collection,
		     const DocumentRequest_t &request,
		     DocumentResponse_t &response,
		     comerror_t &err, ostream &logout);

};


#endif
