/**********************************************************************
 *
 * htmlbrowserclass.cpp -- 
 * Copyright (C) 1999  The New Zealand Digital Library Project
 *
 * A component of the Greenstone digital library software
 * from the New Zealand Digital Library Project at the
 * University of Waikato, New Zealand.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 *********************************************************************/

#include "htmlbrowserclass.h"
#include <assert.h>
#include "OIDtools.h"

htmlbrowserclass::htmlbrowserclass () {
}

htmlbrowserclass::~htmlbrowserclass () {
}

// returns the name that specifies the browserclass type
text_t htmlbrowserclass::get_browser_name () {
  return "HTML";
}

// redirect to html page
void htmlbrowserclass::processOID (cgiargsclass &args, recptproto *collectproto,
				   ostream &logout) {

  // should only reach here from within a classification
  if (!args["d"].empty()) return;
  if (args["cl"].empty()) return;

  FilterRequest_t request;
  FilterResponse_t response;
  comerror_t err;
  request.filterName = "NullFilter";
  request.filterResultOptions = FROID;
  request.docSet.push_back (args["cl"] + ".fc");
  collectproto->filter (args["c"], request, response, err, logout);

  if (err != noError || response.docInfo[0].OID.empty()) return;

  // redirect to html page
  args["a"] = "p";
  args["p"] = "html";
  args["hp"] = response.docInfo[0].OID;
}
