/**********************************************************************
 *
 * hlistbrowserclass.cpp -- 
 * Copyright (C) 1999  The New Zealand Digital Library Project
 *
 * A component of the Greenstone digital library software
 * from the New Zealand Digital Library Project at the
 * University of Waikato, New Zealand.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 *********************************************************************/

#include "hlistbrowserclass.h"
#include <assert.h>
#include "OIDtools.h"

hlistbrowserclass::hlistbrowserclass () {
}

hlistbrowserclass::~hlistbrowserclass () {
}

// returns the name that specifies the browserclass type
text_t hlistbrowserclass::get_browser_name () {
  return "HList";
}

void hlistbrowserclass::load_metadata_defaults (text_tset &metadata) {
  metadata.insert ("doctype");
}

text_t hlistbrowserclass::get_default_formatstring () {
  return "[link][highlight][Title][/highlight][/link]";
}

// need to change OID to it's child 
void hlistbrowserclass::processOID (cgiargsclass &args, recptproto *collectproto,
				    ostream &logout) {

  text_t OID = args["d"];
  bool is_classify = false;
  if (OID.empty()) {
    is_classify = true;
    OID = args["cl"];
  }

  FilterResponse_t response;
  text_tset metadata;
  metadata.insert ("childtype");
  text_t classifytype = "Invisible";
  text_t child_doctype;

  text_tarray OIDs;

  while (classifytype == "Invisible") {
    OIDs.erase (OIDs.begin(), OIDs.end());
    
    OIDs.push_back (OID);
    OIDs.push_back (OID + ".fc");

    get_info (OIDs, args["c"], metadata, false, collectproto, response, logout);

    OID = response.docInfo[1].OID;
    classifytype = response.docInfo[0].metadata["childtype"].values[0];
  }
  if (is_classify) args["cl"] = OID;
  else args["d"] = OID;
}

int hlistbrowserclass::output_section_group (ResultDocInfo_t &section, cgiargsclass &args,
					     const text_t& collection, int colnumber, 
					     format_t *formatlistptr, bool use_table, 
					     text_tset &metadata, bool &getParents, 
					     recptproto *collectproto, displayclass &disp, 
					     outconvertclass &outconvert, ostream &textout, 
					     ostream &logout) {

  // expanded contents are going to cause some nasty recursions
  // so we'll only continue if being passed the current section
  if ((args["gc"] == 1) && (section.OID != args["d"])) return 0;

  // get all siblings
  FilterResponse_t response;
  text_t &arg_cl = args["cl"];
  get_children (section.OID + ".pr", args["c"], metadata, getParents, 
		collectproto, response, logout);

					
  if (use_table || colnumber > 0) {
    textout << "<table><tr><td>";
    // get tab size
    text_t tab; int itab;
    disp.expandstring ("Global", "_tabwidth_", tab);
    itab = tab.getint();
    if (colnumber > 0) textout << outconvert << disp 
			       << "<img src=\"_httpimg_/space.gif\" width=" 
			       << (itab*colnumber) << ">";
    textout << "</td>\n";
  }

  textout << "<table><tr>\n";

  ResultDocInfo_tarray::iterator tsibling = response.docInfo.begin();
  ResultDocInfo_tarray::iterator esibling = response.docInfo.end();

  text_t icon, link;
  while (tsibling != esibling) {

    bool highlight = false;
    textout << "<td>";
    text_t &doctype = (*tsibling).metadata["doctype"].values[0];

    if ((*tsibling).OID == section.OID) {
      link.clear();
      highlight = true;
    } else {
      link = "<a href=\"_httpdocument_";
      if (doctype == "classify") 
	link += "&cl=" + (*tsibling).OID + "\">";
      else
	link += "&cl=" + arg_cl + "&d=" + (*tsibling).OID + "\">";
    }

    textout << outconvert << disp 
	    << get_formatted_string (collection, collectproto,
				     *tsibling, disp, formatlistptr, link, icon, highlight,
				     logout);

    textout << "</td>\n";
    tsibling ++;
  }

  textout << "</tr></table>\n";
  if (use_table  || colnumber > 0) textout << "</tr></table>\n";
  return 0;
}

int hlistbrowserclass::output_section_group (FilterResponse_t &/*sections*/, cgiargsclass &/*args*/,
					     const text_t &/*collection*/, int /*colnumber*/, 
					     format_t * /*formatlistptr*/, bool /*use_table*/, 
					     text_tset &/*metadata*/, bool &/*getParents*/,
					     recptproto * /*collectproto*/, displayclass &/*disp*/, 
					     outconvertclass &/*outconvert*/, ostream &/*textout*/, 
					     ostream &/*logout*/) {
  return 0;
}
