/**********************************************************************
 *
 * documentaction.h -- 
 * Copyright (C) 1999  The New Zealand Digital Library Project
 *
 * A component of the Greenstone digital library software
 * from the New Zealand Digital Library Project at the
 * University of Waikato, New Zealand.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 *********************************************************************/


#ifndef DOCUMENTACTION_H
#define DOCUMENTACTION_H

#include "action.h"
#include "gsdlconf.h"
#include "formattools.h"
#include "receptionist.h"

class documentaction : public action {

protected:

  receptionist *recpt;

  bool get_link (cgiargsclass &args, recptprotolistclass *protos,
		 const text_t &inlink, text_t &outlink, ostream &logout);

  void load_formatinfo (const text_tmap &colformat, int gt);

  void set_spacemacro (displayclass &disp, FilterResponse_t &response);

  void set_navbarmacros (displayclass &disp, FilterResponse_t &response, 
			 cgiargsclass &args);

  virtual void output_text (ResultDocInfo_t &docinfo, format_t *formatlistptr,
			    const TermInfo_tarray &terminfo, const text_t &OID,
			    bool highlight, int hastxt, int wanttext, 
			    text_t &collection, recptproto *collectproto,
			    displayclass &disp, outconvertclass &outconvert,
			    ostream &textout, ostream &logout);

  virtual void output_document (const text_t &OID, cgiargsclass &args, 
				recptproto *collectproto, displayclass &disp, 
				outconvertclass &outconvert, ostream &textout, 
				ostream &logout);

  void highlighttext(text_t &text, const TermInfo_tarray &terms, 
		     displayclass &disp, outconvertclass &outconvert, 
		     ostream &textout, ostream &logout);

  formatinfo_t formatinfo;

public:
  documentaction ();
  virtual ~documentaction ();

  void set_receptionist (receptionist *therecpt) {recpt=therecpt;}

  text_t get_action_name () {return "d";}

  bool check_cgiargs (cgiargsinfoclass &argsinfo, cgiargsclass &args, 
		      ostream &logout);

  void get_cgihead_info (cgiargsclass &args, recptprotolistclass *protos,
			 response_t &response,text_t &response_data, 
			 ostream &logout);

  void define_external_macros (displayclass &disp, cgiargsclass &args, 
			       recptprotolistclass *protos, ostream &logout);

  void define_internal_macros (displayclass &disp, cgiargsclass &args, 
			       recptprotolistclass *protos, ostream &logout);

  bool do_action (cgiargsclass &args, recptprotolistclass *protos, 
		  browsermapclass *browsers, displayclass &disp, 
		  outconvertclass &outconvert, ostream &textout, 
		  ostream &logout);

};



#endif
