/**********************************************************************
 *
 * browsetools.h --
 * Copyright (C) 1999  The New Zealand Digital Library Project
 *
 * A component of the Greenstone digital library software
 * from the New Zealand Digital Library Project at the
 * University of Waikato, New Zealand.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 *********************************************************************/


#ifndef BROWSETOOLS_H
#define BROWSETOOLS_H

#include "gsdlconf.h"
#include "text_t.h"
#include "cgiargs.h"
#include "display.h"
#include "recptproto.h"
#include "formattools.h"
#include "browserclass.h"

typedef map<text_t, format_t*, lttext_t> format_tmap; 

void expanded_contents (cgiargsclass &args, int tabcount, bool fulltoc,
			browsermapclass *browsermap, formatinfo_t &formatinfo, 
			recptproto *collectproto, displayclass &disp, 
			outconvertclass &outconvert, ostream &textout, 
			ostream &logout);

void contracted_contents (cgiargsclass &args, int tabcount, bool fulltoc, 
			  browsermapclass *browsermap, formatinfo_t &formatinfo, 
			  recptproto *collectproto, displayclass &disp, 
			  outconvertclass &outconvert, ostream &textout, 
			  ostream &logout);

void output_toc (cgiargsclass &args, browsermapclass *browsermap,
                 formatinfo_t &formatinfo, recptproto *collectproto,
                 displayclass &disp, outconvertclass &outconvert,
                 ostream &textout, ostream &logout);

void output_titles (cgiargsclass &args, recptproto *collectproto, 
		    formatinfo_t &formatinfo, displayclass &disp, 
		    outconvertclass &outconvert, ostream &textout, 
		    ostream &logout);

void output_controls (cgiargsclass &args, const text_tarray &ibuttons,
		      recptproto *collectproto, displayclass &disp, 
		      outconvertclass &outconvert, ostream &textout, 
		      ostream &logout);
    
void output_cover_image (cgiargsclass &args, recptproto *collectproto, 
			 displayclass &disp, outconvertclass &outconvert, 
			 ostream &textout, ostream &logout);


#endif
