/**************************************************************************
 *
 * mg.special.cpp -- Special pass for mg_passes
 * Copyright (C) 1994  Neil Sharman
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 * $Id: mg.special.cpp,v 1.1 2000/01/14 02:26:10 sjboddie Exp $
 *
 **************************************************************************/

#include "sysfuncs.h"

#include "mg.h"
#include "build.h"


/*
   $Log: mg.special.cpp,v $
   Revision 1.1  2000/01/14 02:26:10  sjboddie
   Rodgers new C++ mg

   Revision 1.1  1999/10/11 02:57:45  cs025
   Base install of MG-PP

   Revision 1.1  1999/08/10 21:18:03  sjboddie
   renamed mg-1.3d directory mg

   Revision 1.1  1998/11/17 09:34:51  rjmcnab
   *** empty log message ***

   * Revision 1.3  1994/10/20  03:56:53  tes
   * I have rewritten the boolean query optimiser and abstracted out the
   * components of the boolean query.
   *
   * Revision 1.2  1994/09/20  04:41:44  tes
   * For version 1.1
   *
 */


int init_special (const TagInfo &/*tagInfo*/, char * /*FileName*/) {
  return COMPALLOK;
}

int process_special (const TagInfo &/*tagInfo*/, const TextElArray &doc) {
  // print out the document
  TextElArray::const_iterator here = doc.begin();
  TextElArray::const_iterator end = doc.end();
  while (here != end) {
    if ((*here).elType == OpenTagE) {
      cout << "** OpenTag  \"" << (*here).tagName << "\"\tText \""
	   << (*here).text << "\"\n"; 
    } else if ((*here).elType == CloseTagE) {
      cout << "** CloseTag \"" << (*here).tagName << "\"\tText \""
	   << (*here).text << "\"\n";
    } else {
      cout << "** Text     \"" << (*here).text << "\"\n";
    }
    
    here++;
  }
  
  return COMPALLOK;
}

int done_special (const TagInfo &/*tagInfo*/, char * /*FileName*/) {
  return COMPALLOK;
}
