/**************************************************************************
 *
 * build.h -- Global information for the passes of mg_passes
 * Copyright (C) 1994  Neil Sharman, Alistair Moffat and Lachlan Andrew
 * Copyright (C) 1999  Rodger McNab
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 * $Id: build.h,v 1.1 2000/01/14 02:26:03 sjboddie Exp $
 *
 **************************************************************************/


#ifndef H_BUILD
#define H_BUILD

#include "longlong.h"

#include "TextEl.h"
#include "TagInfo.h"


int init_special (const TagInfo &tagInfo, char *file_name);
int init_text_1 (const TagInfo &tagInfo, char *file_name);
int init_text_2 (const TagInfo &tagInfo, char *file_name);
int init_ivf_1 (const TagInfo &tagInfo, char *file_name);
int init_ivf_2 (const TagInfo &tagInfo, char *file_name);
/*
 * file_name  IN      The name of the dictionary file
 * 
 * returns      COMPALLOK for all ok,
 *              COMPERROR for any error.  e.g. cannot read file
 */





int process_special (const TagInfo &tagInfo, const TextElArray &doc);
int process_text_1 (const TagInfo &tagInfo, const TextElArray &doc);
int process_text_2 (const TagInfo &tagInfo, const TextElArray &doc);
int process_ivf_1 (const TagInfo &tagInfo, const TextElArray &doc);
int process_ivf_2 (const TagInfo &tagInfo, const TextElArray &doc);
/*
 * returns      COMPALLOK for all ok,
 *              COMPERROR for any error.  e.g. cannot read file
 *
 * The calling routine is responsible for ensuring that s_out is long 
 * enough.
 */





int done_special (const TagInfo &tagInfo, char *filename);
int done_text_1 (const TagInfo &tagInfo, char *filename);
int done_text_2 (const TagInfo &tagInfo, char *filename);
int done_ivf_1 (const TagInfo &tagInfo, char *filename);
int done_ivf_2 (const TagInfo &tagInfo, char *filename);
/*
 * returns    COMPALLOK for all ok,
 *              COMPERROR for any error.  e.g. cannot write file
 */




extern unsigned long invf_buffer_size;
/*
 * The amount of memory to allocate to the invertion buffer.
 */



#endif
