#PACKAGE = mg
#VERSION = 1.3

#SHELL = /bin/sh
#exec_prefix = ${prefix}
#prefix = /image/httpd/mg-1.2
#srcdir = .
#subdir = src/text
#top_srcdir = ../..
#transform = s,x,x,

CC = cl
#CC = cl /Z7  this gives symbol and line number debugging (set /DEBUG on link)
#CFLAGS = -g -O
CPPFLAGS =
DEFS = -DNZDL -DQUIET -DSHORT_SUFFIX -DPARADOCNUM -DHAVE_CONFIG_H -D__WIN32__ -D_LITTLE_ENDIAN
#INSTALL = /usr/local/gnu/bin/install -c
#INSTALL_DATA = ${INSTALL} -m 644
#INSTALL_PROGRAM = ${INSTALL}
LDFLAGS =
LIBS = ..\..\lib\libmg.lib
#TOUCH = echo timestamp >
#AWK = gawk

#bindir = $(exec_prefix)/bin
#datadir = $(prefix)/share
#libexecdir = $(exec_prefix)/libexec
#localedir = $(datadir)/locale
#mandir = $(prefix)/man/man1

COMPILE = $(CC) -c $(DEFS) -I. -I..\.. -I..\..\lib
LINK = $(CC) $(LDFLAGS)

.SUFFIXES:
.SUFFIXES: .c .obj .cpp
.c.obj:
	$(COMPILE) $<
.cpp.obj:
	$(COMPILE) $<

o = .obj
e = .exe

#############################################################################
#
# Uncomment (and possibly edit) the following lines if you wish
# to use the GNU readline library for the input in mgquery
#
#READLINE = -DGNU_READLINE -I/opt/gnu/include/readline -L/opt/gnu/lib
#READLINE_LIBS = -lreadline -ltermcap
#
#
#############################################################################


SOURCES = \
  FIvfLevelInfo.cpp        ivf.pass1.cpp            mg_invf_dump.cpp       \
  FText.cpp                ivf.pass2.cpp            mg_passes.cpp          \
  FileBuf.cpp              locallib.cpp             mg_perf_hash_build.cpp \
  FragLevelConvert.cpp     mg.special.cpp           mg_stem_idx.cpp        \
  IndexData.cpp            mg_compression_dict.cpp  mg_weights_build.cpp   \
  TagInfo.cpp              mg_decompress_text.cpp   stemmer.cpp            \
  TextEl.cpp               mg_errors.cpp            text.cpp               \
  TextGet.cpp              mg_fast_comp_dict.cpp    text.pass1.cpp         \
  UCArray.cpp              mg_files.cpp             text.pass2.cpp         \
  comp_dict.cpp            mg_invf_dict.cpp         words.cpp              \
  invf.cpp                 mg_invf_dict_dump.cpp    Weights.cpp            \
  MGQuery.cpp              Terms.cpp                QueryTester.cpp        \
  QueryLex.cpp             QueryParser.cpp          Queryer.cpp


HEADERS = \
  FIvfLevelInfo.h     TextEl.h            hash.h              stemmer.h  \
  FText.h             TextGet.h           invf.h              text.h     \
  FileBuf.h           UCArray.h           locallib.h          words.h    \
  FragLevelConvert.h  WordData.h          mg.h                           \
  IndexData.h         build.h             mg_errors.h                    \
  TagInfo.h           comp_dict.h         mg_files.h          Weights.h  \
  MGQuery.h           Terms.h             QueryLex.h          QueryParser.h

#MISC          = Makefile.in 

ALLFILES      = $(SOURCES) $(HEADERS) $(MISC) $(MAN)

DISTFILES     = $(ALLFILES)

EXEC          = mg_passes$e mg_decompress_text$e mg_perf_hash_build$e \
                mg_invf_dump$e mg_weights_build$e mg_invf_dict$e mg_stem_idx$e \
                mg_invf_dict_dump$e mg_compression_dict$e mg_fast_comp_dict$e \
                QueryTester$e Queryer$e

MAN           =  mg_weights_build.1  mg_invf_dict.1 \
                 mg_passes.1 mg_perf_hash_build.1 \
                 mg_compression_dict.1  mg_fast_comp_dict.1 \
                 mg_stem_idx.1

# # # # # # # # # # # # # # # # # # # # # # # # # # # # # # # # # # # # # # # #


all:    $(EXEC) libtextin.lib


# # # # # # # # # # # # # # # # # # # # # # # # # # # # # # # # # # # # # # # #

HILITE_OBJS = mg_hilite_words$o stemmer$o locallib$o words$o

mg_hilite_words$e: $(HILITE_OBJS)
	$(LINK) $(HILITE_OBJS) $(LIBS)

# # # # # # # # # # # # # # # # # # # # # # # # # # # # # # # # # # # # # # # #

PASSES_OBJS = \
	mg_passes$o text.pass1$o comp_dict$o \
	text.pass2$o locallib$o \
	ivf.pass1$o ivf.pass2$o mg.special$o mg_files$o \
	words$o invf$o FileBuf$o TextEl$o UCArray$o TagInfo$o \
        FText$o text$o FIvfLevelInfo$o

mg_passes: $(PASSES_OBJS)
	$(LINK) $(PASSES_OBJS) $(LIBS)

# # # # # # # # # # # # # # # # # # # # # # # # # # # # # # # # # # # # # # # #

QUERYER_OBJS = Queryer$o mg_files$o mg_errors$o locallib$o invf$o UCArray$o \
               FIvfLevelInfo$o FragLevelConvert$o Terms$o MGQuery$o \
               IndexData$o stemmer$o Weights$o TextGet$o text$o FText$o \
               QueryParser$o QueryLex$o words$o

Queryer: $(QUERYER_OBJS)
	$(LINK) $(QUERYER_OBJS) $(LIBS)

QUERY_TESTER_OBJS = QueryTester$o mg_files$o invf$o UCArray$o \
                    FIvfLevelInfo$o FragLevelConvert$o Terms$o MGQuery$o \
                    IndexData$o stemmer$o Weights$o

QueryTester: $(QUERY_TESTER_OBJS)
	$(LINK) $(QUERY_TESTER_OBJS) $(LIBS)

WEIGHTS_BUILD_OBJS = mg_weights_build$o mg_files$o invf$o UCArray$o \
                     FIvfLevelInfo$o FragLevelConvert$o

mg_weights_build: $(WEIGHTS_BUILD_OBJS)
	$(LINK) $(WEIGHTS_BUILD_OBJS) $(LIBS)

COMP_DICT_OBJS = mg_compression_dict$o mg_files$o locallib$o

mg_compression_dict: $(COMP_DICT_OBJS)
	$(LINK) $(COMP_DICT_OBJS) $(LIBS)

FAST_COMP_OBJS = mg_fast_comp_dict$o mg_files$o locallib$o

mg_fast_comp_dict: $(FAST_COMP_OBJS)
	$(LINK) $(FAST_COMP_OBJS) $(LIBS)

INVF_DUMP_OBJS = mg_invf_dump$o locallib$o mg_files$o invf$o UCArray$o

mg_invf_dump: $(INVF_DUMP_OBJS)
	$(LINK) $(INVF_DUMP_OBJS) $(LIBS)

INVF_DICT_OBJS = mg_invf_dict$o mg_files$o invf$o UCArray$o

mg_invf_dict: $(INVF_DICT_OBJS)
	$(LINK) $(INVF_DICT_OBJS) $(LIBS)

INVF_DICT_DUMP_OBJS = mg_invf_dict_dump$o mg_files$o invf$o UCArray$o

mg_invf_dict_dump: $(INVF_DICT_DUMP_OBJS)
	$(LINK) $(INVF_DICT_DUMP_OBJS) $(LIBS)

PERF_HASH_OBJS = mg_perf_hash_build$o mg_files$o invf$o UCArray$o

mg_perf_hash_build: $(PERF_HASH_OBJS)
	$(LINK) $(PERF_HASH_OBJS) $(LIBS)

STEM_IDX_OBJS = mg_stem_idx$o mg_files$o stemmer$o \
                invf$o UCArray$o

mg_stem_idx: $(STEM_IDX_OBJS)
	$(LINK) $(STEM_IDX_OBJS) $(LIBS)

DECOMPRESS_TEXT_OBJS = \
                mg_decompress_text$o mg_files$o mg_errors$o \
                locallib$o text$o UCArray$o TextGet$o FText$o

mg_decompress_text: $(DECOMPRESS_TEXT_OBJS)
	$(LINK) $(DECOMPRESS_TEXT_OBJS) $(LIBS)

# # # # # # # # # # # # # # # # # # # # # # # # # # # # # # # # # # # # # # # #

install: execinstall maninstall
uninstall: execuninstall manuninstall

maninstall: $(MAN)
	$(top_srcdir)/mkinstalldirs $(mandir); \
	for f in $(MAN); do \
	  $(INSTALL_DATA) $$f $(mandir)/$$f ;\
	done

manuninstall: $(MAN)
	for f in $(MAN); do \
	  rm -f $(mandir)/$$f ;\
	done


LIB_OBJS = Queryer$o mg_files$o mg_errors$o locallib$o invf$o UCArray$o \
           FIvfLevelInfo$o FragLevelConvert$o Terms$o MGQuery$o \
           IndexData$o stemmer$o Weights$o TextGet$o text$o FText$o \
           QueryParser$o QueryLex$o words$o

libtextin.lib: $(LIB_OBJS)
	del libtextin.lib
	lib /out:libtextin.lib $(LIB_OBJS)


mostlyclean:
	rm -f *$o _*.c _*.o *._c *._o core core.*
 
clean: mostlyclean
	rm -f $(EXEC)
 
distclean: clean
	rm -f ansi2knr
	rm -f Makefile
 
maintainer-clean: distclean
	@echo "This command is intended only for maintainers to use;"
	@echo "rebuilding the deleted files may require special tools."
 
#dist: $(DISTFILES)
#        for file in $(DISTFILES); do \
#          ln $(srcdir)/$$file $(distdir) 2> /dev/null \
#          || cp -p $(srcdir)/$$file $(distdir); \
#        done
 
#Makefile: Makefile.in ../../config.status
#        cd ../.. && CONFIG_FILES=$(subdir)/$@ CONFIG_HEADERS= ./config.status
 
# Tell versions [3.59,3.63) of GNU make not to export all variables.
# Otherwise a system limit (for SysV at least) may be exceeded.
#.NOEXPORT:
