/**************************************************************************
 *
 * TagInfo.h -- 
 * Copyright (C) 1999  Rodger McNab
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 * $Id: TagInfo.h,v 1.1 2000/01/14 02:17:45 sjboddie Exp $
 *
 **************************************************************************/

#ifndef TAGINFO_H
#define TAGINFO_H

#include "UCArray.h"


class TagInfo {
public:
  UCArray docTag;
  UCArray indexLevel;    // empty for word level index
  UCArraySet levelTags;

  void SetDocTag (const char *cStr);
  void SetIndexLevel (const char *cStr);
  void AddLevelTag (const char *cStr);
  
  TagInfo ();
  void Clear ();
};

// stream operator to print TagInfo
ostream &operator<<(ostream &s, const TagInfo &t);


#endif
