/**************************************************************************
 *
 * FragLevelConvert.cpp -- converting between fragment and document numbers
 * Copyright (C) 1999  Rodger McNab
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 * $Id: FragLevelConvert.cpp,v 1.2 2000/02/15 22:45:20 kjm18 Exp $
 *
 **************************************************************************/

#include "FragLevelConvert.h"
#include "bitio_m_stdio.h"
#include "bitio_gen.h"


FragLevelConvert::FragLevelConvert () {
  numFrags = 0;
  numLevelDocs = 0;
}

bool FragLevelConvert::Read (FILE *invfFile,
			     unsigned long levelPtr,
			     unsigned long _numFrags,
			     unsigned long _numLevelDocs) {
  levelStarts.erase (levelStarts.begin(), levelStarts.end());
  numFrags = _numFrags;
  numLevelDocs = _numLevelDocs;

  // seek to the appropriate place in the inverted file
  fseek (invfFile, levelPtr, SEEK_SET);

  stdio_bitio_buffer buffer(invfFile);
  
  unsigned long pTag = numLevelDocs*2;
  unsigned long B = BIO_Bblock_Init (numFrags+pTag, pTag);
  unsigned long fragNum = 0;
  unsigned long i;
  for (i=0; i<numLevelDocs; i++) {
    unsigned long delta = buffer.bblock_decode (B, NULL)-1;
    fragNum += delta;

    levelStarts.push_back (fragNum);

    // ignore end, assume every fragment is in a level
    delta = buffer.bblock_decode (B, NULL)-1;
    fragNum += delta;
  }

  // fragNum would be the starting fragment of the next document
  // if there was one
  levelStarts.push_back (fragNum);
  
  buffer.done();

  return true;
}

bool FragLevelConvert::FragToLevel (unsigned long fragNum,
				    unsigned long &levelDocNum) const {
  // do binary search for something containing this fragment number
  unsigned long low = 1, high = numLevelDocs;
  unsigned long mid;

  while ((mid = (low+high)/2) >= 1 && low <= high) {
    if (fragNum > levelStarts[mid]) low = mid+1;
    else if (fragNum <= levelStarts[mid-1]) high = mid-1;
    else {
      levelDocNum = mid;
      return true;
    }
  }
  return false;
}


bool FragLevelConvert::LevelToLevel (FragLevelConvert sectionLevelConvert,
		 unsigned long levelNum, unsigned long &DocNum) {
  
  if (levelNum==1) {
    DocNum=1;
    return true;
  }
  unsigned long levelfragnum = sectionLevelConvert.levelStarts[levelNum-1]+1;

  if (FragToLevel(levelfragnum, DocNum)) {
    return true;
  } 
  return false;
  

}



