/**********************************************************************
 *
 * db2txt.cpp -- 
 * Copyright (C) 1999  The New Zealand Digital Library Project
 *
 * A component of the Greenstone digital library software
 * from the New Zealand Digital Library Project at the
 * University of Waikato, New Zealand.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 *********************************************************************/


#ifdef __WIN32__
#include "autoconf.h"
#include "systems.h"
#include "gdbmconst.h"
#include "gdbm.h"

#else
#include <gdbm.h>
#endif

#include "gsdlconf.h"
#include <stdlib.h>

#if defined(GSDL_USE_OBJECTSPACE)
#include <ospace\std\iostream>
#elif defined(GSDL_USE_IOS_H)
#include <iostream.h>
#else
#include <iostream>
#endif

void print_usage (char *program_name) {
  cerr << "usage: " << program_name << " database-name\n\n";
}


int main (int argc, char *argv[]) {
  int block_size = 0, i;
  GDBM_FILE dbf;
  datum key, value;
      
  // sanity check
  if (argc != 2) {
    print_usage (argv[0]);
    exit (0);
  }
  
  // open the database
#ifdef __WIN32__
  dbf = gdbm_open (argv[1], block_size, GDBM_READER, 00664, NULL, 0);
#else
  dbf = gdbm_open  (argv[1], block_size, GDBM_READER, 00664, NULL);
#endif
  if (dbf == NULL) {
    cerr << "couldn't create " << argv[1] << "\n";
    exit (0);
  }

  key = gdbm_firstkey (dbf);
  while (key.dptr != NULL) {
    cout << "[";
    for (i = 0; i < key.dsize; i++)
      cout << key.dptr[i];
    cout << "]\n";
    value = gdbm_fetch (dbf, key);
    for (i = 0; i < value.dsize; i++)
      cout << value.dptr[i];
    cout << "\n----------------------------------------------------------------------\n";
    key = gdbm_nextkey (dbf, key);
    delete value.dptr;
  }
  
  gdbm_close (dbf);
  return 0;
}
