/**********************************************************************
 *
 * collectset.cpp -- 
 * Copyright (C) 1999  The New Zealand Digital Library Project
 *
 * A component of the Greenstone digital library software
 * from the New Zealand Digital Library Project at the
 * University of Waikato, New Zealand.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 * $Id: collectset.cpp,v 1.3 2001/01/31 02:03:30 sjboddie Exp $
 *
 *********************************************************************/


#include "collectserver.h"
#include "filter.h"
#include "browsefilter.h"
#include "queryfilter.h"
#include "infodbclass.h"
#include "mgqueryfilter.h"
#include "mgppqueryfilter.h"
#include "mgsearch.h"
#include "mgppsearch.h"
#include "mggdbmsource.h"
#include "fileutil.h"
#include <assert.h>

#include "colservrconfig.h"
#include "recptconfig.h"

#include "collectset.h"

collectset::collectset (text_t &gsdlhome) {

  text_tarray collections;
  text_t      collectdir;

  // get gsdlhome (if we fail the error will be picked up later -- in
  // cgiwrapper)
  if (site_cfg_read (gsdlhome, httpdomain, httpprefix)) {
    collectdir = filename_cat (gsdlhome, "collect");

    if (!read_dir (collectdir, collections)) {
      cerr << "couldn't read collect directory - make sure gsdlhome field is correct in gsdlsite.cfg\n";
      exit (1);
    }
  }
    
  text_tarray::const_iterator thiscol = collections.begin();
  text_tarray::const_iterator endcol = collections.end();

  while (thiscol != endcol) {
    // ignore the modelcol
    if (*thiscol == "modelcol") {
      thiscol ++;
      continue;
    }

    // Dummy call to add collection added 24/11/2000;
    // we already do this ourselves! 
    // this->add_collection(*thiscol, &recpt, gsdlghome, gsdlhome);

    // read config file to see if built with mg or mgpp
    text_t buildtype = "mg"; // mg is default
    text_tarray cfgline;
    text_t key;
    text_t filename = filename_cat(collectdir, *thiscol, "index" , "build.cfg");
    ifstream confin(filename.getcstr());

    if (confin) {
      while (read_cfg_line(confin, cfgline) >= 0) {
	if (cfgline.size() ==2 ) {
	  key = cfgline[0];
	  cfgline.erase(cfgline.begin());
	  if (key =="buildtype") {
	    buildtype = cfgline[0];
	    break;
	  }
	}
      }
    }
    
    confin.close();

    // this memory is created but never destroyed
    // we're also not doing any error checking to make sure we didn't
    // run out of memory
    collectserver *cserver = new collectserver();
    gdbmclass *gdbmhandler = new gdbmclass();
    
    // add a null filter
    filterclass *filter = new filterclass ();
    cserver->add_filter (filter);
    
    // add a browse filter
    browsefilterclass *browsefilter = new browsefilterclass();
    browsefilter->set_gdbmptr (gdbmhandler);
    cserver->add_filter (browsefilter);
    
    if (buildtype == "mg") {
       mgsearchclass *mgsearch = new mgsearchclass();
 
       // add a query filter
       mgqueryfilterclass *queryfilter = new mgqueryfilterclass();
       queryfilter->set_gdbmptr (gdbmhandler);
       queryfilter->set_mgsearchptr (mgsearch);
       cserver->add_filter (queryfilter);
       
       // add a mg and gdbm source
       mggdbmsourceclass *mggdbmsource = new mggdbmsourceclass ();
       mggdbmsource->set_gdbmptr (gdbmhandler);
       mggdbmsource->set_mgsearchptr (mgsearch);
       cserver->add_source (mggdbmsource);
    }
#ifndef __WIN32__

    else if (buildtype == "mgpp") {

      mgppsearchclass *mgsearch = new mgppsearchclass();

      // add a query filter
      mgppqueryfilterclass *queryfilter = new mgppqueryfilterclass();
      queryfilter->set_gdbmptr (gdbmhandler);
      queryfilter->set_mgsearchptr (mgsearch);
      cserver->add_filter (queryfilter);
      
      // add a mg and gdbm source
      mggdbmsourceclass *mggdbmsource = new mggdbmsourceclass ();
      mggdbmsource->set_gdbmptr (gdbmhandler);
      mggdbmsource->set_mgsearchptr (mgsearch);
      cserver->add_source (mggdbmsource);   
    }
#endif

    // inform collection server and everything it contains about its
    // collection name
    cserver->configure ("collection", *thiscol);
    // AZIZ: added on 10/10/00
    //       the cserver object does not have a reference to gsdlhome
    cserver->configure ("gsdlhome", gsdlhome);
    
    // GRB: removed    proto.add_collectserver (cserver);
    // GRB: added to build our own cservers list
    cservers.addcollectserver (cserver);

    thiscol ++;
  }
}

collectset::~collectset () {
  collectservermapclass::iterator here = cservers.begin();
  collectservermapclass::iterator end = cservers.end();

  while (here != end) {
    if ((*here).second.c != NULL) {
      delete (*here).second.c;
    }
    here ++;
  }
  cservers.clear();
}

bool collectset::init (ostream &logout) {
  collectservermapclass::iterator here = cservers.begin();
  collectservermapclass::iterator end = cservers.end();

  while (here != end) {
    assert ((*here).second.c != NULL);
    if ((*here).second.c != NULL) {
      const colservrconf &configinfo = (*here).second.c->get_configinfo ();

      // configure this collection server

      // note that we read build.cfg before collect.cfg so that the indexmaps
      // are available to decode defaultindex, defaultsubcollection, and
      // defaultlanguage
      if (!build_cfg_read (*((*here).second.c), configinfo.gsdlhome,
			   configinfo.collection)) {
	outconvertclass text_t2ascii;
	logout << text_t2ascii 
	       << "Warning: couldn't read build.cfg file for collection \"" //****
	       << configinfo.collection << "\", gsdlhome=\""
	       << configinfo.gsdlhome << "\"\n";
	here ++;
	continue;
      }

      if (!collect_cfg_read (*((*here).second.c), configinfo.gsdlhome,
			     configinfo.collection)) {
	outconvertclass text_t2ascii;
	logout << text_t2ascii 
	       << "Warning: couldn't read collect.cfg file for collection \""
	       << configinfo.collection << "\", gsdlhome=\"" 
	       << configinfo.gsdlhome << "\"\n";
	here ++;
	continue;
      }

      if (!(*here).second.c->init (logout)) return false;

      (*here).second.c->configure("httpdomain",httpdomain);
      (*here).second.c->configure("httpprefix",httpprefix);
    }
    here++;
  }

  return true;
}

collectservermapclass collectset::servers()
{ return cservers;
}

// add_collection sets up the collectionserver and calls
// add_collectserver
void collectset::add_collection (const text_t &collection, void *recpt, 
				 const text_t &gsdlhome, const text_t &gdbmhome) {
      
  // read config file to see if built with mg or mgpp
  // -- we can rely on the collection (and therefore the build.cfg)
  // being here since this is the null protocol - a nicer way to 
  // do this would be preferable though - Stefan.
  text_t buildtype = "mg"; // mg is default
  // (for now we'll just ignore mgpp if on windows)
#ifndef __WIN32__
  text_tarray cfgline;
  text_t key;
  text_t build_cfg = filename_cat(gsdlhome, "collect", collection, "index", "build.cfg");
  char *build_cfgc = build_cfg.getcstr();
  ifstream confin(build_cfgc);

  if (confin) {
    while (read_cfg_line(confin, cfgline) >= 0) {
      if (cfgline.size() == 2) {
	key = cfgline[0];
	cfgline.erase(cfgline.begin());
	if (key == "buildtype") {
	  buildtype = cfgline[0];
	  break;
	}
      }
    }
    confin.close();
  }
  delete build_cfgc;
#endif

  collectserver *cserver = new collectserver();
  gdbmclass *gdbmhandler = new gdbmclass();

  // add a null filter
  filterclass *filter = new filterclass ();
  cserver->add_filter (filter);
      
  // add a browse filter
  browsefilterclass *browsefilter = new browsefilterclass();
  browsefilter->set_gdbmptr (gdbmhandler);

  cserver->add_filter (browsefilter);  
 
  if (buildtype == "mg") {
    mgsearchclass *mgsearch = new mgsearchclass();
 
    // add a query filter
    mgqueryfilterclass *queryfilter = new mgqueryfilterclass();
    queryfilter->set_gdbmptr (gdbmhandler);
    queryfilter->set_mgsearchptr (mgsearch);
    cserver->add_filter (queryfilter);
    
    // add a mg and gdbm source
    mggdbmsourceclass *mggdbmsource = new mggdbmsourceclass ();
    mggdbmsource->set_gdbmptr (gdbmhandler);
    mggdbmsource->set_mgsearchptr (mgsearch);
    cserver->add_source (mggdbmsource);
  }

#ifndef __WIN32__

  else if (buildtype == "mgpp") {
      
    mgppsearchclass *mgsearch = new mgppsearchclass();

    // add a query filter
    mgppqueryfilterclass *queryfilter = new mgppqueryfilterclass();
    queryfilter->set_gdbmptr (gdbmhandler);
    queryfilter->set_mgsearchptr (mgsearch);
    cserver->add_filter (queryfilter);
      
    // add a mg and gdbm source
    mggdbmsourceclass *mggdbmsource = new mggdbmsourceclass ();
    mggdbmsource->set_gdbmptr (gdbmhandler);
    mggdbmsource->set_mgsearchptr (mgsearch);
    cserver->add_source (mggdbmsource);
    
  }
#endif    

  // inform collection server and everything it contains about its
  // collection name
  cserver->configure ("collection", collection);

  /* Removed from add_collection 24/11/2000; already done elsewhere in collectset.  
  // configure receptionist's collectinfo structure 
  text_tarray colinfo;
  colinfo.push_back (collection);
  colinfo.push_back (gsdlhome);
  colinfo.push_back (gdbmhome);
  */
  cservers.addcollectserver (cserver);
}

// remove_collection deletes the collection server of collection.
// This only needs to be called if a collectionserver is to be
// removed while the library is running. The destructor function
// cleans up all collectservers when the program exits.
void collectset::remove_collection (const text_t &collection, ostream &logout) {
  collectservermapclass::iterator here = cservers.begin();
  collectservermapclass::iterator end = cservers.end();

  while (here != end) {
    if ((*here).second.c != NULL && (*here).first == collection) {
      delete (*here).second.c;
      cservers.erase (here);
      return;
    }
    here ++;
  }
  outconvertclass text_t2ascii;
  logout << text_t2ascii << "nullproto::remove_collection: failed to remove collectserver for "
	 << collection << "\n";
}

void collectset::configure(const text_t &key, const text_tarray &cfgline)
{
  if (key == "collection" || key == "collectdir") return;

  collectservermapclass::iterator here = cservers.begin();
  collectservermapclass::iterator end = cservers.end();

  while (here != end) {
    assert ((*here).second.c != NULL);
    if ((*here).second.c != NULL) {
      if (key == "collectinfo") {
	if ((*here).first == cfgline[0]) {
	  (*here).second.c->configure ("gsdlhome", cfgline[1]);
	  (*here).second.c->configure ("gdbmhome", cfgline[2]);
	}
      } else {
	(*here).second.c->configure (key, cfgline);
      }
    }

    here++;
  }
}

void collectset::getCollectionList (text_tarray &collist) 
{
  collist.erase(collist.begin(),collist.end());

  collectservermapclass::iterator here = cservers.begin();
  collectservermapclass::iterator end = cservers.end();
  while (here != end) {
    assert ((*here).second.c != NULL);
    if ((*here).second.c != NULL) {
      collist.push_back ((*here).second.c->get_collection_name());
    }
    here++;
  }
}

void collectset::setReceptionistServers(receptionist &recpt, text_t &gsdlhome)
{ 
  collectservermapclass::iterator here = cservers.begin();
  collectservermapclass::iterator end = cservers.end();
  while (here != end) {
    assert ((*here).second.c != NULL);

    text_tarray colinfo;
    colinfo.push_back((*here).second.c->get_collection_name());
    colinfo.push_back(gsdlhome);
    colinfo.push_back(gsdlhome);
    recpt.configure("collectinfo", colinfo);

    here++;
  }
}
