/**********************************************************************
 *
 * browsefilter.h -- 
 * Copyright (C) 1999  The New Zealand Digital Library Project
 *
 * A component of the Greenstone digital library software
 * from the New Zealand Digital Library Project at the
 * University of Waikato, New Zealand.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 *********************************************************************/


#ifndef BROWSEFILTER_H
#define BROWSEFILTER_H


#include "gsdlconf.h"
#include "text_t.h"
#include "comtypes.h"
#include "filter.h"
#include "infodbclass.h"


class browsefilterclass : public filterclass {
protected:
  text_t gdbm_filename;
  gdbmclass *gdbmptr;

public:
  browsefilterclass ();
  virtual ~browsefilterclass ();

  // the gdbmptr remains the responsability of the calling code and
  // should be destroyed after this browsefilter is destroyed
  void set_gdbmptr (gdbmclass *thegdbmptr) {gdbmptr = thegdbmptr;}

  bool init (ostream &logout);
  text_t get_filter_name () {return "BrowseFilter";}
  void filter (const FilterRequest_t &request,
	       FilterResponse_t &response,
	       comerror_t &err, ostream &logout);
};


#endif
