###########################################################################
#
# gcc win32 makefile -- src/colservr
# A component of the Greenstone digital library software
# from the New Zealand Digital Library Project at the
# University of Waikato, New Zealand.
#
# Copyright (C) 2000  The New Zealand Digital Library Project
#
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
#
###########################################################################


AR = ar
RANLIB = ranlib
CC = g++
DELETE = del

o = .o
/ = \\

CPPFLAGS = -g -Wall
DEFS = -D__WIN32__ -DGSDL_USE_IOS_H -DHAVE_CONFIG_H

INCLUDES = -I"..$/..$/lib" -I"..$/recpt" -I"..$/..$/packages$/mg" \
	   -I"..$/..$/packages$/mg$/lib" -I"..$/..$/packages$/mg$/src$/text" \
           -I"..$/..$/packages$/wingdbm"

COMPILE = $(CC) -c $(DEFS) $(INCLUDES) $(CPPFLAGS)
LINK = $(CC) $(LDFLAGS) -o $@
 
.SUFFIXES:
.SUFFIXES: .c $o
.c$o:
	$(COMPILE) $<

.SUFFIXES: .cpp $o
.cpp$o:
	$(COMPILE) $< 

HEADERS = mgq.h mgsearch.h querycache.h queryinfo.h collectserver.h \
          colservrconfig.h maptools.h filter.h source.h browsefilter.h \
          queryfilter.h mggdbmsource.h phrasesearch.h phrasequeryfilter.h

SOURCES = mgq.c mgsearch.cpp querycache.cpp queryinfo.cpp collectserver.cpp \
          colservrconfig.cpp maptools.cpp filter.cpp source.cpp \
          browsefilter.cpp queryfilter.cpp mggdbmsource.cpp phrasesearch.cpp \
          phrasequeryfilter.cpp

OBJECTS = mgq$o mgsearch$o querycache$o queryinfo$o collectserver$o \
          colservrconfig$o maptools$o filter$o source$o browsefilter$o \
          queryfilter$o mggdbmsource$o phrasesearch$o phrasequeryfilter$o

all : $(OBJECTS)

clean:
	$(DELETE) *$o

install:
